/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import java.util.Arrays;
import java.util.Random;

public interface ShuffleOrder {
    public int getLength();

    public int getNextIndex(int var1);

    public int getPreviousIndex(int var1);

    public int getLastIndex();

    public int getFirstIndex();

    public ShuffleOrder cloneAndInsert(int var1, int var2);

    public ShuffleOrder cloneAndRemove(int var1, int var2);

    public ShuffleOrder cloneAndClear();

    public static final class UnshuffledShuffleOrder
    implements ShuffleOrder {
        private final int length;

        public UnshuffledShuffleOrder(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getNextIndex(int index) {
            return ++index < this.length ? index : -1;
        }

        @Override
        public int getPreviousIndex(int index) {
            return --index >= 0 ? index : -1;
        }

        @Override
        public int getLastIndex() {
            return this.length > 0 ? this.length - 1 : -1;
        }

        @Override
        public int getFirstIndex() {
            return this.length > 0 ? 0 : -1;
        }

        @Override
        public ShuffleOrder cloneAndInsert(int insertionIndex, int insertionCount) {
            return new UnshuffledShuffleOrder(this.length + insertionCount);
        }

        @Override
        public ShuffleOrder cloneAndRemove(int indexFrom, int indexToExclusive) {
            return new UnshuffledShuffleOrder(this.length - indexToExclusive + indexFrom);
        }

        @Override
        public ShuffleOrder cloneAndClear() {
            return new UnshuffledShuffleOrder(0);
        }
    }

    public static class DefaultShuffleOrder
    implements ShuffleOrder {
        private final Random random;
        private final int[] shuffled;
        private final int[] indexInShuffled;

        public DefaultShuffleOrder(int length) {
            this(length, new Random());
        }

        public DefaultShuffleOrder(int length, long randomSeed) {
            this(length, new Random(randomSeed));
        }

        public DefaultShuffleOrder(int[] shuffledIndices, long randomSeed) {
            this(Arrays.copyOf(shuffledIndices, shuffledIndices.length), new Random(randomSeed));
        }

        private DefaultShuffleOrder(int length, Random random) {
            this(DefaultShuffleOrder.createShuffledList(length, random), random);
        }

        private DefaultShuffleOrder(int[] shuffled, Random random) {
            this.shuffled = shuffled;
            this.random = random;
            this.indexInShuffled = new int[shuffled.length];
            for (int i = 0; i < shuffled.length; ++i) {
                this.indexInShuffled[shuffled[i]] = i;
            }
        }

        @Override
        public int getLength() {
            return this.shuffled.length;
        }

        @Override
        public int getNextIndex(int index) {
            int shuffledIndex = this.indexInShuffled[index];
            return ++shuffledIndex < this.shuffled.length ? this.shuffled[shuffledIndex] : -1;
        }

        @Override
        public int getPreviousIndex(int index) {
            int shuffledIndex = this.indexInShuffled[index];
            return --shuffledIndex >= 0 ? this.shuffled[shuffledIndex] : -1;
        }

        @Override
        public int getLastIndex() {
            return this.shuffled.length > 0 ? this.shuffled[this.shuffled.length - 1] : -1;
        }

        @Override
        public int getFirstIndex() {
            return this.shuffled.length > 0 ? this.shuffled[0] : -1;
        }

        @Override
        public ShuffleOrder cloneAndInsert(int insertionIndex, int insertionCount) {
            int[] insertionPoints = new int[insertionCount];
            int[] insertionValues = new int[insertionCount];
            for (int i = 0; i < insertionCount; ++i) {
                insertionPoints[i] = this.random.nextInt(this.shuffled.length + 1);
                int swapIndex = this.random.nextInt(i + 1);
                insertionValues[i] = insertionValues[swapIndex];
                insertionValues[swapIndex] = i + insertionIndex;
            }
            Arrays.sort(insertionPoints);
            int[] newShuffled = new int[this.shuffled.length + insertionCount];
            int indexInOldShuffled = 0;
            int indexInInsertionList = 0;
            for (int i = 0; i < this.shuffled.length + insertionCount; ++i) {
                if (indexInInsertionList < insertionCount && indexInOldShuffled == insertionPoints[indexInInsertionList]) {
                    newShuffled[i] = insertionValues[indexInInsertionList++];
                    continue;
                }
                newShuffled[i] = this.shuffled[indexInOldShuffled++];
                if (newShuffled[i] < insertionIndex) continue;
                int n = i;
                newShuffled[n] = newShuffled[n] + insertionCount;
            }
            return new DefaultShuffleOrder(newShuffled, new Random(this.random.nextLong()));
        }

        @Override
        public ShuffleOrder cloneAndRemove(int indexFrom, int indexToExclusive) {
            int numberOfElementsToRemove = indexToExclusive - indexFrom;
            int[] newShuffled = new int[this.shuffled.length - numberOfElementsToRemove];
            int foundElementsCount = 0;
            for (int i = 0; i < this.shuffled.length; ++i) {
                if (this.shuffled[i] >= indexFrom && this.shuffled[i] < indexToExclusive) {
                    ++foundElementsCount;
                    continue;
                }
                newShuffled[i - foundElementsCount] = this.shuffled[i] >= indexFrom ? this.shuffled[i] - numberOfElementsToRemove : this.shuffled[i];
            }
            return new DefaultShuffleOrder(newShuffled, new Random(this.random.nextLong()));
        }

        @Override
        public ShuffleOrder cloneAndClear() {
            return new DefaultShuffleOrder(0, new Random(this.random.nextLong()));
        }

        private static int[] createShuffledList(int length, Random random) {
            int[] shuffled = new int[length];
            int i = 0;
            while (i < length) {
                int swapIndex = random.nextInt(i + 1);
                shuffled[i] = shuffled[swapIndex];
                shuffled[swapIndex] = i++;
            }
            return shuffled;
        }
    }
}

