/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.util.SparseArray;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Consumer;

final class SpannedData<V> {
    private int memoizedReadIndex;
    private final SparseArray<V> spans = new SparseArray();
    private final Consumer<V> removeCallback;

    public SpannedData() {
        this(value -> {});
    }

    public SpannedData(Consumer<V> removeCallback) {
        this.removeCallback = removeCallback;
        this.memoizedReadIndex = -1;
    }

    public V get(int key) {
        if (this.memoizedReadIndex == -1) {
            this.memoizedReadIndex = 0;
        }
        while (this.memoizedReadIndex > 0 && key < this.spans.keyAt(this.memoizedReadIndex)) {
            --this.memoizedReadIndex;
        }
        while (this.memoizedReadIndex < this.spans.size() - 1 && key >= this.spans.keyAt(this.memoizedReadIndex + 1)) {
            ++this.memoizedReadIndex;
        }
        return (V)this.spans.valueAt(this.memoizedReadIndex);
    }

    public void appendSpan(int startKey, V value) {
        if (this.memoizedReadIndex == -1) {
            Assertions.checkState((this.spans.size() == 0 ? 1 : 0) != 0);
            this.memoizedReadIndex = 0;
        }
        if (this.spans.size() > 0) {
            int lastStartKey = this.spans.keyAt(this.spans.size() - 1);
            Assertions.checkArgument((startKey >= lastStartKey ? 1 : 0) != 0);
            if (lastStartKey == startKey) {
                this.removeCallback.accept(this.spans.valueAt(this.spans.size() - 1));
            }
        }
        this.spans.append(startKey, value);
    }

    public V getEndValue() {
        return (V)this.spans.valueAt(this.spans.size() - 1);
    }

    public void discardTo(int discardToKey) {
        for (int i = 0; i < this.spans.size() - 1 && discardToKey >= this.spans.keyAt(i + 1); ++i) {
            this.removeCallback.accept(this.spans.valueAt(i));
            this.spans.removeAt(i);
            if (this.memoizedReadIndex <= 0) continue;
            --this.memoizedReadIndex;
        }
    }

    public void discardFrom(int discardFromKey) {
        for (int i = this.spans.size() - 1; i >= 0 && discardFromKey < this.spans.keyAt(i); --i) {
            this.removeCallback.accept(this.spans.valueAt(i));
            this.spans.removeAt(i);
        }
        this.memoizedReadIndex = this.spans.size() > 0 ? Math.min(this.memoizedReadIndex, this.spans.size() - 1) : -1;
    }

    public void clear() {
        for (int i = 0; i < this.spans.size(); ++i) {
            this.removeCallback.accept(this.spans.valueAt(i));
        }
        this.memoizedReadIndex = -1;
        this.spans.clear();
    }

    public boolean isEmpty() {
        return this.spans.size() == 0;
    }
}

