/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.chunk;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.extractor.DefaultExtractorInput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.chunk.BaseMediaChunk;
import com.google.android.exoplayer2.source.chunk.BaseMediaChunkOutput;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSourceUtil;
import com.google.android.exoplayer2.upstream.DataSpec;
import java.io.IOException;

public final class SingleSampleMediaChunk
extends BaseMediaChunk {
    private final int trackType;
    private final Format sampleFormat;
    private long nextLoadPosition;
    private boolean loadCompleted;

    public SingleSampleMediaChunk(DataSource dataSource, DataSpec dataSpec, Format trackFormat, int trackSelectionReason, @Nullable Object trackSelectionData, long startTimeUs, long endTimeUs, long chunkIndex, int trackType, Format sampleFormat) {
        super(dataSource, dataSpec, trackFormat, trackSelectionReason, trackSelectionData, startTimeUs, endTimeUs, -9223372036854775807L, -9223372036854775807L, chunkIndex);
        this.trackType = trackType;
        this.sampleFormat = sampleFormat;
    }

    @Override
    public boolean isLoadCompleted() {
        return this.loadCompleted;
    }

    @Override
    public void cancelLoad() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws IOException {
        BaseMediaChunkOutput output = this.getOutput();
        output.setSampleOffsetUs(0L);
        TrackOutput trackOutput = output.track(0, this.trackType);
        trackOutput.format(this.sampleFormat);
        try {
            DataSpec loadDataSpec = this.dataSpec.subrange(this.nextLoadPosition);
            long length = this.dataSource.open(loadDataSpec);
            if (length != -1L) {
                length += this.nextLoadPosition;
            }
            DefaultExtractorInput extractorInput = new DefaultExtractorInput((DataReader)this.dataSource, this.nextLoadPosition, length);
            int result = 0;
            while (result != -1) {
                this.nextLoadPosition += (long)result;
                result = trackOutput.sampleData((DataReader)extractorInput, Integer.MAX_VALUE, true);
            }
            int sampleSize = (int)this.nextLoadPosition;
            trackOutput.sampleMetadata(this.startTimeUs, 1, sampleSize, 0, null);
        }
        finally {
            DataSourceUtil.closeQuietly((DataSource)this.dataSource);
        }
        this.loadCompleted = true;
    }
}

