/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.CueDecoder;
import com.google.android.exoplayer2.text.Subtitle;
import com.google.android.exoplayer2.text.SubtitleDecoder;
import com.google.android.exoplayer2.text.SubtitleDecoderException;
import com.google.android.exoplayer2.text.SubtitleInputBuffer;
import com.google.android.exoplayer2.text.SubtitleOutputBuffer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;

public final class ExoplayerCuesDecoder
implements SubtitleDecoder {
    private static final int INPUT_BUFFER_AVAILABLE = 0;
    private static final int INPUT_BUFFER_DEQUEUED = 1;
    private static final int INPUT_BUFFER_QUEUED = 2;
    private static final int OUTPUT_BUFFERS_COUNT = 2;
    private final CueDecoder cueDecoder = new CueDecoder();
    private final SubtitleInputBuffer inputBuffer = new SubtitleInputBuffer();
    private final Deque<SubtitleOutputBuffer> availableOutputBuffers = new ArrayDeque<SubtitleOutputBuffer>();
    private int inputBufferState;
    private boolean released;

    public ExoplayerCuesDecoder() {
        for (int i = 0; i < 2; ++i) {
            this.availableOutputBuffers.addFirst(new SubtitleOutputBuffer(){

                public void release() {
                    ExoplayerCuesDecoder.this.releaseOutputBuffer(this);
                }
            });
        }
        this.inputBufferState = 0;
    }

    public String getName() {
        return "ExoplayerCuesDecoder";
    }

    @Nullable
    public SubtitleInputBuffer dequeueInputBuffer() throws SubtitleDecoderException {
        Assertions.checkState((!this.released ? 1 : 0) != 0);
        if (this.inputBufferState != 0) {
            return null;
        }
        this.inputBufferState = 1;
        return this.inputBuffer;
    }

    public void queueInputBuffer(SubtitleInputBuffer inputBuffer) throws SubtitleDecoderException {
        Assertions.checkState((!this.released ? 1 : 0) != 0);
        Assertions.checkState((this.inputBufferState == 1 ? 1 : 0) != 0);
        Assertions.checkArgument((this.inputBuffer == inputBuffer ? 1 : 0) != 0);
        this.inputBufferState = 2;
    }

    @Nullable
    public SubtitleOutputBuffer dequeueOutputBuffer() throws SubtitleDecoderException {
        Assertions.checkState((!this.released ? 1 : 0) != 0);
        if (this.inputBufferState != 2 || this.availableOutputBuffers.isEmpty()) {
            return null;
        }
        SubtitleOutputBuffer outputBuffer = this.availableOutputBuffers.removeFirst();
        if (this.inputBuffer.isEndOfStream()) {
            outputBuffer.addFlag(4);
        } else {
            SingleEventSubtitle subtitle = new SingleEventSubtitle(this.inputBuffer.timeUs, (ImmutableList<Cue>)this.cueDecoder.decode(((ByteBuffer)Assertions.checkNotNull((Object)this.inputBuffer.data)).array()));
            outputBuffer.setContent(this.inputBuffer.timeUs, (Subtitle)subtitle, 0L);
        }
        this.inputBuffer.clear();
        this.inputBufferState = 0;
        return outputBuffer;
    }

    public void flush() {
        Assertions.checkState((!this.released ? 1 : 0) != 0);
        this.inputBuffer.clear();
        this.inputBufferState = 0;
    }

    public void release() {
        this.released = true;
    }

    public void setPositionUs(long positionUs) {
    }

    private void releaseOutputBuffer(SubtitleOutputBuffer outputBuffer) {
        Assertions.checkState((this.availableOutputBuffers.size() < 2 ? 1 : 0) != 0);
        Assertions.checkArgument((!this.availableOutputBuffers.contains(outputBuffer) ? 1 : 0) != 0);
        outputBuffer.clear();
        this.availableOutputBuffers.addFirst(outputBuffer);
    }

    private static final class SingleEventSubtitle
    implements Subtitle {
        private final long timeUs;
        private final ImmutableList<Cue> cues;

        public SingleEventSubtitle(long timeUs, ImmutableList<Cue> cues) {
            this.timeUs = timeUs;
            this.cues = cues;
        }

        public int getNextEventTimeIndex(long timeUs) {
            return this.timeUs > timeUs ? 0 : -1;
        }

        public int getEventTimeCount() {
            return 1;
        }

        public long getEventTime(int index) {
            Assertions.checkArgument((index == 0 ? 1 : 0) != 0);
            return this.timeUs;
        }

        public List<Cue> getCues(long timeUs) {
            return timeUs >= this.timeUs ? this.cues : ImmutableList.of();
        }
    }
}

