/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text;

import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.text.ExoplayerCuesDecoder;
import com.google.android.exoplayer2.text.SubtitleDecoder;
import com.google.android.exoplayer2.text.cea.Cea608Decoder;
import com.google.android.exoplayer2.text.cea.Cea708Decoder;
import com.google.android.exoplayer2.text.dvb.DvbDecoder;
import com.google.android.exoplayer2.text.pgs.PgsDecoder;
import com.google.android.exoplayer2.text.ssa.SsaDecoder;
import com.google.android.exoplayer2.text.subrip.SubripDecoder;
import com.google.android.exoplayer2.text.ttml.TtmlDecoder;
import com.google.android.exoplayer2.text.tx3g.Tx3gDecoder;
import com.google.android.exoplayer2.text.webvtt.Mp4WebvttDecoder;
import com.google.android.exoplayer2.text.webvtt.WebvttDecoder;

public interface SubtitleDecoderFactory {
    public static final SubtitleDecoderFactory DEFAULT = new SubtitleDecoderFactory(){

        @Override
        public boolean supportsFormat(Format format) {
            String mimeType = format.sampleMimeType;
            return "text/vtt".equals(mimeType) || "text/x-ssa".equals(mimeType) || "application/ttml+xml".equals(mimeType) || "application/x-mp4-vtt".equals(mimeType) || "application/x-subrip".equals(mimeType) || "application/x-quicktime-tx3g".equals(mimeType) || "application/cea-608".equals(mimeType) || "application/x-mp4-cea-608".equals(mimeType) || "application/cea-708".equals(mimeType) || "application/dvbsubs".equals(mimeType) || "application/pgs".equals(mimeType) || "text/x-exoplayer-cues".equals(mimeType);
        }

        @Override
        public SubtitleDecoder createDecoder(Format format) {
            String mimeType = format.sampleMimeType;
            if (mimeType != null) {
                switch (mimeType) {
                    case "text/vtt": {
                        return new WebvttDecoder();
                    }
                    case "text/x-ssa": {
                        return new SsaDecoder(format.initializationData);
                    }
                    case "application/x-mp4-vtt": {
                        return new Mp4WebvttDecoder();
                    }
                    case "application/ttml+xml": {
                        return new TtmlDecoder();
                    }
                    case "application/x-subrip": {
                        return new SubripDecoder();
                    }
                    case "application/x-quicktime-tx3g": {
                        return new Tx3gDecoder(format.initializationData);
                    }
                    case "application/cea-608": 
                    case "application/x-mp4-cea-608": {
                        return new Cea608Decoder(mimeType, format.accessibilityChannel, 16000L);
                    }
                    case "application/cea-708": {
                        return new Cea708Decoder(format.accessibilityChannel, format.initializationData);
                    }
                    case "application/dvbsubs": {
                        return new DvbDecoder(format.initializationData);
                    }
                    case "application/pgs": {
                        return new PgsDecoder();
                    }
                    case "text/x-exoplayer-cues": {
                        return new ExoplayerCuesDecoder();
                    }
                }
            }
            String string = String.valueOf(mimeType);
            throw new IllegalArgumentException(string.length() != 0 ? "Attempted to create decoder for unsupported MIME type: ".concat(string) : new String("Attempted to create decoder for unsupported MIME type: "));
        }
    };

    public boolean supportsFormat(Format var1);

    public SubtitleDecoder createDecoder(Format var1);
}

