/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Point;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.RendererConfiguration;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectionOverrides;
import com.google.android.exoplayer2.trackselection.TrackSelectionParameters;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.BundleableUtil;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public class DefaultTrackSelector
extends MappingTrackSelector {
    protected static final int SELECTION_ELIGIBILITY_NO = 0;
    protected static final int SELECTION_ELIGIBILITY_FIXED = 1;
    protected static final int SELECTION_ELIGIBILITY_ADAPTIVE = 2;
    private static final float FRACTION_TO_CONSIDER_FULLSCREEN = 0.98f;
    private static final Ordering<Integer> FORMAT_VALUE_ORDERING = Ordering.from((first, second) -> first == -1 ? (second == -1 ? 0 : -1) : (second == -1 ? 1 : first - second));
    private static final Ordering<Integer> NO_ORDER = Ordering.from((first, second) -> 0);
    private final ExoTrackSelection.Factory trackSelectionFactory;
    private final AtomicReference<Parameters> parametersReference;

    @Deprecated
    public DefaultTrackSelector() {
        this(Parameters.DEFAULT_WITHOUT_CONTEXT, (ExoTrackSelection.Factory)new AdaptiveTrackSelection.Factory());
    }

    @Deprecated
    public DefaultTrackSelector(ExoTrackSelection.Factory trackSelectionFactory) {
        this(Parameters.DEFAULT_WITHOUT_CONTEXT, trackSelectionFactory);
    }

    public DefaultTrackSelector(Context context) {
        this(context, (ExoTrackSelection.Factory)new AdaptiveTrackSelection.Factory());
    }

    public DefaultTrackSelector(Context context, ExoTrackSelection.Factory trackSelectionFactory) {
        this(Parameters.getDefaults(context), trackSelectionFactory);
    }

    public DefaultTrackSelector(Parameters parameters, ExoTrackSelection.Factory trackSelectionFactory) {
        this.trackSelectionFactory = trackSelectionFactory;
        this.parametersReference = new AtomicReference<Parameters>(parameters);
    }

    @Override
    public Parameters getParameters() {
        return this.parametersReference.get();
    }

    @Override
    public boolean isSetParametersSupported() {
        return true;
    }

    @Override
    public void setParameters(TrackSelectionParameters parameters) {
        if (parameters instanceof Parameters) {
            this.setParametersInternal((Parameters)parameters);
        }
        Parameters mergedParameters = new ParametersBuilder(this.parametersReference.get()).set(parameters).build();
        this.setParametersInternal(mergedParameters);
    }

    public void setParameters(ParametersBuilder parametersBuilder) {
        this.setParametersInternal(parametersBuilder.build());
    }

    public ParametersBuilder buildUponParameters() {
        return this.getParameters().buildUpon();
    }

    private void setParametersInternal(Parameters parameters) {
        Assertions.checkNotNull((Object)((Object)parameters));
        if (!this.parametersReference.getAndSet(parameters).equals((Object)parameters)) {
            this.invalidate();
        }
    }

    @Override
    protected final Pair<@NullableType RendererConfiguration[], @NullableType ExoTrackSelection[]> selectTracks(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] rendererFormatSupports, int[] rendererMixedMimeTypeAdaptationSupports, MediaSource.MediaPeriodId mediaPeriodId, Timeline timeline) throws ExoPlaybackException {
        int i;
        Parameters params = this.parametersReference.get();
        int rendererCount = mappedTrackInfo.getRendererCount();
        @NullableType ExoTrackSelection.Definition[] definitions = this.selectAllTracks(mappedTrackInfo, rendererFormatSupports, rendererMixedMimeTypeAdaptationSupports, params);
        SparseArray<Pair<TrackSelectionOverrides.TrackSelectionOverride, Integer>> applicableOverridesByTrackType = this.getApplicableOverrides(mappedTrackInfo, params);
        for (i = 0; i < applicableOverridesByTrackType.size(); ++i) {
            Pair overrideAndRendererIndex = (Pair)applicableOverridesByTrackType.valueAt(i);
            this.applyTrackTypeOverride(mappedTrackInfo, definitions, applicableOverridesByTrackType.keyAt(i), (TrackSelectionOverrides.TrackSelectionOverride)overrideAndRendererIndex.first, (Integer)overrideAndRendererIndex.second);
        }
        for (i = 0; i < rendererCount; ++i) {
            if (!this.hasLegacyRendererOverride(mappedTrackInfo, params, i)) continue;
            definitions[i] = this.getLegacyRendererOverride(mappedTrackInfo, params, i);
        }
        for (i = 0; i < rendererCount; ++i) {
            if (!this.isRendererDisabled(mappedTrackInfo, params, i)) continue;
            definitions[i] = null;
        }
        @NullableType ExoTrackSelection[] rendererTrackSelections = this.trackSelectionFactory.createTrackSelections(definitions, this.getBandwidthMeter(), mediaPeriodId, timeline);
        @NullableType RendererConfiguration[] rendererConfigurations = new RendererConfiguration[rendererCount];
        for (int i2 = 0; i2 < rendererCount; ++i2) {
            int rendererType = mappedTrackInfo.getRendererType(i2);
            boolean forceRendererDisabled = params.getRendererDisabled(i2) || params.disabledTrackTypes.contains((Object)rendererType);
            boolean rendererEnabled = !forceRendererDisabled && (mappedTrackInfo.getRendererType(i2) == -2 || rendererTrackSelections[i2] != null);
            rendererConfigurations[i2] = rendererEnabled ? RendererConfiguration.DEFAULT : null;
        }
        if (params.tunnelingEnabled) {
            DefaultTrackSelector.maybeConfigureRenderersForTunneling(mappedTrackInfo, rendererFormatSupports, rendererConfigurations, rendererTrackSelections);
        }
        return Pair.create((Object)rendererConfigurations, (Object)rendererTrackSelections);
    }

    private boolean isRendererDisabled(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, Parameters params, int rendererIndex) {
        int rendererType = mappedTrackInfo.getRendererType(rendererIndex);
        return params.getRendererDisabled(rendererIndex) || params.disabledTrackTypes.contains((Object)rendererType);
    }

    private boolean hasLegacyRendererOverride(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, Parameters params, int rendererIndex) {
        TrackGroupArray rendererTrackGroups = mappedTrackInfo.getTrackGroups(rendererIndex);
        return params.hasSelectionOverride(rendererIndex, rendererTrackGroups);
    }

    private @NullableType ExoTrackSelection.Definition getLegacyRendererOverride(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, Parameters params, int rendererIndex) {
        TrackGroupArray rendererTrackGroups = mappedTrackInfo.getTrackGroups(rendererIndex);
        SelectionOverride override = params.getSelectionOverride(rendererIndex, rendererTrackGroups);
        if (override == null) {
            return null;
        }
        return new ExoTrackSelection.Definition(rendererTrackGroups.get(override.groupIndex), override.tracks, override.type);
    }

    private SparseArray<Pair<TrackSelectionOverrides.TrackSelectionOverride, Integer>> getApplicableOverrides(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, Parameters params) {
        SparseArray applicableOverrides = new SparseArray();
        int rendererCount = mappedTrackInfo.getRendererCount();
        for (int rendererIndex = 0; rendererIndex < rendererCount; ++rendererIndex) {
            TrackGroupArray rendererTrackGroups = mappedTrackInfo.getTrackGroups(rendererIndex);
            for (int j = 0; j < rendererTrackGroups.length; ++j) {
                this.maybeUpdateApplicableOverrides((SparseArray<Pair<TrackSelectionOverrides.TrackSelectionOverride, Integer>>)applicableOverrides, params.trackSelectionOverrides.getOverride(rendererTrackGroups.get(j)), rendererIndex);
            }
        }
        TrackGroupArray unmappedGroups = mappedTrackInfo.getUnmappedTrackGroups();
        for (int i = 0; i < unmappedGroups.length; ++i) {
            this.maybeUpdateApplicableOverrides((SparseArray<Pair<TrackSelectionOverrides.TrackSelectionOverride, Integer>>)applicableOverrides, params.trackSelectionOverrides.getOverride(unmappedGroups.get(i)), -1);
        }
        return applicableOverrides;
    }

    private void maybeUpdateApplicableOverrides(SparseArray<Pair<TrackSelectionOverrides.TrackSelectionOverride, Integer>> applicableOverrides, @Nullable TrackSelectionOverrides.TrackSelectionOverride override, int rendererIndex) {
        if (override == null) {
            return;
        }
        int trackType = override.getTrackType();
        Pair existingOverride = (Pair)applicableOverrides.get(trackType);
        if (existingOverride == null || ((TrackSelectionOverrides.TrackSelectionOverride)existingOverride.first).trackIndices.isEmpty()) {
            applicableOverrides.put(trackType, (Object)Pair.create((Object)override, (Object)rendererIndex));
        }
    }

    private void applyTrackTypeOverride(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, @NullableType ExoTrackSelection.Definition[] definitions, int trackType, TrackSelectionOverrides.TrackSelectionOverride override, int overrideRendererIndex) {
        for (int i = 0; i < definitions.length; ++i) {
            if (overrideRendererIndex == i) {
                definitions[i] = new ExoTrackSelection.Definition(override.trackGroup, Ints.toArray((Collection)override.trackIndices));
                continue;
            }
            if (mappedTrackInfo.getRendererType(i) != trackType) continue;
            definitions[i] = null;
        }
    }

    protected @NullableType ExoTrackSelection.Definition[] selectAllTracks(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] rendererFormatSupports, int[] rendererMixedMimeTypeAdaptationSupports, Parameters params) throws ExoPlaybackException {
        String selectedAudioLanguage;
        Pair<ExoTrackSelection.Definition, Integer> selectedText;
        Pair<ExoTrackSelection.Definition, Integer> selectedAudio;
        int rendererCount = mappedTrackInfo.getRendererCount();
        @NullableType ExoTrackSelection.Definition[] definitions = new ExoTrackSelection.Definition[rendererCount];
        Pair<ExoTrackSelection.Definition, Integer> selectedVideo = this.selectVideoTrack(mappedTrackInfo, rendererFormatSupports, rendererMixedMimeTypeAdaptationSupports, params);
        if (selectedVideo != null) {
            definitions[((Integer)selectedVideo.second).intValue()] = (ExoTrackSelection.Definition)selectedVideo.first;
        }
        if ((selectedAudio = this.selectAudioTrack(mappedTrackInfo, rendererFormatSupports, rendererMixedMimeTypeAdaptationSupports, params)) != null) {
            definitions[((Integer)selectedAudio.second).intValue()] = (ExoTrackSelection.Definition)selectedAudio.first;
        }
        if ((selectedText = this.selectTextTrack(mappedTrackInfo, rendererFormatSupports, params, selectedAudioLanguage = selectedAudio == null ? null : ((ExoTrackSelection.Definition)selectedAudio.first).group.getFormat((int)((ExoTrackSelection.Definition)selectedAudio.first).tracks[0]).language)) != null) {
            definitions[((Integer)selectedText.second).intValue()] = (ExoTrackSelection.Definition)selectedText.first;
        }
        for (int i = 0; i < rendererCount; ++i) {
            int trackType = mappedTrackInfo.getRendererType(i);
            if (trackType == 2 || trackType == 1 || trackType == 3) continue;
            definitions[i] = this.selectOtherTrack(trackType, mappedTrackInfo.getTrackGroups(i), rendererFormatSupports[i], params);
        }
        return definitions;
    }

    @SuppressLint(value={"WrongConstant"})
    @Nullable
    protected Pair<ExoTrackSelection.Definition, Integer> selectVideoTrack(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] rendererFormatSupports, int[] mixedMimeTypeSupports, Parameters params) throws ExoPlaybackException {
        return this.selectTracksForType(2, mappedTrackInfo, rendererFormatSupports, (rendererIndex, group, support) -> VideoTrackInfo.createForTrackGroup(rendererIndex, group, params, support, mixedMimeTypeSupports[rendererIndex]), VideoTrackInfo::compareSelections);
    }

    @SuppressLint(value={"WrongConstant"})
    @Nullable
    protected Pair<ExoTrackSelection.Definition, Integer> selectAudioTrack(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] rendererFormatSupports, int[] rendererMixedMimeTypeAdaptationSupports, Parameters params) throws ExoPlaybackException {
        boolean hasVideoRendererWithMappedTracks = false;
        for (int i = 0; i < mappedTrackInfo.getRendererCount(); ++i) {
            if (2 != mappedTrackInfo.getRendererType(i) || mappedTrackInfo.getTrackGroups((int)i).length <= 0) continue;
            hasVideoRendererWithMappedTracks = true;
            break;
        }
        boolean hasVideoRendererWithMappedTracksFinal = hasVideoRendererWithMappedTracks;
        return this.selectTracksForType(1, mappedTrackInfo, rendererFormatSupports, (rendererIndex, group, support) -> AudioTrackInfo.createForTrackGroup(rendererIndex, group, params, support, hasVideoRendererWithMappedTracksFinal), AudioTrackInfo::compareSelections);
    }

    @SuppressLint(value={"WrongConstant"})
    @Nullable
    protected Pair<ExoTrackSelection.Definition, Integer> selectTextTrack(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] rendererFormatSupports, Parameters params, @Nullable String selectedAudioLanguage) throws ExoPlaybackException {
        return this.selectTracksForType(3, mappedTrackInfo, rendererFormatSupports, (rendererIndex, group, support) -> TextTrackInfo.createForTrackGroup(rendererIndex, group, params, support, selectedAudioLanguage), TextTrackInfo::compareSelections);
    }

    @Nullable
    protected ExoTrackSelection.Definition selectOtherTrack(int trackType, TrackGroupArray groups, int[][] formatSupport, Parameters params) throws ExoPlaybackException {
        TrackGroup selectedGroup = null;
        int selectedTrackIndex = 0;
        OtherTrackScore selectedTrackScore = null;
        for (int groupIndex = 0; groupIndex < groups.length; ++groupIndex) {
            TrackGroup trackGroup = groups.get(groupIndex);
            int[] trackFormatSupport = formatSupport[groupIndex];
            for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                if (!DefaultTrackSelector.isSupported(trackFormatSupport[trackIndex], params.exceedRendererCapabilitiesIfNecessary)) continue;
                Format format = trackGroup.getFormat(trackIndex);
                OtherTrackScore trackScore = new OtherTrackScore(format, trackFormatSupport[trackIndex]);
                if (selectedTrackScore != null && trackScore.compareTo(selectedTrackScore) <= 0) continue;
                selectedGroup = trackGroup;
                selectedTrackIndex = trackIndex;
                selectedTrackScore = trackScore;
            }
        }
        return selectedGroup == null ? null : new ExoTrackSelection.Definition(selectedGroup, selectedTrackIndex);
    }

    @Nullable
    private <T extends TrackInfo<T>> Pair<ExoTrackSelection.Definition, Integer> selectTracksForType(int trackType, MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] formatSupport, TrackInfo.Factory<T> trackInfoFactory, Comparator<List<T>> selectionComparator) {
        ArrayList<Object> possibleSelections = new ArrayList<Object>();
        int rendererCount = mappedTrackInfo.getRendererCount();
        for (int rendererIndex = 0; rendererIndex < rendererCount; ++rendererIndex) {
            if (trackType != mappedTrackInfo.getRendererType(rendererIndex)) continue;
            TrackGroupArray groups = mappedTrackInfo.getTrackGroups(rendererIndex);
            for (int groupIndex = 0; groupIndex < groups.length; ++groupIndex) {
                TrackGroup trackGroup = groups.get(groupIndex);
                int[] groupSupport = formatSupport[rendererIndex][groupIndex];
                List<T> trackInfos = trackInfoFactory.create(rendererIndex, trackGroup, groupSupport);
                boolean[] usedTrackInSelection = new boolean[trackGroup.length];
                for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                    Object selection;
                    TrackInfo trackInfo = (TrackInfo)trackInfos.get(trackIndex);
                    int eligibility = trackInfo.getSelectionEligibility();
                    if (usedTrackInSelection[trackIndex] || eligibility == 0) continue;
                    if (eligibility == 1) {
                        selection = ImmutableList.of((Object)trackInfo);
                    } else {
                        selection = new ArrayList();
                        selection.add(trackInfo);
                        for (int i = trackIndex + 1; i < trackGroup.length; ++i) {
                            TrackInfo otherTrackInfo = (TrackInfo)trackInfos.get(i);
                            if (otherTrackInfo.getSelectionEligibility() != 2 || !trackInfo.isCompatibleForAdaptationWith(otherTrackInfo)) continue;
                            selection.add(otherTrackInfo);
                            usedTrackInSelection[i] = true;
                        }
                    }
                    possibleSelections.add(selection);
                }
            }
        }
        if (possibleSelections.isEmpty()) {
            return null;
        }
        List<T> bestSelection = Collections.max(possibleSelections, selectionComparator);
        int[] trackIndices = new int[bestSelection.size()];
        for (int i = 0; i < bestSelection.size(); ++i) {
            trackIndices[i] = ((TrackInfo)bestSelection.get((int)i)).trackIndex;
        }
        TrackInfo firstTrackInfo = (TrackInfo)bestSelection.get(0);
        return Pair.create((Object)new ExoTrackSelection.Definition(firstTrackInfo.trackGroup, trackIndices), (Object)firstTrackInfo.rendererIndex);
    }

    private static void maybeConfigureRenderersForTunneling(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] renderererFormatSupports, @NullableType RendererConfiguration[] rendererConfigurations, @NullableType ExoTrackSelection[] trackSelections) {
        int tunnelingAudioRendererIndex = -1;
        int tunnelingVideoRendererIndex = -1;
        boolean enableTunneling = true;
        for (int i = 0; i < mappedTrackInfo.getRendererCount(); ++i) {
            int rendererType = mappedTrackInfo.getRendererType(i);
            ExoTrackSelection trackSelection = trackSelections[i];
            if (rendererType != 1 && rendererType != 2 || trackSelection == null || !DefaultTrackSelector.rendererSupportsTunneling(renderererFormatSupports[i], mappedTrackInfo.getTrackGroups(i), trackSelection)) continue;
            if (rendererType == 1) {
                if (tunnelingAudioRendererIndex != -1) {
                    enableTunneling = false;
                    break;
                }
                tunnelingAudioRendererIndex = i;
                continue;
            }
            if (tunnelingVideoRendererIndex != -1) {
                enableTunneling = false;
                break;
            }
            tunnelingVideoRendererIndex = i;
        }
        if (enableTunneling &= tunnelingAudioRendererIndex != -1 && tunnelingVideoRendererIndex != -1) {
            RendererConfiguration tunnelingRendererConfiguration;
            rendererConfigurations[tunnelingAudioRendererIndex] = tunnelingRendererConfiguration = new RendererConfiguration(true);
            rendererConfigurations[tunnelingVideoRendererIndex] = tunnelingRendererConfiguration;
        }
    }

    private static boolean rendererSupportsTunneling(int[][] formatSupport, TrackGroupArray trackGroups, ExoTrackSelection selection) {
        if (selection == null) {
            return false;
        }
        int trackGroupIndex = trackGroups.indexOf(selection.getTrackGroup());
        for (int i = 0; i < selection.length(); ++i) {
            int trackFormatSupport = formatSupport[trackGroupIndex][selection.getIndexInTrackGroup(i)];
            if (RendererCapabilities.getTunnelingSupport(trackFormatSupport) == 32) continue;
            return false;
        }
        return true;
    }

    protected static boolean isSupported(int formatSupport, boolean allowExceedsCapabilities) {
        int maskedSupport = RendererCapabilities.getFormatSupport(formatSupport);
        return maskedSupport == 4 || allowExceedsCapabilities && maskedSupport == 3;
    }

    @Nullable
    protected static String normalizeUndeterminedLanguageToNull(@Nullable String language) {
        return TextUtils.isEmpty((CharSequence)language) || TextUtils.equals((CharSequence)language, (CharSequence)"und") ? null : language;
    }

    protected static int getFormatLanguageScore(Format format, @Nullable String language, boolean allowUndeterminedFormatLanguage) {
        String queryMainLanguage;
        if (!TextUtils.isEmpty((CharSequence)language) && language.equals(format.language)) {
            return 4;
        }
        language = DefaultTrackSelector.normalizeUndeterminedLanguageToNull(language);
        String formatLanguage = DefaultTrackSelector.normalizeUndeterminedLanguageToNull(format.language);
        if (formatLanguage == null || language == null) {
            return allowUndeterminedFormatLanguage && formatLanguage == null ? 1 : 0;
        }
        if (formatLanguage.startsWith(language) || language.startsWith(formatLanguage)) {
            return 3;
        }
        String formatMainLanguage = Util.splitAtFirst((String)formatLanguage, (String)"-")[0];
        if (formatMainLanguage.equals(queryMainLanguage = Util.splitAtFirst((String)language, (String)"-")[0])) {
            return 2;
        }
        return 0;
    }

    private static int getMaxVideoPixelsToRetainForViewport(TrackGroup group, int viewportWidth, int viewportHeight, boolean orientationMayChange) {
        if (viewportWidth == Integer.MAX_VALUE || viewportHeight == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int maxVideoPixelsToRetain = Integer.MAX_VALUE;
        for (int i = 0; i < group.length; ++i) {
            Format format = group.getFormat(i);
            if (format.width <= 0 || format.height <= 0) continue;
            Point maxVideoSizeInViewport = DefaultTrackSelector.getMaxVideoSizeInViewport(orientationMayChange, viewportWidth, viewportHeight, format.width, format.height);
            int videoPixels = format.width * format.height;
            if (format.width < (int)((float)maxVideoSizeInViewport.x * 0.98f) || format.height < (int)((float)maxVideoSizeInViewport.y * 0.98f) || videoPixels >= maxVideoPixelsToRetain) continue;
            maxVideoPixelsToRetain = videoPixels;
        }
        return maxVideoPixelsToRetain;
    }

    private static Point getMaxVideoSizeInViewport(boolean orientationMayChange, int viewportWidth, int viewportHeight, int videoWidth, int videoHeight) {
        if (orientationMayChange && videoWidth > videoHeight != viewportWidth > viewportHeight) {
            int tempViewportWidth = viewportWidth;
            viewportWidth = viewportHeight;
            viewportHeight = tempViewportWidth;
        }
        if (videoWidth * viewportHeight >= videoHeight * viewportWidth) {
            return new Point(viewportWidth, Util.ceilDivide((int)(viewportWidth * videoHeight), (int)videoWidth));
        }
        return new Point(Util.ceilDivide((int)(viewportHeight * videoWidth), (int)videoHeight), viewportHeight);
    }

    private static int getRoleFlagMatchScore(int trackRoleFlags, int preferredRoleFlags) {
        if (trackRoleFlags != 0 && trackRoleFlags == preferredRoleFlags) {
            return Integer.MAX_VALUE;
        }
        return Integer.bitCount(trackRoleFlags & preferredRoleFlags);
    }

    private static int getVideoCodecPreferenceScore(@Nullable String mimeType) {
        if (mimeType == null) {
            return 0;
        }
        switch (mimeType) {
            case "video/av01": {
                return 4;
            }
            case "video/hevc": {
                return 3;
            }
            case "video/x-vnd.on2.vp9": {
                return 2;
            }
            case "video/avc": {
                return 1;
            }
        }
        return 0;
    }

    private static final class OtherTrackScore
    implements Comparable<OtherTrackScore> {
        private final boolean isDefault;
        private final boolean isWithinRendererCapabilities;

        public OtherTrackScore(Format format, int trackFormatSupport) {
            this.isDefault = (format.selectionFlags & 1) != 0;
            this.isWithinRendererCapabilities = DefaultTrackSelector.isSupported(trackFormatSupport, false);
        }

        @Override
        public int compareTo(OtherTrackScore other) {
            return ComparisonChain.start().compareFalseFirst(this.isWithinRendererCapabilities, other.isWithinRendererCapabilities).compareFalseFirst(this.isDefault, other.isDefault).result();
        }
    }

    private static final class TextTrackInfo
    extends TrackInfo<TextTrackInfo>
    implements Comparable<TextTrackInfo> {
        private final int selectionEligibility;
        private final boolean isWithinRendererCapabilities;
        private final boolean isDefault;
        private final boolean isForced;
        private final int preferredLanguageIndex;
        private final int preferredLanguageScore;
        private final int preferredRoleFlagsScore;
        private final int selectedAudioLanguageScore;
        private final boolean hasCaptionRoleFlags;

        public static ImmutableList<TextTrackInfo> createForTrackGroup(int rendererIndex, TrackGroup trackGroup, Parameters params, int[] formatSupport, @Nullable String selectedAudioLanguage) {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (int i = 0; i < trackGroup.length; ++i) {
                listBuilder.add((Object)new TextTrackInfo(rendererIndex, trackGroup, i, params, formatSupport[i], selectedAudioLanguage));
            }
            return listBuilder.build();
        }

        public TextTrackInfo(int rendererIndex, TrackGroup trackGroup, int trackIndex, Parameters parameters, int trackFormatSupport, @Nullable String selectedAudioLanguage) {
            super(rendererIndex, trackGroup, trackIndex);
            this.isWithinRendererCapabilities = DefaultTrackSelector.isSupported(trackFormatSupport, false);
            int maskedSelectionFlags = this.format.selectionFlags & ~parameters.disabledTextTrackSelectionFlags;
            this.isDefault = (maskedSelectionFlags & 1) != 0;
            this.isForced = (maskedSelectionFlags & 2) != 0;
            int bestLanguageIndex = Integer.MAX_VALUE;
            int bestLanguageScore = 0;
            ImmutableList preferredLanguages = parameters.preferredTextLanguages.isEmpty() ? ImmutableList.of((Object)"") : parameters.preferredTextLanguages;
            for (int i = 0; i < preferredLanguages.size(); ++i) {
                int score = DefaultTrackSelector.getFormatLanguageScore(this.format, (String)preferredLanguages.get(i), parameters.selectUndeterminedTextLanguage);
                if (score <= 0) continue;
                bestLanguageIndex = i;
                bestLanguageScore = score;
                break;
            }
            this.preferredLanguageIndex = bestLanguageIndex;
            this.preferredLanguageScore = bestLanguageScore;
            this.preferredRoleFlagsScore = DefaultTrackSelector.getRoleFlagMatchScore(this.format.roleFlags, parameters.preferredTextRoleFlags);
            this.hasCaptionRoleFlags = (this.format.roleFlags & 0x440) != 0;
            boolean selectedAudioLanguageUndetermined = DefaultTrackSelector.normalizeUndeterminedLanguageToNull(selectedAudioLanguage) == null;
            this.selectedAudioLanguageScore = DefaultTrackSelector.getFormatLanguageScore(this.format, selectedAudioLanguage, selectedAudioLanguageUndetermined);
            boolean isWithinConstraints = this.preferredLanguageScore > 0 || parameters.preferredTextLanguages.isEmpty() && this.preferredRoleFlagsScore > 0 || this.isDefault || this.isForced && this.selectedAudioLanguageScore > 0;
            this.selectionEligibility = DefaultTrackSelector.isSupported(trackFormatSupport, parameters.exceedRendererCapabilitiesIfNecessary) && isWithinConstraints ? 1 : 0;
        }

        @Override
        public int getSelectionEligibility() {
            return this.selectionEligibility;
        }

        @Override
        public boolean isCompatibleForAdaptationWith(TextTrackInfo otherTrack) {
            return false;
        }

        @Override
        public int compareTo(TextTrackInfo other) {
            ComparisonChain chain = ComparisonChain.start().compareFalseFirst(this.isWithinRendererCapabilities, other.isWithinRendererCapabilities).compare((Object)this.preferredLanguageIndex, (Object)other.preferredLanguageIndex, (Comparator)Ordering.natural().reverse()).compare(this.preferredLanguageScore, other.preferredLanguageScore).compare(this.preferredRoleFlagsScore, other.preferredRoleFlagsScore).compareFalseFirst(this.isDefault, other.isDefault).compare((Object)this.isForced, (Object)other.isForced, (Comparator)(this.preferredLanguageScore == 0 ? Ordering.natural() : Ordering.natural().reverse())).compare(this.selectedAudioLanguageScore, other.selectedAudioLanguageScore);
            if (this.preferredRoleFlagsScore == 0) {
                chain = chain.compareTrueFirst(this.hasCaptionRoleFlags, other.hasCaptionRoleFlags);
            }
            return chain.result();
        }

        public static int compareSelections(List<TextTrackInfo> infos1, List<TextTrackInfo> infos2) {
            return infos1.get(0).compareTo(infos2.get(0));
        }
    }

    private static final class AudioTrackInfo
    extends TrackInfo<AudioTrackInfo>
    implements Comparable<AudioTrackInfo> {
        private final int selectionEligibility;
        private final boolean isWithinConstraints;
        @Nullable
        private final String language;
        private final Parameters parameters;
        private final boolean isWithinRendererCapabilities;
        private final int preferredLanguageScore;
        private final int preferredLanguageIndex;
        private final int preferredRoleFlagsScore;
        private final boolean hasMainOrNoRoleFlag;
        private final int localeLanguageMatchIndex;
        private final int localeLanguageScore;
        private final boolean isDefaultSelectionFlag;
        private final int channelCount;
        private final int sampleRate;
        private final int bitrate;
        private final int preferredMimeTypeMatchIndex;
        private final boolean usesPrimaryDecoder;
        private final boolean usesHardwareAcceleration;

        public static ImmutableList<AudioTrackInfo> createForTrackGroup(int rendererIndex, TrackGroup trackGroup, Parameters params, int[] formatSupport, boolean hasMappedVideoTracks) {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (int i = 0; i < trackGroup.length; ++i) {
                listBuilder.add((Object)new AudioTrackInfo(rendererIndex, trackGroup, i, params, formatSupport[i], hasMappedVideoTracks));
            }
            return listBuilder.build();
        }

        public AudioTrackInfo(int rendererIndex, TrackGroup trackGroup, int trackIndex, Parameters parameters, int formatSupport, boolean hasMappedVideoTracks) {
            super(rendererIndex, trackGroup, trackIndex);
            this.parameters = parameters;
            this.language = DefaultTrackSelector.normalizeUndeterminedLanguageToNull(this.format.language);
            this.isWithinRendererCapabilities = DefaultTrackSelector.isSupported(formatSupport, false);
            int bestLanguageScore = 0;
            int bestLanguageIndex = Integer.MAX_VALUE;
            for (int i = 0; i < parameters.preferredAudioLanguages.size(); ++i) {
                int score = DefaultTrackSelector.getFormatLanguageScore(this.format, (String)parameters.preferredAudioLanguages.get(i), false);
                if (score <= 0) continue;
                bestLanguageIndex = i;
                bestLanguageScore = score;
                break;
            }
            this.preferredLanguageIndex = bestLanguageIndex;
            this.preferredLanguageScore = bestLanguageScore;
            this.preferredRoleFlagsScore = DefaultTrackSelector.getRoleFlagMatchScore(this.format.roleFlags, parameters.preferredAudioRoleFlags);
            this.hasMainOrNoRoleFlag = this.format.roleFlags == 0 || (this.format.roleFlags & 1) != 0;
            this.isDefaultSelectionFlag = (this.format.selectionFlags & 1) != 0;
            this.channelCount = this.format.channelCount;
            this.sampleRate = this.format.sampleRate;
            this.bitrate = this.format.bitrate;
            this.isWithinConstraints = !(this.format.bitrate != -1 && this.format.bitrate > parameters.maxAudioBitrate || this.format.channelCount != -1 && this.format.channelCount > parameters.maxAudioChannelCount);
            String[] localeLanguages = Util.getSystemLanguageCodes();
            int bestLocaleMatchIndex = Integer.MAX_VALUE;
            int bestLocaleMatchScore = 0;
            for (int i = 0; i < localeLanguages.length; ++i) {
                int score = DefaultTrackSelector.getFormatLanguageScore(this.format, localeLanguages[i], false);
                if (score <= 0) continue;
                bestLocaleMatchIndex = i;
                bestLocaleMatchScore = score;
                break;
            }
            this.localeLanguageMatchIndex = bestLocaleMatchIndex;
            this.localeLanguageScore = bestLocaleMatchScore;
            int bestMimeTypeMatchIndex = Integer.MAX_VALUE;
            for (int i = 0; i < parameters.preferredAudioMimeTypes.size(); ++i) {
                if (this.format.sampleMimeType == null || !this.format.sampleMimeType.equals(parameters.preferredAudioMimeTypes.get(i))) continue;
                bestMimeTypeMatchIndex = i;
                break;
            }
            this.preferredMimeTypeMatchIndex = bestMimeTypeMatchIndex;
            this.usesPrimaryDecoder = RendererCapabilities.getDecoderSupport(formatSupport) == 128;
            this.usesHardwareAcceleration = RendererCapabilities.getHardwareAccelerationSupport(formatSupport) == 64;
            this.selectionEligibility = this.evaluateSelectionEligibility(formatSupport, hasMappedVideoTracks);
        }

        @Override
        public int getSelectionEligibility() {
            return this.selectionEligibility;
        }

        @Override
        public boolean isCompatibleForAdaptationWith(AudioTrackInfo otherTrack) {
            return (this.parameters.allowAudioMixedChannelCountAdaptiveness || this.format.channelCount != -1 && this.format.channelCount == otherTrack.format.channelCount) && (this.parameters.allowAudioMixedMimeTypeAdaptiveness || this.format.sampleMimeType != null && TextUtils.equals((CharSequence)this.format.sampleMimeType, (CharSequence)otherTrack.format.sampleMimeType)) && (this.parameters.allowAudioMixedSampleRateAdaptiveness || this.format.sampleRate != -1 && this.format.sampleRate == otherTrack.format.sampleRate) && (this.parameters.allowAudioMixedDecoderSupportAdaptiveness || this.usesPrimaryDecoder == otherTrack.usesPrimaryDecoder && this.usesHardwareAcceleration == otherTrack.usesHardwareAcceleration);
        }

        @Override
        public int compareTo(AudioTrackInfo other) {
            Ordering qualityOrdering = this.isWithinConstraints && this.isWithinRendererCapabilities ? FORMAT_VALUE_ORDERING : FORMAT_VALUE_ORDERING.reverse();
            return ComparisonChain.start().compareFalseFirst(this.isWithinRendererCapabilities, other.isWithinRendererCapabilities).compare((Object)this.preferredLanguageIndex, (Object)other.preferredLanguageIndex, (Comparator)Ordering.natural().reverse()).compare(this.preferredLanguageScore, other.preferredLanguageScore).compare(this.preferredRoleFlagsScore, other.preferredRoleFlagsScore).compareFalseFirst(this.isDefaultSelectionFlag, other.isDefaultSelectionFlag).compareFalseFirst(this.hasMainOrNoRoleFlag, other.hasMainOrNoRoleFlag).compare((Object)this.localeLanguageMatchIndex, (Object)other.localeLanguageMatchIndex, (Comparator)Ordering.natural().reverse()).compare(this.localeLanguageScore, other.localeLanguageScore).compareFalseFirst(this.isWithinConstraints, other.isWithinConstraints).compare((Object)this.preferredMimeTypeMatchIndex, (Object)other.preferredMimeTypeMatchIndex, (Comparator)Ordering.natural().reverse()).compare((Object)this.bitrate, (Object)other.bitrate, (Comparator)(this.parameters.forceLowestBitrate ? FORMAT_VALUE_ORDERING.reverse() : NO_ORDER)).compareFalseFirst(this.usesPrimaryDecoder, other.usesPrimaryDecoder).compareFalseFirst(this.usesHardwareAcceleration, other.usesHardwareAcceleration).compare((Object)this.channelCount, (Object)other.channelCount, (Comparator)qualityOrdering).compare((Object)this.sampleRate, (Object)other.sampleRate, (Comparator)qualityOrdering).compare((Object)this.bitrate, (Object)other.bitrate, (Comparator)(Util.areEqual((Object)this.language, (Object)other.language) ? qualityOrdering : NO_ORDER)).result();
        }

        private int evaluateSelectionEligibility(int rendererSupport, boolean hasMappedVideoTracks) {
            if (!DefaultTrackSelector.isSupported(rendererSupport, this.parameters.exceedRendererCapabilitiesIfNecessary)) {
                return 0;
            }
            if (!this.isWithinConstraints && !this.parameters.exceedAudioConstraintsIfNecessary) {
                return 0;
            }
            return DefaultTrackSelector.isSupported(rendererSupport, false) && this.isWithinConstraints && this.format.bitrate != -1 && !this.parameters.forceHighestSupportedBitrate && !this.parameters.forceLowestBitrate && (this.parameters.allowMultipleAdaptiveSelections || !hasMappedVideoTracks) ? 2 : 1;
        }

        public static int compareSelections(List<AudioTrackInfo> infos1, List<AudioTrackInfo> infos2) {
            return Collections.max(infos1).compareTo(Collections.max(infos2));
        }
    }

    private static final class VideoTrackInfo
    extends TrackInfo<VideoTrackInfo> {
        private final boolean isWithinMaxConstraints;
        private final Parameters parameters;
        private final boolean isWithinMinConstraints;
        private final boolean isWithinRendererCapabilities;
        private final int bitrate;
        private final int pixelCount;
        private final int preferredMimeTypeMatchIndex;
        private final int preferredRoleFlagsScore;
        private final boolean hasMainOrNoRoleFlag;
        private final boolean allowMixedMimeTypes;
        private final int selectionEligibility;
        private final boolean usesPrimaryDecoder;
        private final boolean usesHardwareAcceleration;
        private final int codecPreferenceScore;

        public static ImmutableList<VideoTrackInfo> createForTrackGroup(int rendererIndex, TrackGroup trackGroup, Parameters params, int[] formatSupport, int mixedMimeTypeAdaptionSupport) {
            int maxPixelsToRetainForViewport = DefaultTrackSelector.getMaxVideoPixelsToRetainForViewport(trackGroup, params.viewportWidth, params.viewportHeight, params.viewportOrientationMayChange);
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (int i = 0; i < trackGroup.length; ++i) {
                int pixelCount = trackGroup.getFormat(i).getPixelCount();
                boolean isSuitableForViewport = maxPixelsToRetainForViewport == Integer.MAX_VALUE || pixelCount != -1 && pixelCount <= maxPixelsToRetainForViewport;
                listBuilder.add((Object)new VideoTrackInfo(rendererIndex, trackGroup, i, params, formatSupport[i], mixedMimeTypeAdaptionSupport, isSuitableForViewport));
            }
            return listBuilder.build();
        }

        public VideoTrackInfo(int rendererIndex, TrackGroup trackGroup, int trackIndex, Parameters parameters, int formatSupport, int mixedMimeTypeAdaptationSupport, boolean isSuitableForViewport) {
            super(rendererIndex, trackGroup, trackIndex);
            this.parameters = parameters;
            int requiredAdaptiveSupport = parameters.allowVideoNonSeamlessAdaptiveness ? 24 : 16;
            this.allowMixedMimeTypes = parameters.allowVideoMixedMimeTypeAdaptiveness && (mixedMimeTypeAdaptationSupport & requiredAdaptiveSupport) != 0;
            this.isWithinMaxConstraints = !(!isSuitableForViewport || this.format.width != -1 && this.format.width > parameters.maxVideoWidth || this.format.height != -1 && this.format.height > parameters.maxVideoHeight || this.format.frameRate != -1.0f && !(this.format.frameRate <= (float)parameters.maxVideoFrameRate) || this.format.bitrate != -1 && this.format.bitrate > parameters.maxVideoBitrate);
            this.isWithinMinConstraints = !(!isSuitableForViewport || this.format.width != -1 && this.format.width < parameters.minVideoWidth || this.format.height != -1 && this.format.height < parameters.minVideoHeight || this.format.frameRate != -1.0f && !(this.format.frameRate >= (float)parameters.minVideoFrameRate) || this.format.bitrate != -1 && this.format.bitrate < parameters.minVideoBitrate);
            this.isWithinRendererCapabilities = DefaultTrackSelector.isSupported(formatSupport, false);
            this.bitrate = this.format.bitrate;
            this.pixelCount = this.format.getPixelCount();
            this.preferredRoleFlagsScore = DefaultTrackSelector.getRoleFlagMatchScore(this.format.roleFlags, parameters.preferredVideoRoleFlags);
            this.hasMainOrNoRoleFlag = this.format.roleFlags == 0 || (this.format.roleFlags & 1) != 0;
            int bestMimeTypeMatchIndex = Integer.MAX_VALUE;
            for (int i = 0; i < parameters.preferredVideoMimeTypes.size(); ++i) {
                if (this.format.sampleMimeType == null || !this.format.sampleMimeType.equals(parameters.preferredVideoMimeTypes.get(i))) continue;
                bestMimeTypeMatchIndex = i;
                break;
            }
            this.preferredMimeTypeMatchIndex = bestMimeTypeMatchIndex;
            this.usesPrimaryDecoder = RendererCapabilities.getDecoderSupport(formatSupport) == 128;
            this.usesHardwareAcceleration = RendererCapabilities.getHardwareAccelerationSupport(formatSupport) == 64;
            this.codecPreferenceScore = DefaultTrackSelector.getVideoCodecPreferenceScore(this.format.sampleMimeType);
            this.selectionEligibility = this.evaluateSelectionEligibility(formatSupport, requiredAdaptiveSupport);
        }

        @Override
        public int getSelectionEligibility() {
            return this.selectionEligibility;
        }

        @Override
        public boolean isCompatibleForAdaptationWith(VideoTrackInfo otherTrack) {
            return (this.allowMixedMimeTypes || Util.areEqual((Object)this.format.sampleMimeType, (Object)otherTrack.format.sampleMimeType)) && (this.parameters.allowVideoMixedDecoderSupportAdaptiveness || this.usesPrimaryDecoder == otherTrack.usesPrimaryDecoder && this.usesHardwareAcceleration == otherTrack.usesHardwareAcceleration);
        }

        private int evaluateSelectionEligibility(int rendererSupport, int requiredAdaptiveSupport) {
            if ((this.format.roleFlags & 0x4000) != 0) {
                return 0;
            }
            if (!DefaultTrackSelector.isSupported(rendererSupport, this.parameters.exceedRendererCapabilitiesIfNecessary)) {
                return 0;
            }
            if (!this.isWithinMaxConstraints && !this.parameters.exceedVideoConstraintsIfNecessary) {
                return 0;
            }
            return DefaultTrackSelector.isSupported(rendererSupport, false) && this.isWithinMinConstraints && this.isWithinMaxConstraints && this.format.bitrate != -1 && !this.parameters.forceHighestSupportedBitrate && !this.parameters.forceLowestBitrate && (rendererSupport & requiredAdaptiveSupport) != 0 ? 2 : 1;
        }

        private static int compareNonQualityPreferences(VideoTrackInfo info1, VideoTrackInfo info2) {
            ComparisonChain chain = ComparisonChain.start().compareFalseFirst(info1.isWithinRendererCapabilities, info2.isWithinRendererCapabilities).compare(info1.preferredRoleFlagsScore, info2.preferredRoleFlagsScore).compareFalseFirst(info1.hasMainOrNoRoleFlag, info2.hasMainOrNoRoleFlag).compareFalseFirst(info1.isWithinMaxConstraints, info2.isWithinMaxConstraints).compareFalseFirst(info1.isWithinMinConstraints, info2.isWithinMinConstraints).compare((Object)info1.preferredMimeTypeMatchIndex, (Object)info2.preferredMimeTypeMatchIndex, (Comparator)Ordering.natural().reverse()).compareFalseFirst(info1.usesPrimaryDecoder, info2.usesPrimaryDecoder).compareFalseFirst(info1.usesHardwareAcceleration, info2.usesHardwareAcceleration);
            if (info1.usesPrimaryDecoder && info1.usesHardwareAcceleration) {
                chain = chain.compare(info1.codecPreferenceScore, info2.codecPreferenceScore);
            }
            return chain.result();
        }

        private static int compareQualityPreferences(VideoTrackInfo info1, VideoTrackInfo info2) {
            Ordering qualityOrdering = info1.isWithinMaxConstraints && info1.isWithinRendererCapabilities ? FORMAT_VALUE_ORDERING : FORMAT_VALUE_ORDERING.reverse();
            return ComparisonChain.start().compare((Object)info1.bitrate, (Object)info2.bitrate, (Comparator)(info1.parameters.forceLowestBitrate ? FORMAT_VALUE_ORDERING.reverse() : NO_ORDER)).compare((Object)info1.pixelCount, (Object)info2.pixelCount, (Comparator)qualityOrdering).compare((Object)info1.bitrate, (Object)info2.bitrate, (Comparator)qualityOrdering).result();
        }

        public static int compareSelections(List<VideoTrackInfo> infos1, List<VideoTrackInfo> infos2) {
            return ComparisonChain.start().compare((Object)Collections.max(infos1, VideoTrackInfo::compareNonQualityPreferences), (Object)Collections.max(infos2, VideoTrackInfo::compareNonQualityPreferences), VideoTrackInfo::compareNonQualityPreferences).compare(infos1.size(), infos2.size()).compare((Object)Collections.max(infos1, VideoTrackInfo::compareQualityPreferences), (Object)Collections.max(infos2, VideoTrackInfo::compareQualityPreferences), VideoTrackInfo::compareQualityPreferences).result();
        }
    }

    private static abstract class TrackInfo<T extends TrackInfo<T>> {
        public final int rendererIndex;
        public final TrackGroup trackGroup;
        public final int trackIndex;
        public final Format format;

        public TrackInfo(int rendererIndex, TrackGroup trackGroup, int trackIndex) {
            this.rendererIndex = rendererIndex;
            this.trackGroup = trackGroup;
            this.trackIndex = trackIndex;
            this.format = trackGroup.getFormat(trackIndex);
        }

        public abstract int getSelectionEligibility();

        public abstract boolean isCompatibleForAdaptationWith(T var1);

        public static interface Factory<T extends TrackInfo<T>> {
            public List<T> create(int var1, TrackGroup var2, int[] var3);
        }
    }

    public static final class SelectionOverride
    implements Bundleable {
        public final int groupIndex;
        public final int[] tracks;
        public final int length;
        public final int type;
        private static final int FIELD_GROUP_INDEX = 0;
        private static final int FIELD_TRACKS = 1;
        private static final int FIELD_TRACK_TYPE = 2;
        public static final Bundleable.Creator<SelectionOverride> CREATOR = bundle -> {
            int groupIndex = bundle.getInt(SelectionOverride.keyForField(0), -1);
            int[] tracks = bundle.getIntArray(SelectionOverride.keyForField(1));
            int trackType = bundle.getInt(SelectionOverride.keyForField(2), -1);
            Assertions.checkArgument((groupIndex >= 0 && trackType >= 0 ? 1 : 0) != 0);
            Assertions.checkNotNull((Object)tracks);
            return new SelectionOverride(groupIndex, tracks, trackType);
        };

        public SelectionOverride(int groupIndex, int ... tracks) {
            this(groupIndex, tracks, 0);
        }

        public SelectionOverride(int groupIndex, int[] tracks, int type) {
            this.groupIndex = groupIndex;
            this.tracks = Arrays.copyOf(tracks, tracks.length);
            this.length = tracks.length;
            this.type = type;
            Arrays.sort(this.tracks);
        }

        public boolean containsTrack(int track) {
            for (int overrideTrack : this.tracks) {
                if (overrideTrack != track) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            int hash = 31 * this.groupIndex + Arrays.hashCode(this.tracks);
            return 31 * hash + this.type;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SelectionOverride other = (SelectionOverride)obj;
            return this.groupIndex == other.groupIndex && Arrays.equals(this.tracks, other.tracks) && this.type == other.type;
        }

        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putInt(SelectionOverride.keyForField(0), this.groupIndex);
            bundle.putIntArray(SelectionOverride.keyForField(1), this.tracks);
            bundle.putInt(SelectionOverride.keyForField(2), this.type);
            return bundle;
        }

        private static String keyForField(int field) {
            return Integer.toString(field, 36);
        }
    }

    public static final class Parameters
    extends TrackSelectionParameters
    implements Bundleable {
        public static final Parameters DEFAULT_WITHOUT_CONTEXT;
        @Deprecated
        public static final Parameters DEFAULT;
        public final int disabledTextTrackSelectionFlags;
        public final boolean exceedVideoConstraintsIfNecessary;
        public final boolean allowVideoMixedMimeTypeAdaptiveness;
        public final boolean allowVideoNonSeamlessAdaptiveness;
        public final boolean allowVideoMixedDecoderSupportAdaptiveness;
        public final boolean exceedAudioConstraintsIfNecessary;
        public final boolean allowAudioMixedMimeTypeAdaptiveness;
        public final boolean allowAudioMixedSampleRateAdaptiveness;
        public final boolean allowAudioMixedChannelCountAdaptiveness;
        public final boolean allowAudioMixedDecoderSupportAdaptiveness;
        public final boolean exceedRendererCapabilitiesIfNecessary;
        public final boolean tunnelingEnabled;
        public final boolean allowMultipleAdaptiveSelections;
        private final SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> selectionOverrides;
        private final SparseBooleanArray rendererDisabledFlags;
        private static final int FIELD_EXCEED_VIDEO_CONSTRAINTS_IF_NECESSARY = 1000;
        private static final int FIELD_ALLOW_VIDEO_MIXED_MIME_TYPE_ADAPTIVENESS = 1001;
        private static final int FIELD_ALLOW_VIDEO_NON_SEAMLESS_ADAPTIVENESS = 1002;
        private static final int FIELD_EXCEED_AUDIO_CONSTRAINTS_IF_NCESSARY = 1003;
        private static final int FIELD_ALLOW_AUDIO_MIXED_MIME_TYPE_ADAPTIVENESS = 1004;
        private static final int FIELD_ALLOW_AUDIO_MIXED_SAMPLE_RATE_ADAPTIVENESS = 1005;
        private static final int FIELD_ALLOW_AUDIO_MIXED_CHANNEL_COUNT_ADAPTIVENESS = 1006;
        private static final int FIELD_DISABLED_TEXT_TRACK_SELECTION_FLAGS = 1007;
        private static final int FIELD_EXCEED_RENDERER_CAPABILITIES_IF_NECESSARY = 1008;
        private static final int FIELD_TUNNELING_ENABLED = 1009;
        private static final int FIELD_ALLOW_MULTIPLE_ADAPTIVE_SELECTIONS = 1010;
        private static final int FIELD_SELECTION_OVERRIDES_RENDERER_INDICES = 1011;
        private static final int FIELD_SELECTION_OVERRIDES_TRACK_GROUP_ARRAYS = 1012;
        private static final int FIELD_SELECTION_OVERRIDES = 1013;
        private static final int FIELD_RENDERER_DISABLED_INDICES = 1014;
        private static final int FIELD_ALLOW_VIDEO_MIXED_DECODER_SUPPORT_ADAPTIVENESS = 1015;
        private static final int FIELD_ALLOW_AUDIO_MIXED_DECODER_SUPPORT_ADAPTIVENESS = 1016;
        public static final Bundleable.Creator<Parameters> CREATOR;

        public static Parameters getDefaults(Context context) {
            return new ParametersBuilder(context).build();
        }

        private Parameters(ParametersBuilder builder) {
            super((TrackSelectionParameters.Builder)builder);
            this.exceedVideoConstraintsIfNecessary = builder.exceedVideoConstraintsIfNecessary;
            this.allowVideoMixedMimeTypeAdaptiveness = builder.allowVideoMixedMimeTypeAdaptiveness;
            this.allowVideoNonSeamlessAdaptiveness = builder.allowVideoNonSeamlessAdaptiveness;
            this.allowVideoMixedDecoderSupportAdaptiveness = builder.allowVideoMixedDecoderSupportAdaptiveness;
            this.exceedAudioConstraintsIfNecessary = builder.exceedAudioConstraintsIfNecessary;
            this.allowAudioMixedMimeTypeAdaptiveness = builder.allowAudioMixedMimeTypeAdaptiveness;
            this.allowAudioMixedSampleRateAdaptiveness = builder.allowAudioMixedSampleRateAdaptiveness;
            this.allowAudioMixedChannelCountAdaptiveness = builder.allowAudioMixedChannelCountAdaptiveness;
            this.allowAudioMixedDecoderSupportAdaptiveness = builder.allowAudioMixedDecoderSupportAdaptiveness;
            this.disabledTextTrackSelectionFlags = builder.disabledTextTrackSelectionFlags;
            this.exceedRendererCapabilitiesIfNecessary = builder.exceedRendererCapabilitiesIfNecessary;
            this.tunnelingEnabled = builder.tunnelingEnabled;
            this.allowMultipleAdaptiveSelections = builder.allowMultipleAdaptiveSelections;
            this.selectionOverrides = builder.selectionOverrides;
            this.rendererDisabledFlags = builder.rendererDisabledFlags;
        }

        public final boolean getRendererDisabled(int rendererIndex) {
            return this.rendererDisabledFlags.get(rendererIndex);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Deprecated
        public final boolean hasSelectionOverride(int rendererIndex, TrackGroupArray groups) {
            @NullableType Map overrides = (Map)this.selectionOverrides.get(rendererIndex);
            return overrides != null && overrides.containsKey(groups);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Deprecated
        @Nullable
        public final SelectionOverride getSelectionOverride(int rendererIndex, TrackGroupArray groups) {
            @NullableType Map overrides = (Map)this.selectionOverrides.get(rendererIndex);
            return overrides != null ? (SelectionOverride)overrides.get(groups) : null;
        }

        public ParametersBuilder buildUpon() {
            return new ParametersBuilder(this);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Parameters other = (Parameters)((Object)obj);
            return super.equals((Object)other) && this.exceedVideoConstraintsIfNecessary == other.exceedVideoConstraintsIfNecessary && this.allowVideoMixedMimeTypeAdaptiveness == other.allowVideoMixedMimeTypeAdaptiveness && this.allowVideoNonSeamlessAdaptiveness == other.allowVideoNonSeamlessAdaptiveness && this.allowVideoMixedDecoderSupportAdaptiveness == other.allowVideoMixedDecoderSupportAdaptiveness && this.exceedAudioConstraintsIfNecessary == other.exceedAudioConstraintsIfNecessary && this.allowAudioMixedMimeTypeAdaptiveness == other.allowAudioMixedMimeTypeAdaptiveness && this.allowAudioMixedSampleRateAdaptiveness == other.allowAudioMixedSampleRateAdaptiveness && this.allowAudioMixedChannelCountAdaptiveness == other.allowAudioMixedChannelCountAdaptiveness && this.allowAudioMixedDecoderSupportAdaptiveness == other.allowAudioMixedDecoderSupportAdaptiveness && this.disabledTextTrackSelectionFlags == other.disabledTextTrackSelectionFlags && this.exceedRendererCapabilitiesIfNecessary == other.exceedRendererCapabilitiesIfNecessary && this.tunnelingEnabled == other.tunnelingEnabled && this.allowMultipleAdaptiveSelections == other.allowMultipleAdaptiveSelections && Parameters.areRendererDisabledFlagsEqual(this.rendererDisabledFlags, other.rendererDisabledFlags) && Parameters.areSelectionOverridesEqual(this.selectionOverrides, other.selectionOverrides);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + super.hashCode();
            result = 31 * result + (this.exceedVideoConstraintsIfNecessary ? 1 : 0);
            result = 31 * result + (this.allowVideoMixedMimeTypeAdaptiveness ? 1 : 0);
            result = 31 * result + (this.allowVideoNonSeamlessAdaptiveness ? 1 : 0);
            result = 31 * result + (this.allowVideoMixedDecoderSupportAdaptiveness ? 1 : 0);
            result = 31 * result + (this.exceedAudioConstraintsIfNecessary ? 1 : 0);
            result = 31 * result + (this.allowAudioMixedMimeTypeAdaptiveness ? 1 : 0);
            result = 31 * result + (this.allowAudioMixedSampleRateAdaptiveness ? 1 : 0);
            result = 31 * result + (this.allowAudioMixedChannelCountAdaptiveness ? 1 : 0);
            result = 31 * result + (this.allowAudioMixedDecoderSupportAdaptiveness ? 1 : 0);
            result = 31 * result + this.disabledTextTrackSelectionFlags;
            result = 31 * result + (this.exceedRendererCapabilitiesIfNecessary ? 1 : 0);
            result = 31 * result + (this.tunnelingEnabled ? 1 : 0);
            result = 31 * result + (this.allowMultipleAdaptiveSelections ? 1 : 0);
            return result;
        }

        public Bundle toBundle() {
            Bundle bundle = super.toBundle();
            bundle.putBoolean(Parameters.keyForField(1000), this.exceedVideoConstraintsIfNecessary);
            bundle.putBoolean(Parameters.keyForField(1001), this.allowVideoMixedMimeTypeAdaptiveness);
            bundle.putBoolean(Parameters.keyForField(1002), this.allowVideoNonSeamlessAdaptiveness);
            bundle.putBoolean(Parameters.keyForField(1015), this.allowVideoMixedDecoderSupportAdaptiveness);
            bundle.putBoolean(Parameters.keyForField(1003), this.exceedAudioConstraintsIfNecessary);
            bundle.putBoolean(Parameters.keyForField(1004), this.allowAudioMixedMimeTypeAdaptiveness);
            bundle.putBoolean(Parameters.keyForField(1005), this.allowAudioMixedSampleRateAdaptiveness);
            bundle.putBoolean(Parameters.keyForField(1006), this.allowAudioMixedChannelCountAdaptiveness);
            bundle.putBoolean(Parameters.keyForField(1016), this.allowAudioMixedDecoderSupportAdaptiveness);
            bundle.putInt(Parameters.keyForField(1007), this.disabledTextTrackSelectionFlags);
            bundle.putBoolean(Parameters.keyForField(1008), this.exceedRendererCapabilitiesIfNecessary);
            bundle.putBoolean(Parameters.keyForField(1009), this.tunnelingEnabled);
            bundle.putBoolean(Parameters.keyForField(1010), this.allowMultipleAdaptiveSelections);
            Parameters.putSelectionOverridesToBundle(bundle, this.selectionOverrides);
            bundle.putIntArray(Parameters.keyForField(1014), Parameters.getKeysFromSparseBooleanArray(this.rendererDisabledFlags));
            return bundle;
        }

        private static String keyForField(int field) {
            return Integer.toString(field, 36);
        }

        private static void putSelectionOverridesToBundle(Bundle bundle, SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> selectionOverrides) {
            ArrayList<Integer> rendererIndices = new ArrayList<Integer>();
            ArrayList<TrackGroupArray> trackGroupArrays = new ArrayList<TrackGroupArray>();
            SparseArray selections = new SparseArray();
            for (int i = 0; i < selectionOverrides.size(); ++i) {
                int rendererIndex = selectionOverrides.keyAt(i);
                for (Map.Entry override : ((Map)selectionOverrides.valueAt(i)).entrySet()) {
                    SelectionOverride selection = (SelectionOverride)override.getValue();
                    if (selection != null) {
                        selections.put(trackGroupArrays.size(), (Object)selection);
                    }
                    trackGroupArrays.add((TrackGroupArray)override.getKey());
                    rendererIndices.add(rendererIndex);
                }
                bundle.putIntArray(Parameters.keyForField(1011), Ints.toArray(rendererIndices));
                bundle.putParcelableArrayList(Parameters.keyForField(1012), BundleableUtil.toBundleArrayList(trackGroupArrays));
                bundle.putSparseParcelableArray(Parameters.keyForField(1013), BundleableUtil.toBundleSparseArray((SparseArray)selections));
            }
        }

        private static int[] getKeysFromSparseBooleanArray(SparseBooleanArray sparseBooleanArray) {
            int[] keys = new int[sparseBooleanArray.size()];
            for (int i = 0; i < sparseBooleanArray.size(); ++i) {
                keys[i] = sparseBooleanArray.keyAt(i);
            }
            return keys;
        }

        private static boolean areRendererDisabledFlagsEqual(SparseBooleanArray first, SparseBooleanArray second) {
            int firstSize = first.size();
            if (second.size() != firstSize) {
                return false;
            }
            for (int indexInFirst = 0; indexInFirst < firstSize; ++indexInFirst) {
                if (second.indexOfKey(first.keyAt(indexInFirst)) >= 0) continue;
                return false;
            }
            return true;
        }

        private static boolean areSelectionOverridesEqual(SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> first, SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> second) {
            int firstSize = first.size();
            if (second.size() != firstSize) {
                return false;
            }
            for (int indexInFirst = 0; indexInFirst < firstSize; ++indexInFirst) {
                int indexInSecond = second.indexOfKey(first.keyAt(indexInFirst));
                if (indexInSecond >= 0 && Parameters.areSelectionOverridesEqual((Map)first.valueAt(indexInFirst), (Map)second.valueAt(indexInSecond))) continue;
                return false;
            }
            return true;
        }

        private static boolean areSelectionOverridesEqual(Map<TrackGroupArray, @NullableType SelectionOverride> first, Map<TrackGroupArray, @NullableType SelectionOverride> second) {
            int firstSize = first.size();
            if (second.size() != firstSize) {
                return false;
            }
            for (Map.Entry<TrackGroupArray, SelectionOverride> firstEntry : first.entrySet()) {
                TrackGroupArray key = firstEntry.getKey();
                if (second.containsKey(key) && Util.areEqual((Object)firstEntry.getValue(), (Object)second.get(key))) continue;
                return false;
            }
            return true;
        }

        static {
            DEFAULT = DEFAULT_WITHOUT_CONTEXT = new ParametersBuilder().build();
            CREATOR = bundle -> new ParametersBuilder(bundle).build();
        }
    }

    public static final class ParametersBuilder
    extends TrackSelectionParameters.Builder {
        private boolean exceedVideoConstraintsIfNecessary;
        private boolean allowVideoMixedMimeTypeAdaptiveness;
        private boolean allowVideoNonSeamlessAdaptiveness;
        private boolean allowVideoMixedDecoderSupportAdaptiveness;
        private boolean exceedAudioConstraintsIfNecessary;
        private boolean allowAudioMixedMimeTypeAdaptiveness;
        private boolean allowAudioMixedSampleRateAdaptiveness;
        private boolean allowAudioMixedChannelCountAdaptiveness;
        private boolean allowAudioMixedDecoderSupportAdaptiveness;
        private int disabledTextTrackSelectionFlags;
        private boolean exceedRendererCapabilitiesIfNecessary;
        private boolean tunnelingEnabled;
        private boolean allowMultipleAdaptiveSelections;
        private final SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> selectionOverrides;
        private final SparseBooleanArray rendererDisabledFlags;

        @Deprecated
        public ParametersBuilder() {
            this.selectionOverrides = new SparseArray();
            this.rendererDisabledFlags = new SparseBooleanArray();
            this.init();
        }

        public ParametersBuilder(Context context) {
            super(context);
            this.selectionOverrides = new SparseArray();
            this.rendererDisabledFlags = new SparseBooleanArray();
            this.init();
        }

        private ParametersBuilder(Parameters initialValues) {
            super((TrackSelectionParameters)initialValues);
            this.disabledTextTrackSelectionFlags = initialValues.disabledTextTrackSelectionFlags;
            this.exceedVideoConstraintsIfNecessary = initialValues.exceedVideoConstraintsIfNecessary;
            this.allowVideoMixedMimeTypeAdaptiveness = initialValues.allowVideoMixedMimeTypeAdaptiveness;
            this.allowVideoNonSeamlessAdaptiveness = initialValues.allowVideoNonSeamlessAdaptiveness;
            this.allowVideoMixedDecoderSupportAdaptiveness = initialValues.allowVideoMixedDecoderSupportAdaptiveness;
            this.exceedAudioConstraintsIfNecessary = initialValues.exceedAudioConstraintsIfNecessary;
            this.allowAudioMixedMimeTypeAdaptiveness = initialValues.allowAudioMixedMimeTypeAdaptiveness;
            this.allowAudioMixedSampleRateAdaptiveness = initialValues.allowAudioMixedSampleRateAdaptiveness;
            this.allowAudioMixedChannelCountAdaptiveness = initialValues.allowAudioMixedChannelCountAdaptiveness;
            this.allowAudioMixedDecoderSupportAdaptiveness = initialValues.allowAudioMixedDecoderSupportAdaptiveness;
            this.exceedRendererCapabilitiesIfNecessary = initialValues.exceedRendererCapabilitiesIfNecessary;
            this.tunnelingEnabled = initialValues.tunnelingEnabled;
            this.allowMultipleAdaptiveSelections = initialValues.allowMultipleAdaptiveSelections;
            this.selectionOverrides = ParametersBuilder.cloneSelectionOverrides((SparseArray<Map<TrackGroupArray, SelectionOverride>>)initialValues.selectionOverrides);
            this.rendererDisabledFlags = initialValues.rendererDisabledFlags.clone();
        }

        private ParametersBuilder(Bundle bundle) {
            super(bundle);
            Parameters defaultValue = Parameters.DEFAULT_WITHOUT_CONTEXT;
            this.setExceedVideoConstraintsIfNecessary(bundle.getBoolean(Parameters.keyForField(1000), defaultValue.exceedVideoConstraintsIfNecessary));
            this.setAllowVideoMixedMimeTypeAdaptiveness(bundle.getBoolean(Parameters.keyForField(1001), defaultValue.allowVideoMixedMimeTypeAdaptiveness));
            this.setAllowVideoNonSeamlessAdaptiveness(bundle.getBoolean(Parameters.keyForField(1002), defaultValue.allowVideoNonSeamlessAdaptiveness));
            this.setAllowVideoMixedDecoderSupportAdaptiveness(bundle.getBoolean(Parameters.keyForField(1015), defaultValue.allowVideoMixedDecoderSupportAdaptiveness));
            this.setExceedAudioConstraintsIfNecessary(bundle.getBoolean(Parameters.keyForField(1003), defaultValue.exceedAudioConstraintsIfNecessary));
            this.setAllowAudioMixedMimeTypeAdaptiveness(bundle.getBoolean(Parameters.keyForField(1004), defaultValue.allowAudioMixedMimeTypeAdaptiveness));
            this.setAllowAudioMixedSampleRateAdaptiveness(bundle.getBoolean(Parameters.keyForField(1005), defaultValue.allowAudioMixedSampleRateAdaptiveness));
            this.setAllowAudioMixedChannelCountAdaptiveness(bundle.getBoolean(Parameters.keyForField(1006), defaultValue.allowAudioMixedChannelCountAdaptiveness));
            this.setAllowAudioMixedDecoderSupportAdaptiveness(bundle.getBoolean(Parameters.keyForField(1016), defaultValue.allowAudioMixedDecoderSupportAdaptiveness));
            this.setDisabledTextTrackSelectionFlags(bundle.getInt(Parameters.keyForField(1007), defaultValue.disabledTextTrackSelectionFlags));
            this.setExceedRendererCapabilitiesIfNecessary(bundle.getBoolean(Parameters.keyForField(1008), defaultValue.exceedRendererCapabilitiesIfNecessary));
            this.setTunnelingEnabled(bundle.getBoolean(Parameters.keyForField(1009), defaultValue.tunnelingEnabled));
            this.setAllowMultipleAdaptiveSelections(bundle.getBoolean(Parameters.keyForField(1010), defaultValue.allowMultipleAdaptiveSelections));
            this.selectionOverrides = new SparseArray();
            this.setSelectionOverridesFromBundle(bundle);
            this.rendererDisabledFlags = this.makeSparseBooleanArrayFromTrueKeys(bundle.getIntArray(Parameters.keyForField(1014)));
        }

        protected ParametersBuilder set(TrackSelectionParameters parameters) {
            super.set(parameters);
            return this;
        }

        public ParametersBuilder setMaxVideoSizeSd() {
            super.setMaxVideoSizeSd();
            return this;
        }

        public ParametersBuilder clearVideoSizeConstraints() {
            super.clearVideoSizeConstraints();
            return this;
        }

        public ParametersBuilder setMaxVideoSize(int maxVideoWidth, int maxVideoHeight) {
            super.setMaxVideoSize(maxVideoWidth, maxVideoHeight);
            return this;
        }

        public ParametersBuilder setMaxVideoFrameRate(int maxVideoFrameRate) {
            super.setMaxVideoFrameRate(maxVideoFrameRate);
            return this;
        }

        public ParametersBuilder setMaxVideoBitrate(int maxVideoBitrate) {
            super.setMaxVideoBitrate(maxVideoBitrate);
            return this;
        }

        public ParametersBuilder setMinVideoSize(int minVideoWidth, int minVideoHeight) {
            super.setMinVideoSize(minVideoWidth, minVideoHeight);
            return this;
        }

        public ParametersBuilder setMinVideoFrameRate(int minVideoFrameRate) {
            super.setMinVideoFrameRate(minVideoFrameRate);
            return this;
        }

        public ParametersBuilder setMinVideoBitrate(int minVideoBitrate) {
            super.setMinVideoBitrate(minVideoBitrate);
            return this;
        }

        public ParametersBuilder setExceedVideoConstraintsIfNecessary(boolean exceedVideoConstraintsIfNecessary) {
            this.exceedVideoConstraintsIfNecessary = exceedVideoConstraintsIfNecessary;
            return this;
        }

        public ParametersBuilder setAllowVideoMixedMimeTypeAdaptiveness(boolean allowVideoMixedMimeTypeAdaptiveness) {
            this.allowVideoMixedMimeTypeAdaptiveness = allowVideoMixedMimeTypeAdaptiveness;
            return this;
        }

        public ParametersBuilder setAllowVideoNonSeamlessAdaptiveness(boolean allowVideoNonSeamlessAdaptiveness) {
            this.allowVideoNonSeamlessAdaptiveness = allowVideoNonSeamlessAdaptiveness;
            return this;
        }

        public ParametersBuilder setAllowVideoMixedDecoderSupportAdaptiveness(boolean allowVideoMixedDecoderSupportAdaptiveness) {
            this.allowVideoMixedDecoderSupportAdaptiveness = allowVideoMixedDecoderSupportAdaptiveness;
            return this;
        }

        public ParametersBuilder setViewportSizeToPhysicalDisplaySize(Context context, boolean viewportOrientationMayChange) {
            super.setViewportSizeToPhysicalDisplaySize(context, viewportOrientationMayChange);
            return this;
        }

        public ParametersBuilder clearViewportSizeConstraints() {
            super.clearViewportSizeConstraints();
            return this;
        }

        public ParametersBuilder setViewportSize(int viewportWidth, int viewportHeight, boolean viewportOrientationMayChange) {
            super.setViewportSize(viewportWidth, viewportHeight, viewportOrientationMayChange);
            return this;
        }

        public ParametersBuilder setPreferredVideoMimeType(@Nullable String mimeType) {
            super.setPreferredVideoMimeType(mimeType);
            return this;
        }

        public ParametersBuilder setPreferredVideoMimeTypes(String ... mimeTypes) {
            super.setPreferredVideoMimeTypes(mimeTypes);
            return this;
        }

        public ParametersBuilder setPreferredVideoRoleFlags(int preferredVideoRoleFlags) {
            super.setPreferredVideoRoleFlags(preferredVideoRoleFlags);
            return this;
        }

        public ParametersBuilder setPreferredAudioLanguage(@Nullable String preferredAudioLanguage) {
            super.setPreferredAudioLanguage(preferredAudioLanguage);
            return this;
        }

        public ParametersBuilder setPreferredAudioLanguages(String ... preferredAudioLanguages) {
            super.setPreferredAudioLanguages(preferredAudioLanguages);
            return this;
        }

        public ParametersBuilder setPreferredAudioRoleFlags(int preferredAudioRoleFlags) {
            super.setPreferredAudioRoleFlags(preferredAudioRoleFlags);
            return this;
        }

        public ParametersBuilder setMaxAudioChannelCount(int maxAudioChannelCount) {
            super.setMaxAudioChannelCount(maxAudioChannelCount);
            return this;
        }

        public ParametersBuilder setMaxAudioBitrate(int maxAudioBitrate) {
            super.setMaxAudioBitrate(maxAudioBitrate);
            return this;
        }

        public ParametersBuilder setExceedAudioConstraintsIfNecessary(boolean exceedAudioConstraintsIfNecessary) {
            this.exceedAudioConstraintsIfNecessary = exceedAudioConstraintsIfNecessary;
            return this;
        }

        public ParametersBuilder setAllowAudioMixedMimeTypeAdaptiveness(boolean allowAudioMixedMimeTypeAdaptiveness) {
            this.allowAudioMixedMimeTypeAdaptiveness = allowAudioMixedMimeTypeAdaptiveness;
            return this;
        }

        public ParametersBuilder setAllowAudioMixedSampleRateAdaptiveness(boolean allowAudioMixedSampleRateAdaptiveness) {
            this.allowAudioMixedSampleRateAdaptiveness = allowAudioMixedSampleRateAdaptiveness;
            return this;
        }

        public ParametersBuilder setAllowAudioMixedChannelCountAdaptiveness(boolean allowAudioMixedChannelCountAdaptiveness) {
            this.allowAudioMixedChannelCountAdaptiveness = allowAudioMixedChannelCountAdaptiveness;
            return this;
        }

        public ParametersBuilder setAllowAudioMixedDecoderSupportAdaptiveness(boolean allowAudioMixedDecoderSupportAdaptiveness) {
            this.allowAudioMixedDecoderSupportAdaptiveness = allowAudioMixedDecoderSupportAdaptiveness;
            return this;
        }

        public ParametersBuilder setPreferredAudioMimeType(@Nullable String mimeType) {
            super.setPreferredAudioMimeType(mimeType);
            return this;
        }

        public ParametersBuilder setPreferredAudioMimeTypes(String ... mimeTypes) {
            super.setPreferredAudioMimeTypes(mimeTypes);
            return this;
        }

        public ParametersBuilder setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(Context context) {
            super.setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(context);
            return this;
        }

        public ParametersBuilder setPreferredTextLanguage(@Nullable String preferredTextLanguage) {
            super.setPreferredTextLanguage(preferredTextLanguage);
            return this;
        }

        public ParametersBuilder setPreferredTextLanguages(String ... preferredTextLanguages) {
            super.setPreferredTextLanguages(preferredTextLanguages);
            return this;
        }

        public ParametersBuilder setPreferredTextRoleFlags(int preferredTextRoleFlags) {
            super.setPreferredTextRoleFlags(preferredTextRoleFlags);
            return this;
        }

        public ParametersBuilder setSelectUndeterminedTextLanguage(boolean selectUndeterminedTextLanguage) {
            super.setSelectUndeterminedTextLanguage(selectUndeterminedTextLanguage);
            return this;
        }

        public ParametersBuilder setDisabledTextTrackSelectionFlags(int disabledTextTrackSelectionFlags) {
            this.disabledTextTrackSelectionFlags = disabledTextTrackSelectionFlags;
            return this;
        }

        public ParametersBuilder setForceLowestBitrate(boolean forceLowestBitrate) {
            super.setForceLowestBitrate(forceLowestBitrate);
            return this;
        }

        public ParametersBuilder setForceHighestSupportedBitrate(boolean forceHighestSupportedBitrate) {
            super.setForceHighestSupportedBitrate(forceHighestSupportedBitrate);
            return this;
        }

        public ParametersBuilder setTrackSelectionOverrides(TrackSelectionOverrides trackSelectionOverrides) {
            super.setTrackSelectionOverrides(trackSelectionOverrides);
            return this;
        }

        public ParametersBuilder setDisabledTrackTypes(Set<Integer> disabledTrackTypes) {
            super.setDisabledTrackTypes(disabledTrackTypes);
            return this;
        }

        public ParametersBuilder setExceedRendererCapabilitiesIfNecessary(boolean exceedRendererCapabilitiesIfNecessary) {
            this.exceedRendererCapabilitiesIfNecessary = exceedRendererCapabilitiesIfNecessary;
            return this;
        }

        public ParametersBuilder setTunnelingEnabled(boolean tunnelingEnabled) {
            this.tunnelingEnabled = tunnelingEnabled;
            return this;
        }

        public ParametersBuilder setAllowMultipleAdaptiveSelections(boolean allowMultipleAdaptiveSelections) {
            this.allowMultipleAdaptiveSelections = allowMultipleAdaptiveSelections;
            return this;
        }

        public final ParametersBuilder setRendererDisabled(int rendererIndex, boolean disabled) {
            if (this.rendererDisabledFlags.get(rendererIndex) == disabled) {
                return this;
            }
            if (disabled) {
                this.rendererDisabledFlags.put(rendererIndex, true);
            } else {
                this.rendererDisabledFlags.delete(rendererIndex);
            }
            return this;
        }

        @Deprecated
        public final ParametersBuilder setSelectionOverride(int rendererIndex, TrackGroupArray groups, @Nullable SelectionOverride override) {
            HashMap<TrackGroupArray, @NullableType SelectionOverride> overrides = (HashMap<TrackGroupArray, SelectionOverride>)this.selectionOverrides.get(rendererIndex);
            if (overrides == null) {
                overrides = new HashMap<TrackGroupArray, SelectionOverride>();
                this.selectionOverrides.put(rendererIndex, overrides);
            }
            if (overrides.containsKey(groups) && Util.areEqual(overrides.get(groups), (Object)override)) {
                return this;
            }
            overrides.put(groups, override);
            return this;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Deprecated
        public final ParametersBuilder clearSelectionOverride(int rendererIndex, TrackGroupArray groups) {
            @NullableType Map overrides = (Map)this.selectionOverrides.get(rendererIndex);
            if (overrides == null || !overrides.containsKey(groups)) {
                return this;
            }
            overrides.remove(groups);
            if (overrides.isEmpty()) {
                this.selectionOverrides.remove(rendererIndex);
            }
            return this;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Deprecated
        public final ParametersBuilder clearSelectionOverrides(int rendererIndex) {
            @NullableType Map overrides = (Map)this.selectionOverrides.get(rendererIndex);
            if (overrides == null || overrides.isEmpty()) {
                return this;
            }
            this.selectionOverrides.remove(rendererIndex);
            return this;
        }

        @Deprecated
        public final ParametersBuilder clearSelectionOverrides() {
            if (this.selectionOverrides.size() == 0) {
                return this;
            }
            this.selectionOverrides.clear();
            return this;
        }

        public Parameters build() {
            return new Parameters(this);
        }

        private void init() {
            this.exceedVideoConstraintsIfNecessary = true;
            this.allowVideoMixedMimeTypeAdaptiveness = false;
            this.allowVideoNonSeamlessAdaptiveness = true;
            this.allowVideoMixedDecoderSupportAdaptiveness = false;
            this.exceedAudioConstraintsIfNecessary = true;
            this.allowAudioMixedMimeTypeAdaptiveness = false;
            this.allowAudioMixedSampleRateAdaptiveness = false;
            this.allowAudioMixedChannelCountAdaptiveness = false;
            this.allowAudioMixedDecoderSupportAdaptiveness = false;
            this.disabledTextTrackSelectionFlags = 0;
            this.exceedRendererCapabilitiesIfNecessary = true;
            this.tunnelingEnabled = false;
            this.allowMultipleAdaptiveSelections = true;
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        private static SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> cloneSelectionOverrides(SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> selectionOverrides) {
            @NullableType SparseArray clone = new SparseArray();
            for (int i = 0; i < selectionOverrides.size(); ++i) {
                clone.put(selectionOverrides.keyAt(i), new HashMap((Map)selectionOverrides.valueAt(i)));
            }
            return clone;
        }

        private void setSelectionOverridesFromBundle(Bundle bundle) {
            int[] rendererIndices = bundle.getIntArray(Parameters.keyForField(1011));
            List trackGroupArrays = BundleableUtil.fromBundleNullableList((Bundleable.Creator)TrackGroupArray.CREATOR, (List)bundle.getParcelableArrayList(Parameters.keyForField(1012)), (List)ImmutableList.of());
            SparseArray selectionOverrides = BundleableUtil.fromBundleNullableSparseArray(SelectionOverride.CREATOR, (SparseArray)bundle.getSparseParcelableArray(Parameters.keyForField(1013)), (SparseArray)new SparseArray());
            if (rendererIndices == null || rendererIndices.length != trackGroupArrays.size()) {
                return;
            }
            for (int i = 0; i < rendererIndices.length; ++i) {
                int rendererIndex = rendererIndices[i];
                TrackGroupArray groups = (TrackGroupArray)trackGroupArrays.get(i);
                SelectionOverride selectionOverride = (SelectionOverride)selectionOverrides.get(i);
                this.setSelectionOverride(rendererIndex, groups, selectionOverride);
            }
        }

        private SparseBooleanArray makeSparseBooleanArrayFromTrueKeys(@Nullable int[] trueKeys) {
            if (trueKeys == null) {
                return new SparseBooleanArray();
            }
            SparseBooleanArray sparseBooleanArray = new SparseBooleanArray(trueKeys.length);
            for (int trueKey : trueKeys) {
                sparseBooleanArray.append(trueKey, true);
            }
            return sparseBooleanArray;
        }
    }
}

