/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.source.chunk.MediaChunkIterator;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public interface ExoTrackSelection
extends TrackSelection {
    public void enable();

    public void disable();

    public Format getSelectedFormat();

    public int getSelectedIndexInTrackGroup();

    public int getSelectedIndex();

    public int getSelectionReason();

    @Nullable
    public Object getSelectionData();

    public void onPlaybackSpeed(float var1);

    default public void onDiscontinuity() {
    }

    default public void onRebuffer() {
    }

    default public void onPlayWhenReadyChanged(boolean playWhenReady) {
    }

    public void updateSelectedTrack(long var1, long var3, long var5, List<? extends MediaChunk> var7, MediaChunkIterator[] var8);

    public int evaluateQueueSize(long var1, List<? extends MediaChunk> var3);

    default public boolean shouldCancelChunkLoad(long playbackPositionUs, Chunk loadingChunk, List<? extends MediaChunk> queue) {
        return false;
    }

    public boolean blacklist(int var1, long var2);

    public boolean isBlacklisted(int var1, long var2);

    public static interface Factory {
        public @NullableType ExoTrackSelection[] createTrackSelections(@NullableType Definition[] var1, BandwidthMeter var2, MediaSource.MediaPeriodId var3, Timeline var4);
    }

    public static final class Definition {
        public final TrackGroup group;
        public final int[] tracks;
        public final int type;

        public Definition(TrackGroup group, int ... tracks) {
            this(group, tracks, 0);
        }

        public Definition(TrackGroup group, int[] tracks, int type) {
            this.group = group;
            this.tracks = tracks;
            this.type = type;
        }
    }
}

