/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.RendererConfiguration;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.TracksInfo;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectorResult;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableType;

public abstract class MappingTrackSelector
extends TrackSelector {
    @Nullable
    private MappedTrackInfo currentMappedTrackInfo;

    @Nullable
    public final MappedTrackInfo getCurrentMappedTrackInfo() {
        return this.currentMappedTrackInfo;
    }

    @Override
    public final void onSelectionActivated(@Nullable Object info) {
        this.currentMappedTrackInfo = (MappedTrackInfo)info;
    }

    @Override
    public final TrackSelectorResult selectTracks(RendererCapabilities[] rendererCapabilities, TrackGroupArray trackGroups, MediaSource.MediaPeriodId periodId, Timeline timeline) throws ExoPlaybackException {
        int[] rendererTrackGroupCounts = new int[rendererCapabilities.length + 1];
        TrackGroup[][] rendererTrackGroups = new TrackGroup[rendererCapabilities.length + 1][];
        int[][][] rendererFormatSupports = new int[rendererCapabilities.length + 1][][];
        for (int i = 0; i < rendererTrackGroups.length; ++i) {
            rendererTrackGroups[i] = new TrackGroup[trackGroups.length];
            rendererFormatSupports[i] = new int[trackGroups.length][];
        }
        int[] rendererMixedMimeTypeAdaptationSupports = MappingTrackSelector.getMixedMimeTypeAdaptationSupports(rendererCapabilities);
        for (int groupIndex = 0; groupIndex < trackGroups.length; ++groupIndex) {
            TrackGroup group = trackGroups.get(groupIndex);
            boolean preferUnassociatedRenderer = MimeTypes.getTrackType((String)group.getFormat((int)0).sampleMimeType) == 5;
            int rendererIndex = MappingTrackSelector.findRenderer(rendererCapabilities, group, rendererTrackGroupCounts, preferUnassociatedRenderer);
            int[] rendererFormatSupport = rendererIndex == rendererCapabilities.length ? new int[group.length] : MappingTrackSelector.getFormatSupport(rendererCapabilities[rendererIndex], group);
            int rendererTrackGroupCount = rendererTrackGroupCounts[rendererIndex];
            rendererTrackGroups[rendererIndex][rendererTrackGroupCount] = group;
            rendererFormatSupports[rendererIndex][rendererTrackGroupCount] = rendererFormatSupport;
            int n = rendererIndex;
            rendererTrackGroupCounts[n] = rendererTrackGroupCounts[n] + 1;
        }
        TrackGroupArray[] rendererTrackGroupArrays = new TrackGroupArray[rendererCapabilities.length];
        String[] rendererNames = new String[rendererCapabilities.length];
        int[] rendererTrackTypes = new int[rendererCapabilities.length];
        for (int i = 0; i < rendererCapabilities.length; ++i) {
            int rendererTrackGroupCount = rendererTrackGroupCounts[i];
            rendererTrackGroupArrays[i] = new TrackGroupArray((TrackGroup[])Util.nullSafeArrayCopy((Object[])rendererTrackGroups[i], (int)rendererTrackGroupCount));
            rendererFormatSupports[i] = (int[][])Util.nullSafeArrayCopy((Object[])rendererFormatSupports[i], (int)rendererTrackGroupCount);
            rendererNames[i] = rendererCapabilities[i].getName();
            rendererTrackTypes[i] = rendererCapabilities[i].getTrackType();
        }
        int unmappedTrackGroupCount = rendererTrackGroupCounts[rendererCapabilities.length];
        TrackGroupArray unmappedTrackGroupArray = new TrackGroupArray((TrackGroup[])Util.nullSafeArrayCopy((Object[])rendererTrackGroups[rendererCapabilities.length], (int)unmappedTrackGroupCount));
        MappedTrackInfo mappedTrackInfo = new MappedTrackInfo(rendererNames, rendererTrackTypes, rendererTrackGroupArrays, rendererMixedMimeTypeAdaptationSupports, rendererFormatSupports, unmappedTrackGroupArray);
        Pair<@NullableType RendererConfiguration[], @NullableType ExoTrackSelection[]> result = this.selectTracks(mappedTrackInfo, rendererFormatSupports, rendererMixedMimeTypeAdaptationSupports, periodId, timeline);
        TracksInfo tracksInfo = MappingTrackSelector.buildTracksInfo((TrackSelection[])result.second, mappedTrackInfo);
        return new TrackSelectorResult((RendererConfiguration[])result.first, (ExoTrackSelection[])result.second, tracksInfo, mappedTrackInfo);
    }

    protected abstract Pair<@NullableType RendererConfiguration[], @NullableType ExoTrackSelection[]> selectTracks(MappedTrackInfo var1, int[][][] var2, int[] var3, MediaSource.MediaPeriodId var4, Timeline var5) throws ExoPlaybackException;

    private static int findRenderer(RendererCapabilities[] rendererCapabilities, TrackGroup group, int[] rendererTrackGroupCounts, boolean preferUnassociatedRenderer) throws ExoPlaybackException {
        int bestRendererIndex = rendererCapabilities.length;
        int bestFormatSupportLevel = 0;
        boolean bestRendererIsUnassociated = true;
        for (int rendererIndex = 0; rendererIndex < rendererCapabilities.length; ++rendererIndex) {
            boolean rendererIsUnassociated;
            RendererCapabilities rendererCapability = rendererCapabilities[rendererIndex];
            int formatSupportLevel = 0;
            for (int trackIndex = 0; trackIndex < group.length; ++trackIndex) {
                int trackFormatSupportLevel = RendererCapabilities.getFormatSupport(rendererCapability.supportsFormat(group.getFormat(trackIndex)));
                formatSupportLevel = Math.max(formatSupportLevel, trackFormatSupportLevel);
            }
            boolean bl = rendererIsUnassociated = rendererTrackGroupCounts[rendererIndex] == 0;
            if (formatSupportLevel <= bestFormatSupportLevel && (formatSupportLevel != bestFormatSupportLevel || !preferUnassociatedRenderer || bestRendererIsUnassociated || !rendererIsUnassociated)) continue;
            bestRendererIndex = rendererIndex;
            bestFormatSupportLevel = formatSupportLevel;
            bestRendererIsUnassociated = rendererIsUnassociated;
        }
        return bestRendererIndex;
    }

    private static int[] getFormatSupport(RendererCapabilities rendererCapabilities, TrackGroup group) throws ExoPlaybackException {
        int[] formatSupport = new int[group.length];
        for (int i = 0; i < group.length; ++i) {
            formatSupport[i] = rendererCapabilities.supportsFormat(group.getFormat(i));
        }
        return formatSupport;
    }

    private static int[] getMixedMimeTypeAdaptationSupports(RendererCapabilities[] rendererCapabilities) throws ExoPlaybackException {
        int[] mixedMimeTypeAdaptationSupport = new int[rendererCapabilities.length];
        for (int i = 0; i < mixedMimeTypeAdaptationSupport.length; ++i) {
            mixedMimeTypeAdaptationSupport[i] = rendererCapabilities[i].supportsMixedMimeTypeAdaptation();
        }
        return mixedMimeTypeAdaptationSupport;
    }

    @VisibleForTesting
    static TracksInfo buildTracksInfo(@NullableType TrackSelection[] selections, MappedTrackInfo mappedTrackInfo) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (int rendererIndex = 0; rendererIndex < mappedTrackInfo.getRendererCount(); ++rendererIndex) {
            TrackGroupArray trackGroupArray = mappedTrackInfo.getTrackGroups(rendererIndex);
            TrackSelection trackSelection = selections[rendererIndex];
            for (int groupIndex = 0; groupIndex < trackGroupArray.length; ++groupIndex) {
                TrackGroup trackGroup = trackGroupArray.get(groupIndex);
                int[] trackSupport = new int[trackGroup.length];
                boolean[] selected = new boolean[trackGroup.length];
                for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                    boolean isTrackSelected;
                    trackSupport[trackIndex] = mappedTrackInfo.getTrackSupport(rendererIndex, groupIndex, trackIndex);
                    selected[trackIndex] = isTrackSelected = trackSelection != null && trackSelection.getTrackGroup().equals((Object)trackGroup) && trackSelection.indexOf(trackIndex) != -1;
                }
                int trackGroupType = mappedTrackInfo.getRendererType(rendererIndex);
                builder.add((Object)new TracksInfo.TrackGroupInfo(trackGroup, trackSupport, trackGroupType, selected));
            }
        }
        TrackGroupArray unmappedTrackGroups = mappedTrackInfo.getUnmappedTrackGroups();
        for (int groupIndex = 0; groupIndex < unmappedTrackGroups.length; ++groupIndex) {
            TrackGroup trackGroup = unmappedTrackGroups.get(groupIndex);
            int[] trackSupport = new int[trackGroup.length];
            Arrays.fill(trackSupport, 0);
            int trackGroupType = MimeTypes.getTrackType((String)trackGroup.getFormat((int)0).sampleMimeType);
            boolean[] selected = new boolean[trackGroup.length];
            builder.add((Object)new TracksInfo.TrackGroupInfo(trackGroup, trackSupport, trackGroupType, selected));
        }
        return new TracksInfo((List)builder.build());
    }

    public static final class MappedTrackInfo {
        public static final int RENDERER_SUPPORT_NO_TRACKS = 0;
        public static final int RENDERER_SUPPORT_UNSUPPORTED_TRACKS = 1;
        public static final int RENDERER_SUPPORT_EXCEEDS_CAPABILITIES_TRACKS = 2;
        public static final int RENDERER_SUPPORT_PLAYABLE_TRACKS = 3;
        private final int rendererCount;
        private final String[] rendererNames;
        private final int[] rendererTrackTypes;
        private final TrackGroupArray[] rendererTrackGroups;
        private final int[] rendererMixedMimeTypeAdaptiveSupports;
        private final int[][][] rendererFormatSupports;
        private final TrackGroupArray unmappedTrackGroups;

        @VisibleForTesting
        MappedTrackInfo(String[] rendererNames, int[] rendererTrackTypes, TrackGroupArray[] rendererTrackGroups, int[] rendererMixedMimeTypeAdaptiveSupports, int[][][] rendererFormatSupports, TrackGroupArray unmappedTrackGroups) {
            this.rendererNames = rendererNames;
            this.rendererTrackTypes = rendererTrackTypes;
            this.rendererTrackGroups = rendererTrackGroups;
            this.rendererFormatSupports = rendererFormatSupports;
            this.rendererMixedMimeTypeAdaptiveSupports = rendererMixedMimeTypeAdaptiveSupports;
            this.unmappedTrackGroups = unmappedTrackGroups;
            this.rendererCount = rendererTrackTypes.length;
        }

        public int getRendererCount() {
            return this.rendererCount;
        }

        public String getRendererName(int rendererIndex) {
            return this.rendererNames[rendererIndex];
        }

        public int getRendererType(int rendererIndex) {
            return this.rendererTrackTypes[rendererIndex];
        }

        public TrackGroupArray getTrackGroups(int rendererIndex) {
            return this.rendererTrackGroups[rendererIndex];
        }

        public int getRendererSupport(int rendererIndex) {
            int[][] rendererFormatSupport;
            int bestRendererSupport = 0;
            int[][] nArray = rendererFormatSupport = this.rendererFormatSupports[rendererIndex];
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int[] trackGroupFormatSupport;
                for (int trackFormatSupport : trackGroupFormatSupport = nArray[i]) {
                    int trackRendererSupport;
                    switch (RendererCapabilities.getFormatSupport(trackFormatSupport)) {
                        case 4: {
                            return 3;
                        }
                        case 3: {
                            trackRendererSupport = 2;
                            break;
                        }
                        case 0: 
                        case 1: 
                        case 2: {
                            trackRendererSupport = 1;
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    bestRendererSupport = Math.max(bestRendererSupport, trackRendererSupport);
                }
            }
            return bestRendererSupport;
        }

        public int getTypeSupport(int trackType) {
            int bestRendererSupport = 0;
            for (int i = 0; i < this.rendererCount; ++i) {
                if (this.rendererTrackTypes[i] != trackType) continue;
                bestRendererSupport = Math.max(bestRendererSupport, this.getRendererSupport(i));
            }
            return bestRendererSupport;
        }

        public int getCapabilities(int rendererIndex, int groupIndex, int trackIndex) {
            return this.rendererFormatSupports[rendererIndex][groupIndex][trackIndex];
        }

        public int getTrackSupport(int rendererIndex, int groupIndex, int trackIndex) {
            return RendererCapabilities.getFormatSupport(this.getCapabilities(rendererIndex, groupIndex, trackIndex));
        }

        public int getAdaptiveSupport(int rendererIndex, int groupIndex, boolean includeCapabilitiesExceededTracks) {
            int trackCount = this.rendererTrackGroups[rendererIndex].get((int)groupIndex).length;
            int[] trackIndices = new int[trackCount];
            int trackIndexCount = 0;
            for (int i = 0; i < trackCount; ++i) {
                int fixedSupport = this.getTrackSupport(rendererIndex, groupIndex, i);
                if (fixedSupport != 4 && (!includeCapabilitiesExceededTracks || fixedSupport != 3)) continue;
                trackIndices[trackIndexCount++] = i;
            }
            trackIndices = Arrays.copyOf(trackIndices, trackIndexCount);
            return this.getAdaptiveSupport(rendererIndex, groupIndex, trackIndices);
        }

        public int getAdaptiveSupport(int rendererIndex, int groupIndex, int[] trackIndices) {
            int handledTrackCount = 0;
            int adaptiveSupport = 16;
            boolean multipleMimeTypes = false;
            String firstSampleMimeType = null;
            for (int i = 0; i < trackIndices.length; ++i) {
                int trackIndex = trackIndices[i];
                String sampleMimeType = this.rendererTrackGroups[rendererIndex].get((int)groupIndex).getFormat((int)trackIndex).sampleMimeType;
                if (handledTrackCount++ == 0) {
                    firstSampleMimeType = sampleMimeType;
                } else {
                    multipleMimeTypes |= !Util.areEqual((Object)firstSampleMimeType, (Object)sampleMimeType);
                }
                adaptiveSupport = Math.min(adaptiveSupport, RendererCapabilities.getAdaptiveSupport(this.rendererFormatSupports[rendererIndex][groupIndex][i]));
            }
            return multipleMimeTypes ? Math.min(adaptiveSupport, this.rendererMixedMimeTypeAdaptiveSupports[rendererIndex]) : adaptiveSupport;
        }

        public TrackGroupArray getUnmappedTrackGroups() {
            return this.unmappedTrackGroups;
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
        public static @interface RendererSupport {
        }
    }
}

