/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.upstream.DataSourceException;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.Loader;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DefaultLoadErrorHandlingPolicy
implements LoadErrorHandlingPolicy {
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT = 3;
    public static final int DEFAULT_MIN_LOADABLE_RETRY_COUNT_PROGRESSIVE_LIVE = 6;
    public static final long DEFAULT_TRACK_EXCLUSION_MS = 60000L;
    @Deprecated
    public static final long DEFAULT_TRACK_BLACKLIST_MS = 60000L;
    public static final long DEFAULT_LOCATION_EXCLUSION_MS = 300000L;
    private static final int DEFAULT_BEHAVIOR_MIN_LOADABLE_RETRY_COUNT = -1;
    private final int minimumLoadableRetryCount;

    public DefaultLoadErrorHandlingPolicy() {
        this(-1);
    }

    public DefaultLoadErrorHandlingPolicy(int minimumLoadableRetryCount) {
        this.minimumLoadableRetryCount = minimumLoadableRetryCount;
    }

    @Override
    @Nullable
    public LoadErrorHandlingPolicy.FallbackSelection getFallbackSelectionFor(LoadErrorHandlingPolicy.FallbackOptions fallbackOptions, LoadErrorHandlingPolicy.LoadErrorInfo loadErrorInfo) {
        if (!this.isEligibleForFallback(loadErrorInfo.exception)) {
            return null;
        }
        if (fallbackOptions.isFallbackAvailable(1)) {
            return new LoadErrorHandlingPolicy.FallbackSelection(1, 300000L);
        }
        if (fallbackOptions.isFallbackAvailable(2)) {
            return new LoadErrorHandlingPolicy.FallbackSelection(2, 60000L);
        }
        return null;
    }

    @Override
    public long getRetryDelayMsFor(LoadErrorHandlingPolicy.LoadErrorInfo loadErrorInfo) {
        IOException exception = loadErrorInfo.exception;
        return exception instanceof ParserException || exception instanceof FileNotFoundException || exception instanceof HttpDataSource.CleartextNotPermittedException || exception instanceof Loader.UnexpectedLoaderException || DataSourceException.isCausedByPositionOutOfRange((IOException)exception) ? -9223372036854775807L : (long)Math.min((loadErrorInfo.errorCount - 1) * 1000, 5000);
    }

    @Override
    public int getMinimumLoadableRetryCount(int dataType) {
        if (this.minimumLoadableRetryCount == -1) {
            return dataType == 7 ? 6 : 3;
        }
        return this.minimumLoadableRetryCount;
    }

    protected boolean isEligibleForFallback(IOException exception) {
        if (!(exception instanceof HttpDataSource.InvalidResponseCodeException)) {
            return false;
        }
        HttpDataSource.InvalidResponseCodeException invalidResponseCodeException = (HttpDataSource.InvalidResponseCodeException)((Object)exception);
        return invalidResponseCodeException.responseCode == 403 || invalidResponseCodeException.responseCode == 404 || invalidResponseCodeException.responseCode == 410 || invalidResponseCodeException.responseCode == 416 || invalidResponseCodeException.responseCode == 500 || invalidResponseCodeException.responseCode == 503;
    }
}

