/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.SystemClock;
import com.google.android.exoplayer2.LivePlaybackSpeedControl;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

@Deprecated
public final class DefaultLivePlaybackSpeedControl
implements LivePlaybackSpeedControl {
    public static final float DEFAULT_FALLBACK_MIN_PLAYBACK_SPEED = 0.97f;
    public static final float DEFAULT_FALLBACK_MAX_PLAYBACK_SPEED = 1.03f;
    public static final long DEFAULT_MIN_UPDATE_INTERVAL_MS = 1000L;
    public static final float DEFAULT_PROPORTIONAL_CONTROL_FACTOR = 0.1f;
    public static final long DEFAULT_TARGET_LIVE_OFFSET_INCREMENT_ON_REBUFFER_MS = 500L;
    public static final float DEFAULT_MIN_POSSIBLE_LIVE_OFFSET_SMOOTHING_FACTOR = 0.999f;
    public static final long DEFAULT_MAX_LIVE_OFFSET_ERROR_MS_FOR_UNIT_SPEED = 20L;
    private final float fallbackMinPlaybackSpeed;
    private final float fallbackMaxPlaybackSpeed;
    private final long minUpdateIntervalMs;
    private final float proportionalControlFactor;
    private final long maxLiveOffsetErrorUsForUnitSpeed;
    private final long targetLiveOffsetRebufferDeltaUs;
    private final float minPossibleLiveOffsetSmoothingFactor;
    private long mediaConfigurationTargetLiveOffsetUs;
    private long targetLiveOffsetOverrideUs;
    private long idealTargetLiveOffsetUs;
    private long minTargetLiveOffsetUs;
    private long maxTargetLiveOffsetUs;
    private long currentTargetLiveOffsetUs;
    private float maxPlaybackSpeed;
    private float minPlaybackSpeed;
    private float adjustedPlaybackSpeed;
    private long lastPlaybackSpeedUpdateMs;
    private long smoothedMinPossibleLiveOffsetUs;
    private long smoothedMinPossibleLiveOffsetDeviationUs;

    private DefaultLivePlaybackSpeedControl(float fallbackMinPlaybackSpeed, float fallbackMaxPlaybackSpeed, long minUpdateIntervalMs, float proportionalControlFactor, long maxLiveOffsetErrorUsForUnitSpeed, long targetLiveOffsetRebufferDeltaUs, float minPossibleLiveOffsetSmoothingFactor) {
        this.fallbackMinPlaybackSpeed = fallbackMinPlaybackSpeed;
        this.fallbackMaxPlaybackSpeed = fallbackMaxPlaybackSpeed;
        this.minUpdateIntervalMs = minUpdateIntervalMs;
        this.proportionalControlFactor = proportionalControlFactor;
        this.maxLiveOffsetErrorUsForUnitSpeed = maxLiveOffsetErrorUsForUnitSpeed;
        this.targetLiveOffsetRebufferDeltaUs = targetLiveOffsetRebufferDeltaUs;
        this.minPossibleLiveOffsetSmoothingFactor = minPossibleLiveOffsetSmoothingFactor;
        this.mediaConfigurationTargetLiveOffsetUs = -9223372036854775807L;
        this.targetLiveOffsetOverrideUs = -9223372036854775807L;
        this.minTargetLiveOffsetUs = -9223372036854775807L;
        this.maxTargetLiveOffsetUs = -9223372036854775807L;
        this.minPlaybackSpeed = fallbackMinPlaybackSpeed;
        this.maxPlaybackSpeed = fallbackMaxPlaybackSpeed;
        this.adjustedPlaybackSpeed = 1.0f;
        this.lastPlaybackSpeedUpdateMs = -9223372036854775807L;
        this.idealTargetLiveOffsetUs = -9223372036854775807L;
        this.currentTargetLiveOffsetUs = -9223372036854775807L;
        this.smoothedMinPossibleLiveOffsetUs = -9223372036854775807L;
        this.smoothedMinPossibleLiveOffsetDeviationUs = -9223372036854775807L;
    }

    @Override
    public void setLiveConfiguration(MediaItem.LiveConfiguration liveConfiguration) {
        this.mediaConfigurationTargetLiveOffsetUs = Util.msToUs((long)liveConfiguration.targetOffsetMs);
        this.minTargetLiveOffsetUs = Util.msToUs((long)liveConfiguration.minOffsetMs);
        this.maxTargetLiveOffsetUs = Util.msToUs((long)liveConfiguration.maxOffsetMs);
        this.minPlaybackSpeed = liveConfiguration.minPlaybackSpeed != -3.4028235E38f ? liveConfiguration.minPlaybackSpeed : this.fallbackMinPlaybackSpeed;
        float f = this.maxPlaybackSpeed = liveConfiguration.maxPlaybackSpeed != -3.4028235E38f ? liveConfiguration.maxPlaybackSpeed : this.fallbackMaxPlaybackSpeed;
        if (this.minPlaybackSpeed == 1.0f && this.maxPlaybackSpeed == 1.0f) {
            this.mediaConfigurationTargetLiveOffsetUs = -9223372036854775807L;
        }
        this.maybeResetTargetLiveOffsetUs();
    }

    @Override
    public void setTargetLiveOffsetOverrideUs(long liveOffsetUs) {
        this.targetLiveOffsetOverrideUs = liveOffsetUs;
        this.maybeResetTargetLiveOffsetUs();
    }

    @Override
    public void notifyRebuffer() {
        if (this.currentTargetLiveOffsetUs == -9223372036854775807L) {
            return;
        }
        this.currentTargetLiveOffsetUs += this.targetLiveOffsetRebufferDeltaUs;
        if (this.maxTargetLiveOffsetUs != -9223372036854775807L && this.currentTargetLiveOffsetUs > this.maxTargetLiveOffsetUs) {
            this.currentTargetLiveOffsetUs = this.maxTargetLiveOffsetUs;
        }
        this.lastPlaybackSpeedUpdateMs = -9223372036854775807L;
    }

    @Override
    public float getAdjustedPlaybackSpeed(long liveOffsetUs, long bufferedDurationUs) {
        if (this.mediaConfigurationTargetLiveOffsetUs == -9223372036854775807L) {
            return 1.0f;
        }
        this.updateSmoothedMinPossibleLiveOffsetUs(liveOffsetUs, bufferedDurationUs);
        if (this.lastPlaybackSpeedUpdateMs != -9223372036854775807L && SystemClock.elapsedRealtime() - this.lastPlaybackSpeedUpdateMs < this.minUpdateIntervalMs) {
            return this.adjustedPlaybackSpeed;
        }
        this.lastPlaybackSpeedUpdateMs = SystemClock.elapsedRealtime();
        this.adjustTargetLiveOffsetUs(liveOffsetUs);
        long liveOffsetErrorUs = liveOffsetUs - this.currentTargetLiveOffsetUs;
        if (Math.abs(liveOffsetErrorUs) < this.maxLiveOffsetErrorUsForUnitSpeed) {
            this.adjustedPlaybackSpeed = 1.0f;
        } else {
            float calculatedSpeed = 1.0f + this.proportionalControlFactor * (float)liveOffsetErrorUs;
            this.adjustedPlaybackSpeed = Util.constrainValue((float)calculatedSpeed, (float)this.minPlaybackSpeed, (float)this.maxPlaybackSpeed);
        }
        return this.adjustedPlaybackSpeed;
    }

    @Override
    public long getTargetLiveOffsetUs() {
        return this.currentTargetLiveOffsetUs;
    }

    private void maybeResetTargetLiveOffsetUs() {
        long idealOffsetUs = -9223372036854775807L;
        if (this.mediaConfigurationTargetLiveOffsetUs != -9223372036854775807L) {
            long l = idealOffsetUs = this.targetLiveOffsetOverrideUs != -9223372036854775807L ? this.targetLiveOffsetOverrideUs : this.mediaConfigurationTargetLiveOffsetUs;
            if (this.minTargetLiveOffsetUs != -9223372036854775807L && idealOffsetUs < this.minTargetLiveOffsetUs) {
                idealOffsetUs = this.minTargetLiveOffsetUs;
            }
            if (this.maxTargetLiveOffsetUs != -9223372036854775807L && idealOffsetUs > this.maxTargetLiveOffsetUs) {
                idealOffsetUs = this.maxTargetLiveOffsetUs;
            }
        }
        if (this.idealTargetLiveOffsetUs == idealOffsetUs) {
            return;
        }
        this.idealTargetLiveOffsetUs = idealOffsetUs;
        this.currentTargetLiveOffsetUs = idealOffsetUs;
        this.smoothedMinPossibleLiveOffsetUs = -9223372036854775807L;
        this.smoothedMinPossibleLiveOffsetDeviationUs = -9223372036854775807L;
        this.lastPlaybackSpeedUpdateMs = -9223372036854775807L;
    }

    private void updateSmoothedMinPossibleLiveOffsetUs(long liveOffsetUs, long bufferedDurationUs) {
        long minPossibleLiveOffsetUs = liveOffsetUs - bufferedDurationUs;
        if (this.smoothedMinPossibleLiveOffsetUs == -9223372036854775807L) {
            this.smoothedMinPossibleLiveOffsetUs = minPossibleLiveOffsetUs;
            this.smoothedMinPossibleLiveOffsetDeviationUs = 0L;
        } else {
            this.smoothedMinPossibleLiveOffsetUs = Math.max(minPossibleLiveOffsetUs, DefaultLivePlaybackSpeedControl.smooth(this.smoothedMinPossibleLiveOffsetUs, minPossibleLiveOffsetUs, this.minPossibleLiveOffsetSmoothingFactor));
            long minPossibleLiveOffsetDeviationUs = Math.abs(minPossibleLiveOffsetUs - this.smoothedMinPossibleLiveOffsetUs);
            this.smoothedMinPossibleLiveOffsetDeviationUs = DefaultLivePlaybackSpeedControl.smooth(this.smoothedMinPossibleLiveOffsetDeviationUs, minPossibleLiveOffsetDeviationUs, this.minPossibleLiveOffsetSmoothingFactor);
        }
    }

    private void adjustTargetLiveOffsetUs(long liveOffsetUs) {
        long safeOffsetUs = this.smoothedMinPossibleLiveOffsetUs + 3L * this.smoothedMinPossibleLiveOffsetDeviationUs;
        if (this.currentTargetLiveOffsetUs > safeOffsetUs) {
            long minUpdateIntervalUs = Util.msToUs((long)this.minUpdateIntervalMs);
            long decrementToOffsetCurrentSpeedUs = (long)((this.adjustedPlaybackSpeed - 1.0f) * (float)minUpdateIntervalUs);
            long decrementToIncreaseSpeedUs = (long)((this.maxPlaybackSpeed - 1.0f) * (float)minUpdateIntervalUs);
            long maxDecrementUs = decrementToOffsetCurrentSpeedUs + decrementToIncreaseSpeedUs;
            this.currentTargetLiveOffsetUs = Longs.max((long[])new long[]{safeOffsetUs, this.idealTargetLiveOffsetUs, this.currentTargetLiveOffsetUs - maxDecrementUs});
        } else {
            long offsetWhenSlowingDownNowUs = liveOffsetUs - (long)(Math.max(0.0f, this.adjustedPlaybackSpeed - 1.0f) / this.proportionalControlFactor);
            this.currentTargetLiveOffsetUs = Util.constrainValue((long)offsetWhenSlowingDownNowUs, (long)this.currentTargetLiveOffsetUs, (long)safeOffsetUs);
            if (this.maxTargetLiveOffsetUs != -9223372036854775807L && this.currentTargetLiveOffsetUs > this.maxTargetLiveOffsetUs) {
                this.currentTargetLiveOffsetUs = this.maxTargetLiveOffsetUs;
            }
        }
    }

    private static long smooth(long smoothedValue, long newValue, float smoothingFactor) {
        return (long)(smoothingFactor * (float)smoothedValue + (1.0f - smoothingFactor) * (float)newValue);
    }

    public static final class Builder {
        private float fallbackMinPlaybackSpeed = 0.97f;
        private float fallbackMaxPlaybackSpeed = 1.03f;
        private long minUpdateIntervalMs = 1000L;
        private float proportionalControlFactorUs = 1.0E-7f;
        private long maxLiveOffsetErrorUsForUnitSpeed = Util.msToUs((long)20L);
        private long targetLiveOffsetIncrementOnRebufferUs = Util.msToUs((long)500L);
        private float minPossibleLiveOffsetSmoothingFactor = 0.999f;

        @CanIgnoreReturnValue
        public Builder setFallbackMinPlaybackSpeed(float fallbackMinPlaybackSpeed) {
            Assertions.checkArgument((0.0f < fallbackMinPlaybackSpeed && fallbackMinPlaybackSpeed <= 1.0f ? 1 : 0) != 0);
            this.fallbackMinPlaybackSpeed = fallbackMinPlaybackSpeed;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setFallbackMaxPlaybackSpeed(float fallbackMaxPlaybackSpeed) {
            Assertions.checkArgument((fallbackMaxPlaybackSpeed >= 1.0f ? 1 : 0) != 0);
            this.fallbackMaxPlaybackSpeed = fallbackMaxPlaybackSpeed;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMinUpdateIntervalMs(long minUpdateIntervalMs) {
            Assertions.checkArgument((minUpdateIntervalMs > 0L ? 1 : 0) != 0);
            this.minUpdateIntervalMs = minUpdateIntervalMs;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setProportionalControlFactor(float proportionalControlFactor) {
            Assertions.checkArgument((proportionalControlFactor > 0.0f ? 1 : 0) != 0);
            this.proportionalControlFactorUs = proportionalControlFactor / 1000000.0f;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMaxLiveOffsetErrorMsForUnitSpeed(long maxLiveOffsetErrorMsForUnitSpeed) {
            Assertions.checkArgument((maxLiveOffsetErrorMsForUnitSpeed > 0L ? 1 : 0) != 0);
            this.maxLiveOffsetErrorUsForUnitSpeed = Util.msToUs((long)maxLiveOffsetErrorMsForUnitSpeed);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTargetLiveOffsetIncrementOnRebufferMs(long targetLiveOffsetIncrementOnRebufferMs) {
            Assertions.checkArgument((targetLiveOffsetIncrementOnRebufferMs >= 0L ? 1 : 0) != 0);
            this.targetLiveOffsetIncrementOnRebufferUs = Util.msToUs((long)targetLiveOffsetIncrementOnRebufferMs);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMinPossibleLiveOffsetSmoothingFactor(float minPossibleLiveOffsetSmoothingFactor) {
            Assertions.checkArgument((minPossibleLiveOffsetSmoothingFactor >= 0.0f && minPossibleLiveOffsetSmoothingFactor < 1.0f ? 1 : 0) != 0);
            this.minPossibleLiveOffsetSmoothingFactor = minPossibleLiveOffsetSmoothingFactor;
            return this;
        }

        public DefaultLivePlaybackSpeedControl build() {
            return new DefaultLivePlaybackSpeedControl(this.fallbackMinPlaybackSpeed, this.fallbackMaxPlaybackSpeed, this.minUpdateIntervalMs, this.proportionalControlFactorUs, this.maxLiveOffsetErrorUsForUnitSpeed, this.targetLiveOffsetIncrementOnRebufferUs, this.minPossibleLiveOffsetSmoothingFactor);
        }
    }
}

