/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.Bundle;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.CheckResult;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.PlaybackException;
import com.google.android.exoplayer2.source.MediaPeriodId;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Deprecated
public final class ExoPlaybackException
extends PlaybackException {
    public static final int TYPE_SOURCE = 0;
    public static final int TYPE_RENDERER = 1;
    public static final int TYPE_UNEXPECTED = 2;
    public static final int TYPE_REMOTE = 3;
    public final int type;
    @Nullable
    public final String rendererName;
    public final int rendererIndex;
    @Nullable
    public final Format rendererFormat;
    public final int rendererFormatSupport;
    @Nullable
    public final MediaPeriodId mediaPeriodId;
    final boolean isRecoverable;
    public static final Bundleable.Creator<ExoPlaybackException> CREATOR = ExoPlaybackException::new;
    private static final String FIELD_TYPE = Util.intToStringMaxRadix((int)1001);
    private static final String FIELD_RENDERER_NAME = Util.intToStringMaxRadix((int)1002);
    private static final String FIELD_RENDERER_INDEX = Util.intToStringMaxRadix((int)1003);
    private static final String FIELD_RENDERER_FORMAT = Util.intToStringMaxRadix((int)1004);
    private static final String FIELD_RENDERER_FORMAT_SUPPORT = Util.intToStringMaxRadix((int)1005);
    private static final String FIELD_IS_RECOVERABLE = Util.intToStringMaxRadix((int)1006);

    public static ExoPlaybackException createForSource(IOException cause, int errorCode) {
        return new ExoPlaybackException(0, cause, errorCode);
    }

    public static ExoPlaybackException createForRenderer(Throwable cause, String rendererName, int rendererIndex, @Nullable Format rendererFormat, int rendererFormatSupport, boolean isRecoverable, int errorCode) {
        return new ExoPlaybackException(1, cause, null, errorCode, rendererName, rendererIndex, rendererFormat, rendererFormat == null ? 4 : rendererFormatSupport, isRecoverable);
    }

    @Deprecated
    public static ExoPlaybackException createForUnexpected(RuntimeException cause) {
        return ExoPlaybackException.createForUnexpected(cause, 1000);
    }

    public static ExoPlaybackException createForUnexpected(RuntimeException cause, int errorCode) {
        return new ExoPlaybackException(2, cause, errorCode);
    }

    public static ExoPlaybackException createForRemote(String message) {
        return new ExoPlaybackException(3, null, message, 1001, null, -1, null, 4, false);
    }

    private ExoPlaybackException(int type, Throwable cause, int errorCode) {
        this(type, cause, null, errorCode, null, -1, null, 4, false);
    }

    private ExoPlaybackException(int type, @Nullable Throwable cause, @Nullable String customMessage, int errorCode, @Nullable String rendererName, int rendererIndex, @Nullable Format rendererFormat, int rendererFormatSupport, boolean isRecoverable) {
        this(ExoPlaybackException.deriveMessage(type, customMessage, rendererName, rendererIndex, rendererFormat, rendererFormatSupport), cause, errorCode, type, rendererName, rendererIndex, rendererFormat, rendererFormatSupport, null, SystemClock.elapsedRealtime(), isRecoverable);
    }

    private ExoPlaybackException(Bundle bundle) {
        super(bundle);
        this.type = bundle.getInt(FIELD_TYPE, 2);
        this.rendererName = bundle.getString(FIELD_RENDERER_NAME);
        this.rendererIndex = bundle.getInt(FIELD_RENDERER_INDEX, -1);
        Bundle rendererFormatBundle = bundle.getBundle(FIELD_RENDERER_FORMAT);
        this.rendererFormat = rendererFormatBundle == null ? null : (Format)Format.CREATOR.fromBundle(rendererFormatBundle);
        this.rendererFormatSupport = bundle.getInt(FIELD_RENDERER_FORMAT_SUPPORT, 4);
        this.isRecoverable = bundle.getBoolean(FIELD_IS_RECOVERABLE, false);
        this.mediaPeriodId = null;
    }

    private ExoPlaybackException(String message, @Nullable Throwable cause, int errorCode, int type, @Nullable String rendererName, int rendererIndex, @Nullable Format rendererFormat, int rendererFormatSupport, @Nullable MediaPeriodId mediaPeriodId, long timestampMs, boolean isRecoverable) {
        super(message, cause, errorCode, timestampMs);
        Assertions.checkArgument((!isRecoverable || type == 1 ? 1 : 0) != 0);
        Assertions.checkArgument((cause != null || type == 3 ? 1 : 0) != 0);
        this.type = type;
        this.rendererName = rendererName;
        this.rendererIndex = rendererIndex;
        this.rendererFormat = rendererFormat;
        this.rendererFormatSupport = rendererFormatSupport;
        this.mediaPeriodId = mediaPeriodId;
        this.isRecoverable = isRecoverable;
    }

    public IOException getSourceException() {
        Assertions.checkState((this.type == 0 ? 1 : 0) != 0);
        return (IOException)Assertions.checkNotNull((Object)this.getCause());
    }

    public Exception getRendererException() {
        Assertions.checkState((this.type == 1 ? 1 : 0) != 0);
        return (Exception)Assertions.checkNotNull((Object)this.getCause());
    }

    public RuntimeException getUnexpectedException() {
        Assertions.checkState((this.type == 2 ? 1 : 0) != 0);
        return (RuntimeException)Assertions.checkNotNull((Object)this.getCause());
    }

    public boolean errorInfoEquals(@Nullable PlaybackException that) {
        if (!super.errorInfoEquals(that)) {
            return false;
        }
        ExoPlaybackException other = (ExoPlaybackException)((Object)Util.castNonNull((Object)that));
        return this.type == other.type && Util.areEqual((Object)this.rendererName, (Object)other.rendererName) && this.rendererIndex == other.rendererIndex && Util.areEqual((Object)this.rendererFormat, (Object)other.rendererFormat) && this.rendererFormatSupport == other.rendererFormatSupport && Util.areEqual((Object)this.mediaPeriodId, (Object)other.mediaPeriodId) && this.isRecoverable == other.isRecoverable;
    }

    @CheckResult
    ExoPlaybackException copyWithMediaPeriodId(@Nullable MediaPeriodId mediaPeriodId) {
        return new ExoPlaybackException((String)Util.castNonNull((Object)this.getMessage()), this.getCause(), this.errorCode, this.type, this.rendererName, this.rendererIndex, this.rendererFormat, this.rendererFormatSupport, mediaPeriodId, this.timestampMs, this.isRecoverable);
    }

    private static String deriveMessage(int type, @Nullable String customMessage, @Nullable String rendererName, int rendererIndex, @Nullable Format rendererFormat, int rendererFormatSupport) {
        String message;
        switch (type) {
            case 0: {
                message = "Source error";
                break;
            }
            case 1: {
                message = rendererName + " error, index=" + rendererIndex + ", format=" + rendererFormat + ", format_supported=" + Util.getFormatSupportString((int)rendererFormatSupport);
                break;
            }
            case 3: {
                message = "Remote error";
                break;
            }
            default: {
                message = "Unexpected runtime error";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)customMessage)) {
            message = message + ": " + customMessage;
        }
        return message;
    }

    public Bundle toBundle() {
        Bundle bundle = super.toBundle();
        bundle.putInt(FIELD_TYPE, this.type);
        bundle.putString(FIELD_RENDERER_NAME, this.rendererName);
        bundle.putInt(FIELD_RENDERER_INDEX, this.rendererIndex);
        if (this.rendererFormat != null) {
            bundle.putBundle(FIELD_RENDERER_FORMAT, this.rendererFormat.toBundle());
        }
        bundle.putInt(FIELD_RENDERER_FORMAT_SUPPORT, this.rendererFormatSupport);
        bundle.putBoolean(FIELD_IS_RECOVERABLE, this.isRecoverable);
        return bundle;
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface Type {
    }
}

