/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.content.Context;
import android.media.AudioDeviceInfo;
import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.DefaultLivePlaybackSpeedControl;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.DefaultRenderersFactory;
import com.google.android.exoplayer2.DeviceInfo;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayerImpl;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.LivePlaybackSpeedControl;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.PlayerMessage;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.analytics.AnalyticsCollector;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.analytics.DefaultAnalyticsCollector;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AuxEffectInfo;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.source.DefaultMediaSourceFactory;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ShuffleOrder;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.text.CueGroup;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.Effect;
import com.google.android.exoplayer2.util.PriorityTaskManager;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoFrameMetadataListener;
import com.google.android.exoplayer2.video.VideoSize;
import com.google.android.exoplayer2.video.spherical.CameraMotionListener;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;

@Deprecated
public interface ExoPlayer
extends Player {
    public static final long DEFAULT_RELEASE_TIMEOUT_MS = 500L;
    public static final long DEFAULT_DETACH_SURFACE_TIMEOUT_MS = 2000L;

    @Nullable
    public ExoPlaybackException getPlayerError();

    @Deprecated
    @Nullable
    public AudioComponent getAudioComponent();

    @Deprecated
    @Nullable
    public VideoComponent getVideoComponent();

    @Deprecated
    @Nullable
    public TextComponent getTextComponent();

    @Deprecated
    @Nullable
    public DeviceComponent getDeviceComponent();

    public void addAudioOffloadListener(AudioOffloadListener var1);

    public void removeAudioOffloadListener(AudioOffloadListener var1);

    public AnalyticsCollector getAnalyticsCollector();

    public void addAnalyticsListener(AnalyticsListener var1);

    public void removeAnalyticsListener(AnalyticsListener var1);

    public int getRendererCount();

    public int getRendererType(int var1);

    public Renderer getRenderer(int var1);

    @Nullable
    public TrackSelector getTrackSelector();

    @Deprecated
    public TrackGroupArray getCurrentTrackGroups();

    @Deprecated
    public TrackSelectionArray getCurrentTrackSelections();

    public Looper getPlaybackLooper();

    public Clock getClock();

    @Deprecated
    public void prepare(MediaSource var1);

    @Deprecated
    public void prepare(MediaSource var1, boolean var2, boolean var3);

    public void setMediaSources(List<MediaSource> var1);

    public void setMediaSources(List<MediaSource> var1, boolean var2);

    public void setMediaSources(List<MediaSource> var1, int var2, long var3);

    public void setMediaSource(MediaSource var1);

    public void setMediaSource(MediaSource var1, long var2);

    public void setMediaSource(MediaSource var1, boolean var2);

    public void addMediaSource(MediaSource var1);

    public void addMediaSource(int var1, MediaSource var2);

    public void addMediaSources(List<MediaSource> var1);

    public void addMediaSources(int var1, List<MediaSource> var2);

    public void setShuffleOrder(ShuffleOrder var1);

    public void setAudioAttributes(AudioAttributes var1, boolean var2);

    public void setAudioSessionId(int var1);

    public int getAudioSessionId();

    public void setAuxEffectInfo(AuxEffectInfo var1);

    public void clearAuxEffectInfo();

    @RequiresApi(value=23)
    public void setPreferredAudioDevice(@Nullable AudioDeviceInfo var1);

    public void setSkipSilenceEnabled(boolean var1);

    public boolean getSkipSilenceEnabled();

    @RequiresApi(value=18)
    public void setVideoEffects(List<Effect> var1);

    public void setVideoScalingMode(int var1);

    public int getVideoScalingMode();

    public void setVideoChangeFrameRateStrategy(int var1);

    public int getVideoChangeFrameRateStrategy();

    public void setVideoFrameMetadataListener(VideoFrameMetadataListener var1);

    public void clearVideoFrameMetadataListener(VideoFrameMetadataListener var1);

    public void setCameraMotionListener(CameraMotionListener var1);

    public void clearCameraMotionListener(CameraMotionListener var1);

    public PlayerMessage createMessage(PlayerMessage.Target var1);

    public void setSeekParameters(@Nullable SeekParameters var1);

    public SeekParameters getSeekParameters();

    public void setForegroundMode(boolean var1);

    public void setPauseAtEndOfMediaItems(boolean var1);

    public boolean getPauseAtEndOfMediaItems();

    @Nullable
    public Format getAudioFormat();

    @Nullable
    public Format getVideoFormat();

    @Nullable
    public DecoderCounters getAudioDecoderCounters();

    @Nullable
    public DecoderCounters getVideoDecoderCounters();

    public void setHandleAudioBecomingNoisy(boolean var1);

    public void setWakeMode(int var1);

    public void setPriorityTaskManager(@Nullable PriorityTaskManager var1);

    public void experimentalSetOffloadSchedulingEnabled(boolean var1);

    public boolean experimentalIsSleepingForOffload();

    public boolean isTunnelingEnabled();

    public static final class Builder {
        final Context context;
        Clock clock;
        long foregroundModeTimeoutMs;
        Supplier<RenderersFactory> renderersFactorySupplier;
        Supplier<MediaSource.Factory> mediaSourceFactorySupplier;
        Supplier<TrackSelector> trackSelectorSupplier;
        Supplier<LoadControl> loadControlSupplier;
        Supplier<BandwidthMeter> bandwidthMeterSupplier;
        Function<Clock, AnalyticsCollector> analyticsCollectorFunction;
        Looper looper;
        @Nullable
        PriorityTaskManager priorityTaskManager;
        AudioAttributes audioAttributes;
        boolean handleAudioFocus;
        int wakeMode;
        boolean handleAudioBecomingNoisy;
        boolean skipSilenceEnabled;
        boolean deviceVolumeControlEnabled;
        int videoScalingMode;
        int videoChangeFrameRateStrategy;
        boolean useLazyPreparation;
        SeekParameters seekParameters;
        long seekBackIncrementMs;
        long seekForwardIncrementMs;
        LivePlaybackSpeedControl livePlaybackSpeedControl;
        long releaseTimeoutMs;
        long detachSurfaceTimeoutMs;
        boolean pauseAtEndOfMediaItems;
        boolean usePlatformDiagnostics;
        @Nullable
        Looper playbackLooper;
        boolean buildCalled;

        public Builder(Context context) {
            this(context, (Supplier<RenderersFactory>)((Supplier)() -> new DefaultRenderersFactory(context)), (Supplier<MediaSource.Factory>)((Supplier)() -> new DefaultMediaSourceFactory(context, (ExtractorsFactory)new DefaultExtractorsFactory())));
        }

        public Builder(Context context, RenderersFactory renderersFactory) {
            this(context, (Supplier<RenderersFactory>)((Supplier)() -> renderersFactory), (Supplier<MediaSource.Factory>)((Supplier)() -> new DefaultMediaSourceFactory(context, (ExtractorsFactory)new DefaultExtractorsFactory())));
            Assertions.checkNotNull((Object)renderersFactory);
        }

        public Builder(Context context, MediaSource.Factory mediaSourceFactory) {
            this(context, (Supplier<RenderersFactory>)((Supplier)() -> new DefaultRenderersFactory(context)), (Supplier<MediaSource.Factory>)((Supplier)() -> mediaSourceFactory));
            Assertions.checkNotNull((Object)mediaSourceFactory);
        }

        public Builder(Context context, RenderersFactory renderersFactory, MediaSource.Factory mediaSourceFactory) {
            this(context, (Supplier<RenderersFactory>)((Supplier)() -> renderersFactory), (Supplier<MediaSource.Factory>)((Supplier)() -> mediaSourceFactory));
            Assertions.checkNotNull((Object)renderersFactory);
            Assertions.checkNotNull((Object)mediaSourceFactory);
        }

        public Builder(Context context, RenderersFactory renderersFactory, MediaSource.Factory mediaSourceFactory, TrackSelector trackSelector, LoadControl loadControl, BandwidthMeter bandwidthMeter, AnalyticsCollector analyticsCollector) {
            this(context, (Supplier<RenderersFactory>)((Supplier)() -> renderersFactory), (Supplier<MediaSource.Factory>)((Supplier)() -> mediaSourceFactory), (Supplier<TrackSelector>)((Supplier)() -> trackSelector), (Supplier<LoadControl>)((Supplier)() -> loadControl), (Supplier<BandwidthMeter>)((Supplier)() -> bandwidthMeter), (Function<Clock, AnalyticsCollector>)((Function)clock -> analyticsCollector));
            Assertions.checkNotNull((Object)renderersFactory);
            Assertions.checkNotNull((Object)mediaSourceFactory);
            Assertions.checkNotNull((Object)trackSelector);
            Assertions.checkNotNull((Object)bandwidthMeter);
            Assertions.checkNotNull((Object)analyticsCollector);
        }

        private Builder(Context context, Supplier<RenderersFactory> renderersFactorySupplier, Supplier<MediaSource.Factory> mediaSourceFactorySupplier) {
            this(context, renderersFactorySupplier, mediaSourceFactorySupplier, (Supplier<TrackSelector>)((Supplier)() -> new DefaultTrackSelector(context)), (Supplier<LoadControl>)((Supplier)DefaultLoadControl::new), (Supplier<BandwidthMeter>)((Supplier)() -> DefaultBandwidthMeter.getSingletonInstance(context)), (Function<Clock, AnalyticsCollector>)((Function)DefaultAnalyticsCollector::new));
        }

        private Builder(Context context, Supplier<RenderersFactory> renderersFactorySupplier, Supplier<MediaSource.Factory> mediaSourceFactorySupplier, Supplier<TrackSelector> trackSelectorSupplier, Supplier<LoadControl> loadControlSupplier, Supplier<BandwidthMeter> bandwidthMeterSupplier, Function<Clock, AnalyticsCollector> analyticsCollectorFunction) {
            this.context = (Context)Assertions.checkNotNull((Object)context);
            this.renderersFactorySupplier = renderersFactorySupplier;
            this.mediaSourceFactorySupplier = mediaSourceFactorySupplier;
            this.trackSelectorSupplier = trackSelectorSupplier;
            this.loadControlSupplier = loadControlSupplier;
            this.bandwidthMeterSupplier = bandwidthMeterSupplier;
            this.analyticsCollectorFunction = analyticsCollectorFunction;
            this.looper = Util.getCurrentOrMainLooper();
            this.audioAttributes = AudioAttributes.DEFAULT;
            this.wakeMode = 0;
            this.videoScalingMode = 1;
            this.videoChangeFrameRateStrategy = 0;
            this.useLazyPreparation = true;
            this.seekParameters = SeekParameters.DEFAULT;
            this.seekBackIncrementMs = 5000L;
            this.seekForwardIncrementMs = 15000L;
            this.livePlaybackSpeedControl = new DefaultLivePlaybackSpeedControl.Builder().build();
            this.clock = Clock.DEFAULT;
            this.releaseTimeoutMs = 500L;
            this.detachSurfaceTimeoutMs = 2000L;
            this.usePlatformDiagnostics = true;
        }

        @CanIgnoreReturnValue
        public Builder experimentalSetForegroundModeTimeoutMs(long timeoutMs) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.foregroundModeTimeoutMs = timeoutMs;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setRenderersFactory(RenderersFactory renderersFactory) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            Assertions.checkNotNull((Object)renderersFactory);
            this.renderersFactorySupplier = () -> renderersFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMediaSourceFactory(MediaSource.Factory mediaSourceFactory) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            Assertions.checkNotNull((Object)mediaSourceFactory);
            this.mediaSourceFactorySupplier = () -> mediaSourceFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTrackSelector(TrackSelector trackSelector) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            Assertions.checkNotNull((Object)trackSelector);
            this.trackSelectorSupplier = () -> trackSelector;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLoadControl(LoadControl loadControl) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            Assertions.checkNotNull((Object)loadControl);
            this.loadControlSupplier = () -> loadControl;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setBandwidthMeter(BandwidthMeter bandwidthMeter) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            Assertions.checkNotNull((Object)bandwidthMeter);
            this.bandwidthMeterSupplier = () -> bandwidthMeter;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLooper(Looper looper) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            Assertions.checkNotNull((Object)looper);
            this.looper = looper;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAnalyticsCollector(AnalyticsCollector analyticsCollector) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            Assertions.checkNotNull((Object)analyticsCollector);
            this.analyticsCollectorFunction = clock -> analyticsCollector;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPriorityTaskManager(@Nullable PriorityTaskManager priorityTaskManager) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.priorityTaskManager = priorityTaskManager;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAudioAttributes(AudioAttributes audioAttributes, boolean handleAudioFocus) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.audioAttributes = (AudioAttributes)Assertions.checkNotNull((Object)audioAttributes);
            this.handleAudioFocus = handleAudioFocus;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setWakeMode(int wakeMode) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.wakeMode = wakeMode;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setHandleAudioBecomingNoisy(boolean handleAudioBecomingNoisy) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.handleAudioBecomingNoisy = handleAudioBecomingNoisy;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSkipSilenceEnabled(boolean skipSilenceEnabled) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.skipSilenceEnabled = skipSilenceEnabled;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDeviceVolumeControlEnabled(boolean deviceVolumeControlEnabled) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.deviceVolumeControlEnabled = deviceVolumeControlEnabled;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setVideoScalingMode(int videoScalingMode) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.videoScalingMode = videoScalingMode;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setVideoChangeFrameRateStrategy(int videoChangeFrameRateStrategy) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.videoChangeFrameRateStrategy = videoChangeFrameRateStrategy;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUseLazyPreparation(boolean useLazyPreparation) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.useLazyPreparation = useLazyPreparation;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSeekParameters(SeekParameters seekParameters) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.seekParameters = (SeekParameters)Assertions.checkNotNull((Object)seekParameters);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSeekBackIncrementMs(@IntRange(from=1L) long seekBackIncrementMs) {
            Assertions.checkArgument((seekBackIncrementMs > 0L ? 1 : 0) != 0);
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.seekBackIncrementMs = seekBackIncrementMs;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSeekForwardIncrementMs(@IntRange(from=1L) long seekForwardIncrementMs) {
            Assertions.checkArgument((seekForwardIncrementMs > 0L ? 1 : 0) != 0);
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.seekForwardIncrementMs = seekForwardIncrementMs;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setReleaseTimeoutMs(long releaseTimeoutMs) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.releaseTimeoutMs = releaseTimeoutMs;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setDetachSurfaceTimeoutMs(long detachSurfaceTimeoutMs) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.detachSurfaceTimeoutMs = detachSurfaceTimeoutMs;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPauseAtEndOfMediaItems(boolean pauseAtEndOfMediaItems) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.pauseAtEndOfMediaItems = pauseAtEndOfMediaItems;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setLivePlaybackSpeedControl(LivePlaybackSpeedControl livePlaybackSpeedControl) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.livePlaybackSpeedControl = (LivePlaybackSpeedControl)Assertions.checkNotNull((Object)livePlaybackSpeedControl);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUsePlatformDiagnostics(boolean usePlatformDiagnostics) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.usePlatformDiagnostics = usePlatformDiagnostics;
            return this;
        }

        @CanIgnoreReturnValue
        @VisibleForTesting
        public Builder setClock(Clock clock) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.clock = clock;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPlaybackLooper(Looper playbackLooper) {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.playbackLooper = playbackLooper;
            return this;
        }

        public ExoPlayer build() {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.buildCalled = true;
            return new ExoPlayerImpl(this, null);
        }

        SimpleExoPlayer buildSimpleExoPlayer() {
            Assertions.checkState((!this.buildCalled ? 1 : 0) != 0);
            this.buildCalled = true;
            return new SimpleExoPlayer(this);
        }
    }

    public static interface AudioOffloadListener {
        default public void onExperimentalOffloadSchedulingEnabledChanged(boolean offloadSchedulingEnabled) {
        }

        default public void onExperimentalSleepingForOffloadChanged(boolean sleepingForOffload) {
        }

        default public void onExperimentalOffloadedPlayback(boolean offloadedPlayback) {
        }
    }

    @Deprecated
    public static interface DeviceComponent {
        @Deprecated
        public DeviceInfo getDeviceInfo();

        @Deprecated
        public int getDeviceVolume();

        @Deprecated
        public boolean isDeviceMuted();

        @Deprecated
        public void setDeviceVolume(int var1);

        @Deprecated
        public void increaseDeviceVolume();

        @Deprecated
        public void decreaseDeviceVolume();

        @Deprecated
        public void setDeviceMuted(boolean var1);
    }

    @Deprecated
    public static interface TextComponent {
        @Deprecated
        public CueGroup getCurrentCues();
    }

    @Deprecated
    public static interface VideoComponent {
        @Deprecated
        public void setVideoScalingMode(int var1);

        @Deprecated
        public int getVideoScalingMode();

        @Deprecated
        public void setVideoChangeFrameRateStrategy(int var1);

        @Deprecated
        public int getVideoChangeFrameRateStrategy();

        @Deprecated
        public void setVideoFrameMetadataListener(VideoFrameMetadataListener var1);

        @Deprecated
        public void clearVideoFrameMetadataListener(VideoFrameMetadataListener var1);

        @Deprecated
        public void setCameraMotionListener(CameraMotionListener var1);

        @Deprecated
        public void clearCameraMotionListener(CameraMotionListener var1);

        @Deprecated
        public void clearVideoSurface();

        @Deprecated
        public void clearVideoSurface(@Nullable Surface var1);

        @Deprecated
        public void setVideoSurface(@Nullable Surface var1);

        @Deprecated
        public void setVideoSurfaceHolder(@Nullable SurfaceHolder var1);

        @Deprecated
        public void clearVideoSurfaceHolder(@Nullable SurfaceHolder var1);

        @Deprecated
        public void setVideoSurfaceView(@Nullable SurfaceView var1);

        @Deprecated
        public void clearVideoSurfaceView(@Nullable SurfaceView var1);

        @Deprecated
        public void setVideoTextureView(@Nullable TextureView var1);

        @Deprecated
        public void clearVideoTextureView(@Nullable TextureView var1);

        @Deprecated
        public VideoSize getVideoSize();
    }

    @Deprecated
    public static interface AudioComponent {
        @Deprecated
        public void setAudioAttributes(AudioAttributes var1, boolean var2);

        @Deprecated
        public AudioAttributes getAudioAttributes();

        @Deprecated
        public void setAudioSessionId(int var1);

        @Deprecated
        public int getAudioSessionId();

        @Deprecated
        public void setAuxEffectInfo(AuxEffectInfo var1);

        @Deprecated
        public void clearAuxEffectInfo();

        @Deprecated
        public void setVolume(float var1);

        @Deprecated
        public float getVolume();

        @Deprecated
        public void setSkipSilenceEnabled(boolean var1);

        @Deprecated
        public boolean getSkipSilenceEnabled();
    }
}

