/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.IllegalSeekPositionException;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.concurrent.TimeoutException;

@Deprecated
public final class PlayerMessage {
    private final Target target;
    private final Sender sender;
    private final Clock clock;
    private final Timeline timeline;
    private int type;
    @Nullable
    private Object payload;
    private Looper looper;
    private int mediaItemIndex;
    private long positionMs;
    private boolean deleteAfterDelivery;
    private boolean isSent;
    private boolean isDelivered;
    private boolean isProcessed;
    private boolean isCanceled;

    public PlayerMessage(Sender sender, Target target, Timeline timeline, int defaultMediaItemIndex, Clock clock, Looper defaultLooper) {
        this.sender = sender;
        this.target = target;
        this.timeline = timeline;
        this.looper = defaultLooper;
        this.clock = clock;
        this.mediaItemIndex = defaultMediaItemIndex;
        this.positionMs = -9223372036854775807L;
        this.deleteAfterDelivery = true;
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public Target getTarget() {
        return this.target;
    }

    @CanIgnoreReturnValue
    public PlayerMessage setType(int messageType) {
        Assertions.checkState((!this.isSent ? 1 : 0) != 0);
        this.type = messageType;
        return this;
    }

    public int getType() {
        return this.type;
    }

    @CanIgnoreReturnValue
    public PlayerMessage setPayload(@Nullable Object payload) {
        Assertions.checkState((!this.isSent ? 1 : 0) != 0);
        this.payload = payload;
        return this;
    }

    @Nullable
    public Object getPayload() {
        return this.payload;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public PlayerMessage setHandler(Handler handler) {
        return this.setLooper(handler.getLooper());
    }

    @CanIgnoreReturnValue
    public PlayerMessage setLooper(Looper looper) {
        Assertions.checkState((!this.isSent ? 1 : 0) != 0);
        this.looper = looper;
        return this;
    }

    public Looper getLooper() {
        return this.looper;
    }

    public long getPositionMs() {
        return this.positionMs;
    }

    @CanIgnoreReturnValue
    public PlayerMessage setPosition(long positionMs) {
        Assertions.checkState((!this.isSent ? 1 : 0) != 0);
        this.positionMs = positionMs;
        return this;
    }

    @CanIgnoreReturnValue
    public PlayerMessage setPosition(int mediaItemIndex, long positionMs) {
        Assertions.checkState((!this.isSent ? 1 : 0) != 0);
        Assertions.checkArgument((positionMs != -9223372036854775807L ? 1 : 0) != 0);
        if (mediaItemIndex < 0 || !this.timeline.isEmpty() && mediaItemIndex >= this.timeline.getWindowCount()) {
            throw new IllegalSeekPositionException(this.timeline, mediaItemIndex, positionMs);
        }
        this.mediaItemIndex = mediaItemIndex;
        this.positionMs = positionMs;
        return this;
    }

    public int getMediaItemIndex() {
        return this.mediaItemIndex;
    }

    @CanIgnoreReturnValue
    public PlayerMessage setDeleteAfterDelivery(boolean deleteAfterDelivery) {
        Assertions.checkState((!this.isSent ? 1 : 0) != 0);
        this.deleteAfterDelivery = deleteAfterDelivery;
        return this;
    }

    public boolean getDeleteAfterDelivery() {
        return this.deleteAfterDelivery;
    }

    @CanIgnoreReturnValue
    public PlayerMessage send() {
        Assertions.checkState((!this.isSent ? 1 : 0) != 0);
        if (this.positionMs == -9223372036854775807L) {
            Assertions.checkArgument((boolean)this.deleteAfterDelivery);
        }
        this.isSent = true;
        this.sender.sendMessage(this);
        return this;
    }

    @CanIgnoreReturnValue
    public synchronized PlayerMessage cancel() {
        Assertions.checkState((boolean)this.isSent);
        this.isCanceled = true;
        this.markAsProcessed(false);
        return this;
    }

    public synchronized boolean isCanceled() {
        return this.isCanceled;
    }

    public synchronized void markAsProcessed(boolean isDelivered) {
        this.isDelivered |= isDelivered;
        this.isProcessed = true;
        this.notifyAll();
    }

    public synchronized boolean blockUntilDelivered() throws InterruptedException {
        Assertions.checkState((boolean)this.isSent);
        Assertions.checkState((this.looper.getThread() != Thread.currentThread() ? 1 : 0) != 0);
        while (!this.isProcessed) {
            this.wait();
        }
        return this.isDelivered;
    }

    public synchronized boolean blockUntilDelivered(long timeoutMs) throws InterruptedException, TimeoutException {
        Assertions.checkState((boolean)this.isSent);
        Assertions.checkState((this.looper.getThread() != Thread.currentThread() ? 1 : 0) != 0);
        long deadlineMs = this.clock.elapsedRealtime() + timeoutMs;
        long remainingMs = timeoutMs;
        while (!this.isProcessed && remainingMs > 0L) {
            this.clock.onThreadBlocked();
            this.wait(remainingMs);
            remainingMs = deadlineMs - this.clock.elapsedRealtime();
        }
        if (!this.isProcessed) {
            throw new TimeoutException("Message delivery timed out.");
        }
        return this.isDelivered;
    }

    public static interface Sender {
        public void sendMessage(PlayerMessage var1);
    }

    public static interface Target {
        public void handleMessage(int var1, @Nullable Object var2) throws ExoPlaybackException;
    }
}

