/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;

@Deprecated
public final class SeekParameters {
    public static final SeekParameters EXACT = new SeekParameters(0L, 0L);
    public static final SeekParameters CLOSEST_SYNC = new SeekParameters(Long.MAX_VALUE, Long.MAX_VALUE);
    public static final SeekParameters PREVIOUS_SYNC = new SeekParameters(Long.MAX_VALUE, 0L);
    public static final SeekParameters NEXT_SYNC = new SeekParameters(0L, Long.MAX_VALUE);
    public static final SeekParameters DEFAULT = EXACT;
    public final long toleranceBeforeUs;
    public final long toleranceAfterUs;

    public SeekParameters(long toleranceBeforeUs, long toleranceAfterUs) {
        Assertions.checkArgument((toleranceBeforeUs >= 0L ? 1 : 0) != 0);
        Assertions.checkArgument((toleranceAfterUs >= 0L ? 1 : 0) != 0);
        this.toleranceBeforeUs = toleranceBeforeUs;
        this.toleranceAfterUs = toleranceAfterUs;
    }

    public long resolveSeekPositionUs(long positionUs, long firstSyncUs, long secondSyncUs) {
        boolean secondSyncPositionValid;
        if (this.toleranceBeforeUs == 0L && this.toleranceAfterUs == 0L) {
            return positionUs;
        }
        long minPositionUs = Util.subtractWithOverflowDefault((long)positionUs, (long)this.toleranceBeforeUs, (long)Long.MIN_VALUE);
        long maxPositionUs = Util.addWithOverflowDefault((long)positionUs, (long)this.toleranceAfterUs, (long)Long.MAX_VALUE);
        boolean firstSyncPositionValid = minPositionUs <= firstSyncUs && firstSyncUs <= maxPositionUs;
        boolean bl = secondSyncPositionValid = minPositionUs <= secondSyncUs && secondSyncUs <= maxPositionUs;
        if (firstSyncPositionValid && secondSyncPositionValid) {
            if (Math.abs(firstSyncUs - positionUs) <= Math.abs(secondSyncUs - positionUs)) {
                return firstSyncUs;
            }
            return secondSyncUs;
        }
        if (firstSyncPositionValid) {
            return firstSyncUs;
        }
        if (secondSyncPositionValid) {
            return secondSyncUs;
        }
        return minPositionUs;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SeekParameters other = (SeekParameters)obj;
        return this.toleranceBeforeUs == other.toleranceBeforeUs && this.toleranceAfterUs == other.toleranceAfterUs;
    }

    public int hashCode() {
        return 31 * (int)this.toleranceBeforeUs + (int)this.toleranceAfterUs;
    }
}

