/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.BaseAudioProcessor;
import com.google.android.exoplayer2.util.Assertions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;

@Deprecated
final class ChannelMappingAudioProcessor
extends BaseAudioProcessor {
    @Nullable
    private int[] pendingOutputChannels;
    @Nullable
    private int[] outputChannels;

    ChannelMappingAudioProcessor() {
    }

    public void setChannelMap(@Nullable int[] outputChannels) {
        this.pendingOutputChannels = outputChannels;
    }

    @CanIgnoreReturnValue
    public AudioProcessor.AudioFormat onConfigure(AudioProcessor.AudioFormat inputAudioFormat) throws AudioProcessor.UnhandledAudioFormatException {
        int[] outputChannels = this.pendingOutputChannels;
        if (outputChannels == null) {
            return AudioProcessor.AudioFormat.NOT_SET;
        }
        if (inputAudioFormat.encoding != 2) {
            throw new AudioProcessor.UnhandledAudioFormatException(inputAudioFormat);
        }
        boolean active = inputAudioFormat.channelCount != outputChannels.length;
        for (int i = 0; i < outputChannels.length; ++i) {
            int channelIndex = outputChannels[i];
            if (channelIndex >= inputAudioFormat.channelCount) {
                throw new AudioProcessor.UnhandledAudioFormatException(inputAudioFormat);
            }
            active |= channelIndex != i;
        }
        return active ? new AudioProcessor.AudioFormat(inputAudioFormat.sampleRate, outputChannels.length, 2) : AudioProcessor.AudioFormat.NOT_SET;
    }

    public void queueInput(ByteBuffer inputBuffer) {
        int position;
        int[] outputChannels = (int[])Assertions.checkNotNull((Object)this.outputChannels);
        int limit = inputBuffer.limit();
        int frameCount = (limit - position) / this.inputAudioFormat.bytesPerFrame;
        int outputSize = frameCount * this.outputAudioFormat.bytesPerFrame;
        ByteBuffer buffer = this.replaceOutputBuffer(outputSize);
        for (position = inputBuffer.position(); position < limit; position += this.inputAudioFormat.bytesPerFrame) {
            for (int channelIndex : outputChannels) {
                buffer.putShort(inputBuffer.getShort(position + 2 * channelIndex));
            }
        }
        inputBuffer.position(limit);
        buffer.flip();
    }

    protected void onFlush() {
        this.outputChannels = this.pendingOutputChannels;
    }

    protected void onReset() {
        this.outputChannels = null;
        this.pendingOutputChannels = null;
    }
}

