/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioAttributes;
import android.media.AudioDeviceInfo;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioTrack;
import android.media.PlaybackParams;
import android.media.metrics.LogSessionId;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Pair;
import androidx.annotation.DoNotInline;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.analytics.PlayerId;
import com.google.android.exoplayer2.audio.Ac3Util;
import com.google.android.exoplayer2.audio.Ac4Util;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AudioCapabilities;
import com.google.android.exoplayer2.audio.AudioCapabilitiesReceiver;
import com.google.android.exoplayer2.audio.AudioProcessingPipeline;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.AudioSink;
import com.google.android.exoplayer2.audio.AudioTrackPositionTracker;
import com.google.android.exoplayer2.audio.AuxEffectInfo;
import com.google.android.exoplayer2.audio.ChannelMappingAudioProcessor;
import com.google.android.exoplayer2.audio.DefaultAudioTrackBufferSizeProvider;
import com.google.android.exoplayer2.audio.DtsUtil;
import com.google.android.exoplayer2.audio.MpegAudioUtil;
import com.google.android.exoplayer2.audio.OpusUtil;
import com.google.android.exoplayer2.audio.SilenceSkippingAudioProcessor;
import com.google.android.exoplayer2.audio.SonicAudioProcessor;
import com.google.android.exoplayer2.audio.ToFloatPcmAudioProcessor;
import com.google.android.exoplayer2.audio.ToInt16PcmAudioProcessor;
import com.google.android.exoplayer2.audio.TrimmingAudioProcessor;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.ConditionVariable;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.concurrent.ExecutorService;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@Deprecated
public final class DefaultAudioSink
implements AudioSink {
    private static final int AUDIO_TRACK_SMALLER_BUFFER_RETRY_SIZE = 1000000;
    public static final float DEFAULT_PLAYBACK_SPEED = 1.0f;
    public static final float MIN_PLAYBACK_SPEED = 0.1f;
    public static final float MAX_PLAYBACK_SPEED = 8.0f;
    public static final float MIN_PITCH = 0.1f;
    public static final float MAX_PITCH = 8.0f;
    private static final boolean DEFAULT_SKIP_SILENCE = false;
    public static final int OFFLOAD_MODE_DISABLED = 0;
    public static final int OFFLOAD_MODE_ENABLED_GAPLESS_REQUIRED = 1;
    public static final int OFFLOAD_MODE_ENABLED_GAPLESS_NOT_REQUIRED = 2;
    public static final int OFFLOAD_MODE_ENABLED_GAPLESS_DISABLED = 3;
    public static final int OUTPUT_MODE_PCM = 0;
    public static final int OUTPUT_MODE_OFFLOAD = 1;
    public static final int OUTPUT_MODE_PASSTHROUGH = 2;
    private static final int ERROR_NATIVE_DEAD_OBJECT = -32;
    private static final int AUDIO_TRACK_RETRY_DURATION_MS = 100;
    private static final String TAG = "DefaultAudioSink";
    public static boolean failOnSpuriousAudioTimestamp = false;
    private static final Object releaseExecutorLock = new Object();
    @GuardedBy(value="releaseExecutorLock")
    @Nullable
    private static ExecutorService releaseExecutor;
    @GuardedBy(value="releaseExecutorLock")
    private static int pendingReleaseCount;
    @Nullable
    private final Context context;
    private final com.google.android.exoplayer2.audio.AudioProcessorChain audioProcessorChain;
    private final boolean enableFloatOutput;
    private final ChannelMappingAudioProcessor channelMappingAudioProcessor;
    private final TrimmingAudioProcessor trimmingAudioProcessor;
    private final ImmutableList<AudioProcessor> toIntPcmAvailableAudioProcessors;
    private final ImmutableList<AudioProcessor> toFloatPcmAvailableAudioProcessors;
    private final ConditionVariable releasingConditionVariable;
    private final AudioTrackPositionTracker audioTrackPositionTracker;
    private final ArrayDeque<MediaPositionParameters> mediaPositionParametersCheckpoints;
    private final boolean preferAudioTrackPlaybackParams;
    private final int offloadMode;
    private @MonotonicNonNull StreamEventCallbackV29 offloadStreamEventCallbackV29;
    private final PendingExceptionHolder<AudioSink.InitializationException> initializationExceptionPendingExceptionHolder;
    private final PendingExceptionHolder<AudioSink.WriteException> writeExceptionPendingExceptionHolder;
    private final AudioTrackBufferSizeProvider audioTrackBufferSizeProvider;
    @Nullable
    private final ExoPlayer.AudioOffloadListener audioOffloadListener;
    @Nullable
    private PlayerId playerId;
    @Nullable
    private AudioSink.Listener listener;
    @Nullable
    private Configuration pendingConfiguration;
    private @MonotonicNonNull Configuration configuration;
    private @MonotonicNonNull AudioProcessingPipeline audioProcessingPipeline;
    @Nullable
    private AudioTrack audioTrack;
    private AudioCapabilities audioCapabilities;
    private @MonotonicNonNull AudioCapabilitiesReceiver audioCapabilitiesReceiver;
    private AudioAttributes audioAttributes;
    @Nullable
    private MediaPositionParameters afterDrainParameters;
    private MediaPositionParameters mediaPositionParameters;
    private PlaybackParameters playbackParameters;
    private boolean skipSilenceEnabled;
    @Nullable
    private ByteBuffer avSyncHeader;
    private int bytesUntilNextAvSync;
    private long submittedPcmBytes;
    private long submittedEncodedFrames;
    private long writtenPcmBytes;
    private long writtenEncodedFrames;
    private int framesPerEncodedSample;
    private boolean startMediaTimeUsNeedsSync;
    private boolean startMediaTimeUsNeedsInit;
    private long startMediaTimeUs;
    private float volume;
    @Nullable
    private ByteBuffer inputBuffer;
    private int inputBufferAccessUnitCount;
    @Nullable
    private ByteBuffer outputBuffer;
    private @MonotonicNonNull byte[] preV21OutputBuffer;
    private int preV21OutputBufferOffset;
    private boolean handledEndOfStream;
    private boolean stoppedAudioTrack;
    private boolean playing;
    private boolean externalAudioSessionIdProvided;
    private int audioSessionId;
    private AuxEffectInfo auxEffectInfo;
    @Nullable
    private AudioDeviceInfoApi23 preferredDevice;
    private boolean tunneling;
    private long lastTunnelingAvSyncPresentationTimeUs;
    private long lastFeedElapsedRealtimeMs;
    private boolean offloadDisabledUntilNextConfiguration;
    private boolean isWaitingForOffloadEndOfStreamHandled;
    @Nullable
    private Looper playbackLooper;

    @RequiresNonNull(value={"#1.audioProcessorChain"})
    private DefaultAudioSink(Builder builder) {
        this.context = builder.context;
        this.audioCapabilities = this.context != null ? AudioCapabilities.getCapabilities(this.context) : builder.audioCapabilities;
        this.audioProcessorChain = builder.audioProcessorChain;
        this.enableFloatOutput = Util.SDK_INT >= 21 && builder.enableFloatOutput;
        this.preferAudioTrackPlaybackParams = Util.SDK_INT >= 23 && builder.enableAudioTrackPlaybackParams;
        this.offloadMode = Util.SDK_INT >= 29 ? builder.offloadMode : 0;
        this.audioTrackBufferSizeProvider = builder.audioTrackBufferSizeProvider;
        this.releasingConditionVariable = new ConditionVariable(Clock.DEFAULT);
        this.releasingConditionVariable.open();
        this.audioTrackPositionTracker = new AudioTrackPositionTracker(new PositionTrackerListener());
        this.channelMappingAudioProcessor = new ChannelMappingAudioProcessor();
        this.trimmingAudioProcessor = new TrimmingAudioProcessor();
        this.toIntPcmAvailableAudioProcessors = ImmutableList.of((Object)new ToInt16PcmAudioProcessor(), (Object)((Object)this.channelMappingAudioProcessor), (Object)((Object)this.trimmingAudioProcessor));
        this.toFloatPcmAvailableAudioProcessors = ImmutableList.of((Object)((Object)new ToFloatPcmAudioProcessor()));
        this.volume = 1.0f;
        this.audioAttributes = AudioAttributes.DEFAULT;
        this.audioSessionId = 0;
        this.auxEffectInfo = new AuxEffectInfo(0, 0.0f);
        this.mediaPositionParameters = new MediaPositionParameters(PlaybackParameters.DEFAULT, 0L, 0L);
        this.playbackParameters = PlaybackParameters.DEFAULT;
        this.skipSilenceEnabled = false;
        this.mediaPositionParametersCheckpoints = new ArrayDeque();
        this.initializationExceptionPendingExceptionHolder = new PendingExceptionHolder(100L);
        this.writeExceptionPendingExceptionHolder = new PendingExceptionHolder(100L);
        this.audioOffloadListener = builder.audioOffloadListener;
    }

    @Override
    public void setListener(AudioSink.Listener listener) {
        this.listener = listener;
    }

    @Override
    public void setPlayerId(@Nullable PlayerId playerId) {
        this.playerId = playerId;
    }

    @Override
    public boolean supportsFormat(Format format) {
        return this.getFormatSupport(format) != 0;
    }

    @Override
    public int getFormatSupport(Format format) {
        if ("audio/raw".equals(format.sampleMimeType)) {
            if (!Util.isEncodingLinearPcm((int)format.pcmEncoding)) {
                Log.w((String)TAG, (String)("Invalid PCM encoding: " + format.pcmEncoding));
                return 0;
            }
            if (format.pcmEncoding == 2 || this.enableFloatOutput && format.pcmEncoding == 4) {
                return 2;
            }
            return 1;
        }
        if (!this.offloadDisabledUntilNextConfiguration && this.useOffloadedPlayback(format, this.audioAttributes)) {
            return 2;
        }
        if (this.getAudioCapabilities().isPassthroughPlaybackSupported(format)) {
            return 2;
        }
        return 0;
    }

    @Override
    public long getCurrentPositionUs(boolean sourceEnded) {
        if (!this.isAudioTrackInitialized() || this.startMediaTimeUsNeedsInit) {
            return Long.MIN_VALUE;
        }
        long positionUs = this.audioTrackPositionTracker.getCurrentPositionUs(sourceEnded);
        positionUs = Math.min(positionUs, this.configuration.framesToDurationUs(this.getWrittenFrames()));
        return this.applySkipping(this.applyMediaPositionParameters(positionUs));
    }

    @Override
    public void configure(Format inputFormat, int specifiedBufferSize, @Nullable int[] outputChannels) throws AudioSink.ConfigurationException {
        boolean enableAudioTrackPlaybackParams;
        int outputPcmFrameSize;
        int outputChannelConfig;
        int outputSampleRate;
        int outputEncoding;
        int outputMode;
        AudioProcessingPipeline audioProcessingPipeline;
        int inputPcmFrameSize;
        if ("audio/raw".equals(inputFormat.sampleMimeType)) {
            Assertions.checkArgument((boolean)Util.isEncodingLinearPcm((int)inputFormat.pcmEncoding));
            inputPcmFrameSize = Util.getPcmFrameSize((int)inputFormat.pcmEncoding, (int)inputFormat.channelCount);
            ImmutableList.Builder pipelineProcessors = new ImmutableList.Builder();
            if (this.shouldUseFloatOutput(inputFormat.pcmEncoding)) {
                pipelineProcessors.addAll(this.toFloatPcmAvailableAudioProcessors);
            } else {
                pipelineProcessors.addAll(this.toIntPcmAvailableAudioProcessors);
                pipelineProcessors.add((Object[])this.audioProcessorChain.getAudioProcessors());
            }
            audioProcessingPipeline = new AudioProcessingPipeline(pipelineProcessors.build());
            if (audioProcessingPipeline.equals((Object)this.audioProcessingPipeline)) {
                audioProcessingPipeline = this.audioProcessingPipeline;
            }
            this.trimmingAudioProcessor.setTrimFrameCount(inputFormat.encoderDelay, inputFormat.encoderPadding);
            if (Util.SDK_INT < 21 && inputFormat.channelCount == 8 && outputChannels == null) {
                outputChannels = new int[6];
                for (int i = 0; i < outputChannels.length; ++i) {
                    outputChannels[i] = i;
                }
            }
            this.channelMappingAudioProcessor.setChannelMap(outputChannels);
            AudioProcessor.AudioFormat outputFormat = new AudioProcessor.AudioFormat(inputFormat.sampleRate, inputFormat.channelCount, inputFormat.pcmEncoding);
            try {
                outputFormat = audioProcessingPipeline.configure(outputFormat);
            }
            catch (AudioProcessor.UnhandledAudioFormatException e) {
                throw new AudioSink.ConfigurationException(e, inputFormat);
            }
            outputMode = 0;
            outputEncoding = outputFormat.encoding;
            outputSampleRate = outputFormat.sampleRate;
            outputChannelConfig = Util.getAudioTrackChannelConfig((int)outputFormat.channelCount);
            outputPcmFrameSize = Util.getPcmFrameSize((int)outputEncoding, (int)outputFormat.channelCount);
            enableAudioTrackPlaybackParams = this.preferAudioTrackPlaybackParams;
        } else {
            audioProcessingPipeline = new AudioProcessingPipeline(ImmutableList.of());
            inputPcmFrameSize = -1;
            outputSampleRate = inputFormat.sampleRate;
            outputPcmFrameSize = -1;
            if (this.useOffloadedPlayback(inputFormat, this.audioAttributes)) {
                outputMode = 1;
                outputEncoding = MimeTypes.getEncoding((String)((String)Assertions.checkNotNull((Object)inputFormat.sampleMimeType)), (String)inputFormat.codecs);
                outputChannelConfig = Util.getAudioTrackChannelConfig((int)inputFormat.channelCount);
                enableAudioTrackPlaybackParams = true;
            } else {
                outputMode = 2;
                Pair<Integer, Integer> encodingAndChannelConfig = this.getAudioCapabilities().getEncodingAndChannelConfigForPassthrough(inputFormat);
                if (encodingAndChannelConfig == null) {
                    throw new AudioSink.ConfigurationException("Unable to configure passthrough for: " + inputFormat, inputFormat);
                }
                outputEncoding = (Integer)encodingAndChannelConfig.first;
                outputChannelConfig = (Integer)encodingAndChannelConfig.second;
                enableAudioTrackPlaybackParams = this.preferAudioTrackPlaybackParams;
            }
        }
        if (outputEncoding == 0) {
            throw new AudioSink.ConfigurationException("Invalid output encoding (mode=" + outputMode + ") for: " + inputFormat, inputFormat);
        }
        if (outputChannelConfig == 0) {
            throw new AudioSink.ConfigurationException("Invalid output channel config (mode=" + outputMode + ") for: " + inputFormat, inputFormat);
        }
        int bufferSize = specifiedBufferSize != 0 ? specifiedBufferSize : this.audioTrackBufferSizeProvider.getBufferSizeInBytes(DefaultAudioSink.getAudioTrackMinBufferSize(outputSampleRate, outputChannelConfig, outputEncoding), outputEncoding, outputMode, outputPcmFrameSize != -1 ? outputPcmFrameSize : 1, outputSampleRate, inputFormat.bitrate, enableAudioTrackPlaybackParams ? 8.0 : 1.0);
        this.offloadDisabledUntilNextConfiguration = false;
        Configuration pendingConfiguration = new Configuration(inputFormat, inputPcmFrameSize, outputMode, outputPcmFrameSize, outputSampleRate, outputChannelConfig, outputEncoding, bufferSize, audioProcessingPipeline, enableAudioTrackPlaybackParams);
        if (this.isAudioTrackInitialized()) {
            this.pendingConfiguration = pendingConfiguration;
        } else {
            this.configuration = pendingConfiguration;
        }
    }

    private void setupAudioProcessors() {
        this.audioProcessingPipeline = this.configuration.audioProcessingPipeline;
        this.audioProcessingPipeline.flush();
    }

    private boolean initializeAudioTrack() throws AudioSink.InitializationException {
        if (!this.releasingConditionVariable.isOpen()) {
            return false;
        }
        this.audioTrack = this.buildAudioTrackWithRetry();
        if (DefaultAudioSink.isOffloadedPlayback(this.audioTrack)) {
            this.registerStreamEventCallbackV29(this.audioTrack);
            if (this.offloadMode != 3) {
                this.audioTrack.setOffloadDelayPadding(this.configuration.inputFormat.encoderDelay, this.configuration.inputFormat.encoderPadding);
            }
        }
        if (Util.SDK_INT >= 31 && this.playerId != null) {
            Api31.setLogSessionIdOnAudioTrack(this.audioTrack, this.playerId);
        }
        this.audioSessionId = this.audioTrack.getAudioSessionId();
        this.audioTrackPositionTracker.setAudioTrack(this.audioTrack, this.configuration.outputMode == 2, this.configuration.outputEncoding, this.configuration.outputPcmFrameSize, this.configuration.bufferSize);
        this.setVolumeInternal();
        if (this.auxEffectInfo.effectId != 0) {
            this.audioTrack.attachAuxEffect(this.auxEffectInfo.effectId);
            this.audioTrack.setAuxEffectSendLevel(this.auxEffectInfo.sendLevel);
        }
        if (this.preferredDevice != null && Util.SDK_INT >= 23) {
            Api23.setPreferredDeviceOnAudioTrack(this.audioTrack, this.preferredDevice);
        }
        this.startMediaTimeUsNeedsInit = true;
        return true;
    }

    @Override
    public void play() {
        this.playing = true;
        if (this.isAudioTrackInitialized()) {
            this.audioTrackPositionTracker.start();
            this.audioTrack.play();
        }
    }

    @Override
    public void handleDiscontinuity() {
        this.startMediaTimeUsNeedsSync = true;
    }

    @Override
    public boolean handleBuffer(ByteBuffer buffer, long presentationTimeUs, int encodedAccessUnitCount) throws AudioSink.InitializationException, AudioSink.WriteException {
        Assertions.checkArgument((this.inputBuffer == null || buffer == this.inputBuffer ? 1 : 0) != 0);
        if (this.pendingConfiguration != null) {
            if (!this.drainToEndOfStream()) {
                return false;
            }
            if (!this.pendingConfiguration.canReuseAudioTrack(this.configuration)) {
                this.playPendingData();
                if (this.hasPendingData()) {
                    return false;
                }
                this.flush();
            } else {
                this.configuration = this.pendingConfiguration;
                this.pendingConfiguration = null;
                if (DefaultAudioSink.isOffloadedPlayback(this.audioTrack) && this.offloadMode != 3) {
                    if (this.audioTrack.getPlayState() == 3) {
                        this.audioTrack.setOffloadEndOfStream();
                    }
                    this.audioTrack.setOffloadDelayPadding(this.configuration.inputFormat.encoderDelay, this.configuration.inputFormat.encoderPadding);
                    this.isWaitingForOffloadEndOfStreamHandled = true;
                }
            }
            this.applyAudioProcessorPlaybackParametersAndSkipSilence(presentationTimeUs);
        }
        if (!this.isAudioTrackInitialized()) {
            try {
                if (!this.initializeAudioTrack()) {
                    return false;
                }
            }
            catch (AudioSink.InitializationException e) {
                if (e.isRecoverable) {
                    throw e;
                }
                this.initializationExceptionPendingExceptionHolder.throwExceptionIfDeadlineIsReached(e);
                return false;
            }
        }
        this.initializationExceptionPendingExceptionHolder.clear();
        if (this.startMediaTimeUsNeedsInit) {
            this.startMediaTimeUs = Math.max(0L, presentationTimeUs);
            this.startMediaTimeUsNeedsSync = false;
            this.startMediaTimeUsNeedsInit = false;
            if (this.useAudioTrackPlaybackParams()) {
                this.setAudioTrackPlaybackParametersV23();
            }
            this.applyAudioProcessorPlaybackParametersAndSkipSilence(presentationTimeUs);
            if (this.playing) {
                this.play();
            }
        }
        if (!this.audioTrackPositionTracker.mayHandleBuffer(this.getWrittenFrames())) {
            return false;
        }
        if (this.inputBuffer == null) {
            Assertions.checkArgument((buffer.order() == ByteOrder.LITTLE_ENDIAN ? 1 : 0) != 0);
            if (!buffer.hasRemaining()) {
                return true;
            }
            if (this.configuration.outputMode != 0 && this.framesPerEncodedSample == 0) {
                this.framesPerEncodedSample = DefaultAudioSink.getFramesPerEncodedSample(this.configuration.outputEncoding, buffer);
                if (this.framesPerEncodedSample == 0) {
                    return true;
                }
            }
            if (this.afterDrainParameters != null) {
                if (!this.drainToEndOfStream()) {
                    return false;
                }
                this.applyAudioProcessorPlaybackParametersAndSkipSilence(presentationTimeUs);
                this.afterDrainParameters = null;
            }
            long expectedPresentationTimeUs = this.startMediaTimeUs + this.configuration.inputFramesToDurationUs(this.getSubmittedFrames() - this.trimmingAudioProcessor.getTrimmedFrameCount());
            if (!this.startMediaTimeUsNeedsSync && Math.abs(expectedPresentationTimeUs - presentationTimeUs) > 200000L) {
                if (this.listener != null) {
                    this.listener.onAudioSinkError(new AudioSink.UnexpectedDiscontinuityException(presentationTimeUs, expectedPresentationTimeUs));
                }
                this.startMediaTimeUsNeedsSync = true;
            }
            if (this.startMediaTimeUsNeedsSync) {
                if (!this.drainToEndOfStream()) {
                    return false;
                }
                long adjustmentUs = presentationTimeUs - expectedPresentationTimeUs;
                this.startMediaTimeUs += adjustmentUs;
                this.startMediaTimeUsNeedsSync = false;
                this.applyAudioProcessorPlaybackParametersAndSkipSilence(presentationTimeUs);
                if (this.listener != null && adjustmentUs != 0L) {
                    this.listener.onPositionDiscontinuity();
                }
            }
            if (this.configuration.outputMode == 0) {
                this.submittedPcmBytes += (long)buffer.remaining();
            } else {
                this.submittedEncodedFrames += (long)this.framesPerEncodedSample * (long)encodedAccessUnitCount;
            }
            this.inputBuffer = buffer;
            this.inputBufferAccessUnitCount = encodedAccessUnitCount;
        }
        this.processBuffers(presentationTimeUs);
        if (!this.inputBuffer.hasRemaining()) {
            this.inputBuffer = null;
            this.inputBufferAccessUnitCount = 0;
            return true;
        }
        if (this.audioTrackPositionTracker.isStalled(this.getWrittenFrames())) {
            Log.w((String)TAG, (String)"Resetting stalled audio track");
            this.flush();
            return true;
        }
        return false;
    }

    private AudioTrack buildAudioTrackWithRetry() throws AudioSink.InitializationException {
        try {
            return this.buildAudioTrack((Configuration)Assertions.checkNotNull((Object)this.configuration));
        }
        catch (AudioSink.InitializationException initialFailure) {
            if (this.configuration.bufferSize > 1000000) {
                Configuration retryConfiguration = this.configuration.copyWithBufferSize(1000000);
                try {
                    AudioTrack audioTrack = this.buildAudioTrack(retryConfiguration);
                    this.configuration = retryConfiguration;
                    return audioTrack;
                }
                catch (AudioSink.InitializationException retryFailure) {
                    initialFailure.addSuppressed(retryFailure);
                }
            }
            this.maybeDisableOffload();
            throw initialFailure;
        }
    }

    private AudioTrack buildAudioTrack(Configuration configuration) throws AudioSink.InitializationException {
        try {
            AudioTrack audioTrack = configuration.buildAudioTrack(this.tunneling, this.audioAttributes, this.audioSessionId);
            if (this.audioOffloadListener != null) {
                this.audioOffloadListener.onExperimentalOffloadedPlayback(DefaultAudioSink.isOffloadedPlayback(audioTrack));
            }
            return audioTrack;
        }
        catch (AudioSink.InitializationException e) {
            if (this.listener != null) {
                this.listener.onAudioSinkError(e);
            }
            throw e;
        }
    }

    @RequiresApi(value=29)
    private void registerStreamEventCallbackV29(AudioTrack audioTrack) {
        if (this.offloadStreamEventCallbackV29 == null) {
            this.offloadStreamEventCallbackV29 = new StreamEventCallbackV29();
        }
        this.offloadStreamEventCallbackV29.register(audioTrack);
    }

    private void processBuffers(long avSyncPresentationTimeUs) throws AudioSink.WriteException {
        if (!this.audioProcessingPipeline.isOperational()) {
            this.writeBuffer(this.inputBuffer != null ? this.inputBuffer : AudioProcessor.EMPTY_BUFFER, avSyncPresentationTimeUs);
            return;
        }
        while (!this.audioProcessingPipeline.isEnded()) {
            ByteBuffer bufferToWrite;
            while ((bufferToWrite = this.audioProcessingPipeline.getOutput()).hasRemaining()) {
                this.writeBuffer(bufferToWrite, avSyncPresentationTimeUs);
                if (!bufferToWrite.hasRemaining()) continue;
                return;
            }
            if (this.inputBuffer == null || !this.inputBuffer.hasRemaining()) {
                return;
            }
            this.audioProcessingPipeline.queueInput(this.inputBuffer);
        }
    }

    private boolean drainToEndOfStream() throws AudioSink.WriteException {
        if (!this.audioProcessingPipeline.isOperational()) {
            if (this.outputBuffer == null) {
                return true;
            }
            this.writeBuffer(this.outputBuffer, Long.MIN_VALUE);
            return this.outputBuffer == null;
        }
        this.audioProcessingPipeline.queueEndOfStream();
        this.processBuffers(Long.MIN_VALUE);
        return this.audioProcessingPipeline.isEnded() && (this.outputBuffer == null || !this.outputBuffer.hasRemaining());
    }

    private void writeBuffer(ByteBuffer buffer, long avSyncPresentationTimeUs) throws AudioSink.WriteException {
        int bytesRemaining;
        if (!buffer.hasRemaining()) {
            return;
        }
        if (this.outputBuffer != null) {
            Assertions.checkArgument((this.outputBuffer == buffer ? 1 : 0) != 0);
        } else {
            this.outputBuffer = buffer;
            if (Util.SDK_INT < 21) {
                bytesRemaining = buffer.remaining();
                if (this.preV21OutputBuffer == null || this.preV21OutputBuffer.length < bytesRemaining) {
                    this.preV21OutputBuffer = new byte[bytesRemaining];
                }
                int originalPosition = buffer.position();
                buffer.get(this.preV21OutputBuffer, 0, bytesRemaining);
                buffer.position(originalPosition);
                this.preV21OutputBufferOffset = 0;
            }
        }
        bytesRemaining = buffer.remaining();
        int bytesWrittenOrError = 0;
        if (Util.SDK_INT < 21) {
            int bytesToWrite = this.audioTrackPositionTracker.getAvailableBufferSize(this.writtenPcmBytes);
            if (bytesToWrite > 0 && (bytesWrittenOrError = this.audioTrack.write(this.preV21OutputBuffer, this.preV21OutputBufferOffset, bytesToWrite = Math.min(bytesRemaining, bytesToWrite))) > 0) {
                this.preV21OutputBufferOffset += bytesWrittenOrError;
                buffer.position(buffer.position() + bytesWrittenOrError);
            }
        } else if (this.tunneling) {
            Assertions.checkState((avSyncPresentationTimeUs != -9223372036854775807L ? 1 : 0) != 0);
            if (avSyncPresentationTimeUs == Long.MIN_VALUE) {
                avSyncPresentationTimeUs = this.lastTunnelingAvSyncPresentationTimeUs;
            } else {
                this.lastTunnelingAvSyncPresentationTimeUs = avSyncPresentationTimeUs;
            }
            bytesWrittenOrError = this.writeNonBlockingWithAvSyncV21(this.audioTrack, buffer, bytesRemaining, avSyncPresentationTimeUs);
        } else {
            bytesWrittenOrError = DefaultAudioSink.writeNonBlockingV21(this.audioTrack, buffer, bytesRemaining);
        }
        this.lastFeedElapsedRealtimeMs = SystemClock.elapsedRealtime();
        if (bytesWrittenOrError < 0) {
            int error = bytesWrittenOrError;
            boolean isRecoverable = DefaultAudioSink.isAudioTrackDeadObject(error) && this.writtenEncodedFrames > 0L;
            AudioSink.WriteException e = new AudioSink.WriteException(error, this.configuration.inputFormat, isRecoverable);
            if (this.listener != null) {
                this.listener.onAudioSinkError(e);
            }
            if (e.isRecoverable) {
                this.audioCapabilities = AudioCapabilities.DEFAULT_AUDIO_CAPABILITIES;
                throw e;
            }
            this.writeExceptionPendingExceptionHolder.throwExceptionIfDeadlineIsReached(e);
            return;
        }
        this.writeExceptionPendingExceptionHolder.clear();
        int bytesWritten = bytesWrittenOrError;
        if (DefaultAudioSink.isOffloadedPlayback(this.audioTrack)) {
            if (this.writtenEncodedFrames > 0L) {
                this.isWaitingForOffloadEndOfStreamHandled = false;
            }
            if (this.playing && this.listener != null && bytesWritten < bytesRemaining && !this.isWaitingForOffloadEndOfStreamHandled) {
                this.listener.onOffloadBufferFull();
            }
        }
        if (this.configuration.outputMode == 0) {
            this.writtenPcmBytes += (long)bytesWritten;
        }
        if (bytesWritten == bytesRemaining) {
            if (this.configuration.outputMode != 0) {
                Assertions.checkState((buffer == this.inputBuffer ? 1 : 0) != 0);
                this.writtenEncodedFrames += (long)this.framesPerEncodedSample * (long)this.inputBufferAccessUnitCount;
            }
            this.outputBuffer = null;
        }
    }

    @Override
    public void playToEndOfStream() throws AudioSink.WriteException {
        if (!this.handledEndOfStream && this.isAudioTrackInitialized() && this.drainToEndOfStream()) {
            this.playPendingData();
            this.handledEndOfStream = true;
        }
    }

    private void maybeDisableOffload() {
        if (!this.configuration.outputModeIsOffload()) {
            return;
        }
        this.offloadDisabledUntilNextConfiguration = true;
    }

    private static boolean isAudioTrackDeadObject(int status) {
        return Util.SDK_INT >= 24 && status == -6 || status == -32;
    }

    @Override
    public boolean isEnded() {
        return !this.isAudioTrackInitialized() || this.handledEndOfStream && !this.hasPendingData();
    }

    @Override
    public boolean hasPendingData() {
        return this.isAudioTrackInitialized() && this.audioTrackPositionTracker.hasPendingData(this.getWrittenFrames());
    }

    @Override
    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        this.playbackParameters = new PlaybackParameters(Util.constrainValue((float)playbackParameters.speed, (float)0.1f, (float)8.0f), Util.constrainValue((float)playbackParameters.pitch, (float)0.1f, (float)8.0f));
        if (this.useAudioTrackPlaybackParams()) {
            this.setAudioTrackPlaybackParametersV23();
        } else {
            this.setAudioProcessorPlaybackParameters(playbackParameters);
        }
    }

    @Override
    public PlaybackParameters getPlaybackParameters() {
        return this.playbackParameters;
    }

    @Override
    public void setSkipSilenceEnabled(boolean skipSilenceEnabled) {
        this.skipSilenceEnabled = skipSilenceEnabled;
        this.setAudioProcessorPlaybackParameters(this.useAudioTrackPlaybackParams() ? PlaybackParameters.DEFAULT : this.playbackParameters);
    }

    @Override
    public boolean getSkipSilenceEnabled() {
        return this.skipSilenceEnabled;
    }

    @Override
    public void setAudioAttributes(AudioAttributes audioAttributes) {
        if (this.audioAttributes.equals((Object)audioAttributes)) {
            return;
        }
        this.audioAttributes = audioAttributes;
        if (this.tunneling) {
            return;
        }
        this.flush();
    }

    @Override
    public AudioAttributes getAudioAttributes() {
        return this.audioAttributes;
    }

    @Override
    public void setAudioSessionId(int audioSessionId) {
        if (this.audioSessionId != audioSessionId) {
            this.audioSessionId = audioSessionId;
            this.externalAudioSessionIdProvided = audioSessionId != 0;
            this.flush();
        }
    }

    @Override
    public void setAuxEffectInfo(AuxEffectInfo auxEffectInfo) {
        if (this.auxEffectInfo.equals((Object)auxEffectInfo)) {
            return;
        }
        int effectId = auxEffectInfo.effectId;
        float sendLevel = auxEffectInfo.sendLevel;
        if (this.audioTrack != null) {
            if (this.auxEffectInfo.effectId != effectId) {
                this.audioTrack.attachAuxEffect(effectId);
            }
            if (effectId != 0) {
                this.audioTrack.setAuxEffectSendLevel(sendLevel);
            }
        }
        this.auxEffectInfo = auxEffectInfo;
    }

    @Override
    @RequiresApi(value=23)
    public void setPreferredDevice(@Nullable AudioDeviceInfo audioDeviceInfo) {
        AudioDeviceInfoApi23 audioDeviceInfoApi23 = this.preferredDevice = audioDeviceInfo == null ? null : new AudioDeviceInfoApi23(audioDeviceInfo);
        if (this.audioTrack != null) {
            Api23.setPreferredDeviceOnAudioTrack(this.audioTrack, this.preferredDevice);
        }
    }

    @Override
    public void enableTunnelingV21() {
        Assertions.checkState((Util.SDK_INT >= 21 ? 1 : 0) != 0);
        Assertions.checkState((boolean)this.externalAudioSessionIdProvided);
        if (!this.tunneling) {
            this.tunneling = true;
            this.flush();
        }
    }

    @Override
    public void disableTunneling() {
        if (this.tunneling) {
            this.tunneling = false;
            this.flush();
        }
    }

    @Override
    public void setVolume(float volume) {
        if (this.volume != volume) {
            this.volume = volume;
            this.setVolumeInternal();
        }
    }

    private void setVolumeInternal() {
        if (this.isAudioTrackInitialized()) {
            if (Util.SDK_INT >= 21) {
                DefaultAudioSink.setVolumeInternalV21(this.audioTrack, this.volume);
            } else {
                DefaultAudioSink.setVolumeInternalV3(this.audioTrack, this.volume);
            }
        }
    }

    @Override
    public void pause() {
        this.playing = false;
        if (this.isAudioTrackInitialized() && this.audioTrackPositionTracker.pause()) {
            this.audioTrack.pause();
        }
    }

    @Override
    public void flush() {
        if (this.isAudioTrackInitialized()) {
            this.resetSinkStateForFlush();
            if (this.audioTrackPositionTracker.isPlaying()) {
                this.audioTrack.pause();
            }
            if (DefaultAudioSink.isOffloadedPlayback(this.audioTrack)) {
                ((StreamEventCallbackV29)Assertions.checkNotNull((Object)this.offloadStreamEventCallbackV29)).unregister(this.audioTrack);
            }
            if (Util.SDK_INT < 21 && !this.externalAudioSessionIdProvided) {
                this.audioSessionId = 0;
            }
            if (this.pendingConfiguration != null) {
                this.configuration = this.pendingConfiguration;
                this.pendingConfiguration = null;
            }
            this.audioTrackPositionTracker.reset();
            DefaultAudioSink.releaseAudioTrackAsync(this.audioTrack, this.releasingConditionVariable);
            this.audioTrack = null;
        }
        this.writeExceptionPendingExceptionHolder.clear();
        this.initializationExceptionPendingExceptionHolder.clear();
    }

    @Override
    public void experimentalFlushWithoutAudioTrackRelease() {
        if (Util.SDK_INT < 25) {
            this.flush();
            return;
        }
        this.writeExceptionPendingExceptionHolder.clear();
        this.initializationExceptionPendingExceptionHolder.clear();
        if (!this.isAudioTrackInitialized()) {
            return;
        }
        this.resetSinkStateForFlush();
        if (this.audioTrackPositionTracker.isPlaying()) {
            this.audioTrack.pause();
        }
        this.audioTrack.flush();
        this.audioTrackPositionTracker.reset();
        this.audioTrackPositionTracker.setAudioTrack(this.audioTrack, this.configuration.outputMode == 2, this.configuration.outputEncoding, this.configuration.outputPcmFrameSize, this.configuration.bufferSize);
        this.startMediaTimeUsNeedsInit = true;
    }

    @Override
    public void reset() {
        this.flush();
        for (AudioProcessor audioProcessor : this.toIntPcmAvailableAudioProcessors) {
            audioProcessor.reset();
        }
        for (AudioProcessor audioProcessor : this.toFloatPcmAvailableAudioProcessors) {
            audioProcessor.reset();
        }
        if (this.audioProcessingPipeline != null) {
            this.audioProcessingPipeline.reset();
        }
        this.playing = false;
        this.offloadDisabledUntilNextConfiguration = false;
    }

    @Override
    public void release() {
        if (this.audioCapabilitiesReceiver != null) {
            this.audioCapabilitiesReceiver.unregister();
        }
    }

    public void onAudioCapabilitiesChanged(AudioCapabilities audioCapabilities) {
        Assertions.checkState((this.playbackLooper == Looper.myLooper() ? 1 : 0) != 0);
        if (!audioCapabilities.equals(this.getAudioCapabilities())) {
            this.audioCapabilities = audioCapabilities;
            if (this.listener != null) {
                this.listener.onAudioCapabilitiesChanged();
            }
        }
    }

    private void resetSinkStateForFlush() {
        this.submittedPcmBytes = 0L;
        this.submittedEncodedFrames = 0L;
        this.writtenPcmBytes = 0L;
        this.writtenEncodedFrames = 0L;
        this.isWaitingForOffloadEndOfStreamHandled = false;
        this.framesPerEncodedSample = 0;
        this.mediaPositionParameters = new MediaPositionParameters(this.playbackParameters, 0L, 0L);
        this.startMediaTimeUs = 0L;
        this.afterDrainParameters = null;
        this.mediaPositionParametersCheckpoints.clear();
        this.inputBuffer = null;
        this.inputBufferAccessUnitCount = 0;
        this.outputBuffer = null;
        this.stoppedAudioTrack = false;
        this.handledEndOfStream = false;
        this.avSyncHeader = null;
        this.bytesUntilNextAvSync = 0;
        this.trimmingAudioProcessor.resetTrimmedFrameCount();
        this.setupAudioProcessors();
    }

    @RequiresApi(value=23)
    private void setAudioTrackPlaybackParametersV23() {
        if (this.isAudioTrackInitialized()) {
            PlaybackParams playbackParams = new PlaybackParams().allowDefaults().setSpeed(this.playbackParameters.speed).setPitch(this.playbackParameters.pitch).setAudioFallbackMode(2);
            try {
                this.audioTrack.setPlaybackParams(playbackParams);
            }
            catch (IllegalArgumentException e) {
                Log.w((String)TAG, (String)"Failed to set playback params", (Throwable)e);
            }
            this.playbackParameters = new PlaybackParameters(this.audioTrack.getPlaybackParams().getSpeed(), this.audioTrack.getPlaybackParams().getPitch());
            this.audioTrackPositionTracker.setAudioTrackPlaybackSpeed(this.playbackParameters.speed);
        }
    }

    private void setAudioProcessorPlaybackParameters(PlaybackParameters playbackParameters) {
        MediaPositionParameters mediaPositionParameters = new MediaPositionParameters(playbackParameters, -9223372036854775807L, -9223372036854775807L);
        if (this.isAudioTrackInitialized()) {
            this.afterDrainParameters = mediaPositionParameters;
        } else {
            this.mediaPositionParameters = mediaPositionParameters;
        }
    }

    private void applyAudioProcessorPlaybackParametersAndSkipSilence(long presentationTimeUs) {
        PlaybackParameters audioProcessorPlaybackParameters = !this.useAudioTrackPlaybackParams() ? (this.playbackParameters = this.shouldApplyAudioProcessorPlaybackParameters() ? this.audioProcessorChain.applyPlaybackParameters(this.playbackParameters) : PlaybackParameters.DEFAULT) : PlaybackParameters.DEFAULT;
        this.skipSilenceEnabled = this.shouldApplyAudioProcessorPlaybackParameters() ? this.audioProcessorChain.applySkipSilenceEnabled(this.skipSilenceEnabled) : false;
        this.mediaPositionParametersCheckpoints.add(new MediaPositionParameters(audioProcessorPlaybackParameters, Math.max(0L, presentationTimeUs), this.configuration.framesToDurationUs(this.getWrittenFrames())));
        this.setupAudioProcessors();
        if (this.listener != null) {
            this.listener.onSkipSilenceEnabledChanged(this.skipSilenceEnabled);
        }
    }

    private boolean shouldApplyAudioProcessorPlaybackParameters() {
        return !this.tunneling && this.configuration.outputMode == 0 && !this.shouldUseFloatOutput(this.configuration.inputFormat.pcmEncoding);
    }

    private boolean useAudioTrackPlaybackParams() {
        return this.configuration != null && this.configuration.enableAudioTrackPlaybackParams && Util.SDK_INT >= 23;
    }

    private boolean shouldUseFloatOutput(int pcmEncoding) {
        return this.enableFloatOutput && Util.isEncodingHighResolutionPcm((int)pcmEncoding);
    }

    private long applyMediaPositionParameters(long positionUs) {
        while (!this.mediaPositionParametersCheckpoints.isEmpty() && positionUs >= this.mediaPositionParametersCheckpoints.getFirst().audioTrackPositionUs) {
            this.mediaPositionParameters = this.mediaPositionParametersCheckpoints.remove();
        }
        long playoutDurationSinceLastCheckpointUs = positionUs - this.mediaPositionParameters.audioTrackPositionUs;
        if (this.mediaPositionParameters.playbackParameters.equals((Object)PlaybackParameters.DEFAULT)) {
            return this.mediaPositionParameters.mediaTimeUs + playoutDurationSinceLastCheckpointUs;
        }
        if (this.mediaPositionParametersCheckpoints.isEmpty()) {
            long mediaDurationSinceLastCheckpointUs = this.audioProcessorChain.getMediaDuration(playoutDurationSinceLastCheckpointUs);
            return this.mediaPositionParameters.mediaTimeUs + mediaDurationSinceLastCheckpointUs;
        }
        MediaPositionParameters nextMediaPositionParameters = this.mediaPositionParametersCheckpoints.getFirst();
        long playoutDurationUntilNextCheckpointUs = nextMediaPositionParameters.audioTrackPositionUs - positionUs;
        long mediaDurationUntilNextCheckpointUs = Util.getMediaDurationForPlayoutDuration((long)playoutDurationUntilNextCheckpointUs, (float)this.mediaPositionParameters.playbackParameters.speed);
        return nextMediaPositionParameters.mediaTimeUs - mediaDurationUntilNextCheckpointUs;
    }

    private long applySkipping(long positionUs) {
        return positionUs + this.configuration.framesToDurationUs(this.audioProcessorChain.getSkippedOutputFrameCount());
    }

    private boolean isAudioTrackInitialized() {
        return this.audioTrack != null;
    }

    private long getSubmittedFrames() {
        return this.configuration.outputMode == 0 ? this.submittedPcmBytes / (long)this.configuration.inputPcmFrameSize : this.submittedEncodedFrames;
    }

    private long getWrittenFrames() {
        return this.configuration.outputMode == 0 ? this.writtenPcmBytes / (long)this.configuration.outputPcmFrameSize : this.writtenEncodedFrames;
    }

    private boolean useOffloadedPlayback(Format format, AudioAttributes audioAttributes) {
        if (Util.SDK_INT < 29 || this.offloadMode == 0) {
            return false;
        }
        int encoding = MimeTypes.getEncoding((String)((String)Assertions.checkNotNull((Object)format.sampleMimeType)), (String)format.codecs);
        if (encoding == 0) {
            return false;
        }
        int channelConfig = Util.getAudioTrackChannelConfig((int)format.channelCount);
        if (channelConfig == 0) {
            return false;
        }
        AudioFormat audioFormat = DefaultAudioSink.getAudioFormat(format.sampleRate, channelConfig, encoding);
        switch (this.getOffloadedPlaybackSupport(audioFormat, audioAttributes.getAudioAttributesV21().audioAttributes)) {
            case 0: {
                return false;
            }
            case 1: {
                boolean isGapless = format.encoderDelay != 0 || format.encoderPadding != 0;
                boolean gaplessSupportRequired = this.offloadMode == 1;
                return !isGapless || !gaplessSupportRequired;
            }
            case 2: {
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private AudioCapabilities getAudioCapabilities() {
        if (this.audioCapabilitiesReceiver == null && this.context != null) {
            this.playbackLooper = Looper.myLooper();
            this.audioCapabilitiesReceiver = new AudioCapabilitiesReceiver(this.context, this::onAudioCapabilitiesChanged);
            this.audioCapabilities = this.audioCapabilitiesReceiver.register();
        }
        return this.audioCapabilities;
    }

    @RequiresApi(value=29)
    @SuppressLint(value={"InlinedApi"})
    private int getOffloadedPlaybackSupport(AudioFormat audioFormat, android.media.AudioAttributes audioAttributes) {
        if (Util.SDK_INT >= 31) {
            return AudioManager.getPlaybackOffloadSupport((AudioFormat)audioFormat, (android.media.AudioAttributes)audioAttributes);
        }
        if (!AudioManager.isOffloadedPlaybackSupported((AudioFormat)audioFormat, (android.media.AudioAttributes)audioAttributes)) {
            return 0;
        }
        if (Util.SDK_INT == 30 && Util.MODEL.startsWith("Pixel")) {
            return 2;
        }
        return 1;
    }

    private static boolean isOffloadedPlayback(AudioTrack audioTrack) {
        return Util.SDK_INT >= 29 && audioTrack.isOffloadedPlayback();
    }

    private static int getFramesPerEncodedSample(int encoding, ByteBuffer buffer) {
        switch (encoding) {
            case 9: {
                int headerDataInBigEndian = Util.getBigEndianInt((ByteBuffer)buffer, (int)buffer.position());
                int frameCount = MpegAudioUtil.parseMpegAudioFrameSampleCount((int)headerDataInBigEndian);
                if (frameCount == -1) {
                    throw new IllegalArgumentException();
                }
                return frameCount;
            }
            case 10: {
                return 1024;
            }
            case 11: 
            case 12: {
                return 2048;
            }
            case 16: {
                return 1024;
            }
            case 15: {
                return 512;
            }
            case 7: 
            case 8: {
                return DtsUtil.parseDtsAudioSampleCount((ByteBuffer)buffer);
            }
            case 5: 
            case 6: 
            case 18: {
                return Ac3Util.parseAc3SyncframeAudioSampleCount((ByteBuffer)buffer);
            }
            case 17: {
                return Ac4Util.parseAc4SyncframeAudioSampleCount((ByteBuffer)buffer);
            }
            case 14: {
                int syncframeOffset = Ac3Util.findTrueHdSyncframeOffset((ByteBuffer)buffer);
                return syncframeOffset == -1 ? 0 : Ac3Util.parseTrueHdSyncframeAudioSampleCount((ByteBuffer)buffer, (int)syncframeOffset) * 16;
            }
            case 20: {
                return OpusUtil.parseOggPacketAudioSampleCount((ByteBuffer)buffer);
            }
        }
        throw new IllegalStateException("Unexpected audio encoding: " + encoding);
    }

    @RequiresApi(value=21)
    private static int writeNonBlockingV21(AudioTrack audioTrack, ByteBuffer buffer, int size) {
        return audioTrack.write(buffer, size, 1);
    }

    @RequiresApi(value=21)
    private int writeNonBlockingWithAvSyncV21(AudioTrack audioTrack, ByteBuffer buffer, int size, long presentationTimeUs) {
        int result;
        int avSyncHeaderBytesRemaining;
        if (Util.SDK_INT >= 26) {
            return audioTrack.write(buffer, size, 1, presentationTimeUs * 1000L);
        }
        if (this.avSyncHeader == null) {
            this.avSyncHeader = ByteBuffer.allocate(16);
            this.avSyncHeader.order(ByteOrder.BIG_ENDIAN);
            this.avSyncHeader.putInt(0x55550001);
        }
        if (this.bytesUntilNextAvSync == 0) {
            this.avSyncHeader.putInt(4, size);
            this.avSyncHeader.putLong(8, presentationTimeUs * 1000L);
            this.avSyncHeader.position(0);
            this.bytesUntilNextAvSync = size;
        }
        if ((avSyncHeaderBytesRemaining = this.avSyncHeader.remaining()) > 0) {
            result = audioTrack.write(this.avSyncHeader, avSyncHeaderBytesRemaining, 1);
            if (result < 0) {
                this.bytesUntilNextAvSync = 0;
                return result;
            }
            if (result < avSyncHeaderBytesRemaining) {
                return 0;
            }
        }
        if ((result = DefaultAudioSink.writeNonBlockingV21(audioTrack, buffer, size)) < 0) {
            this.bytesUntilNextAvSync = 0;
            return result;
        }
        this.bytesUntilNextAvSync -= result;
        return result;
    }

    @RequiresApi(value=21)
    private static void setVolumeInternalV21(AudioTrack audioTrack, float volume) {
        audioTrack.setVolume(volume);
    }

    private static void setVolumeInternalV3(AudioTrack audioTrack, float volume) {
        audioTrack.setStereoVolume(volume, volume);
    }

    private void playPendingData() {
        if (!this.stoppedAudioTrack) {
            this.stoppedAudioTrack = true;
            this.audioTrackPositionTracker.handleEndOfStream(this.getWrittenFrames());
            this.audioTrack.stop();
            this.bytesUntilNextAvSync = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseAudioTrackAsync(AudioTrack audioTrack, ConditionVariable releasedConditionVariable) {
        releasedConditionVariable.close();
        Object object = releaseExecutorLock;
        synchronized (object) {
            if (releaseExecutor == null) {
                releaseExecutor = Util.newSingleThreadExecutor((String)"ExoPlayer:AudioTrackReleaseThread");
            }
            ++pendingReleaseCount;
            releaseExecutor.execute(() -> {
                try {
                    audioTrack.flush();
                    audioTrack.release();
                }
                finally {
                    releasedConditionVariable.open();
                    Object object = releaseExecutorLock;
                    synchronized (object) {
                        if (--pendingReleaseCount == 0) {
                            releaseExecutor.shutdown();
                            releaseExecutor = null;
                        }
                    }
                }
            });
        }
    }

    @RequiresApi(value=21)
    private static AudioFormat getAudioFormat(int sampleRate, int channelConfig, int encoding) {
        return new AudioFormat.Builder().setSampleRate(sampleRate).setChannelMask(channelConfig).setEncoding(encoding).build();
    }

    private static int getAudioTrackMinBufferSize(int sampleRateInHz, int channelConfig, int encoding) {
        int minBufferSize = AudioTrack.getMinBufferSize((int)sampleRateInHz, (int)channelConfig, (int)encoding);
        Assertions.checkState((minBufferSize != -2 ? 1 : 0) != 0);
        return minBufferSize;
    }

    public static final class Builder {
        @Nullable
        private final Context context;
        private AudioCapabilities audioCapabilities;
        @Nullable
        private com.google.android.exoplayer2.audio.AudioProcessorChain audioProcessorChain;
        private boolean enableFloatOutput;
        private boolean enableAudioTrackPlaybackParams;
        private int offloadMode;
        AudioTrackBufferSizeProvider audioTrackBufferSizeProvider;
        @Nullable
        ExoPlayer.AudioOffloadListener audioOffloadListener;

        @Deprecated
        public Builder() {
            this.context = null;
            this.audioCapabilities = AudioCapabilities.DEFAULT_AUDIO_CAPABILITIES;
            this.offloadMode = 0;
            this.audioTrackBufferSizeProvider = AudioTrackBufferSizeProvider.DEFAULT;
        }

        public Builder(Context context) {
            this.context = context;
            this.audioCapabilities = AudioCapabilities.DEFAULT_AUDIO_CAPABILITIES;
            this.offloadMode = 0;
            this.audioTrackBufferSizeProvider = AudioTrackBufferSizeProvider.DEFAULT;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder setAudioCapabilities(AudioCapabilities audioCapabilities) {
            Assertions.checkNotNull((Object)audioCapabilities);
            this.audioCapabilities = audioCapabilities;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAudioProcessors(AudioProcessor[] audioProcessors) {
            Assertions.checkNotNull((Object)audioProcessors);
            return this.setAudioProcessorChain(new DefaultAudioProcessorChain(audioProcessors));
        }

        @CanIgnoreReturnValue
        public Builder setAudioProcessorChain(com.google.android.exoplayer2.audio.AudioProcessorChain audioProcessorChain) {
            Assertions.checkNotNull((Object)audioProcessorChain);
            this.audioProcessorChain = audioProcessorChain;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setEnableFloatOutput(boolean enableFloatOutput) {
            this.enableFloatOutput = enableFloatOutput;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setEnableAudioTrackPlaybackParams(boolean enableAudioTrackPlaybackParams) {
            this.enableAudioTrackPlaybackParams = enableAudioTrackPlaybackParams;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setOffloadMode(int offloadMode) {
            this.offloadMode = offloadMode;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAudioTrackBufferSizeProvider(AudioTrackBufferSizeProvider audioTrackBufferSizeProvider) {
            this.audioTrackBufferSizeProvider = audioTrackBufferSizeProvider;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setExperimentalAudioOffloadListener(@Nullable ExoPlayer.AudioOffloadListener audioOffloadListener) {
            this.audioOffloadListener = audioOffloadListener;
            return this;
        }

        public DefaultAudioSink build() {
            if (this.audioProcessorChain == null) {
                this.audioProcessorChain = new DefaultAudioProcessorChain(new AudioProcessor[0]);
            }
            return new DefaultAudioSink(this);
        }
    }

    public static interface AudioTrackBufferSizeProvider {
        public static final AudioTrackBufferSizeProvider DEFAULT = new DefaultAudioTrackBufferSizeProvider.Builder().build();

        public int getBufferSizeInBytes(int var1, int var2, int var3, int var4, int var5, int var6, double var7);
    }

    private final class PositionTrackerListener
    implements AudioTrackPositionTracker.Listener {
        private PositionTrackerListener() {
        }

        @Override
        public void onPositionFramesMismatch(long audioTimestampPositionFrames, long audioTimestampSystemTimeUs, long systemTimeUs, long playbackPositionUs) {
            String message = "Spurious audio timestamp (frame position mismatch): " + audioTimestampPositionFrames + ", " + audioTimestampSystemTimeUs + ", " + systemTimeUs + ", " + playbackPositionUs + ", " + DefaultAudioSink.this.getSubmittedFrames() + ", " + DefaultAudioSink.this.getWrittenFrames();
            if (failOnSpuriousAudioTimestamp) {
                throw new InvalidAudioTrackTimestampException(message);
            }
            Log.w((String)DefaultAudioSink.TAG, (String)message);
        }

        @Override
        public void onSystemTimeUsMismatch(long audioTimestampPositionFrames, long audioTimestampSystemTimeUs, long systemTimeUs, long playbackPositionUs) {
            String message = "Spurious audio timestamp (system clock mismatch): " + audioTimestampPositionFrames + ", " + audioTimestampSystemTimeUs + ", " + systemTimeUs + ", " + playbackPositionUs + ", " + DefaultAudioSink.this.getSubmittedFrames() + ", " + DefaultAudioSink.this.getWrittenFrames();
            if (failOnSpuriousAudioTimestamp) {
                throw new InvalidAudioTrackTimestampException(message);
            }
            Log.w((String)DefaultAudioSink.TAG, (String)message);
        }

        @Override
        public void onInvalidLatency(long latencyUs) {
            Log.w((String)DefaultAudioSink.TAG, (String)("Ignoring impossibly large audio latency: " + latencyUs));
        }

        @Override
        public void onPositionAdvancing(long playoutStartSystemTimeMs) {
            if (DefaultAudioSink.this.listener != null) {
                DefaultAudioSink.this.listener.onPositionAdvancing(playoutStartSystemTimeMs);
            }
        }

        @Override
        public void onUnderrun(int bufferSize, long bufferSizeMs) {
            if (DefaultAudioSink.this.listener != null) {
                long elapsedSinceLastFeedMs = SystemClock.elapsedRealtime() - DefaultAudioSink.this.lastFeedElapsedRealtimeMs;
                DefaultAudioSink.this.listener.onUnderrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs);
            }
        }
    }

    private static final class MediaPositionParameters {
        public final PlaybackParameters playbackParameters;
        public final long mediaTimeUs;
        public final long audioTrackPositionUs;

        private MediaPositionParameters(PlaybackParameters playbackParameters, long mediaTimeUs, long audioTrackPositionUs) {
            this.playbackParameters = playbackParameters;
            this.mediaTimeUs = mediaTimeUs;
            this.audioTrackPositionUs = audioTrackPositionUs;
        }
    }

    private static final class PendingExceptionHolder<T extends Exception> {
        private final long throwDelayMs;
        @Nullable
        private T pendingException;
        private long throwDeadlineMs;

        public PendingExceptionHolder(long throwDelayMs) {
            this.throwDelayMs = throwDelayMs;
        }

        public void throwExceptionIfDeadlineIsReached(T exception) throws T {
            long nowMs = SystemClock.elapsedRealtime();
            if (this.pendingException == null) {
                this.pendingException = exception;
                this.throwDeadlineMs = nowMs + this.throwDelayMs;
            }
            if (nowMs >= this.throwDeadlineMs) {
                if (this.pendingException != exception) {
                    ((Throwable)this.pendingException).addSuppressed((Throwable)exception);
                }
                T pendingException = this.pendingException;
                this.clear();
                throw pendingException;
            }
        }

        public void clear() {
            this.pendingException = null;
        }
    }

    private static final class Configuration {
        public final Format inputFormat;
        public final int inputPcmFrameSize;
        public final int outputMode;
        public final int outputPcmFrameSize;
        public final int outputSampleRate;
        public final int outputChannelConfig;
        public final int outputEncoding;
        public final int bufferSize;
        public final AudioProcessingPipeline audioProcessingPipeline;
        public final boolean enableAudioTrackPlaybackParams;

        public Configuration(Format inputFormat, int inputPcmFrameSize, int outputMode, int outputPcmFrameSize, int outputSampleRate, int outputChannelConfig, int outputEncoding, int bufferSize, AudioProcessingPipeline audioProcessingPipeline, boolean enableAudioTrackPlaybackParams) {
            this.inputFormat = inputFormat;
            this.inputPcmFrameSize = inputPcmFrameSize;
            this.outputMode = outputMode;
            this.outputPcmFrameSize = outputPcmFrameSize;
            this.outputSampleRate = outputSampleRate;
            this.outputChannelConfig = outputChannelConfig;
            this.outputEncoding = outputEncoding;
            this.bufferSize = bufferSize;
            this.audioProcessingPipeline = audioProcessingPipeline;
            this.enableAudioTrackPlaybackParams = enableAudioTrackPlaybackParams;
        }

        public Configuration copyWithBufferSize(int bufferSize) {
            return new Configuration(this.inputFormat, this.inputPcmFrameSize, this.outputMode, this.outputPcmFrameSize, this.outputSampleRate, this.outputChannelConfig, this.outputEncoding, bufferSize, this.audioProcessingPipeline, this.enableAudioTrackPlaybackParams);
        }

        public boolean canReuseAudioTrack(Configuration newConfiguration) {
            return newConfiguration.outputMode == this.outputMode && newConfiguration.outputEncoding == this.outputEncoding && newConfiguration.outputSampleRate == this.outputSampleRate && newConfiguration.outputChannelConfig == this.outputChannelConfig && newConfiguration.outputPcmFrameSize == this.outputPcmFrameSize && newConfiguration.enableAudioTrackPlaybackParams == this.enableAudioTrackPlaybackParams;
        }

        public long inputFramesToDurationUs(long frameCount) {
            return Util.sampleCountToDurationUs((long)frameCount, (int)this.inputFormat.sampleRate);
        }

        public long framesToDurationUs(long frameCount) {
            return Util.sampleCountToDurationUs((long)frameCount, (int)this.outputSampleRate);
        }

        public AudioTrack buildAudioTrack(boolean tunneling, AudioAttributes audioAttributes, int audioSessionId) throws AudioSink.InitializationException {
            AudioTrack audioTrack;
            try {
                audioTrack = this.createAudioTrack(tunneling, audioAttributes, audioSessionId);
            }
            catch (IllegalArgumentException | UnsupportedOperationException e) {
                throw new AudioSink.InitializationException(0, this.outputSampleRate, this.outputChannelConfig, this.bufferSize, this.inputFormat, this.outputModeIsOffload(), e);
            }
            int state = audioTrack.getState();
            if (state != 1) {
                try {
                    audioTrack.release();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new AudioSink.InitializationException(state, this.outputSampleRate, this.outputChannelConfig, this.bufferSize, this.inputFormat, this.outputModeIsOffload(), null);
            }
            return audioTrack;
        }

        private AudioTrack createAudioTrack(boolean tunneling, AudioAttributes audioAttributes, int audioSessionId) {
            if (Util.SDK_INT >= 29) {
                return this.createAudioTrackV29(tunneling, audioAttributes, audioSessionId);
            }
            if (Util.SDK_INT >= 21) {
                return this.createAudioTrackV21(tunneling, audioAttributes, audioSessionId);
            }
            return this.createAudioTrackV9(audioAttributes, audioSessionId);
        }

        @RequiresApi(value=29)
        private AudioTrack createAudioTrackV29(boolean tunneling, AudioAttributes audioAttributes, int audioSessionId) {
            AudioFormat audioFormat = DefaultAudioSink.getAudioFormat(this.outputSampleRate, this.outputChannelConfig, this.outputEncoding);
            android.media.AudioAttributes audioTrackAttributes = Configuration.getAudioTrackAttributesV21(audioAttributes, tunneling);
            return new AudioTrack.Builder().setAudioAttributes(audioTrackAttributes).setAudioFormat(audioFormat).setTransferMode(1).setBufferSizeInBytes(this.bufferSize).setSessionId(audioSessionId).setOffloadedPlayback(this.outputMode == 1).build();
        }

        @RequiresApi(value=21)
        private AudioTrack createAudioTrackV21(boolean tunneling, AudioAttributes audioAttributes, int audioSessionId) {
            return new AudioTrack(Configuration.getAudioTrackAttributesV21(audioAttributes, tunneling), DefaultAudioSink.getAudioFormat(this.outputSampleRate, this.outputChannelConfig, this.outputEncoding), this.bufferSize, 1, audioSessionId);
        }

        private AudioTrack createAudioTrackV9(AudioAttributes audioAttributes, int audioSessionId) {
            int streamType = Util.getStreamTypeForAudioUsage((int)audioAttributes.usage);
            if (audioSessionId == 0) {
                return new AudioTrack(streamType, this.outputSampleRate, this.outputChannelConfig, this.outputEncoding, this.bufferSize, 1);
            }
            return new AudioTrack(streamType, this.outputSampleRate, this.outputChannelConfig, this.outputEncoding, this.bufferSize, 1, audioSessionId);
        }

        @RequiresApi(value=21)
        private static android.media.AudioAttributes getAudioTrackAttributesV21(AudioAttributes audioAttributes, boolean tunneling) {
            if (tunneling) {
                return Configuration.getAudioTrackTunnelingAttributesV21();
            }
            return audioAttributes.getAudioAttributesV21().audioAttributes;
        }

        @RequiresApi(value=21)
        private static android.media.AudioAttributes getAudioTrackTunnelingAttributesV21() {
            return new AudioAttributes.Builder().setContentType(3).setFlags(16).setUsage(1).build();
        }

        public boolean outputModeIsOffload() {
            return this.outputMode == 1;
        }
    }

    @RequiresApi(value=31)
    private static final class Api31 {
        private Api31() {
        }

        @DoNotInline
        public static void setLogSessionIdOnAudioTrack(AudioTrack audioTrack, PlayerId playerId) {
            LogSessionId logSessionId = playerId.getLogSessionId();
            if (!logSessionId.equals((Object)LogSessionId.LOG_SESSION_ID_NONE)) {
                audioTrack.setLogSessionId(logSessionId);
            }
        }
    }

    @RequiresApi(value=23)
    private static final class AudioDeviceInfoApi23 {
        public final AudioDeviceInfo audioDeviceInfo;

        public AudioDeviceInfoApi23(AudioDeviceInfo audioDeviceInfo) {
            this.audioDeviceInfo = audioDeviceInfo;
        }
    }

    @RequiresApi(value=23)
    private static final class Api23 {
        private Api23() {
        }

        @DoNotInline
        public static void setPreferredDeviceOnAudioTrack(AudioTrack audioTrack, @Nullable AudioDeviceInfoApi23 audioDeviceInfo) {
            audioTrack.setPreferredDevice(audioDeviceInfo == null ? null : audioDeviceInfo.audioDeviceInfo);
        }
    }

    @RequiresApi(value=29)
    private final class StreamEventCallbackV29 {
        private final Handler handler = new Handler(Looper.myLooper());
        private final AudioTrack.StreamEventCallback callback;

        public StreamEventCallbackV29() {
            this.callback = new AudioTrack.StreamEventCallback(){

                public void onDataRequest(AudioTrack track, int size) {
                    if (!track.equals(DefaultAudioSink.this.audioTrack)) {
                        return;
                    }
                    if (DefaultAudioSink.this.listener != null && DefaultAudioSink.this.playing) {
                        DefaultAudioSink.this.listener.onOffloadBufferEmptying();
                    }
                }

                public void onTearDown(AudioTrack track) {
                    if (!track.equals(DefaultAudioSink.this.audioTrack)) {
                        return;
                    }
                    if (DefaultAudioSink.this.listener != null && DefaultAudioSink.this.playing) {
                        DefaultAudioSink.this.listener.onOffloadBufferEmptying();
                    }
                }
            };
        }

        public void register(AudioTrack audioTrack) {
            audioTrack.registerStreamEventCallback(arg_0 -> ((Handler)this.handler).post(arg_0), this.callback);
        }

        public void unregister(AudioTrack audioTrack) {
            audioTrack.unregisterStreamEventCallback(this.callback);
            this.handler.removeCallbacksAndMessages(null);
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface OutputMode {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface OffloadMode {
    }

    public static class DefaultAudioProcessorChain
    implements AudioProcessorChain {
        private final AudioProcessor[] audioProcessors;
        private final SilenceSkippingAudioProcessor silenceSkippingAudioProcessor;
        private final SonicAudioProcessor sonicAudioProcessor;

        public DefaultAudioProcessorChain(AudioProcessor ... audioProcessors) {
            this(audioProcessors, new SilenceSkippingAudioProcessor(), new SonicAudioProcessor());
        }

        public DefaultAudioProcessorChain(AudioProcessor[] audioProcessors, SilenceSkippingAudioProcessor silenceSkippingAudioProcessor, SonicAudioProcessor sonicAudioProcessor) {
            this.audioProcessors = new AudioProcessor[audioProcessors.length + 2];
            System.arraycopy(audioProcessors, 0, this.audioProcessors, 0, audioProcessors.length);
            this.silenceSkippingAudioProcessor = silenceSkippingAudioProcessor;
            this.sonicAudioProcessor = sonicAudioProcessor;
            this.audioProcessors[audioProcessors.length] = silenceSkippingAudioProcessor;
            this.audioProcessors[audioProcessors.length + 1] = sonicAudioProcessor;
        }

        public AudioProcessor[] getAudioProcessors() {
            return this.audioProcessors;
        }

        public PlaybackParameters applyPlaybackParameters(PlaybackParameters playbackParameters) {
            this.sonicAudioProcessor.setSpeed(playbackParameters.speed);
            this.sonicAudioProcessor.setPitch(playbackParameters.pitch);
            return playbackParameters;
        }

        public boolean applySkipSilenceEnabled(boolean skipSilenceEnabled) {
            this.silenceSkippingAudioProcessor.setEnabled(skipSilenceEnabled);
            return skipSilenceEnabled;
        }

        public long getMediaDuration(long playoutDuration) {
            return this.sonicAudioProcessor.getMediaDuration(playoutDuration);
        }

        public long getSkippedOutputFrameCount() {
            return this.silenceSkippingAudioProcessor.getSkippedFrames();
        }
    }

    @Deprecated
    public static interface AudioProcessorChain
    extends com.google.android.exoplayer2.audio.AudioProcessorChain {
    }

    public static final class InvalidAudioTrackTimestampException
    extends RuntimeException {
        private InvalidAudioTrackTimestampException(String message) {
            super(message);
        }
    }
}

