/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioDeviceInfo;
import android.media.MediaCrypto;
import android.media.MediaFormat;
import android.os.Handler;
import androidx.annotation.CallSuper;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AudioCapabilities;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.audio.AudioSink;
import com.google.android.exoplayer2.audio.AuxEffectInfo;
import com.google.android.exoplayer2.audio.DefaultAudioSink;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.decoder.DecoderReuseEvaluation;
import com.google.android.exoplayer2.mediacodec.MediaCodecAdapter;
import com.google.android.exoplayer2.mediacodec.MediaCodecInfo;
import com.google.android.exoplayer2.mediacodec.MediaCodecRenderer;
import com.google.android.exoplayer2.mediacodec.MediaCodecSelector;
import com.google.android.exoplayer2.mediacodec.MediaCodecUtil;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MediaClock;
import com.google.android.exoplayer2.util.MediaFormatUtil;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.nio.ByteBuffer;
import java.util.List;

@Deprecated
public class MediaCodecAudioRenderer
extends MediaCodecRenderer
implements MediaClock {
    private static final String TAG = "MediaCodecAudioRenderer";
    private static final String VIVO_BITS_PER_SAMPLE_KEY = "v-bits-per-sample";
    private final Context context;
    private final AudioRendererEventListener.EventDispatcher eventDispatcher;
    private final AudioSink audioSink;
    private int codecMaxInputSize;
    private boolean codecNeedsDiscardChannelsWorkaround;
    @Nullable
    private Format inputFormat;
    @Nullable
    private Format decryptOnlyCodecFormat;
    private long currentPositionUs;
    private boolean allowFirstBufferPositionDiscontinuity;
    private boolean allowPositionDiscontinuity;
    private boolean audioSinkNeedsReset;
    private boolean experimentalKeepAudioTrackOnSeek;
    @Nullable
    private Renderer.WakeupListener wakeupListener;

    public MediaCodecAudioRenderer(Context context, MediaCodecSelector mediaCodecSelector) {
        this(context, mediaCodecSelector, null, null);
    }

    public MediaCodecAudioRenderer(Context context, MediaCodecSelector mediaCodecSelector, @Nullable Handler eventHandler, @Nullable AudioRendererEventListener eventListener) {
        this(context, mediaCodecSelector, eventHandler, eventListener, AudioCapabilities.DEFAULT_AUDIO_CAPABILITIES, new AudioProcessor[0]);
    }

    public MediaCodecAudioRenderer(Context context, MediaCodecSelector mediaCodecSelector, @Nullable Handler eventHandler, @Nullable AudioRendererEventListener eventListener, AudioCapabilities audioCapabilities, AudioProcessor ... audioProcessors) {
        this(context, mediaCodecSelector, eventHandler, eventListener, new DefaultAudioSink.Builder().setAudioCapabilities((AudioCapabilities)MoreObjects.firstNonNull((Object)audioCapabilities, (Object)AudioCapabilities.DEFAULT_AUDIO_CAPABILITIES)).setAudioProcessors(audioProcessors).build());
    }

    public MediaCodecAudioRenderer(Context context, MediaCodecSelector mediaCodecSelector, @Nullable Handler eventHandler, @Nullable AudioRendererEventListener eventListener, AudioSink audioSink) {
        this(context, MediaCodecAdapter.Factory.DEFAULT, mediaCodecSelector, false, eventHandler, eventListener, audioSink);
    }

    public MediaCodecAudioRenderer(Context context, MediaCodecSelector mediaCodecSelector, boolean enableDecoderFallback, @Nullable Handler eventHandler, @Nullable AudioRendererEventListener eventListener, AudioSink audioSink) {
        this(context, MediaCodecAdapter.Factory.DEFAULT, mediaCodecSelector, enableDecoderFallback, eventHandler, eventListener, audioSink);
    }

    public MediaCodecAudioRenderer(Context context, MediaCodecAdapter.Factory codecAdapterFactory, MediaCodecSelector mediaCodecSelector, boolean enableDecoderFallback, @Nullable Handler eventHandler, @Nullable AudioRendererEventListener eventListener, AudioSink audioSink) {
        super(1, codecAdapterFactory, mediaCodecSelector, enableDecoderFallback, 44100.0f);
        this.context = context = context.getApplicationContext();
        this.audioSink = audioSink;
        this.eventDispatcher = new AudioRendererEventListener.EventDispatcher(eventHandler, eventListener);
        audioSink.setListener(new AudioSinkListener());
    }

    @Override
    public String getName() {
        return TAG;
    }

    public void experimentalSetEnableKeepAudioTrackOnSeek(boolean enableKeepAudioTrackOnSeek) {
        this.experimentalKeepAudioTrackOnSeek = enableKeepAudioTrackOnSeek;
    }

    @Override
    protected int supportsFormat(MediaCodecSelector mediaCodecSelector, Format format) throws MediaCodecUtil.DecoderQueryException {
        if (!MimeTypes.isAudio((String)format.sampleMimeType)) {
            return RendererCapabilities.create(0);
        }
        int tunnelingSupport = Util.SDK_INT >= 21 ? 32 : 0;
        boolean formatHasDrm = format.cryptoType != 0;
        boolean supportsFormatDrm = MediaCodecAudioRenderer.supportsFormatDrm(format);
        if (supportsFormatDrm && this.audioSink.supportsFormat(format) && (!formatHasDrm || MediaCodecUtil.getDecryptOnlyDecoderInfo() != null)) {
            return RendererCapabilities.create(4, 8, tunnelingSupport);
        }
        if ("audio/raw".equals(format.sampleMimeType) && !this.audioSink.supportsFormat(format)) {
            return RendererCapabilities.create(1);
        }
        if (!this.audioSink.supportsFormat(Util.getPcmFormat((int)2, (int)format.channelCount, (int)format.sampleRate))) {
            return RendererCapabilities.create(1);
        }
        List<MediaCodecInfo> decoderInfos = MediaCodecAudioRenderer.getDecoderInfos(mediaCodecSelector, format, false, this.audioSink);
        if (decoderInfos.isEmpty()) {
            return RendererCapabilities.create(1);
        }
        if (!supportsFormatDrm) {
            return RendererCapabilities.create(2);
        }
        MediaCodecInfo decoderInfo = decoderInfos.get(0);
        boolean isFormatSupported = decoderInfo.isFormatSupported(format);
        boolean isPreferredDecoder = true;
        if (!isFormatSupported) {
            for (int i = 1; i < decoderInfos.size(); ++i) {
                MediaCodecInfo otherDecoderInfo = decoderInfos.get(i);
                if (!otherDecoderInfo.isFormatSupported(format)) continue;
                decoderInfo = otherDecoderInfo;
                isFormatSupported = true;
                isPreferredDecoder = false;
                break;
            }
        }
        int formatSupport = isFormatSupported ? 4 : 3;
        int adaptiveSupport = isFormatSupported && decoderInfo.isSeamlessAdaptationSupported(format) ? 16 : 8;
        int hardwareAccelerationSupport = decoderInfo.hardwareAccelerated ? 64 : 0;
        int decoderSupport = isPreferredDecoder ? 128 : 0;
        return RendererCapabilities.create(formatSupport, adaptiveSupport, tunnelingSupport, hardwareAccelerationSupport, decoderSupport);
    }

    @Override
    protected List<MediaCodecInfo> getDecoderInfos(MediaCodecSelector mediaCodecSelector, Format format, boolean requiresSecureDecoder) throws MediaCodecUtil.DecoderQueryException {
        return MediaCodecUtil.getDecoderInfosSortedByFormatSupport(MediaCodecAudioRenderer.getDecoderInfos(mediaCodecSelector, format, requiresSecureDecoder, this.audioSink), format);
    }

    private static List<MediaCodecInfo> getDecoderInfos(MediaCodecSelector mediaCodecSelector, Format format, boolean requiresSecureDecoder, AudioSink audioSink) throws MediaCodecUtil.DecoderQueryException {
        MediaCodecInfo codecInfo;
        String mimeType = format.sampleMimeType;
        if (mimeType == null) {
            return ImmutableList.of();
        }
        if (audioSink.supportsFormat(format) && (codecInfo = MediaCodecUtil.getDecryptOnlyDecoderInfo()) != null) {
            return ImmutableList.of((Object)codecInfo);
        }
        return MediaCodecUtil.getDecoderInfosSoftMatch(mediaCodecSelector, format, requiresSecureDecoder, false);
    }

    @Override
    protected boolean shouldUseBypass(Format format) {
        return this.audioSink.supportsFormat(format);
    }

    @Override
    protected MediaCodecAdapter.Configuration getMediaCodecConfiguration(MediaCodecInfo codecInfo, Format format, @Nullable MediaCrypto crypto, float codecOperatingRate) {
        this.codecMaxInputSize = this.getCodecMaxInputSize(codecInfo, format, this.getStreamFormats());
        this.codecNeedsDiscardChannelsWorkaround = MediaCodecAudioRenderer.codecNeedsDiscardChannelsWorkaround(codecInfo.name);
        MediaFormat mediaFormat = this.getMediaFormat(format, codecInfo.codecMimeType, this.codecMaxInputSize, codecOperatingRate);
        boolean decryptOnlyCodecEnabled = "audio/raw".equals(codecInfo.mimeType) && !"audio/raw".equals(format.sampleMimeType);
        this.decryptOnlyCodecFormat = decryptOnlyCodecEnabled ? format : null;
        return MediaCodecAdapter.Configuration.createForAudioDecoding(codecInfo, mediaFormat, format, crypto);
    }

    @Override
    protected DecoderReuseEvaluation canReuseCodec(MediaCodecInfo codecInfo, Format oldFormat, Format newFormat) {
        DecoderReuseEvaluation evaluation = codecInfo.canReuseCodec(oldFormat, newFormat);
        int discardReasons = evaluation.discardReasons;
        if (this.isBypassPossible(newFormat)) {
            discardReasons |= 0x8000;
        }
        if (this.getCodecMaxInputSize(codecInfo, newFormat) > this.codecMaxInputSize) {
            discardReasons |= 0x40;
        }
        return new DecoderReuseEvaluation(codecInfo.name, oldFormat, newFormat, discardReasons != 0 ? 0 : evaluation.result, discardReasons);
    }

    @Override
    @Nullable
    public MediaClock getMediaClock() {
        return this;
    }

    @Override
    protected float getCodecOperatingRateV23(float targetPlaybackSpeed, Format format, Format[] streamFormats) {
        int maxSampleRate = -1;
        for (Format streamFormat : streamFormats) {
            int streamSampleRate = streamFormat.sampleRate;
            if (streamSampleRate == -1) continue;
            maxSampleRate = Math.max(maxSampleRate, streamSampleRate);
        }
        return maxSampleRate == -1 ? -1.0f : (float)maxSampleRate * targetPlaybackSpeed;
    }

    @Override
    protected void onCodecInitialized(String name, MediaCodecAdapter.Configuration configuration, long initializedTimestampMs, long initializationDurationMs) {
        this.eventDispatcher.decoderInitialized(name, initializedTimestampMs, initializationDurationMs);
    }

    @Override
    protected void onCodecReleased(String name) {
        this.eventDispatcher.decoderReleased(name);
    }

    @Override
    protected void onCodecError(Exception codecError) {
        Log.e((String)TAG, (String)"Audio codec error", (Throwable)codecError);
        this.eventDispatcher.audioCodecError(codecError);
    }

    @Override
    @Nullable
    protected DecoderReuseEvaluation onInputFormatChanged(FormatHolder formatHolder) throws ExoPlaybackException {
        this.inputFormat = (Format)Assertions.checkNotNull((Object)formatHolder.format);
        DecoderReuseEvaluation evaluation = super.onInputFormatChanged(formatHolder);
        this.eventDispatcher.inputFormatChanged(this.inputFormat, evaluation);
        return evaluation;
    }

    @Override
    protected void onOutputFormatChanged(Format format, @Nullable MediaFormat mediaFormat) throws ExoPlaybackException {
        Format audioSinkInputFormat;
        int[] channelMap = null;
        if (this.decryptOnlyCodecFormat != null) {
            audioSinkInputFormat = this.decryptOnlyCodecFormat;
        } else if (this.getCodec() == null) {
            audioSinkInputFormat = format;
        } else {
            int pcmEncoding = "audio/raw".equals(format.sampleMimeType) ? format.pcmEncoding : (Util.SDK_INT >= 24 && mediaFormat.containsKey("pcm-encoding") ? mediaFormat.getInteger("pcm-encoding") : (mediaFormat.containsKey(VIVO_BITS_PER_SAMPLE_KEY) ? Util.getPcmEncoding((int)mediaFormat.getInteger(VIVO_BITS_PER_SAMPLE_KEY)) : 2));
            audioSinkInputFormat = new Format.Builder().setSampleMimeType("audio/raw").setPcmEncoding(pcmEncoding).setEncoderDelay(format.encoderDelay).setEncoderPadding(format.encoderPadding).setChannelCount(mediaFormat.getInteger("channel-count")).setSampleRate(mediaFormat.getInteger("sample-rate")).build();
            if (this.codecNeedsDiscardChannelsWorkaround && audioSinkInputFormat.channelCount == 6 && format.channelCount < 6) {
                channelMap = new int[format.channelCount];
                for (int i = 0; i < format.channelCount; ++i) {
                    channelMap[i] = i;
                }
            }
        }
        try {
            this.audioSink.configure(audioSinkInputFormat, 0, channelMap);
        }
        catch (AudioSink.ConfigurationException e) {
            throw this.createRendererException(e, e.format, 5001);
        }
    }

    @CallSuper
    protected void onPositionDiscontinuity() {
        this.allowPositionDiscontinuity = true;
    }

    @Override
    protected void onEnabled(boolean joining, boolean mayRenderStartOfStream) throws ExoPlaybackException {
        super.onEnabled(joining, mayRenderStartOfStream);
        this.eventDispatcher.enabled(this.decoderCounters);
        if (this.getConfiguration().tunneling) {
            this.audioSink.enableTunnelingV21();
        } else {
            this.audioSink.disableTunneling();
        }
        this.audioSink.setPlayerId(this.getPlayerId());
    }

    @Override
    protected void onPositionReset(long positionUs, boolean joining) throws ExoPlaybackException {
        super.onPositionReset(positionUs, joining);
        if (this.experimentalKeepAudioTrackOnSeek) {
            this.audioSink.experimentalFlushWithoutAudioTrackRelease();
        } else {
            this.audioSink.flush();
        }
        this.currentPositionUs = positionUs;
        this.allowFirstBufferPositionDiscontinuity = true;
        this.allowPositionDiscontinuity = true;
    }

    @Override
    protected void onStarted() {
        super.onStarted();
        this.audioSink.play();
    }

    @Override
    protected void onStopped() {
        this.updateCurrentPosition();
        this.audioSink.pause();
        super.onStopped();
    }

    @Override
    protected void onDisabled() {
        this.audioSinkNeedsReset = true;
        this.inputFormat = null;
        try {
            this.audioSink.flush();
        }
        finally {
            try {
                super.onDisabled();
            }
            finally {
                this.eventDispatcher.disabled(this.decoderCounters);
            }
        }
    }

    @Override
    protected void onReset() {
        try {
            super.onReset();
        }
        finally {
            if (this.audioSinkNeedsReset) {
                this.audioSinkNeedsReset = false;
                this.audioSink.reset();
            }
        }
    }

    @Override
    protected void onRelease() {
        this.audioSink.release();
    }

    @Override
    public boolean isEnded() {
        return super.isEnded() && this.audioSink.isEnded();
    }

    @Override
    public boolean isReady() {
        return this.audioSink.hasPendingData() || super.isReady();
    }

    @Override
    public long getPositionUs() {
        if (this.getState() == 2) {
            this.updateCurrentPosition();
        }
        return this.currentPositionUs;
    }

    @Override
    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        this.audioSink.setPlaybackParameters(playbackParameters);
    }

    @Override
    public PlaybackParameters getPlaybackParameters() {
        return this.audioSink.getPlaybackParameters();
    }

    @Override
    protected void onQueueInputBuffer(DecoderInputBuffer buffer) {
        if (this.allowFirstBufferPositionDiscontinuity && !buffer.isDecodeOnly()) {
            if (Math.abs(buffer.timeUs - this.currentPositionUs) > 500000L) {
                this.currentPositionUs = buffer.timeUs;
            }
            this.allowFirstBufferPositionDiscontinuity = false;
        }
    }

    @Override
    protected void onProcessedStreamChange() {
        super.onProcessedStreamChange();
        this.audioSink.handleDiscontinuity();
    }

    @Override
    protected boolean processOutputBuffer(long positionUs, long elapsedRealtimeUs, @Nullable MediaCodecAdapter codec, @Nullable ByteBuffer buffer, int bufferIndex, int bufferFlags, int sampleCount, long bufferPresentationTimeUs, boolean isDecodeOnlyBuffer, boolean isLastBuffer, Format format) throws ExoPlaybackException {
        boolean fullyConsumed;
        Assertions.checkNotNull((Object)buffer);
        if (this.decryptOnlyCodecFormat != null && (bufferFlags & 2) != 0) {
            ((MediaCodecAdapter)Assertions.checkNotNull((Object)codec)).releaseOutputBuffer(bufferIndex, false);
            return true;
        }
        if (isDecodeOnlyBuffer) {
            if (codec != null) {
                codec.releaseOutputBuffer(bufferIndex, false);
            }
            this.decoderCounters.skippedOutputBufferCount += sampleCount;
            this.audioSink.handleDiscontinuity();
            return true;
        }
        try {
            fullyConsumed = this.audioSink.handleBuffer(buffer, bufferPresentationTimeUs, sampleCount);
        }
        catch (AudioSink.InitializationException e) {
            throw this.createRendererException(e, this.inputFormat, e.isRecoverable, 5001);
        }
        catch (AudioSink.WriteException e) {
            throw this.createRendererException(e, format, e.isRecoverable, 5002);
        }
        if (fullyConsumed) {
            if (codec != null) {
                codec.releaseOutputBuffer(bufferIndex, false);
            }
            this.decoderCounters.renderedOutputBufferCount += sampleCount;
            return true;
        }
        return false;
    }

    @Override
    protected void renderToEndOfStream() throws ExoPlaybackException {
        try {
            this.audioSink.playToEndOfStream();
        }
        catch (AudioSink.WriteException e) {
            throw this.createRendererException(e, e.format, e.isRecoverable, 5002);
        }
    }

    @Override
    protected void onOutputStreamOffsetUsChanged(long outputStreamOffsetUs) {
        this.audioSink.setOutputStreamOffsetUs(outputStreamOffsetUs);
    }

    @Override
    public void handleMessage(int messageType, @Nullable Object message) throws ExoPlaybackException {
        switch (messageType) {
            case 2: {
                this.audioSink.setVolume(((Float)message).floatValue());
                break;
            }
            case 3: {
                AudioAttributes audioAttributes = (AudioAttributes)message;
                this.audioSink.setAudioAttributes(audioAttributes);
                break;
            }
            case 6: {
                AuxEffectInfo auxEffectInfo = (AuxEffectInfo)message;
                this.audioSink.setAuxEffectInfo(auxEffectInfo);
                break;
            }
            case 12: {
                if (Util.SDK_INT < 23) break;
                Api23.setAudioSinkPreferredDevice(this.audioSink, message);
                break;
            }
            case 9: {
                this.audioSink.setSkipSilenceEnabled((Boolean)message);
                break;
            }
            case 10: {
                this.audioSink.setAudioSessionId((Integer)message);
                break;
            }
            case 11: {
                this.wakeupListener = (Renderer.WakeupListener)message;
                break;
            }
            default: {
                super.handleMessage(messageType, message);
            }
        }
    }

    protected int getCodecMaxInputSize(MediaCodecInfo codecInfo, Format format, Format[] streamFormats) {
        int maxInputSize = this.getCodecMaxInputSize(codecInfo, format);
        if (streamFormats.length == 1) {
            return maxInputSize;
        }
        for (Format streamFormat : streamFormats) {
            if (codecInfo.canReuseCodec((Format)format, (Format)streamFormat).result == 0) continue;
            maxInputSize = Math.max(maxInputSize, this.getCodecMaxInputSize(codecInfo, streamFormat));
        }
        return maxInputSize;
    }

    private int getCodecMaxInputSize(MediaCodecInfo codecInfo, Format format) {
        if ("OMX.google.raw.decoder".equals(codecInfo.name) && Util.SDK_INT < 24 && (Util.SDK_INT != 23 || !Util.isTv((Context)this.context))) {
            return -1;
        }
        return format.maxInputSize;
    }

    @SuppressLint(value={"InlinedApi"})
    protected MediaFormat getMediaFormat(Format format, String codecMimeType, int codecMaxInputSize, float codecOperatingRate) {
        MediaFormat mediaFormat = new MediaFormat();
        mediaFormat.setString("mime", codecMimeType);
        mediaFormat.setInteger("channel-count", format.channelCount);
        mediaFormat.setInteger("sample-rate", format.sampleRate);
        MediaFormatUtil.setCsdBuffers((MediaFormat)mediaFormat, (List)format.initializationData);
        MediaFormatUtil.maybeSetInteger((MediaFormat)mediaFormat, (String)"max-input-size", (int)codecMaxInputSize);
        if (Util.SDK_INT >= 23) {
            mediaFormat.setInteger("priority", 0);
            if (codecOperatingRate != -1.0f && !MediaCodecAudioRenderer.deviceDoesntSupportOperatingRate()) {
                mediaFormat.setFloat("operating-rate", codecOperatingRate);
            }
        }
        if (Util.SDK_INT <= 28 && "audio/ac4".equals(format.sampleMimeType)) {
            mediaFormat.setInteger("ac4-is-sync", 1);
        }
        if (Util.SDK_INT >= 24 && this.audioSink.getFormatSupport(Util.getPcmFormat((int)4, (int)format.channelCount, (int)format.sampleRate)) == 2) {
            mediaFormat.setInteger("pcm-encoding", 4);
        }
        if (Util.SDK_INT >= 32) {
            mediaFormat.setInteger("max-output-channel-count", 99);
        }
        return mediaFormat;
    }

    private void updateCurrentPosition() {
        long newCurrentPositionUs = this.audioSink.getCurrentPositionUs(this.isEnded());
        if (newCurrentPositionUs != Long.MIN_VALUE) {
            this.currentPositionUs = this.allowPositionDiscontinuity ? newCurrentPositionUs : Math.max(this.currentPositionUs, newCurrentPositionUs);
            this.allowPositionDiscontinuity = false;
        }
    }

    private static boolean deviceDoesntSupportOperatingRate() {
        return Util.SDK_INT == 23 && ("ZTE B2017G".equals(Util.MODEL) || "AXON 7 mini".equals(Util.MODEL));
    }

    private static boolean codecNeedsDiscardChannelsWorkaround(String codecName) {
        return Util.SDK_INT < 24 && "OMX.SEC.aac.dec".equals(codecName) && "samsung".equals(Util.MANUFACTURER) && (Util.DEVICE.startsWith("zeroflte") || Util.DEVICE.startsWith("herolte") || Util.DEVICE.startsWith("heroqlte"));
    }

    private final class AudioSinkListener
    implements AudioSink.Listener {
        private AudioSinkListener() {
        }

        @Override
        public void onPositionDiscontinuity() {
            MediaCodecAudioRenderer.this.onPositionDiscontinuity();
        }

        @Override
        public void onPositionAdvancing(long playoutStartSystemTimeMs) {
            MediaCodecAudioRenderer.this.eventDispatcher.positionAdvancing(playoutStartSystemTimeMs);
        }

        @Override
        public void onUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
            MediaCodecAudioRenderer.this.eventDispatcher.underrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs);
        }

        @Override
        public void onSkipSilenceEnabledChanged(boolean skipSilenceEnabled) {
            MediaCodecAudioRenderer.this.eventDispatcher.skipSilenceEnabledChanged(skipSilenceEnabled);
        }

        @Override
        public void onOffloadBufferEmptying() {
            if (MediaCodecAudioRenderer.this.wakeupListener != null) {
                MediaCodecAudioRenderer.this.wakeupListener.onWakeup();
            }
        }

        @Override
        public void onOffloadBufferFull() {
            if (MediaCodecAudioRenderer.this.wakeupListener != null) {
                MediaCodecAudioRenderer.this.wakeupListener.onSleep();
            }
        }

        @Override
        public void onAudioSinkError(Exception audioSinkError) {
            Log.e((String)MediaCodecAudioRenderer.TAG, (String)"Audio sink error", (Throwable)audioSinkError);
            MediaCodecAudioRenderer.this.eventDispatcher.audioSinkError(audioSinkError);
        }

        @Override
        public void onAudioCapabilitiesChanged() {
            MediaCodecAudioRenderer.this.onRendererCapabilitiesChanged();
        }
    }

    @RequiresApi(value=23)
    private static final class Api23 {
        private Api23() {
        }

        @DoNotInline
        public static void setAudioSinkPreferredDevice(AudioSink audioSink, @Nullable Object messagePayload) {
            AudioDeviceInfo audioDeviceInfo = (AudioDeviceInfo)messagePayload;
            audioSink.setPreferredDevice(audioDeviceInfo);
        }
    }
}

