/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.BaseAudioProcessor;
import com.google.android.exoplayer2.util.Util;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.ByteBuffer;

@Deprecated
final class ToFloatPcmAudioProcessor
extends BaseAudioProcessor {
    private static final int FLOAT_NAN_AS_INT = Float.floatToIntBits(Float.NaN);
    private static final double PCM_32_BIT_INT_TO_PCM_32_BIT_FLOAT_FACTOR = 4.656612875245797E-10;

    ToFloatPcmAudioProcessor() {
    }

    @CanIgnoreReturnValue
    public AudioProcessor.AudioFormat onConfigure(AudioProcessor.AudioFormat inputAudioFormat) throws AudioProcessor.UnhandledAudioFormatException {
        int encoding = inputAudioFormat.encoding;
        if (!Util.isEncodingHighResolutionPcm((int)encoding)) {
            throw new AudioProcessor.UnhandledAudioFormatException(inputAudioFormat);
        }
        return encoding != 4 ? new AudioProcessor.AudioFormat(inputAudioFormat.sampleRate, inputAudioFormat.channelCount, 4) : AudioProcessor.AudioFormat.NOT_SET;
    }

    public void queueInput(ByteBuffer inputBuffer) {
        ByteBuffer buffer;
        int position = inputBuffer.position();
        int limit = inputBuffer.limit();
        int size = limit - position;
        switch (this.inputAudioFormat.encoding) {
            case 0x20000000: {
                buffer = this.replaceOutputBuffer(size / 3 * 4);
                for (int i = position; i < limit; i += 3) {
                    int pcm32BitInteger = (inputBuffer.get(i) & 0xFF) << 8 | (inputBuffer.get(i + 1) & 0xFF) << 16 | (inputBuffer.get(i + 2) & 0xFF) << 24;
                    ToFloatPcmAudioProcessor.writePcm32BitFloat(pcm32BitInteger, buffer);
                }
                break;
            }
            case 0x30000000: {
                buffer = this.replaceOutputBuffer(size);
                for (int i = position; i < limit; i += 4) {
                    int pcm32BitInteger = inputBuffer.get(i) & 0xFF | (inputBuffer.get(i + 1) & 0xFF) << 8 | (inputBuffer.get(i + 2) & 0xFF) << 16 | (inputBuffer.get(i + 3) & 0xFF) << 24;
                    ToFloatPcmAudioProcessor.writePcm32BitFloat(pcm32BitInteger, buffer);
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        inputBuffer.position(inputBuffer.limit());
        buffer.flip();
    }

    private static void writePcm32BitFloat(int pcm32BitInt, ByteBuffer buffer) {
        float pcm32BitFloat = (float)(4.656612875245797E-10 * (double)pcm32BitInt);
        int floatBits = Float.floatToIntBits(pcm32BitFloat);
        if (floatBits == FLOAT_NAN_AS_INT) {
            floatBits = Float.floatToIntBits(0.0f);
        }
        buffer.putInt(floatBits);
    }
}

