/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.audio;

import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.BaseAudioProcessor;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;

@Deprecated
final class TrimmingAudioProcessor
extends BaseAudioProcessor {
    private static final int OUTPUT_ENCODING = 2;
    private int trimStartFrames;
    private int trimEndFrames;
    private boolean reconfigurationPending;
    private int pendingTrimStartBytes;
    private byte[] endBuffer = Util.EMPTY_BYTE_ARRAY;
    private int endBufferSize;
    private long trimmedFrameCount;

    public void setTrimFrameCount(int trimStartFrames, int trimEndFrames) {
        this.trimStartFrames = trimStartFrames;
        this.trimEndFrames = trimEndFrames;
    }

    public void resetTrimmedFrameCount() {
        this.trimmedFrameCount = 0L;
    }

    public long getTrimmedFrameCount() {
        return this.trimmedFrameCount;
    }

    public AudioProcessor.AudioFormat onConfigure(AudioProcessor.AudioFormat inputAudioFormat) throws AudioProcessor.UnhandledAudioFormatException {
        if (inputAudioFormat.encoding != 2) {
            throw new AudioProcessor.UnhandledAudioFormatException(inputAudioFormat);
        }
        this.reconfigurationPending = true;
        return this.trimStartFrames != 0 || this.trimEndFrames != 0 ? inputAudioFormat : AudioProcessor.AudioFormat.NOT_SET;
    }

    public void queueInput(ByteBuffer inputBuffer) {
        int position = inputBuffer.position();
        int limit = inputBuffer.limit();
        int remaining = limit - position;
        if (remaining == 0) {
            return;
        }
        int trimBytes = Math.min(remaining, this.pendingTrimStartBytes);
        this.trimmedFrameCount += (long)(trimBytes / this.inputAudioFormat.bytesPerFrame);
        this.pendingTrimStartBytes -= trimBytes;
        inputBuffer.position(position + trimBytes);
        if (this.pendingTrimStartBytes > 0) {
            return;
        }
        int remainingBytesToOutput = this.endBufferSize + (remaining -= trimBytes) - this.endBuffer.length;
        ByteBuffer buffer = this.replaceOutputBuffer(remainingBytesToOutput);
        int endBufferBytesToOutput = Util.constrainValue((int)remainingBytesToOutput, (int)0, (int)this.endBufferSize);
        buffer.put(this.endBuffer, 0, endBufferBytesToOutput);
        int inputBufferBytesToOutput = Util.constrainValue((int)(remainingBytesToOutput -= endBufferBytesToOutput), (int)0, (int)remaining);
        inputBuffer.limit(inputBuffer.position() + inputBufferBytesToOutput);
        buffer.put(inputBuffer);
        inputBuffer.limit(limit);
        this.endBufferSize -= endBufferBytesToOutput;
        System.arraycopy(this.endBuffer, endBufferBytesToOutput, this.endBuffer, 0, this.endBufferSize);
        inputBuffer.get(this.endBuffer, this.endBufferSize, remaining -= inputBufferBytesToOutput);
        this.endBufferSize += remaining;
        buffer.flip();
    }

    public ByteBuffer getOutput() {
        if (super.isEnded() && this.endBufferSize > 0) {
            this.replaceOutputBuffer(this.endBufferSize).put(this.endBuffer, 0, this.endBufferSize).flip();
            this.endBufferSize = 0;
        }
        return super.getOutput();
    }

    public boolean isEnded() {
        return super.isEnded() && this.endBufferSize == 0;
    }

    protected void onQueueEndOfStream() {
        if (this.reconfigurationPending) {
            if (this.endBufferSize > 0) {
                this.trimmedFrameCount += (long)(this.endBufferSize / this.inputAudioFormat.bytesPerFrame);
            }
            this.endBufferSize = 0;
        }
    }

    protected void onFlush() {
        if (this.reconfigurationPending) {
            this.reconfigurationPending = false;
            this.endBuffer = new byte[this.trimEndFrames * this.inputAudioFormat.bytesPerFrame];
            this.pendingTrimStartBytes = this.trimStartFrames * this.inputAudioFormat.bytesPerFrame;
        }
        this.endBufferSize = 0;
    }

    protected void onReset() {
        this.endBuffer = Util.EMPTY_BYTE_ARRAY;
    }
}

