/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.drm;

import android.media.DeniedByServerException;
import android.media.MediaDrm;
import android.media.MediaDrmResetException;
import android.media.NotProvisionedException;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.drm.DefaultDrmSessionManager;
import com.google.android.exoplayer2.drm.KeysExpiredException;
import com.google.android.exoplayer2.drm.UnsupportedDrmException;
import com.google.android.exoplayer2.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Deprecated
public final class DrmUtil {
    public static final int ERROR_SOURCE_EXO_MEDIA_DRM = 1;
    public static final int ERROR_SOURCE_LICENSE_ACQUISITION = 2;
    public static final int ERROR_SOURCE_PROVISIONING = 3;

    public static int getErrorCodeForMediaDrmException(Exception exception, int errorSource) {
        if (Util.SDK_INT >= 21 && Api21.isMediaDrmStateException(exception)) {
            return Api21.mediaDrmStateExceptionToErrorCode(exception);
        }
        if (Util.SDK_INT >= 23 && Api23.isMediaDrmResetException(exception)) {
            return 6006;
        }
        if (Util.SDK_INT >= 18 && Api18.isNotProvisionedException(exception)) {
            return 6002;
        }
        if (Util.SDK_INT >= 18 && Api18.isDeniedByServerException(exception)) {
            return 6007;
        }
        if (exception instanceof UnsupportedDrmException) {
            return 6001;
        }
        if (exception instanceof DefaultDrmSessionManager.MissingSchemeDataException) {
            return 6003;
        }
        if (exception instanceof KeysExpiredException) {
            return 6008;
        }
        if (errorSource == 1) {
            return 6006;
        }
        if (errorSource == 2) {
            return 6004;
        }
        if (errorSource == 3) {
            return 6002;
        }
        throw new IllegalArgumentException();
    }

    private DrmUtil() {
    }

    @RequiresApi(value=21)
    private static final class Api21 {
        private Api21() {
        }

        @DoNotInline
        public static boolean isMediaDrmStateException(@Nullable Throwable throwable) {
            return throwable instanceof MediaDrm.MediaDrmStateException;
        }

        @DoNotInline
        public static int mediaDrmStateExceptionToErrorCode(Throwable throwable) {
            String diagnosticsInfo = ((MediaDrm.MediaDrmStateException)throwable).getDiagnosticInfo();
            int drmErrorCode = Util.getErrorCodeFromPlatformDiagnosticsInfo((String)diagnosticsInfo);
            return Util.getErrorCodeForMediaDrmErrorCode((int)drmErrorCode);
        }
    }

    @RequiresApi(value=23)
    private static final class Api23 {
        private Api23() {
        }

        @DoNotInline
        public static boolean isMediaDrmResetException(@Nullable Throwable throwable) {
            return throwable instanceof MediaDrmResetException;
        }
    }

    @RequiresApi(value=18)
    private static final class Api18 {
        private Api18() {
        }

        @DoNotInline
        public static boolean isNotProvisionedException(@Nullable Throwable throwable) {
            return throwable instanceof NotProvisionedException;
        }

        @DoNotInline
        public static boolean isDeniedByServerException(@Nullable Throwable throwable) {
            return throwable instanceof DeniedByServerException;
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface ErrorSource {
    }
}

