/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.mediacodec;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.mediacodec.IntArrayQueue;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayDeque;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@Deprecated
@RequiresApi(value=23)
final class AsynchronousMediaCodecCallback
extends MediaCodec.Callback {
    private final Object lock = new Object();
    private final HandlerThread callbackThread;
    private @MonotonicNonNull Handler handler;
    @GuardedBy(value="lock")
    private final IntArrayQueue availableInputBuffers;
    @GuardedBy(value="lock")
    private final IntArrayQueue availableOutputBuffers;
    @GuardedBy(value="lock")
    private final ArrayDeque<MediaCodec.BufferInfo> bufferInfos;
    @GuardedBy(value="lock")
    private final ArrayDeque<MediaFormat> formats;
    @GuardedBy(value="lock")
    @Nullable
    private MediaFormat currentFormat;
    @GuardedBy(value="lock")
    @Nullable
    private MediaFormat pendingOutputFormat;
    @GuardedBy(value="lock")
    @Nullable
    private MediaCodec.CodecException mediaCodecException;
    @GuardedBy(value="lock")
    private long pendingFlushCount;
    @GuardedBy(value="lock")
    private boolean shutDown;
    @GuardedBy(value="lock")
    @Nullable
    private IllegalStateException internalException;

    AsynchronousMediaCodecCallback(HandlerThread callbackThread) {
        this.callbackThread = callbackThread;
        this.availableInputBuffers = new IntArrayQueue();
        this.availableOutputBuffers = new IntArrayQueue();
        this.bufferInfos = new ArrayDeque();
        this.formats = new ArrayDeque();
    }

    public void initialize(MediaCodec codec) {
        Assertions.checkState((this.handler == null ? 1 : 0) != 0);
        this.callbackThread.start();
        Handler handler = new Handler(this.callbackThread.getLooper());
        codec.setCallback((MediaCodec.Callback)this, handler);
        this.handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.lock;
        synchronized (object) {
            this.shutDown = true;
            this.callbackThread.quit();
            this.flushInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dequeueInputBufferIndex() {
        Object object = this.lock;
        synchronized (object) {
            this.maybeThrowException();
            if (this.isFlushingOrShutdown()) {
                return -1;
            }
            return this.availableInputBuffers.isEmpty() ? -1 : this.availableInputBuffers.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int dequeueOutputBufferIndex(MediaCodec.BufferInfo bufferInfo) {
        Object object = this.lock;
        synchronized (object) {
            this.maybeThrowException();
            if (this.isFlushingOrShutdown()) {
                return -1;
            }
            if (this.availableOutputBuffers.isEmpty()) {
                return -1;
            }
            int bufferIndex = this.availableOutputBuffers.remove();
            if (bufferIndex >= 0) {
                Assertions.checkStateNotNull((Object)this.currentFormat);
                MediaCodec.BufferInfo nextBufferInfo = this.bufferInfos.remove();
                bufferInfo.set(nextBufferInfo.offset, nextBufferInfo.size, nextBufferInfo.presentationTimeUs, nextBufferInfo.flags);
            } else if (bufferIndex == -2) {
                this.currentFormat = this.formats.remove();
            }
            return bufferIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MediaFormat getOutputFormat() {
        Object object = this.lock;
        synchronized (object) {
            if (this.currentFormat == null) {
                throw new IllegalStateException();
            }
            return this.currentFormat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.lock;
        synchronized (object) {
            ++this.pendingFlushCount;
            ((Handler)Util.castNonNull((Object)this.handler)).post(this::onFlushCompleted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInputBufferAvailable(MediaCodec codec, int index) {
        Object object = this.lock;
        synchronized (object) {
            this.availableInputBuffers.add(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutputBufferAvailable(MediaCodec codec, int index, MediaCodec.BufferInfo info) {
        Object object = this.lock;
        synchronized (object) {
            if (this.pendingOutputFormat != null) {
                this.addOutputFormat(this.pendingOutputFormat);
                this.pendingOutputFormat = null;
            }
            this.availableOutputBuffers.add(index);
            this.bufferInfos.add(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(MediaCodec codec, MediaCodec.CodecException e) {
        Object object = this.lock;
        synchronized (object) {
            this.mediaCodecException = e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOutputFormatChanged(MediaCodec codec, MediaFormat format) {
        Object object = this.lock;
        synchronized (object) {
            this.addOutputFormat(format);
            this.pendingOutputFormat = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onFlushCompleted() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutDown) {
                return;
            }
            --this.pendingFlushCount;
            if (this.pendingFlushCount > 0L) {
                return;
            }
            if (this.pendingFlushCount < 0L) {
                this.setInternalException(new IllegalStateException());
                return;
            }
            this.flushInternal();
        }
    }

    @GuardedBy(value="lock")
    private void flushInternal() {
        if (!this.formats.isEmpty()) {
            this.pendingOutputFormat = this.formats.getLast();
        }
        this.availableInputBuffers.clear();
        this.availableOutputBuffers.clear();
        this.bufferInfos.clear();
        this.formats.clear();
    }

    @GuardedBy(value="lock")
    private boolean isFlushingOrShutdown() {
        return this.pendingFlushCount > 0L || this.shutDown;
    }

    @GuardedBy(value="lock")
    private void addOutputFormat(MediaFormat mediaFormat) {
        this.availableOutputBuffers.add(-2);
        this.formats.add(mediaFormat);
    }

    @GuardedBy(value="lock")
    private void maybeThrowException() {
        this.maybeThrowInternalException();
        this.maybeThrowMediaCodecException();
    }

    @GuardedBy(value="lock")
    private void maybeThrowInternalException() {
        if (this.internalException != null) {
            IllegalStateException e = this.internalException;
            this.internalException = null;
            throw e;
        }
    }

    @GuardedBy(value="lock")
    private void maybeThrowMediaCodecException() {
        if (this.mediaCodecException != null) {
            MediaCodec.CodecException codecException = this.mediaCodecException;
            this.mediaCodecException = null;
            throw codecException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInternalException(IllegalStateException e) {
        Object object = this.lock;
        synchronized (object) {
            this.internalException = e;
        }
    }
}

