/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.mediacodec;

import androidx.annotation.IntRange;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.util.Assertions;
import java.nio.ByteBuffer;

@Deprecated
final class BatchBuffer
extends DecoderInputBuffer {
    public static final int DEFAULT_MAX_SAMPLE_COUNT = 32;
    @VisibleForTesting
    static final int MAX_SIZE_BYTES = 0x2EE000;
    private long lastSampleTimeUs;
    private int sampleCount;
    private int maxSampleCount = 32;

    public BatchBuffer() {
        super(2);
    }

    public void clear() {
        super.clear();
        this.sampleCount = 0;
    }

    public void setMaxSampleCount(@IntRange(from=1L) int maxSampleCount) {
        Assertions.checkArgument((maxSampleCount > 0 ? 1 : 0) != 0);
        this.maxSampleCount = maxSampleCount;
    }

    public long getFirstSampleTimeUs() {
        return this.timeUs;
    }

    public long getLastSampleTimeUs() {
        return this.lastSampleTimeUs;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public boolean hasSamples() {
        return this.sampleCount > 0;
    }

    public boolean append(DecoderInputBuffer buffer) {
        ByteBuffer bufferData;
        Assertions.checkArgument((!buffer.isEncrypted() ? 1 : 0) != 0);
        Assertions.checkArgument((!buffer.hasSupplementalData() ? 1 : 0) != 0);
        Assertions.checkArgument((!buffer.isEndOfStream() ? 1 : 0) != 0);
        if (!this.canAppendSampleBuffer(buffer)) {
            return false;
        }
        if (this.sampleCount++ == 0) {
            this.timeUs = buffer.timeUs;
            if (buffer.isKeyFrame()) {
                this.setFlags(1);
            }
        }
        if (buffer.isDecodeOnly()) {
            this.setFlags(Integer.MIN_VALUE);
        }
        if ((bufferData = buffer.data) != null) {
            this.ensureSpaceForWrite(bufferData.remaining());
            this.data.put(bufferData);
        }
        this.lastSampleTimeUs = buffer.timeUs;
        return true;
    }

    private boolean canAppendSampleBuffer(DecoderInputBuffer buffer) {
        if (!this.hasSamples()) {
            return true;
        }
        if (this.sampleCount >= this.maxSampleCount) {
            return false;
        }
        if (buffer.isDecodeOnly() != this.isDecodeOnly()) {
            return false;
        }
        ByteBuffer bufferData = buffer.data;
        return bufferData == null || this.data == null || this.data.position() + bufferData.remaining() <= 0x2EE000;
    }
}

