/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.offline;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.google.android.exoplayer2.offline.Download;
import com.google.android.exoplayer2.offline.DownloadManager;
import com.google.android.exoplayer2.offline.DownloadRequest;
import com.google.android.exoplayer2.scheduler.Requirements;
import com.google.android.exoplayer2.scheduler.Scheduler;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.NotificationUtil;
import com.google.android.exoplayer2.util.Util;
import java.util.HashMap;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

@Deprecated
public abstract class DownloadService
extends Service {
    public static final String ACTION_INIT = "com.google.android.exoplayer.downloadService.action.INIT";
    private static final String ACTION_RESTART = "com.google.android.exoplayer.downloadService.action.RESTART";
    public static final String ACTION_ADD_DOWNLOAD = "com.google.android.exoplayer.downloadService.action.ADD_DOWNLOAD";
    public static final String ACTION_REMOVE_DOWNLOAD = "com.google.android.exoplayer.downloadService.action.REMOVE_DOWNLOAD";
    public static final String ACTION_REMOVE_ALL_DOWNLOADS = "com.google.android.exoplayer.downloadService.action.REMOVE_ALL_DOWNLOADS";
    public static final String ACTION_RESUME_DOWNLOADS = "com.google.android.exoplayer.downloadService.action.RESUME_DOWNLOADS";
    public static final String ACTION_PAUSE_DOWNLOADS = "com.google.android.exoplayer.downloadService.action.PAUSE_DOWNLOADS";
    public static final String ACTION_SET_STOP_REASON = "com.google.android.exoplayer.downloadService.action.SET_STOP_REASON";
    public static final String ACTION_SET_REQUIREMENTS = "com.google.android.exoplayer.downloadService.action.SET_REQUIREMENTS";
    public static final String KEY_DOWNLOAD_REQUEST = "download_request";
    public static final String KEY_CONTENT_ID = "content_id";
    public static final String KEY_STOP_REASON = "stop_reason";
    public static final String KEY_REQUIREMENTS = "requirements";
    public static final String KEY_FOREGROUND = "foreground";
    public static final int FOREGROUND_NOTIFICATION_ID_NONE = 0;
    public static final long DEFAULT_FOREGROUND_NOTIFICATION_UPDATE_INTERVAL = 1000L;
    private static final String TAG = "DownloadService";
    private static final HashMap<Class<? extends DownloadService>, DownloadManagerHelper> downloadManagerHelpers = new HashMap();
    @Nullable
    private final ForegroundNotificationUpdater foregroundNotificationUpdater;
    @Nullable
    private final String channelId;
    @StringRes
    private final int channelNameResourceId;
    @StringRes
    private final int channelDescriptionResourceId;
    private @MonotonicNonNull DownloadManagerHelper downloadManagerHelper;
    private int lastStartId;
    private boolean startedInForeground;
    private boolean taskRemoved;
    private boolean isStopped;
    private boolean isDestroyed;

    protected DownloadService(int foregroundNotificationId) {
        this(foregroundNotificationId, 1000L);
    }

    protected DownloadService(int foregroundNotificationId, long foregroundNotificationUpdateInterval) {
        this(foregroundNotificationId, foregroundNotificationUpdateInterval, null, 0, 0);
    }

    protected DownloadService(int foregroundNotificationId, long foregroundNotificationUpdateInterval, @Nullable String channelId, @StringRes int channelNameResourceId, @StringRes int channelDescriptionResourceId) {
        if (foregroundNotificationId == 0) {
            this.foregroundNotificationUpdater = null;
            this.channelId = null;
            this.channelNameResourceId = 0;
            this.channelDescriptionResourceId = 0;
        } else {
            this.foregroundNotificationUpdater = new ForegroundNotificationUpdater(foregroundNotificationId, foregroundNotificationUpdateInterval);
            this.channelId = channelId;
            this.channelNameResourceId = channelNameResourceId;
            this.channelDescriptionResourceId = channelDescriptionResourceId;
        }
    }

    public static Intent buildAddDownloadIntent(Context context, Class<? extends DownloadService> clazz, DownloadRequest downloadRequest, boolean foreground) {
        return DownloadService.buildAddDownloadIntent(context, clazz, downloadRequest, 0, foreground);
    }

    public static Intent buildAddDownloadIntent(Context context, Class<? extends DownloadService> clazz, DownloadRequest downloadRequest, int stopReason, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_ADD_DOWNLOAD, foreground).putExtra(KEY_DOWNLOAD_REQUEST, (Parcelable)downloadRequest).putExtra(KEY_STOP_REASON, stopReason);
    }

    public static Intent buildRemoveDownloadIntent(Context context, Class<? extends DownloadService> clazz, String id, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_REMOVE_DOWNLOAD, foreground).putExtra(KEY_CONTENT_ID, id);
    }

    public static Intent buildRemoveAllDownloadsIntent(Context context, Class<? extends DownloadService> clazz, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_REMOVE_ALL_DOWNLOADS, foreground);
    }

    public static Intent buildResumeDownloadsIntent(Context context, Class<? extends DownloadService> clazz, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_RESUME_DOWNLOADS, foreground);
    }

    public static Intent buildPauseDownloadsIntent(Context context, Class<? extends DownloadService> clazz, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_PAUSE_DOWNLOADS, foreground);
    }

    public static Intent buildSetStopReasonIntent(Context context, Class<? extends DownloadService> clazz, @Nullable String id, int stopReason, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_SET_STOP_REASON, foreground).putExtra(KEY_CONTENT_ID, id).putExtra(KEY_STOP_REASON, stopReason);
    }

    public static Intent buildSetRequirementsIntent(Context context, Class<? extends DownloadService> clazz, Requirements requirements, boolean foreground) {
        return DownloadService.getIntent(context, clazz, ACTION_SET_REQUIREMENTS, foreground).putExtra(KEY_REQUIREMENTS, (Parcelable)requirements);
    }

    public static void sendAddDownload(Context context, Class<? extends DownloadService> clazz, DownloadRequest downloadRequest, boolean foreground) {
        Intent intent = DownloadService.buildAddDownloadIntent(context, clazz, downloadRequest, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendAddDownload(Context context, Class<? extends DownloadService> clazz, DownloadRequest downloadRequest, int stopReason, boolean foreground) {
        Intent intent = DownloadService.buildAddDownloadIntent(context, clazz, downloadRequest, stopReason, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendRemoveDownload(Context context, Class<? extends DownloadService> clazz, String id, boolean foreground) {
        Intent intent = DownloadService.buildRemoveDownloadIntent(context, clazz, id, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendRemoveAllDownloads(Context context, Class<? extends DownloadService> clazz, boolean foreground) {
        Intent intent = DownloadService.buildRemoveAllDownloadsIntent(context, clazz, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendResumeDownloads(Context context, Class<? extends DownloadService> clazz, boolean foreground) {
        Intent intent = DownloadService.buildResumeDownloadsIntent(context, clazz, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendPauseDownloads(Context context, Class<? extends DownloadService> clazz, boolean foreground) {
        Intent intent = DownloadService.buildPauseDownloadsIntent(context, clazz, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendSetStopReason(Context context, Class<? extends DownloadService> clazz, @Nullable String id, int stopReason, boolean foreground) {
        Intent intent = DownloadService.buildSetStopReasonIntent(context, clazz, id, stopReason, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void sendSetRequirements(Context context, Class<? extends DownloadService> clazz, Requirements requirements, boolean foreground) {
        Intent intent = DownloadService.buildSetRequirementsIntent(context, clazz, requirements, foreground);
        DownloadService.startService(context, intent, foreground);
    }

    public static void start(Context context, Class<? extends DownloadService> clazz) {
        context.startService(DownloadService.getIntent(context, clazz, ACTION_INIT));
    }

    public static void startForeground(Context context, Class<? extends DownloadService> clazz) {
        Intent intent = DownloadService.getIntent(context, clazz, ACTION_INIT, true);
        Util.startForegroundService((Context)context, (Intent)intent);
    }

    public static void clearDownloadManagerHelpers() {
        downloadManagerHelpers.clear();
    }

    public void onCreate() {
        Class<?> clazz;
        DownloadManagerHelper downloadManagerHelper;
        if (this.channelId != null) {
            NotificationUtil.createNotificationChannel((Context)this, (String)this.channelId, (int)this.channelNameResourceId, (int)this.channelDescriptionResourceId, (int)2);
        }
        if ((downloadManagerHelper = downloadManagerHelpers.get(clazz = ((Object)((Object)this)).getClass())) == null) {
            boolean foregroundAllowed = this.foregroundNotificationUpdater != null;
            boolean canStartForegroundServiceFromBackground = Util.SDK_INT < 31;
            Scheduler scheduler = foregroundAllowed && canStartForegroundServiceFromBackground ? this.getScheduler() : null;
            DownloadManager downloadManager = this.getDownloadManager();
            downloadManager.resumeDownloads();
            downloadManagerHelper = new DownloadManagerHelper(this.getApplicationContext(), downloadManager, foregroundAllowed, scheduler, clazz);
            downloadManagerHelpers.put(clazz, downloadManagerHelper);
        }
        this.downloadManagerHelper = downloadManagerHelper;
        downloadManagerHelper.attachService(this);
    }

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        this.lastStartId = startId;
        this.taskRemoved = false;
        String intentAction = null;
        String contentId = null;
        if (intent != null) {
            intentAction = intent.getAction();
            contentId = intent.getStringExtra(KEY_CONTENT_ID);
            this.startedInForeground |= intent.getBooleanExtra(KEY_FOREGROUND, false) || ACTION_RESTART.equals(intentAction);
        }
        if (intentAction == null) {
            intentAction = ACTION_INIT;
        }
        DownloadManager downloadManager = ((DownloadManagerHelper)Assertions.checkNotNull((Object)this.downloadManagerHelper)).downloadManager;
        switch (intentAction) {
            case "com.google.android.exoplayer.downloadService.action.INIT": 
            case "com.google.android.exoplayer.downloadService.action.RESTART": {
                break;
            }
            case "com.google.android.exoplayer.downloadService.action.ADD_DOWNLOAD": {
                DownloadRequest downloadRequest = (DownloadRequest)((Intent)Assertions.checkNotNull((Object)intent)).getParcelableExtra(KEY_DOWNLOAD_REQUEST);
                if (downloadRequest == null) {
                    Log.e((String)TAG, (String)"Ignored ADD_DOWNLOAD: Missing download_request extra");
                    break;
                }
                int stopReason = intent.getIntExtra(KEY_STOP_REASON, 0);
                downloadManager.addDownload(downloadRequest, stopReason);
                break;
            }
            case "com.google.android.exoplayer.downloadService.action.REMOVE_DOWNLOAD": {
                if (contentId == null) {
                    Log.e((String)TAG, (String)"Ignored REMOVE_DOWNLOAD: Missing content_id extra");
                    break;
                }
                downloadManager.removeDownload(contentId);
                break;
            }
            case "com.google.android.exoplayer.downloadService.action.REMOVE_ALL_DOWNLOADS": {
                downloadManager.removeAllDownloads();
                break;
            }
            case "com.google.android.exoplayer.downloadService.action.RESUME_DOWNLOADS": {
                downloadManager.resumeDownloads();
                break;
            }
            case "com.google.android.exoplayer.downloadService.action.PAUSE_DOWNLOADS": {
                downloadManager.pauseDownloads();
                break;
            }
            case "com.google.android.exoplayer.downloadService.action.SET_STOP_REASON": {
                if (!((Intent)Assertions.checkNotNull((Object)intent)).hasExtra(KEY_STOP_REASON)) {
                    Log.e((String)TAG, (String)"Ignored SET_STOP_REASON: Missing stop_reason extra");
                    break;
                }
                int stopReason = intent.getIntExtra(KEY_STOP_REASON, 0);
                downloadManager.setStopReason(contentId, stopReason);
                break;
            }
            case "com.google.android.exoplayer.downloadService.action.SET_REQUIREMENTS": {
                Requirements requirements = (Requirements)((Intent)Assertions.checkNotNull((Object)intent)).getParcelableExtra(KEY_REQUIREMENTS);
                if (requirements == null) {
                    Log.e((String)TAG, (String)"Ignored SET_REQUIREMENTS: Missing requirements extra");
                    break;
                }
                downloadManager.setRequirements(requirements);
                break;
            }
            default: {
                Log.e((String)TAG, (String)("Ignored unrecognized action: " + intentAction));
            }
        }
        if (Util.SDK_INT >= 26 && this.startedInForeground && this.foregroundNotificationUpdater != null) {
            this.foregroundNotificationUpdater.showNotificationIfNotAlready();
        }
        this.isStopped = false;
        if (downloadManager.isIdle()) {
            this.onIdle();
        }
        return 1;
    }

    public void onTaskRemoved(Intent rootIntent) {
        this.taskRemoved = true;
    }

    public void onDestroy() {
        this.isDestroyed = true;
        ((DownloadManagerHelper)Assertions.checkNotNull((Object)this.downloadManagerHelper)).detachService(this);
        if (this.foregroundNotificationUpdater != null) {
            this.foregroundNotificationUpdater.stopPeriodicUpdates();
        }
    }

    @Nullable
    public final IBinder onBind(Intent intent) {
        throw new UnsupportedOperationException();
    }

    protected abstract DownloadManager getDownloadManager();

    @Nullable
    protected abstract Scheduler getScheduler();

    protected abstract Notification getForegroundNotification(List<Download> var1, int var2);

    protected final void invalidateForegroundNotification() {
        if (this.foregroundNotificationUpdater != null && !this.isDestroyed) {
            this.foregroundNotificationUpdater.invalidate();
        }
    }

    private void notifyDownloads(List<Download> downloads) {
        if (this.foregroundNotificationUpdater != null) {
            for (int i = 0; i < downloads.size(); ++i) {
                if (!DownloadService.needsStartedService(downloads.get((int)i).state)) continue;
                this.foregroundNotificationUpdater.startPeriodicUpdates();
                break;
            }
        }
    }

    private void notifyDownloadChanged(Download download) {
        if (this.foregroundNotificationUpdater != null) {
            if (DownloadService.needsStartedService(download.state)) {
                this.foregroundNotificationUpdater.startPeriodicUpdates();
            } else {
                this.foregroundNotificationUpdater.invalidate();
            }
        }
    }

    private void notifyDownloadRemoved() {
        if (this.foregroundNotificationUpdater != null) {
            this.foregroundNotificationUpdater.invalidate();
        }
    }

    private boolean isStopped() {
        return this.isStopped;
    }

    private void onIdle() {
        if (this.foregroundNotificationUpdater != null) {
            this.foregroundNotificationUpdater.stopPeriodicUpdates();
        }
        if (!((DownloadManagerHelper)Assertions.checkNotNull((Object)this.downloadManagerHelper)).updateScheduler()) {
            return;
        }
        if (Util.SDK_INT < 28 && this.taskRemoved) {
            this.stopSelf();
            this.isStopped = true;
        } else {
            this.isStopped |= this.stopSelfResult(this.lastStartId);
        }
    }

    private static boolean needsStartedService(int state) {
        return state == 2 || state == 5 || state == 7;
    }

    private static Intent getIntent(Context context, Class<? extends DownloadService> clazz, String action, boolean foreground) {
        return DownloadService.getIntent(context, clazz, action).putExtra(KEY_FOREGROUND, foreground);
    }

    private static Intent getIntent(Context context, Class<? extends DownloadService> clazz, String action) {
        return new Intent(context, clazz).setAction(action);
    }

    private static void startService(Context context, Intent intent, boolean foreground) {
        if (foreground) {
            Util.startForegroundService((Context)context, (Intent)intent);
        } else {
            context.startService(intent);
        }
    }

    private static final class DownloadManagerHelper
    implements DownloadManager.Listener {
        private final Context context;
        private final DownloadManager downloadManager;
        private final boolean foregroundAllowed;
        @Nullable
        private final Scheduler scheduler;
        private final Class<? extends DownloadService> serviceClass;
        @Nullable
        private DownloadService downloadService;
        private @MonotonicNonNull Requirements scheduledRequirements;

        private DownloadManagerHelper(Context context, DownloadManager downloadManager, boolean foregroundAllowed, @Nullable Scheduler scheduler, Class<? extends DownloadService> serviceClass) {
            this.context = context;
            this.downloadManager = downloadManager;
            this.foregroundAllowed = foregroundAllowed;
            this.scheduler = scheduler;
            this.serviceClass = serviceClass;
            downloadManager.addListener(this);
            this.updateScheduler();
        }

        public void attachService(DownloadService downloadService) {
            Assertions.checkState((this.downloadService == null ? 1 : 0) != 0);
            this.downloadService = downloadService;
            if (this.downloadManager.isInitialized()) {
                Util.createHandlerForCurrentOrMainLooper().postAtFrontOfQueue(() -> downloadService.notifyDownloads(this.downloadManager.getCurrentDownloads()));
            }
        }

        public void detachService(DownloadService downloadService) {
            Assertions.checkState((this.downloadService == downloadService ? 1 : 0) != 0);
            this.downloadService = null;
        }

        public boolean updateScheduler() {
            boolean waitingForRequirements = this.downloadManager.isWaitingForRequirements();
            if (this.scheduler == null) {
                return !waitingForRequirements;
            }
            if (!waitingForRequirements) {
                this.cancelScheduler();
                return true;
            }
            Requirements requirements = this.downloadManager.getRequirements();
            Requirements supportedRequirements = this.scheduler.getSupportedRequirements(requirements);
            if (!supportedRequirements.equals(requirements)) {
                this.cancelScheduler();
                return false;
            }
            if (!this.schedulerNeedsUpdate(requirements)) {
                return true;
            }
            String servicePackage = this.context.getPackageName();
            if (this.scheduler.schedule(requirements, servicePackage, DownloadService.ACTION_RESTART)) {
                this.scheduledRequirements = requirements;
                return true;
            }
            Log.w((String)DownloadService.TAG, (String)"Failed to schedule restart");
            this.cancelScheduler();
            return false;
        }

        @Override
        public void onInitialized(DownloadManager downloadManager) {
            if (this.downloadService != null) {
                this.downloadService.notifyDownloads(downloadManager.getCurrentDownloads());
            }
        }

        @Override
        public void onDownloadChanged(DownloadManager downloadManager, Download download, @Nullable Exception finalException) {
            if (this.downloadService != null) {
                this.downloadService.notifyDownloadChanged(download);
            }
            if (this.serviceMayNeedRestart() && DownloadService.needsStartedService(download.state)) {
                Log.w((String)DownloadService.TAG, (String)"DownloadService wasn't running. Restarting.");
                this.restartService();
            }
        }

        @Override
        public void onDownloadRemoved(DownloadManager downloadManager, Download download) {
            if (this.downloadService != null) {
                this.downloadService.notifyDownloadRemoved();
            }
        }

        @Override
        public final void onIdle(DownloadManager downloadManager) {
            if (this.downloadService != null) {
                this.downloadService.onIdle();
            }
        }

        @Override
        public void onRequirementsStateChanged(DownloadManager downloadManager, Requirements requirements, int notMetRequirements) {
            this.updateScheduler();
        }

        @Override
        public void onWaitingForRequirementsChanged(DownloadManager downloadManager, boolean waitingForRequirements) {
            if (!waitingForRequirements && !downloadManager.getDownloadsPaused() && this.serviceMayNeedRestart()) {
                List<Download> downloads = downloadManager.getCurrentDownloads();
                for (int i = 0; i < downloads.size(); ++i) {
                    if (downloads.get((int)i).state != 0) continue;
                    this.restartService();
                    return;
                }
            }
        }

        private boolean schedulerNeedsUpdate(Requirements requirements) {
            return !Util.areEqual((Object)this.scheduledRequirements, (Object)requirements);
        }

        @RequiresNonNull(value={"scheduler"})
        private void cancelScheduler() {
            Requirements canceledRequirements = new Requirements(0);
            if (this.schedulerNeedsUpdate(canceledRequirements)) {
                this.scheduler.cancel();
                this.scheduledRequirements = canceledRequirements;
            }
        }

        private boolean serviceMayNeedRestart() {
            return this.downloadService == null || this.downloadService.isStopped();
        }

        private void restartService() {
            if (this.foregroundAllowed) {
                try {
                    Intent intent = DownloadService.getIntent(this.context, this.serviceClass, DownloadService.ACTION_RESTART);
                    Util.startForegroundService((Context)this.context, (Intent)intent);
                }
                catch (IllegalStateException e) {
                    Log.w((String)DownloadService.TAG, (String)"Failed to restart (foreground launch restriction)");
                }
            } else {
                try {
                    Intent intent = DownloadService.getIntent(this.context, this.serviceClass, DownloadService.ACTION_INIT);
                    this.context.startService(intent);
                }
                catch (IllegalStateException e) {
                    Log.w((String)DownloadService.TAG, (String)"Failed to restart (process is idle)");
                }
            }
        }
    }

    private final class ForegroundNotificationUpdater {
        private final int notificationId;
        private final long updateInterval;
        private final Handler handler;
        private boolean periodicUpdatesStarted;
        private boolean notificationDisplayed;

        public ForegroundNotificationUpdater(int notificationId, long updateInterval) {
            this.notificationId = notificationId;
            this.updateInterval = updateInterval;
            this.handler = new Handler(Looper.getMainLooper());
        }

        public void startPeriodicUpdates() {
            this.periodicUpdatesStarted = true;
            this.update();
        }

        public void stopPeriodicUpdates() {
            this.periodicUpdatesStarted = false;
            this.handler.removeCallbacksAndMessages(null);
        }

        public void showNotificationIfNotAlready() {
            if (!this.notificationDisplayed) {
                this.update();
            }
        }

        public void invalidate() {
            if (this.notificationDisplayed) {
                this.update();
            }
        }

        private void update() {
            DownloadManager downloadManager = ((DownloadManagerHelper)Assertions.checkNotNull((Object)DownloadService.this.downloadManagerHelper)).downloadManager;
            List<Download> downloads = downloadManager.getCurrentDownloads();
            int notMetRequirements = downloadManager.getNotMetRequirements();
            Notification notification = DownloadService.this.getForegroundNotification(downloads, notMetRequirements);
            if (!this.notificationDisplayed) {
                DownloadService.this.startForeground(this.notificationId, notification);
                this.notificationDisplayed = true;
            } else {
                ((NotificationManager)DownloadService.this.getSystemService("notification")).notify(this.notificationId, notification);
            }
            if (this.periodicUpdatesStarted) {
                this.handler.removeCallbacksAndMessages(null);
                this.handler.postDelayed(this::update, this.updateInterval);
            }
        }
    }
}

