/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.annotation.SuppressLint;
import android.media.MediaParser;
import android.net.Uri;
import android.util.Pair;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.analytics.PlayerId;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.source.ProgressiveMediaExtractor;
import com.google.android.exoplayer2.source.mediaparser.InputReaderAdapterV30;
import com.google.android.exoplayer2.source.mediaparser.MediaParserUtil;
import com.google.android.exoplayer2.source.mediaparser.OutputConsumerAdapterV30;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@Deprecated
@RequiresApi(value=30)
public final class MediaParserExtractorAdapter
implements ProgressiveMediaExtractor {
    public static final ProgressiveMediaExtractor.Factory FACTORY = MediaParserExtractorAdapter::new;
    private final OutputConsumerAdapterV30 outputConsumerAdapter = new OutputConsumerAdapterV30();
    private final InputReaderAdapterV30 inputReaderAdapter = new InputReaderAdapterV30();
    private final MediaParser mediaParser = MediaParser.create((MediaParser.OutputConsumer)this.outputConsumerAdapter, (String[])new String[0]);
    private String parserName;

    @SuppressLint(value={"WrongConstant"})
    public MediaParserExtractorAdapter(PlayerId playerId) {
        this.mediaParser.setParameter("android.media.mediaparser.eagerlyExposeTrackType", (Object)true);
        this.mediaParser.setParameter("android.media.mediaparser.inBandCryptoInfo", (Object)true);
        this.mediaParser.setParameter("android.media.mediaparser.includeSupplementalData", (Object)true);
        this.parserName = "android.media.mediaparser.UNKNOWN";
        if (Util.SDK_INT >= 31) {
            MediaParserUtil.setLogSessionIdOnMediaParser(this.mediaParser, playerId);
        }
    }

    @Override
    public void init(DataReader dataReader, Uri uri, Map<String, List<String>> responseHeaders, long position, long length, ExtractorOutput output) throws IOException {
        this.outputConsumerAdapter.setExtractorOutput(output);
        this.inputReaderAdapter.setDataReader(dataReader, length);
        this.inputReaderAdapter.setCurrentPosition(position);
        String currentParserName = this.mediaParser.getParserName();
        if ("android.media.mediaparser.UNKNOWN".equals(currentParserName)) {
            this.mediaParser.advance((MediaParser.SeekableInputReader)this.inputReaderAdapter);
            this.parserName = this.mediaParser.getParserName();
            this.outputConsumerAdapter.setSelectedParserName(this.parserName);
        } else if (!currentParserName.equals(this.parserName)) {
            this.parserName = this.mediaParser.getParserName();
            this.outputConsumerAdapter.setSelectedParserName(this.parserName);
        }
    }

    @Override
    public void release() {
        this.mediaParser.release();
    }

    @Override
    public void disableSeekingOnMp3Streams() {
        if ("android.media.mediaparser.Mp3Parser".equals(this.parserName)) {
            this.outputConsumerAdapter.disableSeeking();
        }
    }

    @Override
    public long getCurrentInputPosition() {
        return this.inputReaderAdapter.getPosition();
    }

    @Override
    public void seek(long position, long seekTimeUs) {
        this.inputReaderAdapter.setCurrentPosition(position);
        Pair<MediaParser.SeekPoint, MediaParser.SeekPoint> seekPoints = this.outputConsumerAdapter.getSeekPoints(seekTimeUs);
        this.mediaParser.seek(((MediaParser.SeekPoint)seekPoints.second).position == position ? (MediaParser.SeekPoint)seekPoints.second : (MediaParser.SeekPoint)seekPoints.first);
    }

    @Override
    public int read(PositionHolder positionHolder) throws IOException {
        boolean shouldContinue = this.mediaParser.advance((MediaParser.SeekableInputReader)this.inputReaderAdapter);
        positionHolder.position = this.inputReaderAdapter.getAndResetSeekPosition();
        return !shouldContinue ? -1 : (positionHolder.position != -1L ? 1 : 0);
    }
}

