/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.FormatHolder;
import com.google.android.exoplayer2.SeekParameters;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.offline.StreamKey;
import com.google.android.exoplayer2.source.CompositeSequenceableLoaderFactory;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.SampleStream;
import com.google.android.exoplayer2.source.SequenceableLoader;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.chunk.Chunk;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.source.chunk.MediaChunkIterator;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableType;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@Deprecated
final class MergingMediaPeriod
implements MediaPeriod,
MediaPeriod.Callback {
    private final MediaPeriod[] periods;
    private final IdentityHashMap<SampleStream, Integer> streamPeriodIndices;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    private final ArrayList<MediaPeriod> childrenPendingPreparation;
    private final HashMap<TrackGroup, TrackGroup> childTrackGroupByMergedTrackGroup;
    @Nullable
    private MediaPeriod.Callback callback;
    @Nullable
    private TrackGroupArray trackGroups;
    private MediaPeriod[] enabledPeriods;
    private SequenceableLoader compositeSequenceableLoader;

    public MergingMediaPeriod(CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, long[] periodTimeOffsetsUs, MediaPeriod ... periods) {
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.periods = periods;
        this.childrenPendingPreparation = new ArrayList();
        this.childTrackGroupByMergedTrackGroup = new HashMap();
        this.compositeSequenceableLoader = compositeSequenceableLoaderFactory.createCompositeSequenceableLoader(new SequenceableLoader[0]);
        this.streamPeriodIndices = new IdentityHashMap();
        this.enabledPeriods = new MediaPeriod[0];
        for (int i = 0; i < periods.length; ++i) {
            if (periodTimeOffsetsUs[i] == 0L) continue;
            this.periods[i] = new TimeOffsetMediaPeriod(periods[i], periodTimeOffsetsUs[i]);
        }
    }

    public MediaPeriod getChildPeriod(int index) {
        return this.periods[index] instanceof TimeOffsetMediaPeriod ? ((TimeOffsetMediaPeriod)this.periods[index]).mediaPeriod : this.periods[index];
    }

    @Override
    public void prepare(MediaPeriod.Callback callback, long positionUs) {
        this.callback = callback;
        Collections.addAll(this.childrenPendingPreparation, this.periods);
        for (MediaPeriod period : this.periods) {
            period.prepare(this, positionUs);
        }
    }

    @Override
    public void maybeThrowPrepareError() throws IOException {
        for (MediaPeriod period : this.periods) {
            period.maybeThrowPrepareError();
        }
    }

    @Override
    public TrackGroupArray getTrackGroups() {
        return (TrackGroupArray)Assertions.checkNotNull((Object)this.trackGroups);
    }

    @Override
    public long selectTracks(@NullableType ExoTrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        int[] streamChildIndices = new int[selections.length];
        int[] selectionChildIndices = new int[selections.length];
        for (int i = 0; i < selections.length; ++i) {
            Integer streamChildIndex = streams[i] == null ? null : this.streamPeriodIndices.get(streams[i]);
            int n = streamChildIndices[i] = streamChildIndex == null ? -1 : streamChildIndex;
            if (selections[i] != null) {
                TrackGroup mergedTrackGroup = selections[i].getTrackGroup();
                selectionChildIndices[i] = Integer.parseInt(mergedTrackGroup.id.substring(0, mergedTrackGroup.id.indexOf(":")));
                continue;
            }
            selectionChildIndices[i] = -1;
        }
        this.streamPeriodIndices.clear();
        @NullableType SampleStream[] newStreams = new SampleStream[selections.length];
        @NullableType SampleStream[] childStreams = new SampleStream[selections.length];
        @NullableType ExoTrackSelection[] childSelections = new ExoTrackSelection[selections.length];
        ArrayList<MediaPeriod> enabledPeriodsList = new ArrayList<MediaPeriod>(this.periods.length);
        for (int i = 0; i < this.periods.length; ++i) {
            for (int j = 0; j < selections.length; ++j) {
                SampleStream sampleStream = childStreams[j] = streamChildIndices[j] == i ? streams[j] : null;
                if (selectionChildIndices[j] == i) {
                    ExoTrackSelection mergedTrackSelection = (ExoTrackSelection)Assertions.checkNotNull((Object)selections[j]);
                    TrackGroup mergedTrackGroup = mergedTrackSelection.getTrackGroup();
                    TrackGroup childTrackGroup = (TrackGroup)Assertions.checkNotNull((Object)this.childTrackGroupByMergedTrackGroup.get(mergedTrackGroup));
                    childSelections[j] = new ForwardingTrackSelection(mergedTrackSelection, childTrackGroup);
                    continue;
                }
                childSelections[j] = null;
            }
            long selectPositionUs = this.periods[i].selectTracks(childSelections, mayRetainStreamFlags, childStreams, streamResetFlags, positionUs);
            if (i == 0) {
                positionUs = selectPositionUs;
            } else if (selectPositionUs != positionUs) {
                throw new IllegalStateException("Children enabled at different positions.");
            }
            boolean periodEnabled = false;
            for (int j = 0; j < selections.length; ++j) {
                if (selectionChildIndices[j] == i) {
                    SampleStream childStream = (SampleStream)Assertions.checkNotNull((Object)childStreams[j]);
                    newStreams[j] = childStreams[j];
                    periodEnabled = true;
                    this.streamPeriodIndices.put(childStream, i);
                    continue;
                }
                if (streamChildIndices[j] != i) continue;
                Assertions.checkState((childStreams[j] == null ? 1 : 0) != 0);
            }
            if (!periodEnabled) continue;
            enabledPeriodsList.add(this.periods[i]);
        }
        System.arraycopy(newStreams, 0, streams, 0, newStreams.length);
        this.enabledPeriods = enabledPeriodsList.toArray(new MediaPeriod[0]);
        this.compositeSequenceableLoader = this.compositeSequenceableLoaderFactory.createCompositeSequenceableLoader(this.enabledPeriods);
        return positionUs;
    }

    @Override
    public void discardBuffer(long positionUs, boolean toKeyframe) {
        for (MediaPeriod period : this.enabledPeriods) {
            period.discardBuffer(positionUs, toKeyframe);
        }
    }

    @Override
    public void reevaluateBuffer(long positionUs) {
        this.compositeSequenceableLoader.reevaluateBuffer(positionUs);
    }

    @Override
    public boolean continueLoading(long positionUs) {
        if (!this.childrenPendingPreparation.isEmpty()) {
            int childrenPendingPreparationSize = this.childrenPendingPreparation.size();
            for (int i = 0; i < childrenPendingPreparationSize; ++i) {
                this.childrenPendingPreparation.get(i).continueLoading(positionUs);
            }
            return false;
        }
        return this.compositeSequenceableLoader.continueLoading(positionUs);
    }

    @Override
    public boolean isLoading() {
        return this.compositeSequenceableLoader.isLoading();
    }

    @Override
    public long getNextLoadPositionUs() {
        return this.compositeSequenceableLoader.getNextLoadPositionUs();
    }

    @Override
    public long readDiscontinuity() {
        long discontinuityUs = -9223372036854775807L;
        for (MediaPeriod period : this.enabledPeriods) {
            long otherDiscontinuityUs = period.readDiscontinuity();
            if (otherDiscontinuityUs != -9223372036854775807L) {
                if (discontinuityUs == -9223372036854775807L) {
                    discontinuityUs = otherDiscontinuityUs;
                    for (MediaPeriod previousPeriod : this.enabledPeriods) {
                        if (previousPeriod == period) break;
                        if (previousPeriod.seekToUs(discontinuityUs) == discontinuityUs) continue;
                        throw new IllegalStateException("Unexpected child seekToUs result.");
                    }
                    continue;
                }
                if (otherDiscontinuityUs == discontinuityUs) continue;
                throw new IllegalStateException("Conflicting discontinuities.");
            }
            if (discontinuityUs == -9223372036854775807L || period.seekToUs(discontinuityUs) == discontinuityUs) continue;
            throw new IllegalStateException("Unexpected child seekToUs result.");
        }
        return discontinuityUs;
    }

    @Override
    public long getBufferedPositionUs() {
        return this.compositeSequenceableLoader.getBufferedPositionUs();
    }

    @Override
    public long seekToUs(long positionUs) {
        positionUs = this.enabledPeriods[0].seekToUs(positionUs);
        for (int i = 1; i < this.enabledPeriods.length; ++i) {
            if (this.enabledPeriods[i].seekToUs(positionUs) == positionUs) continue;
            throw new IllegalStateException("Unexpected child seekToUs result.");
        }
        return positionUs;
    }

    @Override
    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        MediaPeriod queryPeriod = this.enabledPeriods.length > 0 ? this.enabledPeriods[0] : this.periods[0];
        return queryPeriod.getAdjustedSeekPositionUs(positionUs, seekParameters);
    }

    @Override
    public void onPrepared(MediaPeriod preparedPeriod) {
        this.childrenPendingPreparation.remove(preparedPeriod);
        if (!this.childrenPendingPreparation.isEmpty()) {
            return;
        }
        int totalTrackGroupCount = 0;
        for (MediaPeriod period : this.periods) {
            totalTrackGroupCount += period.getTrackGroups().length;
        }
        TrackGroup[] trackGroupArray = new TrackGroup[totalTrackGroupCount];
        int trackGroupIndex = 0;
        for (int i = 0; i < this.periods.length; ++i) {
            TrackGroupArray periodTrackGroups = this.periods[i].getTrackGroups();
            int periodTrackGroupCount = periodTrackGroups.length;
            for (int j = 0; j < periodTrackGroupCount; ++j) {
                TrackGroup childTrackGroup = periodTrackGroups.get(j);
                TrackGroup mergedTrackGroup = childTrackGroup.copyWithId(i + ":" + childTrackGroup.id);
                this.childTrackGroupByMergedTrackGroup.put(mergedTrackGroup, childTrackGroup);
                trackGroupArray[trackGroupIndex++] = mergedTrackGroup;
            }
        }
        this.trackGroups = new TrackGroupArray(trackGroupArray);
        ((MediaPeriod.Callback)Assertions.checkNotNull((Object)this.callback)).onPrepared(this);
    }

    @Override
    public void onContinueLoadingRequested(MediaPeriod ignored) {
        ((MediaPeriod.Callback)Assertions.checkNotNull((Object)this.callback)).onContinueLoadingRequested(this);
    }

    private static final class TimeOffsetMediaPeriod
    implements MediaPeriod,
    MediaPeriod.Callback {
        private final MediaPeriod mediaPeriod;
        private final long timeOffsetUs;
        private @MonotonicNonNull MediaPeriod.Callback callback;

        public TimeOffsetMediaPeriod(MediaPeriod mediaPeriod, long timeOffsetUs) {
            this.mediaPeriod = mediaPeriod;
            this.timeOffsetUs = timeOffsetUs;
        }

        @Override
        public void prepare(MediaPeriod.Callback callback, long positionUs) {
            this.callback = callback;
            this.mediaPeriod.prepare(this, positionUs - this.timeOffsetUs);
        }

        @Override
        public void maybeThrowPrepareError() throws IOException {
            this.mediaPeriod.maybeThrowPrepareError();
        }

        @Override
        public TrackGroupArray getTrackGroups() {
            return this.mediaPeriod.getTrackGroups();
        }

        @Override
        public List<StreamKey> getStreamKeys(List<ExoTrackSelection> trackSelections) {
            return this.mediaPeriod.getStreamKeys(trackSelections);
        }

        @Override
        public long selectTracks(@NullableType ExoTrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
            @NullableType SampleStream[] childStreams = new SampleStream[streams.length];
            for (int i = 0; i < streams.length; ++i) {
                TimeOffsetSampleStream sampleStream = (TimeOffsetSampleStream)streams[i];
                childStreams[i] = sampleStream != null ? sampleStream.getChildStream() : null;
            }
            long startPositionUs = this.mediaPeriod.selectTracks(selections, mayRetainStreamFlags, childStreams, streamResetFlags, positionUs - this.timeOffsetUs);
            for (int i = 0; i < streams.length; ++i) {
                SampleStream childStream = childStreams[i];
                if (childStream == null) {
                    streams[i] = null;
                    continue;
                }
                if (streams[i] != null && ((TimeOffsetSampleStream)streams[i]).getChildStream() == childStream) continue;
                streams[i] = new TimeOffsetSampleStream(childStream, this.timeOffsetUs);
            }
            return startPositionUs + this.timeOffsetUs;
        }

        @Override
        public void discardBuffer(long positionUs, boolean toKeyframe) {
            this.mediaPeriod.discardBuffer(positionUs - this.timeOffsetUs, toKeyframe);
        }

        @Override
        public long readDiscontinuity() {
            long discontinuityPositionUs = this.mediaPeriod.readDiscontinuity();
            return discontinuityPositionUs == -9223372036854775807L ? -9223372036854775807L : discontinuityPositionUs + this.timeOffsetUs;
        }

        @Override
        public long seekToUs(long positionUs) {
            return this.mediaPeriod.seekToUs(positionUs - this.timeOffsetUs) + this.timeOffsetUs;
        }

        @Override
        public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
            return this.mediaPeriod.getAdjustedSeekPositionUs(positionUs - this.timeOffsetUs, seekParameters) + this.timeOffsetUs;
        }

        @Override
        public long getBufferedPositionUs() {
            long bufferedPositionUs = this.mediaPeriod.getBufferedPositionUs();
            return bufferedPositionUs == Long.MIN_VALUE ? Long.MIN_VALUE : bufferedPositionUs + this.timeOffsetUs;
        }

        @Override
        public long getNextLoadPositionUs() {
            long nextLoadPositionUs = this.mediaPeriod.getNextLoadPositionUs();
            return nextLoadPositionUs == Long.MIN_VALUE ? Long.MIN_VALUE : nextLoadPositionUs + this.timeOffsetUs;
        }

        @Override
        public boolean continueLoading(long positionUs) {
            return this.mediaPeriod.continueLoading(positionUs - this.timeOffsetUs);
        }

        @Override
        public boolean isLoading() {
            return this.mediaPeriod.isLoading();
        }

        @Override
        public void reevaluateBuffer(long positionUs) {
            this.mediaPeriod.reevaluateBuffer(positionUs - this.timeOffsetUs);
        }

        @Override
        public void onPrepared(MediaPeriod mediaPeriod) {
            ((MediaPeriod.Callback)Assertions.checkNotNull((Object)this.callback)).onPrepared(this);
        }

        @Override
        public void onContinueLoadingRequested(MediaPeriod source) {
            ((MediaPeriod.Callback)Assertions.checkNotNull((Object)this.callback)).onContinueLoadingRequested(this);
        }
    }

    private static final class ForwardingTrackSelection
    implements ExoTrackSelection {
        private final ExoTrackSelection trackSelection;
        private final TrackGroup trackGroup;

        public ForwardingTrackSelection(ExoTrackSelection trackSelection, TrackGroup trackGroup) {
            this.trackSelection = trackSelection;
            this.trackGroup = trackGroup;
        }

        @Override
        public int getType() {
            return this.trackSelection.getType();
        }

        @Override
        public TrackGroup getTrackGroup() {
            return this.trackGroup;
        }

        @Override
        public int length() {
            return this.trackSelection.length();
        }

        @Override
        public Format getFormat(int index) {
            return this.trackSelection.getFormat(index);
        }

        @Override
        public int getIndexInTrackGroup(int index) {
            return this.trackSelection.getIndexInTrackGroup(index);
        }

        @Override
        public int indexOf(Format format) {
            return this.trackSelection.indexOf(format);
        }

        @Override
        public int indexOf(int indexInTrackGroup) {
            return this.trackSelection.indexOf(indexInTrackGroup);
        }

        @Override
        public void enable() {
            this.trackSelection.enable();
        }

        @Override
        public void disable() {
            this.trackSelection.disable();
        }

        @Override
        public Format getSelectedFormat() {
            return this.trackSelection.getSelectedFormat();
        }

        @Override
        public int getSelectedIndexInTrackGroup() {
            return this.trackSelection.getSelectedIndexInTrackGroup();
        }

        @Override
        public int getSelectedIndex() {
            return this.trackSelection.getSelectedIndex();
        }

        @Override
        public int getSelectionReason() {
            return this.trackSelection.getSelectionReason();
        }

        @Override
        @Nullable
        public Object getSelectionData() {
            return this.trackSelection.getSelectionData();
        }

        @Override
        public void onPlaybackSpeed(float playbackSpeed) {
            this.trackSelection.onPlaybackSpeed(playbackSpeed);
        }

        @Override
        public void onDiscontinuity() {
            this.trackSelection.onDiscontinuity();
        }

        @Override
        public void onRebuffer() {
            this.trackSelection.onRebuffer();
        }

        @Override
        public void onPlayWhenReadyChanged(boolean playWhenReady) {
            this.trackSelection.onPlayWhenReadyChanged(playWhenReady);
        }

        @Override
        public void updateSelectedTrack(long playbackPositionUs, long bufferedDurationUs, long availableDurationUs, List<? extends MediaChunk> queue, MediaChunkIterator[] mediaChunkIterators) {
            this.trackSelection.updateSelectedTrack(playbackPositionUs, bufferedDurationUs, availableDurationUs, queue, mediaChunkIterators);
        }

        @Override
        public int evaluateQueueSize(long playbackPositionUs, List<? extends MediaChunk> queue) {
            return this.trackSelection.evaluateQueueSize(playbackPositionUs, queue);
        }

        @Override
        public boolean shouldCancelChunkLoad(long playbackPositionUs, Chunk loadingChunk, List<? extends MediaChunk> queue) {
            return this.trackSelection.shouldCancelChunkLoad(playbackPositionUs, loadingChunk, queue);
        }

        @Override
        public boolean excludeTrack(int index, long exclusionDurationMs) {
            return this.trackSelection.excludeTrack(index, exclusionDurationMs);
        }

        @Override
        public boolean isTrackExcluded(int index, long nowMs) {
            return this.trackSelection.isTrackExcluded(index, nowMs);
        }

        @Override
        public long getLatestBitrateEstimate() {
            return this.trackSelection.getLatestBitrateEstimate();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ForwardingTrackSelection)) {
                return false;
            }
            ForwardingTrackSelection that = (ForwardingTrackSelection)o;
            return this.trackSelection.equals(that.trackSelection) && this.trackGroup.equals((Object)that.trackGroup);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.trackGroup.hashCode();
            result = 31 * result + this.trackSelection.hashCode();
            return result;
        }
    }

    private static final class TimeOffsetSampleStream
    implements SampleStream {
        private final SampleStream sampleStream;
        private final long timeOffsetUs;

        public TimeOffsetSampleStream(SampleStream sampleStream, long timeOffsetUs) {
            this.sampleStream = sampleStream;
            this.timeOffsetUs = timeOffsetUs;
        }

        public SampleStream getChildStream() {
            return this.sampleStream;
        }

        @Override
        public boolean isReady() {
            return this.sampleStream.isReady();
        }

        @Override
        public void maybeThrowError() throws IOException {
            this.sampleStream.maybeThrowError();
        }

        @Override
        public int readData(FormatHolder formatHolder, DecoderInputBuffer buffer, int readFlags) {
            int readResult = this.sampleStream.readData(formatHolder, buffer, readFlags);
            if (readResult == -4) {
                buffer.timeUs = Math.max(0L, buffer.timeUs + this.timeOffsetUs);
            }
            return readResult;
        }

        @Override
        public int skipData(long positionUs) {
            return this.sampleStream.skipData(positionUs - this.timeOffsetUs);
        }
    }
}

