/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.ClippingMediaPeriod;
import com.google.android.exoplayer2.source.CompositeMediaSource;
import com.google.android.exoplayer2.source.CompositeSequenceableLoaderFactory;
import com.google.android.exoplayer2.source.DefaultCompositeSequenceableLoaderFactory;
import com.google.android.exoplayer2.source.ForwardingTimeline;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MergingMediaPeriod;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Deprecated
public final class MergingMediaSource
extends CompositeMediaSource<Integer> {
    private static final int PERIOD_COUNT_UNSET = -1;
    private static final MediaItem PLACEHOLDER_MEDIA_ITEM = new MediaItem.Builder().setMediaId("MergingMediaSource").build();
    private final boolean adjustPeriodTimeOffsets;
    private final boolean clipDurations;
    private final MediaSource[] mediaSources;
    private final Timeline[] timelines;
    private final ArrayList<MediaSource> pendingTimelineSources;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    private final Map<Object, Long> clippedDurationsUs;
    private final Multimap<Object, ClippingMediaPeriod> clippedMediaPeriods;
    private int periodCount;
    private long[][] periodTimeOffsetsUs;
    @Nullable
    private IllegalMergeException mergeError;

    public MergingMediaSource(MediaSource ... mediaSources) {
        this(false, mediaSources);
    }

    public MergingMediaSource(boolean adjustPeriodTimeOffsets, MediaSource ... mediaSources) {
        this(adjustPeriodTimeOffsets, false, mediaSources);
    }

    public MergingMediaSource(boolean adjustPeriodTimeOffsets, boolean clipDurations, MediaSource ... mediaSources) {
        this(adjustPeriodTimeOffsets, clipDurations, new DefaultCompositeSequenceableLoaderFactory(), mediaSources);
    }

    public MergingMediaSource(boolean adjustPeriodTimeOffsets, boolean clipDurations, CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, MediaSource ... mediaSources) {
        this.adjustPeriodTimeOffsets = adjustPeriodTimeOffsets;
        this.clipDurations = clipDurations;
        this.mediaSources = mediaSources;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.pendingTimelineSources = new ArrayList<MediaSource>(Arrays.asList(mediaSources));
        this.periodCount = -1;
        this.timelines = new Timeline[mediaSources.length];
        this.periodTimeOffsetsUs = new long[0][];
        this.clippedDurationsUs = new HashMap<Object, Long>();
        this.clippedMediaPeriods = MultimapBuilder.hashKeys().arrayListValues().build();
    }

    @Override
    public MediaItem getMediaItem() {
        return this.mediaSources.length > 0 ? this.mediaSources[0].getMediaItem() : PLACEHOLDER_MEDIA_ITEM;
    }

    @Override
    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        super.prepareSourceInternal(mediaTransferListener);
        for (int i = 0; i < this.mediaSources.length; ++i) {
            this.prepareChildSource(i, this.mediaSources[i]);
        }
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() throws IOException {
        if (this.mergeError != null) {
            throw this.mergeError;
        }
        super.maybeThrowSourceInfoRefreshError();
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        MediaPeriod[] periods = new MediaPeriod[this.mediaSources.length];
        int periodIndex = this.timelines[0].getIndexOfPeriod(id.periodUid);
        for (int i = 0; i < periods.length; ++i) {
            MediaSource.MediaPeriodId childMediaPeriodId = id.copyWithPeriodUid(this.timelines[i].getUidOfPeriod(periodIndex));
            periods[i] = this.mediaSources[i].createPeriod(childMediaPeriodId, allocator, startPositionUs - this.periodTimeOffsetsUs[periodIndex][i]);
        }
        MediaPeriod mediaPeriod = new MergingMediaPeriod(this.compositeSequenceableLoaderFactory, this.periodTimeOffsetsUs[periodIndex], periods);
        if (this.clipDurations) {
            mediaPeriod = new ClippingMediaPeriod(mediaPeriod, true, 0L, (Long)Assertions.checkNotNull((Object)this.clippedDurationsUs.get(id.periodUid)));
            this.clippedMediaPeriods.put(id.periodUid, (Object)((ClippingMediaPeriod)mediaPeriod));
        }
        return mediaPeriod;
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        if (this.clipDurations) {
            ClippingMediaPeriod clippingMediaPeriod = (ClippingMediaPeriod)mediaPeriod;
            for (Map.Entry entry : this.clippedMediaPeriods.entries()) {
                if (!((ClippingMediaPeriod)entry.getValue()).equals(clippingMediaPeriod)) continue;
                this.clippedMediaPeriods.remove(entry.getKey(), entry.getValue());
                break;
            }
            mediaPeriod = clippingMediaPeriod.mediaPeriod;
        }
        MergingMediaPeriod mergingPeriod = (MergingMediaPeriod)mediaPeriod;
        for (int i = 0; i < this.mediaSources.length; ++i) {
            this.mediaSources[i].releasePeriod(mergingPeriod.getChildPeriod(i));
        }
    }

    @Override
    protected void releaseSourceInternal() {
        super.releaseSourceInternal();
        Arrays.fill(this.timelines, null);
        this.periodCount = -1;
        this.mergeError = null;
        this.pendingTimelineSources.clear();
        Collections.addAll(this.pendingTimelineSources, this.mediaSources);
    }

    @Override
    protected void onChildSourceInfoRefreshed(Integer childSourceId, MediaSource mediaSource, Timeline newTimeline) {
        if (this.mergeError != null) {
            return;
        }
        if (this.periodCount == -1) {
            this.periodCount = newTimeline.getPeriodCount();
        } else if (newTimeline.getPeriodCount() != this.periodCount) {
            this.mergeError = new IllegalMergeException(0);
            return;
        }
        if (this.periodTimeOffsetsUs.length == 0) {
            this.periodTimeOffsetsUs = new long[this.periodCount][this.timelines.length];
        }
        this.pendingTimelineSources.remove(mediaSource);
        this.timelines[childSourceId.intValue()] = newTimeline;
        if (this.pendingTimelineSources.isEmpty()) {
            if (this.adjustPeriodTimeOffsets) {
                this.computePeriodTimeOffsets();
            }
            Timeline mergedTimeline = this.timelines[0];
            if (this.clipDurations) {
                this.updateClippedDuration();
                mergedTimeline = new ClippedTimeline(mergedTimeline, this.clippedDurationsUs);
            }
            this.refreshSourceInfo(mergedTimeline);
        }
    }

    @Override
    @Nullable
    protected MediaSource.MediaPeriodId getMediaPeriodIdForChildMediaPeriodId(Integer childSourceId, MediaSource.MediaPeriodId mediaPeriodId) {
        return childSourceId == 0 ? mediaPeriodId : null;
    }

    private void computePeriodTimeOffsets() {
        Timeline.Period period = new Timeline.Period();
        for (int periodIndex = 0; periodIndex < this.periodCount; ++periodIndex) {
            long primaryWindowOffsetUs = -this.timelines[0].getPeriod(periodIndex, period).getPositionInWindowUs();
            for (int timelineIndex = 1; timelineIndex < this.timelines.length; ++timelineIndex) {
                long secondaryWindowOffsetUs = -this.timelines[timelineIndex].getPeriod(periodIndex, period).getPositionInWindowUs();
                this.periodTimeOffsetsUs[periodIndex][timelineIndex] = primaryWindowOffsetUs - secondaryWindowOffsetUs;
            }
        }
    }

    private void updateClippedDuration() {
        Timeline.Period period = new Timeline.Period();
        for (int periodIndex = 0; periodIndex < this.periodCount; ++periodIndex) {
            long minDurationUs = Long.MIN_VALUE;
            for (int timelineIndex = 0; timelineIndex < this.timelines.length; ++timelineIndex) {
                long durationUs = this.timelines[timelineIndex].getPeriod(periodIndex, period).getDurationUs();
                if (durationUs == -9223372036854775807L) continue;
                long adjustedDurationUs = durationUs + this.periodTimeOffsetsUs[periodIndex][timelineIndex];
                if (minDurationUs != Long.MIN_VALUE && adjustedDurationUs >= minDurationUs) continue;
                minDurationUs = adjustedDurationUs;
            }
            Object periodUid = this.timelines[0].getUidOfPeriod(periodIndex);
            this.clippedDurationsUs.put(periodUid, minDurationUs);
            for (ClippingMediaPeriod clippingMediaPeriod : this.clippedMediaPeriods.get(periodUid)) {
                clippingMediaPeriod.updateClipping(0L, minDurationUs);
            }
        }
    }

    public static final class IllegalMergeException
    extends IOException {
        public static final int REASON_PERIOD_COUNT_MISMATCH = 0;
        public final int reason;

        public IllegalMergeException(int reason) {
            this.reason = reason;
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.TYPE_USE})
        public static @interface Reason {
        }
    }

    private static final class ClippedTimeline
    extends ForwardingTimeline {
        private final long[] periodDurationsUs;
        private final long[] windowDurationsUs;

        public ClippedTimeline(Timeline timeline, Map<Object, Long> clippedDurationsUs) {
            super(timeline);
            int windowCount = timeline.getWindowCount();
            this.windowDurationsUs = new long[timeline.getWindowCount()];
            Timeline.Window window = new Timeline.Window();
            for (int i = 0; i < windowCount; ++i) {
                this.windowDurationsUs[i] = timeline.getWindow((int)i, (Timeline.Window)window).durationUs;
            }
            int periodCount = timeline.getPeriodCount();
            this.periodDurationsUs = new long[periodCount];
            Timeline.Period period = new Timeline.Period();
            for (int i = 0; i < periodCount; ++i) {
                timeline.getPeriod(i, period, true);
                long clippedDurationUs = (Long)Assertions.checkNotNull((Object)clippedDurationsUs.get(period.uid));
                long l = this.periodDurationsUs[i] = clippedDurationUs != Long.MIN_VALUE ? clippedDurationUs : period.durationUs;
                if (period.durationUs == -9223372036854775807L) continue;
                int n = period.windowIndex;
                this.windowDurationsUs[n] = this.windowDurationsUs[n] - (period.durationUs - this.periodDurationsUs[i]);
            }
        }

        @Override
        public Timeline.Window getWindow(int windowIndex, Timeline.Window window, long defaultPositionProjectionUs) {
            super.getWindow(windowIndex, window, defaultPositionProjectionUs);
            window.durationUs = this.windowDurationsUs[windowIndex];
            window.defaultPositionUs = window.durationUs == -9223372036854775807L || window.defaultPositionUs == -9223372036854775807L ? window.defaultPositionUs : Math.min(window.defaultPositionUs, window.durationUs);
            return window;
        }

        @Override
        public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
            super.getPeriod(periodIndex, period, setIds);
            period.durationUs = this.periodDurationsUs[periodIndex];
            return period;
        }
    }
}

