/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.decoder.CryptoInfo;
import com.google.android.exoplayer2.decoder.DecoderInputBuffer;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.SampleQueue;
import com.google.android.exoplayer2.upstream.Allocation;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

@Deprecated
class SampleDataQueue {
    private static final int INITIAL_SCRATCH_SIZE = 32;
    private final Allocator allocator;
    private final int allocationLength;
    private final ParsableByteArray scratch;
    private AllocationNode firstAllocationNode;
    private AllocationNode readAllocationNode;
    private AllocationNode writeAllocationNode;
    private long totalBytesWritten;

    public SampleDataQueue(Allocator allocator) {
        this.allocator = allocator;
        this.allocationLength = allocator.getIndividualAllocationLength();
        this.scratch = new ParsableByteArray(32);
        this.readAllocationNode = this.firstAllocationNode = new AllocationNode(0L, this.allocationLength);
        this.writeAllocationNode = this.firstAllocationNode;
    }

    public void reset() {
        this.clearAllocationNodes(this.firstAllocationNode);
        this.firstAllocationNode.reset(0L, this.allocationLength);
        this.readAllocationNode = this.firstAllocationNode;
        this.writeAllocationNode = this.firstAllocationNode;
        this.totalBytesWritten = 0L;
        this.allocator.trim();
    }

    public void discardUpstreamSampleBytes(long totalBytesWritten) {
        Assertions.checkArgument((totalBytesWritten <= this.totalBytesWritten ? 1 : 0) != 0);
        this.totalBytesWritten = totalBytesWritten;
        if (this.totalBytesWritten == 0L || this.totalBytesWritten == this.firstAllocationNode.startPosition) {
            this.clearAllocationNodes(this.firstAllocationNode);
            this.readAllocationNode = this.firstAllocationNode = new AllocationNode(this.totalBytesWritten, this.allocationLength);
            this.writeAllocationNode = this.firstAllocationNode;
        } else {
            AllocationNode lastNodeToKeep = this.firstAllocationNode;
            while (this.totalBytesWritten > lastNodeToKeep.endPosition) {
                lastNodeToKeep = lastNodeToKeep.next;
            }
            AllocationNode firstNodeToDiscard = (AllocationNode)Assertions.checkNotNull((Object)lastNodeToKeep.next);
            this.clearAllocationNodes(firstNodeToDiscard);
            lastNodeToKeep.next = new AllocationNode(lastNodeToKeep.endPosition, this.allocationLength);
            AllocationNode allocationNode = this.writeAllocationNode = this.totalBytesWritten == lastNodeToKeep.endPosition ? lastNodeToKeep.next : lastNodeToKeep;
            if (this.readAllocationNode == firstNodeToDiscard) {
                this.readAllocationNode = lastNodeToKeep.next;
            }
        }
    }

    public void rewind() {
        this.readAllocationNode = this.firstAllocationNode;
    }

    public void readToBuffer(DecoderInputBuffer buffer, SampleQueue.SampleExtrasHolder extrasHolder) {
        this.readAllocationNode = SampleDataQueue.readSampleData(this.readAllocationNode, buffer, extrasHolder, this.scratch);
    }

    public void peekToBuffer(DecoderInputBuffer buffer, SampleQueue.SampleExtrasHolder extrasHolder) {
        SampleDataQueue.readSampleData(this.readAllocationNode, buffer, extrasHolder, this.scratch);
    }

    public void discardDownstreamTo(long absolutePosition) {
        if (absolutePosition == -1L) {
            return;
        }
        while (absolutePosition >= this.firstAllocationNode.endPosition) {
            this.allocator.release(this.firstAllocationNode.allocation);
            this.firstAllocationNode = this.firstAllocationNode.clear();
        }
        if (this.readAllocationNode.startPosition < this.firstAllocationNode.startPosition) {
            this.readAllocationNode = this.firstAllocationNode;
        }
    }

    public long getTotalBytesWritten() {
        return this.totalBytesWritten;
    }

    public int sampleData(DataReader input, int length, boolean allowEndOfInput) throws IOException {
        length = this.preAppend(length);
        int bytesAppended = input.read(this.writeAllocationNode.allocation.data, this.writeAllocationNode.translateOffset(this.totalBytesWritten), length);
        if (bytesAppended == -1) {
            if (allowEndOfInput) {
                return -1;
            }
            throw new EOFException();
        }
        this.postAppend(bytesAppended);
        return bytesAppended;
    }

    public void sampleData(ParsableByteArray buffer, int length) {
        while (length > 0) {
            int bytesAppended = this.preAppend(length);
            buffer.readBytes(this.writeAllocationNode.allocation.data, this.writeAllocationNode.translateOffset(this.totalBytesWritten), bytesAppended);
            length -= bytesAppended;
            this.postAppend(bytesAppended);
        }
    }

    private void clearAllocationNodes(AllocationNode fromNode) {
        if (fromNode.allocation == null) {
            return;
        }
        this.allocator.release(fromNode);
        fromNode.clear();
    }

    private int preAppend(int length) {
        if (this.writeAllocationNode.allocation == null) {
            this.writeAllocationNode.initialize(this.allocator.allocate(), new AllocationNode(this.writeAllocationNode.endPosition, this.allocationLength));
        }
        return Math.min(length, (int)(this.writeAllocationNode.endPosition - this.totalBytesWritten));
    }

    private void postAppend(int length) {
        this.totalBytesWritten += (long)length;
        if (this.totalBytesWritten == this.writeAllocationNode.endPosition) {
            this.writeAllocationNode = this.writeAllocationNode.next;
        }
    }

    private static AllocationNode readSampleData(AllocationNode allocationNode, DecoderInputBuffer buffer, SampleQueue.SampleExtrasHolder extrasHolder, ParsableByteArray scratch) {
        if (buffer.isEncrypted()) {
            allocationNode = SampleDataQueue.readEncryptionData(allocationNode, buffer, extrasHolder, scratch);
        }
        if (buffer.hasSupplementalData()) {
            scratch.reset(4);
            allocationNode = SampleDataQueue.readData(allocationNode, extrasHolder.offset, scratch.getData(), 4);
            int sampleSize = scratch.readUnsignedIntToInt();
            extrasHolder.offset += 4L;
            extrasHolder.size -= 4;
            buffer.ensureSpaceForWrite(sampleSize);
            allocationNode = SampleDataQueue.readData(allocationNode, extrasHolder.offset, buffer.data, sampleSize);
            extrasHolder.offset += (long)sampleSize;
            extrasHolder.size -= sampleSize;
            buffer.resetSupplementalData(extrasHolder.size);
            allocationNode = SampleDataQueue.readData(allocationNode, extrasHolder.offset, buffer.supplementalData, extrasHolder.size);
        } else {
            buffer.ensureSpaceForWrite(extrasHolder.size);
            allocationNode = SampleDataQueue.readData(allocationNode, extrasHolder.offset, buffer.data, extrasHolder.size);
        }
        return allocationNode;
    }

    private static AllocationNode readEncryptionData(AllocationNode allocationNode, DecoderInputBuffer buffer, SampleQueue.SampleExtrasHolder extrasHolder, ParsableByteArray scratch) {
        int[] encryptedDataSizes;
        int subsampleCount;
        long offset = extrasHolder.offset;
        scratch.reset(1);
        allocationNode = SampleDataQueue.readData(allocationNode, offset, scratch.getData(), 1);
        ++offset;
        byte signalByte = scratch.getData()[0];
        boolean subsampleEncryption = (signalByte & 0x80) != 0;
        int ivSize = signalByte & 0x7F;
        CryptoInfo cryptoInfo = buffer.cryptoInfo;
        if (cryptoInfo.iv == null) {
            cryptoInfo.iv = new byte[16];
        } else {
            Arrays.fill(cryptoInfo.iv, (byte)0);
        }
        allocationNode = SampleDataQueue.readData(allocationNode, offset, cryptoInfo.iv, ivSize);
        offset += (long)ivSize;
        if (subsampleEncryption) {
            scratch.reset(2);
            allocationNode = SampleDataQueue.readData(allocationNode, offset, scratch.getData(), 2);
            offset += 2L;
            subsampleCount = scratch.readUnsignedShort();
        } else {
            subsampleCount = 1;
        }
        int[] clearDataSizes = cryptoInfo.numBytesOfClearData;
        if (clearDataSizes == null || clearDataSizes.length < subsampleCount) {
            clearDataSizes = new int[subsampleCount];
        }
        if ((encryptedDataSizes = cryptoInfo.numBytesOfEncryptedData) == null || encryptedDataSizes.length < subsampleCount) {
            encryptedDataSizes = new int[subsampleCount];
        }
        if (subsampleEncryption) {
            int subsampleDataLength = 6 * subsampleCount;
            scratch.reset(subsampleDataLength);
            allocationNode = SampleDataQueue.readData(allocationNode, offset, scratch.getData(), subsampleDataLength);
            offset += (long)subsampleDataLength;
            scratch.setPosition(0);
            for (int i = 0; i < subsampleCount; ++i) {
                clearDataSizes[i] = scratch.readUnsignedShort();
                encryptedDataSizes[i] = scratch.readUnsignedIntToInt();
            }
        } else {
            clearDataSizes[0] = 0;
            encryptedDataSizes[0] = extrasHolder.size - (int)(offset - extrasHolder.offset);
        }
        TrackOutput.CryptoData cryptoData = (TrackOutput.CryptoData)Util.castNonNull((Object)extrasHolder.cryptoData);
        cryptoInfo.set(subsampleCount, clearDataSizes, encryptedDataSizes, cryptoData.encryptionKey, cryptoInfo.iv, cryptoData.cryptoMode, cryptoData.encryptedBlocks, cryptoData.clearBlocks);
        int bytesRead = (int)(offset - extrasHolder.offset);
        extrasHolder.offset += (long)bytesRead;
        extrasHolder.size -= bytesRead;
        return allocationNode;
    }

    private static AllocationNode readData(AllocationNode allocationNode, long absolutePosition, ByteBuffer target, int length) {
        int toCopy;
        allocationNode = SampleDataQueue.getNodeContainingPosition(allocationNode, absolutePosition);
        for (int remaining = length; remaining > 0; remaining -= toCopy) {
            toCopy = Math.min(remaining, (int)(allocationNode.endPosition - absolutePosition));
            Allocation allocation = allocationNode.allocation;
            target.put(allocation.data, allocationNode.translateOffset(absolutePosition), toCopy);
            if ((absolutePosition += (long)toCopy) != allocationNode.endPosition) continue;
            allocationNode = allocationNode.next;
        }
        return allocationNode;
    }

    private static AllocationNode readData(AllocationNode allocationNode, long absolutePosition, byte[] target, int length) {
        int toCopy;
        allocationNode = SampleDataQueue.getNodeContainingPosition(allocationNode, absolutePosition);
        for (int remaining = length; remaining > 0; remaining -= toCopy) {
            toCopy = Math.min(remaining, (int)(allocationNode.endPosition - absolutePosition));
            Allocation allocation = allocationNode.allocation;
            System.arraycopy(allocation.data, allocationNode.translateOffset(absolutePosition), target, length - remaining, toCopy);
            if ((absolutePosition += (long)toCopy) != allocationNode.endPosition) continue;
            allocationNode = allocationNode.next;
        }
        return allocationNode;
    }

    private static AllocationNode getNodeContainingPosition(AllocationNode allocationNode, long absolutePosition) {
        while (absolutePosition >= allocationNode.endPosition) {
            allocationNode = allocationNode.next;
        }
        return allocationNode;
    }

    private static final class AllocationNode
    implements Allocator.AllocationNode {
        public long startPosition;
        public long endPosition;
        @Nullable
        public Allocation allocation;
        @Nullable
        public AllocationNode next;

        public AllocationNode(long startPosition, int allocationLength) {
            this.reset(startPosition, allocationLength);
        }

        public void reset(long startPosition, int allocationLength) {
            Assertions.checkState((this.allocation == null ? 1 : 0) != 0);
            this.startPosition = startPosition;
            this.endPosition = startPosition + (long)allocationLength;
        }

        public void initialize(Allocation allocation, AllocationNode next) {
            this.allocation = allocation;
            this.next = next;
        }

        public int translateOffset(long absolutePosition) {
            return (int)(absolutePosition - this.startPosition) + this.allocation.offset;
        }

        public AllocationNode clear() {
            this.allocation = null;
            AllocationNode temp = this.next;
            this.next = null;
            return temp;
        }

        @Override
        public Allocation getAllocation() {
            return (Allocation)Assertions.checkNotNull((Object)this.allocation);
        }

        @Override
        @Nullable
        public Allocator.AllocationNode next() {
            if (this.next == null || this.next.allocation == null) {
                return null;
            }
            return this.next;
        }
    }
}

