/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source;

import android.os.Bundle;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.util.BundleableUtil;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public final class TrackGroupArray
implements Bundleable {
    private static final String TAG = "TrackGroupArray";
    public static final TrackGroupArray EMPTY = new TrackGroupArray(new TrackGroup[0]);
    public final int length;
    private final ImmutableList<TrackGroup> trackGroups;
    private int hashCode;
    private static final String FIELD_TRACK_GROUPS = Util.intToStringMaxRadix((int)0);
    public static final Bundleable.Creator<TrackGroupArray> CREATOR = bundle -> {
        ArrayList trackGroupBundles = bundle.getParcelableArrayList(FIELD_TRACK_GROUPS);
        if (trackGroupBundles == null) {
            return new TrackGroupArray(new TrackGroup[0]);
        }
        return new TrackGroupArray((TrackGroup[])BundleableUtil.fromBundleList((Bundleable.Creator)TrackGroup.CREATOR, (List)trackGroupBundles).toArray((Object[])new TrackGroup[0]));
    };

    public TrackGroupArray(TrackGroup ... trackGroups) {
        this.trackGroups = ImmutableList.copyOf((Object[])trackGroups);
        this.length = trackGroups.length;
        this.verifyCorrectness();
    }

    public TrackGroup get(int index) {
        return (TrackGroup)this.trackGroups.get(index);
    }

    public int indexOf(TrackGroup group) {
        int index = this.trackGroups.indexOf((Object)group);
        return index >= 0 ? index : -1;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.trackGroups.hashCode();
        }
        return this.hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TrackGroupArray other = (TrackGroupArray)obj;
        return this.length == other.length && this.trackGroups.equals(other.trackGroups);
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList(FIELD_TRACK_GROUPS, BundleableUtil.toBundleArrayList(this.trackGroups));
        return bundle;
    }

    private void verifyCorrectness() {
        for (int i = 0; i < this.trackGroups.size(); ++i) {
            for (int j = i + 1; j < this.trackGroups.size(); ++j) {
                if (!((TrackGroup)this.trackGroups.get(i)).equals(this.trackGroups.get(j))) continue;
                Log.e((String)TAG, (String)"", (Throwable)new IllegalArgumentException("Multiple identical TrackGroups added to one TrackGroupArray."));
            }
        }
    }
}

