/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.ads;

import androidx.annotation.CheckResult;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaPeriodId;
import com.google.android.exoplayer2.source.ads.AdPlaybackState;
import com.google.android.exoplayer2.util.Util;

@Deprecated
public final class ServerSideAdInsertionUtil {
    private ServerSideAdInsertionUtil() {
    }

    @CheckResult
    public static AdPlaybackState addAdGroupToAdPlaybackState(AdPlaybackState adPlaybackState, long fromPositionUs, long contentResumeOffsetUs, long ... adDurationsUs) {
        int insertionIndex;
        long adGroupInsertionPositionUs = ServerSideAdInsertionUtil.getMediaPeriodPositionUsForContent(fromPositionUs, -1, adPlaybackState);
        for (insertionIndex = adPlaybackState.removedAdGroupCount; insertionIndex < adPlaybackState.adGroupCount && adPlaybackState.getAdGroup((int)insertionIndex).timeUs != Long.MIN_VALUE && adPlaybackState.getAdGroup((int)insertionIndex).timeUs <= adGroupInsertionPositionUs; ++insertionIndex) {
        }
        adPlaybackState = adPlaybackState.withNewAdGroup(insertionIndex, adGroupInsertionPositionUs).withIsServerSideInserted(insertionIndex, true).withAdCount(insertionIndex, adDurationsUs.length).withAdDurationsUs(insertionIndex, adDurationsUs).withContentResumeOffsetUs(insertionIndex, contentResumeOffsetUs);
        int adIndex = 0;
        while (adIndex < adDurationsUs.length && adDurationsUs[adIndex] == 0L) {
            adPlaybackState = adPlaybackState.withSkippedAd(insertionIndex, adIndex++);
        }
        return ServerSideAdInsertionUtil.correctFollowingAdGroupTimes(adPlaybackState, insertionIndex, Util.sum((long[])adDurationsUs), contentResumeOffsetUs);
    }

    public static long getStreamPositionUs(Player player, AdPlaybackState adPlaybackState) {
        Timeline timeline = player.getCurrentTimeline();
        if (timeline.isEmpty()) {
            return -9223372036854775807L;
        }
        Timeline.Period period = timeline.getPeriod(player.getCurrentPeriodIndex(), new Timeline.Period());
        if (!Util.areEqual((Object)period.getAdsId(), (Object)adPlaybackState.adsId)) {
            return -9223372036854775807L;
        }
        if (player.isPlayingAd()) {
            int adGroupIndex = player.getCurrentAdGroupIndex();
            int adIndexInAdGroup = player.getCurrentAdIndexInAdGroup();
            long adPositionUs = Util.msToUs((long)player.getCurrentPosition());
            return ServerSideAdInsertionUtil.getStreamPositionUsForAd(adPositionUs, adGroupIndex, adIndexInAdGroup, adPlaybackState);
        }
        long periodPositionUs = Util.msToUs((long)player.getCurrentPosition()) - period.getPositionInWindowUs();
        return ServerSideAdInsertionUtil.getStreamPositionUsForContent(periodPositionUs, -1, adPlaybackState);
    }

    public static long getStreamPositionUs(long positionUs, MediaPeriodId mediaPeriodId, AdPlaybackState adPlaybackState) {
        return mediaPeriodId.isAd() ? ServerSideAdInsertionUtil.getStreamPositionUsForAd(positionUs, mediaPeriodId.adGroupIndex, mediaPeriodId.adIndexInAdGroup, adPlaybackState) : ServerSideAdInsertionUtil.getStreamPositionUsForContent(positionUs, mediaPeriodId.nextAdGroupIndex, adPlaybackState);
    }

    public static long getMediaPeriodPositionUs(long positionUs, MediaPeriodId mediaPeriodId, AdPlaybackState adPlaybackState) {
        return mediaPeriodId.isAd() ? ServerSideAdInsertionUtil.getMediaPeriodPositionUsForAd(positionUs, mediaPeriodId.adGroupIndex, mediaPeriodId.adIndexInAdGroup, adPlaybackState) : ServerSideAdInsertionUtil.getMediaPeriodPositionUsForContent(positionUs, mediaPeriodId.nextAdGroupIndex, adPlaybackState);
    }

    public static long getStreamPositionUsForAd(long positionUs, int adGroupIndex, int adIndexInAdGroup, AdPlaybackState adPlaybackState) {
        int i;
        AdPlaybackState.AdGroup currentAdGroup = adPlaybackState.getAdGroup(adGroupIndex);
        positionUs += currentAdGroup.timeUs;
        for (i = adPlaybackState.removedAdGroupCount; i < adGroupIndex; ++i) {
            AdPlaybackState.AdGroup adGroup = adPlaybackState.getAdGroup(i);
            for (int j = 0; j < ServerSideAdInsertionUtil.getAdCountInGroup(adPlaybackState, i); ++j) {
                positionUs += adGroup.durationsUs[j];
            }
            positionUs -= adGroup.contentResumeOffsetUs;
        }
        if (adIndexInAdGroup < ServerSideAdInsertionUtil.getAdCountInGroup(adPlaybackState, adGroupIndex)) {
            for (i = 0; i < adIndexInAdGroup; ++i) {
                positionUs += currentAdGroup.durationsUs[i];
            }
        }
        return positionUs;
    }

    public static long getMediaPeriodPositionUsForAd(long positionUs, int adGroupIndex, int adIndexInAdGroup, AdPlaybackState adPlaybackState) {
        int i;
        AdPlaybackState.AdGroup currentAdGroup = adPlaybackState.getAdGroup(adGroupIndex);
        positionUs -= currentAdGroup.timeUs;
        for (i = adPlaybackState.removedAdGroupCount; i < adGroupIndex; ++i) {
            AdPlaybackState.AdGroup adGroup = adPlaybackState.getAdGroup(i);
            for (int j = 0; j < ServerSideAdInsertionUtil.getAdCountInGroup(adPlaybackState, i); ++j) {
                positionUs -= adGroup.durationsUs[j];
            }
            positionUs += adGroup.contentResumeOffsetUs;
        }
        if (adIndexInAdGroup < ServerSideAdInsertionUtil.getAdCountInGroup(adPlaybackState, adGroupIndex)) {
            for (i = 0; i < adIndexInAdGroup; ++i) {
                positionUs -= currentAdGroup.durationsUs[i];
            }
        }
        return positionUs;
    }

    public static long getStreamPositionUsForContent(long positionUs, int nextAdGroupIndex, AdPlaybackState adPlaybackState) {
        long totalAdDurationBeforePositionUs = 0L;
        if (nextAdGroupIndex == -1) {
            nextAdGroupIndex = adPlaybackState.adGroupCount;
        }
        for (int i = adPlaybackState.removedAdGroupCount; i < nextAdGroupIndex; ++i) {
            AdPlaybackState.AdGroup adGroup = adPlaybackState.getAdGroup(i);
            if (adGroup.timeUs == Long.MIN_VALUE || adGroup.timeUs > positionUs) break;
            long adGroupStreamStartPositionUs = adGroup.timeUs + totalAdDurationBeforePositionUs;
            for (int j = 0; j < ServerSideAdInsertionUtil.getAdCountInGroup(adPlaybackState, i); ++j) {
                totalAdDurationBeforePositionUs += adGroup.durationsUs[j];
            }
            totalAdDurationBeforePositionUs -= adGroup.contentResumeOffsetUs;
            long adGroupResumePositionUs = adGroup.timeUs + adGroup.contentResumeOffsetUs;
            if (adGroupResumePositionUs <= positionUs) continue;
            return Math.max(adGroupStreamStartPositionUs, positionUs + totalAdDurationBeforePositionUs);
        }
        return positionUs + totalAdDurationBeforePositionUs;
    }

    public static long getMediaPeriodPositionUsForContent(long positionUs, int nextAdGroupIndex, AdPlaybackState adPlaybackState) {
        long totalAdDurationBeforePositionUs = 0L;
        if (nextAdGroupIndex == -1) {
            nextAdGroupIndex = adPlaybackState.adGroupCount;
        }
        for (int i = adPlaybackState.removedAdGroupCount; i < nextAdGroupIndex; ++i) {
            AdPlaybackState.AdGroup adGroup = adPlaybackState.getAdGroup(i);
            if (adGroup.timeUs == Long.MIN_VALUE || adGroup.timeUs > positionUs - totalAdDurationBeforePositionUs) break;
            for (int j = 0; j < ServerSideAdInsertionUtil.getAdCountInGroup(adPlaybackState, i); ++j) {
                totalAdDurationBeforePositionUs += adGroup.durationsUs[j];
            }
            long adGroupResumePositionUs = adGroup.timeUs + adGroup.contentResumeOffsetUs;
            if (adGroupResumePositionUs <= positionUs - (totalAdDurationBeforePositionUs -= adGroup.contentResumeOffsetUs)) continue;
            return Math.max(adGroup.timeUs, positionUs - totalAdDurationBeforePositionUs);
        }
        return positionUs - totalAdDurationBeforePositionUs;
    }

    public static int getAdCountInGroup(AdPlaybackState adPlaybackState, int adGroupIndex) {
        AdPlaybackState.AdGroup adGroup = adPlaybackState.getAdGroup(adGroupIndex);
        return adGroup.count == -1 ? 0 : adGroup.count;
    }

    private static AdPlaybackState correctFollowingAdGroupTimes(AdPlaybackState adPlaybackState, int adGroupInsertionIndex, long insertedAdDurationUs, long addedContentResumeOffsetUs) {
        long followingAdGroupTimeUsOffset = -insertedAdDurationUs + addedContentResumeOffsetUs;
        for (int i = adGroupInsertionIndex + 1; i < adPlaybackState.adGroupCount; ++i) {
            long adGroupTimeUs = adPlaybackState.getAdGroup((int)i).timeUs;
            if (adGroupTimeUs == Long.MIN_VALUE) continue;
            adPlaybackState = adPlaybackState.withAdGroupTimeUs(i, adGroupTimeUs + followingAdGroupTimeUsOffset);
        }
        return adPlaybackState;
    }
}

