/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.mediaparser;

import android.annotation.SuppressLint;
import android.media.DrmInitData;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaParser;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.drm.DrmInitData;
import com.google.android.exoplayer2.extractor.ChunkIndex;
import com.google.android.exoplayer2.extractor.DummyExtractorOutput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.SeekPoint;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MediaFormatUtil;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.compatqual.NullableType;

@Deprecated
@RequiresApi(value=30)
@SuppressLint(value={"Override"})
public final class OutputConsumerAdapterV30
implements MediaParser.OutputConsumer {
    private static final String TAG = "OConsumerAdapterV30";
    private static final Pair<MediaParser.SeekPoint, MediaParser.SeekPoint> SEEK_POINT_PAIR_START = Pair.create((Object)MediaParser.SeekPoint.START, (Object)MediaParser.SeekPoint.START);
    private static final String MEDIA_FORMAT_KEY_TRACK_TYPE = "track-type-string";
    private static final String MEDIA_FORMAT_KEY_CHUNK_INDEX_SIZES = "chunk-index-int-sizes";
    private static final String MEDIA_FORMAT_KEY_CHUNK_INDEX_OFFSETS = "chunk-index-long-offsets";
    private static final String MEDIA_FORMAT_KEY_CHUNK_INDEX_DURATIONS = "chunk-index-long-us-durations";
    private static final String MEDIA_FORMAT_KEY_CHUNK_INDEX_TIMES = "chunk-index-long-us-times";
    private static final Pattern REGEX_CRYPTO_INFO_PATTERN = Pattern.compile("pattern \\(encrypt: (\\d+), skip: (\\d+)\\)");
    private final ArrayList<@NullableType TrackOutput> trackOutputs;
    private final ArrayList<@NullableType Format> trackFormats;
    private final ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
     @NullableType MediaCodec.CryptoInfo> lastReceivedCryptoInfos;
    private final ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
    @NullableType TrackOutput.CryptoData> lastOutputCryptoDatas;
    private final DataReaderAdapter scratchDataReaderAdapter;
    private final boolean expectDummySeekMap;
    private final int primaryTrackType;
    @Nullable
    private final Format primaryTrackManifestFormat;
    private ExtractorOutput extractorOutput;
    @Nullable
    private MediaParser.SeekMap dummySeekMap;
    @Nullable
    private MediaParser.SeekMap lastSeekMap;
    @Nullable
    private String containerMimeType;
    @Nullable
    private ChunkIndex lastChunkIndex;
    @Nullable
    private TimestampAdjuster timestampAdjuster;
    private List<Format> muxedCaptionFormats;
    private int primaryTrackIndex;
    private long sampleTimestampUpperLimitFilterUs;
    private boolean tracksFoundCalled;
    private boolean tracksEnded;
    private boolean seekingDisabled;

    public OutputConsumerAdapterV30() {
        this(null, -2, false);
    }

    public OutputConsumerAdapterV30(@Nullable Format primaryTrackManifestFormat, int primaryTrackType, boolean expectDummySeekMap) {
        this.expectDummySeekMap = expectDummySeekMap;
        this.primaryTrackManifestFormat = primaryTrackManifestFormat;
        this.primaryTrackType = primaryTrackType;
        this.trackOutputs = new ArrayList();
        this.trackFormats = new ArrayList();
        this.lastReceivedCryptoInfos = new ArrayList();
        this.lastOutputCryptoDatas = new ArrayList();
        this.scratchDataReaderAdapter = new DataReaderAdapter();
        this.extractorOutput = new DummyExtractorOutput();
        this.sampleTimestampUpperLimitFilterUs = -9223372036854775807L;
        this.muxedCaptionFormats = ImmutableList.of();
    }

    public void setSampleTimestampUpperLimitFilterUs(long sampleTimestampUpperLimitFilterUs) {
        this.sampleTimestampUpperLimitFilterUs = sampleTimestampUpperLimitFilterUs;
    }

    public void setTimestampAdjuster(TimestampAdjuster timestampAdjuster) {
        this.timestampAdjuster = timestampAdjuster;
    }

    public void setExtractorOutput(ExtractorOutput extractorOutput) {
        this.extractorOutput = extractorOutput;
    }

    public void setMuxedCaptionFormats(List<Format> muxedCaptionFormats) {
        this.muxedCaptionFormats = muxedCaptionFormats;
    }

    public void disableSeeking() {
        this.seekingDisabled = true;
    }

    @Nullable
    public MediaParser.SeekMap getDummySeekMap() {
        return this.dummySeekMap;
    }

    @Nullable
    public ChunkIndex getChunkIndex() {
        return this.lastChunkIndex;
    }

    public Pair<MediaParser.SeekPoint, MediaParser.SeekPoint> getSeekPoints(long seekTimeUs) {
        return this.lastSeekMap != null ? this.lastSeekMap.getSeekPoints(seekTimeUs) : SEEK_POINT_PAIR_START;
    }

    public void setSelectedParserName(String parserName) {
        this.containerMimeType = OutputConsumerAdapterV30.getMimeType(parserName);
    }

    @Nullable
    public Format[] getSampleFormats() {
        if (!this.tracksFoundCalled) {
            return null;
        }
        Format[] sampleFormats = new Format[this.trackFormats.size()];
        for (int i = 0; i < this.trackFormats.size(); ++i) {
            sampleFormats[i] = (Format)Assertions.checkNotNull((Object)this.trackFormats.get(i));
        }
        return sampleFormats;
    }

    public void onTrackCountFound(int numberOfTracks) {
        this.tracksFoundCalled = true;
        this.maybeEndTracks();
    }

    public void onSeekMapFound(MediaParser.SeekMap seekMap) {
        if (this.expectDummySeekMap && this.dummySeekMap == null) {
            this.dummySeekMap = seekMap;
        } else {
            this.lastSeekMap = seekMap;
            long durationUs = seekMap.getDurationMicros();
            this.extractorOutput.seekMap((SeekMap)(this.seekingDisabled ? new SeekMap.Unseekable(durationUs != Integer.MIN_VALUE ? durationUs : -9223372036854775807L) : new SeekMapAdapter(seekMap)));
        }
    }

    public void onTrackDataFound(int trackIndex, MediaParser.TrackData trackData) {
        if (this.maybeObtainChunkIndex(trackData.mediaFormat)) {
            return;
        }
        this.ensureSpaceForTrackIndex(trackIndex);
        TrackOutput trackOutput = this.trackOutputs.get(trackIndex);
        if (trackOutput == null) {
            String trackTypeString = trackData.mediaFormat.getString(MEDIA_FORMAT_KEY_TRACK_TYPE);
            int trackType = OutputConsumerAdapterV30.toTrackTypeConstant(trackTypeString != null ? trackTypeString : trackData.mediaFormat.getString("mime"));
            if (trackType == this.primaryTrackType) {
                this.primaryTrackIndex = trackIndex;
            }
            trackOutput = this.extractorOutput.track(trackIndex, trackType);
            this.trackOutputs.set(trackIndex, trackOutput);
            if (trackTypeString != null) {
                return;
            }
        }
        Format format = this.toExoPlayerFormat(trackData);
        trackOutput.format(this.primaryTrackManifestFormat != null && trackIndex == this.primaryTrackIndex ? format.withManifestFormatInfo(this.primaryTrackManifestFormat) : format);
        this.trackFormats.set(trackIndex, format);
        this.maybeEndTracks();
    }

    public void onSampleDataFound(int trackIndex, MediaParser.InputReader sampleData) throws IOException {
        this.ensureSpaceForTrackIndex(trackIndex);
        this.scratchDataReaderAdapter.input = sampleData;
        TrackOutput trackOutput = this.trackOutputs.get(trackIndex);
        if (trackOutput == null) {
            trackOutput = this.extractorOutput.track(trackIndex, -1);
            this.trackOutputs.set(trackIndex, trackOutput);
        }
        trackOutput.sampleData((DataReader)this.scratchDataReaderAdapter, (int)sampleData.getLength(), true);
    }

    public void onSampleCompleted(int trackIndex, long timeUs, int flags, int size, int offset, @Nullable MediaCodec.CryptoInfo cryptoInfo) {
        if (this.sampleTimestampUpperLimitFilterUs != -9223372036854775807L && timeUs >= this.sampleTimestampUpperLimitFilterUs) {
            return;
        }
        if (this.timestampAdjuster != null) {
            timeUs = this.timestampAdjuster.adjustSampleTimestamp(timeUs);
        }
        ((TrackOutput)Assertions.checkNotNull((Object)this.trackOutputs.get(trackIndex))).sampleMetadata(timeUs, flags, size, offset, this.toExoPlayerCryptoData(trackIndex, cryptoInfo));
    }

    private boolean maybeObtainChunkIndex(MediaFormat mediaFormat) {
        ByteBuffer chunkIndexSizesByteBuffer = mediaFormat.getByteBuffer(MEDIA_FORMAT_KEY_CHUNK_INDEX_SIZES);
        if (chunkIndexSizesByteBuffer == null) {
            return false;
        }
        IntBuffer chunkIndexSizes = chunkIndexSizesByteBuffer.asIntBuffer();
        LongBuffer chunkIndexOffsets = ((ByteBuffer)Assertions.checkNotNull((Object)mediaFormat.getByteBuffer(MEDIA_FORMAT_KEY_CHUNK_INDEX_OFFSETS))).asLongBuffer();
        LongBuffer chunkIndexDurationsUs = ((ByteBuffer)Assertions.checkNotNull((Object)mediaFormat.getByteBuffer(MEDIA_FORMAT_KEY_CHUNK_INDEX_DURATIONS))).asLongBuffer();
        LongBuffer chunkIndexTimesUs = ((ByteBuffer)Assertions.checkNotNull((Object)mediaFormat.getByteBuffer(MEDIA_FORMAT_KEY_CHUNK_INDEX_TIMES))).asLongBuffer();
        int[] sizes = new int[chunkIndexSizes.remaining()];
        long[] offsets = new long[chunkIndexOffsets.remaining()];
        long[] durationsUs = new long[chunkIndexDurationsUs.remaining()];
        long[] timesUs = new long[chunkIndexTimesUs.remaining()];
        chunkIndexSizes.get(sizes);
        chunkIndexOffsets.get(offsets);
        chunkIndexDurationsUs.get(durationsUs);
        chunkIndexTimesUs.get(timesUs);
        this.lastChunkIndex = new ChunkIndex(sizes, offsets, durationsUs, timesUs);
        this.extractorOutput.seekMap((SeekMap)this.lastChunkIndex);
        return true;
    }

    private void ensureSpaceForTrackIndex(int trackIndex) {
        for (int i = this.trackOutputs.size(); i <= trackIndex; ++i) {
            this.trackOutputs.add(null);
            this.trackFormats.add(null);
            this.lastReceivedCryptoInfos.add(null);
            this.lastOutputCryptoDatas.add(null);
        }
    }

    @Nullable
    private TrackOutput.CryptoData toExoPlayerCryptoData(int trackIndex, @Nullable MediaCodec.CryptoInfo cryptoInfo) {
        TrackOutput.CryptoData cryptoDataToOutput;
        if (cryptoInfo == null) {
            return null;
        }
        MediaCodec.CryptoInfo lastReceivedCryptoInfo = this.lastReceivedCryptoInfos.get(trackIndex);
        if (lastReceivedCryptoInfo == cryptoInfo) {
            cryptoDataToOutput = (TrackOutput.CryptoData)Assertions.checkNotNull((Object)this.lastOutputCryptoDatas.get(trackIndex));
        } else {
            int clearBlocks;
            int encryptedBlocks;
            try {
                Matcher matcher = REGEX_CRYPTO_INFO_PATTERN.matcher(cryptoInfo.toString());
                matcher.find();
                encryptedBlocks = Integer.parseInt((String)Util.castNonNull((Object)matcher.group(1)));
                clearBlocks = Integer.parseInt((String)Util.castNonNull((Object)matcher.group(2)));
            }
            catch (RuntimeException e) {
                Log.e((String)TAG, (String)("Unexpected error while parsing CryptoInfo: " + cryptoInfo), (Throwable)e);
                encryptedBlocks = 0;
                clearBlocks = 0;
            }
            cryptoDataToOutput = new TrackOutput.CryptoData(cryptoInfo.mode, cryptoInfo.key, encryptedBlocks, clearBlocks);
            this.lastReceivedCryptoInfos.set(trackIndex, cryptoInfo);
            this.lastOutputCryptoDatas.set(trackIndex, cryptoDataToOutput);
        }
        return cryptoDataToOutput;
    }

    private void maybeEndTracks() {
        if (!this.tracksFoundCalled || this.tracksEnded) {
            return;
        }
        int size = this.trackOutputs.size();
        for (int i = 0; i < size; ++i) {
            if (this.trackOutputs.get(i) != null) continue;
            return;
        }
        this.extractorOutput.endTracks();
        this.tracksEnded = true;
    }

    private static int toTrackTypeConstant(@Nullable String string) {
        if (string == null) {
            return -1;
        }
        switch (string) {
            case "audio": {
                return 1;
            }
            case "video": {
                return 2;
            }
            case "text": {
                return 3;
            }
            case "metadata": {
                return 5;
            }
            case "unknown": {
                return -1;
            }
        }
        return MimeTypes.getTrackType((String)string);
    }

    private Format toExoPlayerFormat(MediaParser.TrackData trackData) {
        MediaFormat mediaFormat = trackData.mediaFormat;
        String mediaFormatMimeType = mediaFormat.getString("mime");
        int mediaFormatAccessibilityChannel = mediaFormat.getInteger("caption-service-number", -1);
        Format.Builder formatBuilder = new Format.Builder().setDrmInitData(OutputConsumerAdapterV30.toExoPlayerDrmInitData(mediaFormat.getString("crypto-mode-fourcc"), trackData.drmInitData)).setContainerMimeType(this.containerMimeType).setPeakBitrate(mediaFormat.getInteger("bitrate", -1)).setChannelCount(mediaFormat.getInteger("channel-count", -1)).setColorInfo(MediaFormatUtil.getColorInfo((MediaFormat)mediaFormat)).setSampleMimeType(mediaFormatMimeType).setCodecs(mediaFormat.getString("codecs-string")).setFrameRate(mediaFormat.getFloat("frame-rate", -1.0f)).setWidth(mediaFormat.getInteger("width", -1)).setHeight(mediaFormat.getInteger("height", -1)).setInitializationData(OutputConsumerAdapterV30.getInitializationData(mediaFormat)).setLanguage(mediaFormat.getString("language")).setMaxInputSize(mediaFormat.getInteger("max-input-size", -1)).setPcmEncoding(mediaFormat.getInteger("exo-pcm-encoding", -1)).setRotationDegrees(mediaFormat.getInteger("rotation-degrees", 0)).setSampleRate(mediaFormat.getInteger("sample-rate", -1)).setSelectionFlags(OutputConsumerAdapterV30.getSelectionFlags(mediaFormat)).setEncoderDelay(mediaFormat.getInteger("encoder-delay", 0)).setEncoderPadding(mediaFormat.getInteger("encoder-padding", 0)).setPixelWidthHeightRatio(mediaFormat.getFloat("pixel-width-height-ratio-float", 1.0f)).setSubsampleOffsetUs(mediaFormat.getLong("subsample-offset-us-long", Long.MAX_VALUE)).setAccessibilityChannel(mediaFormatAccessibilityChannel);
        for (int i = 0; i < this.muxedCaptionFormats.size(); ++i) {
            Format muxedCaptionFormat = this.muxedCaptionFormats.get(i);
            if (!Util.areEqual((Object)muxedCaptionFormat.sampleMimeType, (Object)mediaFormatMimeType) || muxedCaptionFormat.accessibilityChannel != mediaFormatAccessibilityChannel) continue;
            formatBuilder.setLanguage(muxedCaptionFormat.language).setRoleFlags(muxedCaptionFormat.roleFlags).setSelectionFlags(muxedCaptionFormat.selectionFlags).setLabel(muxedCaptionFormat.label).setMetadata(muxedCaptionFormat.metadata);
            break;
        }
        return formatBuilder.build();
    }

    @Nullable
    private static com.google.android.exoplayer2.drm.DrmInitData toExoPlayerDrmInitData(@Nullable String schemeType, @Nullable DrmInitData drmInitData) {
        if (drmInitData == null) {
            return null;
        }
        DrmInitData.SchemeData[] schemeDatas = new DrmInitData.SchemeData[drmInitData.getSchemeInitDataCount()];
        for (int i = 0; i < schemeDatas.length; ++i) {
            DrmInitData.SchemeInitData schemeInitData = drmInitData.getSchemeInitDataAt(i);
            schemeDatas[i] = new DrmInitData.SchemeData(schemeInitData.uuid, schemeInitData.mimeType, schemeInitData.data);
        }
        return new com.google.android.exoplayer2.drm.DrmInitData(schemeType, schemeDatas);
    }

    private static int getSelectionFlags(MediaFormat mediaFormat) {
        int selectionFlags = 0;
        selectionFlags |= OutputConsumerAdapterV30.getFlag(mediaFormat, "is-autoselect", 4);
        selectionFlags |= OutputConsumerAdapterV30.getFlag(mediaFormat, "is-default", 1);
        return selectionFlags |= OutputConsumerAdapterV30.getFlag(mediaFormat, "is-forced-subtitle", 2);
    }

    private static int getFlag(MediaFormat mediaFormat, String key, int returnValueIfPresent) {
        return mediaFormat.getInteger(key, 0) != 0 ? returnValueIfPresent : 0;
    }

    private static List<byte[]> getInitializationData(MediaFormat mediaFormat) {
        ByteBuffer byteBuffer;
        ArrayList<byte[]> initData = new ArrayList<byte[]>();
        int i = 0;
        while ((byteBuffer = mediaFormat.getByteBuffer("csd-" + i++)) != null) {
            initData.add(MediaFormatUtil.getArray((ByteBuffer)byteBuffer));
        }
        return initData;
    }

    private static String getMimeType(String parserName) {
        switch (parserName) {
            case "android.media.mediaparser.MatroskaParser": {
                return "video/webm";
            }
            case "android.media.mediaparser.FragmentedMp4Parser": 
            case "android.media.mediaparser.Mp4Parser": {
                return "video/mp4";
            }
            case "android.media.mediaparser.Mp3Parser": {
                return "audio/mpeg";
            }
            case "android.media.mediaparser.AdtsParser": {
                return "audio/mp4a-latm";
            }
            case "android.media.mediaparser.Ac3Parser": {
                return "audio/ac3";
            }
            case "android.media.mediaparser.TsParser": {
                return "video/mp2t";
            }
            case "android.media.mediaparser.FlvParser": {
                return "video/x-flv";
            }
            case "android.media.mediaparser.OggParser": {
                return "audio/ogg";
            }
            case "android.media.mediaparser.PsParser": {
                return "video/mp2p";
            }
            case "android.media.mediaparser.WavParser": {
                return "audio/raw";
            }
            case "android.media.mediaparser.AmrParser": {
                return "audio/amr";
            }
            case "android.media.mediaparser.Ac4Parser": {
                return "audio/ac4";
            }
            case "android.media.mediaparser.FlacParser": {
                return "audio/flac";
            }
        }
        throw new IllegalArgumentException("Illegal parser name: " + parserName);
    }

    private static final class DataReaderAdapter
    implements DataReader {
        @Nullable
        public MediaParser.InputReader input;

        private DataReaderAdapter() {
        }

        public int read(byte[] buffer, int offset, int length) throws IOException {
            return ((MediaParser.InputReader)Util.castNonNull((Object)this.input)).read(buffer, offset, length);
        }
    }

    private static final class SeekMapAdapter
    implements SeekMap {
        private final MediaParser.SeekMap adaptedSeekMap;

        public SeekMapAdapter(MediaParser.SeekMap adaptedSeekMap) {
            this.adaptedSeekMap = adaptedSeekMap;
        }

        public boolean isSeekable() {
            return this.adaptedSeekMap.isSeekable();
        }

        public long getDurationUs() {
            long durationMicros = this.adaptedSeekMap.getDurationMicros();
            return durationMicros != Integer.MIN_VALUE ? durationMicros : -9223372036854775807L;
        }

        public SeekMap.SeekPoints getSeekPoints(long timeUs) {
            Pair seekPoints = this.adaptedSeekMap.getSeekPoints(timeUs);
            SeekMap.SeekPoints exoPlayerSeekPoints = seekPoints.first == seekPoints.second ? new SeekMap.SeekPoints(SeekMapAdapter.asExoPlayerSeekPoint((MediaParser.SeekPoint)seekPoints.first)) : new SeekMap.SeekPoints(SeekMapAdapter.asExoPlayerSeekPoint((MediaParser.SeekPoint)seekPoints.first), SeekMapAdapter.asExoPlayerSeekPoint((MediaParser.SeekPoint)seekPoints.second));
            return exoPlayerSeekPoints;
        }

        private static SeekPoint asExoPlayerSeekPoint(MediaParser.SeekPoint seekPoint) {
            return new SeekPoint(seekPoint.timeMicros, seekPoint.position);
        }
    }
}

