/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.source.chunk.MediaChunkIterator;
import com.google.android.exoplayer2.trackselection.BaseTrackSelection;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.FixedTrackSelection;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableType;

@Deprecated
public class AdaptiveTrackSelection
extends BaseTrackSelection {
    private static final String TAG = "AdaptiveTrackSelection";
    public static final int DEFAULT_MIN_DURATION_FOR_QUALITY_INCREASE_MS = 10000;
    public static final int DEFAULT_MAX_DURATION_FOR_QUALITY_DECREASE_MS = 25000;
    public static final int DEFAULT_MIN_DURATION_TO_RETAIN_AFTER_DISCARD_MS = 25000;
    public static final int DEFAULT_MAX_WIDTH_TO_DISCARD = 1279;
    public static final int DEFAULT_MAX_HEIGHT_TO_DISCARD = 719;
    public static final float DEFAULT_BANDWIDTH_FRACTION = 0.7f;
    public static final float DEFAULT_BUFFERED_FRACTION_TO_LIVE_EDGE_FOR_QUALITY_INCREASE = 0.75f;
    private static final long MIN_TIME_BETWEEN_BUFFER_REEVALUTATION_MS = 1000L;
    private final BandwidthMeter bandwidthMeter;
    private final long minDurationForQualityIncreaseUs;
    private final long maxDurationForQualityDecreaseUs;
    private final long minDurationToRetainAfterDiscardUs;
    private final int maxWidthToDiscard;
    private final int maxHeightToDiscard;
    private final float bandwidthFraction;
    private final float bufferedFractionToLiveEdgeForQualityIncrease;
    private final ImmutableList<AdaptationCheckpoint> adaptationCheckpoints;
    private final Clock clock;
    private float playbackSpeed;
    private int selectedIndex;
    private int reason;
    private long lastBufferEvaluationMs;
    @Nullable
    private MediaChunk lastBufferEvaluationMediaChunk;
    private long latestBitrateEstimate;

    public AdaptiveTrackSelection(TrackGroup group, int[] tracks, BandwidthMeter bandwidthMeter) {
        this(group, tracks, 0, bandwidthMeter, 10000L, 25000L, 25000L, 1279, 719, 0.7f, 0.75f, (List<AdaptationCheckpoint>)ImmutableList.of(), Clock.DEFAULT);
    }

    protected AdaptiveTrackSelection(TrackGroup group, int[] tracks, int type, BandwidthMeter bandwidthMeter, long minDurationForQualityIncreaseMs, long maxDurationForQualityDecreaseMs, long minDurationToRetainAfterDiscardMs, int maxWidthToDiscard, int maxHeightToDiscard, float bandwidthFraction, float bufferedFractionToLiveEdgeForQualityIncrease, List<AdaptationCheckpoint> adaptationCheckpoints, Clock clock) {
        super(group, tracks, type);
        if (minDurationToRetainAfterDiscardMs < minDurationForQualityIncreaseMs) {
            Log.w((String)TAG, (String)"Adjusting minDurationToRetainAfterDiscardMs to be at least minDurationForQualityIncreaseMs");
            minDurationToRetainAfterDiscardMs = minDurationForQualityIncreaseMs;
        }
        this.bandwidthMeter = bandwidthMeter;
        this.minDurationForQualityIncreaseUs = minDurationForQualityIncreaseMs * 1000L;
        this.maxDurationForQualityDecreaseUs = maxDurationForQualityDecreaseMs * 1000L;
        this.minDurationToRetainAfterDiscardUs = minDurationToRetainAfterDiscardMs * 1000L;
        this.maxWidthToDiscard = maxWidthToDiscard;
        this.maxHeightToDiscard = maxHeightToDiscard;
        this.bandwidthFraction = bandwidthFraction;
        this.bufferedFractionToLiveEdgeForQualityIncrease = bufferedFractionToLiveEdgeForQualityIncrease;
        this.adaptationCheckpoints = ImmutableList.copyOf(adaptationCheckpoints);
        this.clock = clock;
        this.playbackSpeed = 1.0f;
        this.reason = 0;
        this.lastBufferEvaluationMs = -9223372036854775807L;
        this.latestBitrateEstimate = Long.MIN_VALUE;
    }

    @Override
    @CallSuper
    public void enable() {
        this.lastBufferEvaluationMs = -9223372036854775807L;
        this.lastBufferEvaluationMediaChunk = null;
    }

    @Override
    @CallSuper
    public void disable() {
        this.lastBufferEvaluationMediaChunk = null;
    }

    @Override
    public void onPlaybackSpeed(float playbackSpeed) {
        this.playbackSpeed = playbackSpeed;
    }

    @Override
    public void updateSelectedTrack(long playbackPositionUs, long bufferedDurationUs, long availableDurationUs, List<? extends MediaChunk> queue, MediaChunkIterator[] mediaChunkIterators) {
        int newSelectedIndex;
        int formatIndexOfPreviousChunk;
        long nowMs = this.clock.elapsedRealtime();
        long chunkDurationUs = this.getNextChunkDurationUs(mediaChunkIterators, queue);
        if (this.reason == 0) {
            this.reason = 1;
            this.selectedIndex = this.determineIdealSelectedIndex(nowMs, chunkDurationUs);
            return;
        }
        int previousSelectedIndex = this.selectedIndex;
        int previousReason = this.reason;
        int n = formatIndexOfPreviousChunk = queue.isEmpty() ? -1 : this.indexOf(((MediaChunk)Iterables.getLast(queue)).trackFormat);
        if (formatIndexOfPreviousChunk != -1) {
            previousSelectedIndex = formatIndexOfPreviousChunk;
            previousReason = ((MediaChunk)Iterables.getLast(queue)).trackSelectionReason;
        }
        if ((newSelectedIndex = this.determineIdealSelectedIndex(nowMs, chunkDurationUs)) != previousSelectedIndex && !this.isTrackExcluded(previousSelectedIndex, nowMs)) {
            Format currentFormat = this.getFormat(previousSelectedIndex);
            Format selectedFormat = this.getFormat(newSelectedIndex);
            long minDurationForQualityIncreaseUs = this.minDurationForQualityIncreaseUs(availableDurationUs, chunkDurationUs);
            if (selectedFormat.bitrate > currentFormat.bitrate && bufferedDurationUs < minDurationForQualityIncreaseUs) {
                newSelectedIndex = previousSelectedIndex;
            } else if (selectedFormat.bitrate < currentFormat.bitrate && bufferedDurationUs >= this.maxDurationForQualityDecreaseUs) {
                newSelectedIndex = previousSelectedIndex;
            }
        }
        this.reason = newSelectedIndex == previousSelectedIndex ? previousReason : 3;
        this.selectedIndex = newSelectedIndex;
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public int getSelectionReason() {
        return this.reason;
    }

    @Override
    @Nullable
    public Object getSelectionData() {
        return null;
    }

    @Override
    public int evaluateQueueSize(long playbackPositionUs, List<? extends MediaChunk> queue) {
        long minDurationToRetainAfterDiscardUs;
        long nowMs = this.clock.elapsedRealtime();
        if (!this.shouldEvaluateQueueSize(nowMs, queue)) {
            return queue.size();
        }
        this.lastBufferEvaluationMs = nowMs;
        MediaChunk mediaChunk = this.lastBufferEvaluationMediaChunk = queue.isEmpty() ? null : (MediaChunk)Iterables.getLast(queue);
        if (queue.isEmpty()) {
            return 0;
        }
        int queueSize = queue.size();
        MediaChunk lastChunk = queue.get(queueSize - 1);
        long playoutBufferedDurationBeforeLastChunkUs = Util.getPlayoutDurationForMediaDuration((long)(lastChunk.startTimeUs - playbackPositionUs), (float)this.playbackSpeed);
        if (playoutBufferedDurationBeforeLastChunkUs < (minDurationToRetainAfterDiscardUs = this.getMinDurationToRetainAfterDiscardUs())) {
            return queueSize;
        }
        int idealSelectedIndex = this.determineIdealSelectedIndex(nowMs, this.getLastChunkDurationUs(queue));
        Format idealFormat = this.getFormat(idealSelectedIndex);
        for (int i = 0; i < queueSize; ++i) {
            MediaChunk chunk = queue.get(i);
            Format format = chunk.trackFormat;
            long mediaDurationBeforeThisChunkUs = chunk.startTimeUs - playbackPositionUs;
            long playoutDurationBeforeThisChunkUs = Util.getPlayoutDurationForMediaDuration((long)mediaDurationBeforeThisChunkUs, (float)this.playbackSpeed);
            if (playoutDurationBeforeThisChunkUs < minDurationToRetainAfterDiscardUs || format.bitrate >= idealFormat.bitrate || format.height == -1 || format.height > this.maxHeightToDiscard || format.width == -1 || format.width > this.maxWidthToDiscard || format.height >= idealFormat.height) continue;
            return i;
        }
        return queueSize;
    }

    @Override
    public long getLatestBitrateEstimate() {
        return this.latestBitrateEstimate;
    }

    protected boolean canSelectFormat(Format format, int trackBitrate, long effectiveBitrate) {
        return (long)trackBitrate <= effectiveBitrate;
    }

    protected boolean shouldEvaluateQueueSize(long nowMs, List<? extends MediaChunk> queue) {
        return this.lastBufferEvaluationMs == -9223372036854775807L || nowMs - this.lastBufferEvaluationMs >= 1000L || !queue.isEmpty() && !((MediaChunk)Iterables.getLast(queue)).equals(this.lastBufferEvaluationMediaChunk);
    }

    protected long getMinDurationToRetainAfterDiscardUs() {
        return this.minDurationToRetainAfterDiscardUs;
    }

    private int determineIdealSelectedIndex(long nowMs, long chunkDurationUs) {
        long effectiveBitrate = this.getAllocatedBandwidth(chunkDurationUs);
        int lowestBitrateAllowedIndex = 0;
        for (int i = 0; i < this.length; ++i) {
            if (nowMs != Long.MIN_VALUE && this.isTrackExcluded(i, nowMs)) continue;
            Format format = this.getFormat(i);
            if (this.canSelectFormat(format, format.bitrate, effectiveBitrate)) {
                return i;
            }
            lowestBitrateAllowedIndex = i;
        }
        return lowestBitrateAllowedIndex;
    }

    private long minDurationForQualityIncreaseUs(long availableDurationUs, long chunkDurationUs) {
        if (availableDurationUs == -9223372036854775807L) {
            return this.minDurationForQualityIncreaseUs;
        }
        if (chunkDurationUs != -9223372036854775807L) {
            availableDurationUs -= chunkDurationUs;
        }
        long adjustedMinDurationForQualityIncreaseUs = (long)((float)availableDurationUs * this.bufferedFractionToLiveEdgeForQualityIncrease);
        return Math.min(adjustedMinDurationForQualityIncreaseUs, this.minDurationForQualityIncreaseUs);
    }

    private long getNextChunkDurationUs(MediaChunkIterator[] mediaChunkIterators, List<? extends MediaChunk> queue) {
        if (this.selectedIndex < mediaChunkIterators.length && mediaChunkIterators[this.selectedIndex].next()) {
            MediaChunkIterator iterator = mediaChunkIterators[this.selectedIndex];
            return iterator.getChunkEndTimeUs() - iterator.getChunkStartTimeUs();
        }
        for (MediaChunkIterator iterator : mediaChunkIterators) {
            if (!iterator.next()) continue;
            return iterator.getChunkEndTimeUs() - iterator.getChunkStartTimeUs();
        }
        return this.getLastChunkDurationUs(queue);
    }

    private long getLastChunkDurationUs(List<? extends MediaChunk> queue) {
        if (queue.isEmpty()) {
            return -9223372036854775807L;
        }
        MediaChunk lastChunk = (MediaChunk)Iterables.getLast(queue);
        return lastChunk.startTimeUs != -9223372036854775807L && lastChunk.endTimeUs != -9223372036854775807L ? lastChunk.endTimeUs - lastChunk.startTimeUs : -9223372036854775807L;
    }

    private long getAllocatedBandwidth(long chunkDurationUs) {
        int nextIndex;
        long totalBandwidth = this.getTotalAllocatableBandwidth(chunkDurationUs);
        if (this.adaptationCheckpoints.isEmpty()) {
            return totalBandwidth;
        }
        for (nextIndex = 1; nextIndex < this.adaptationCheckpoints.size() - 1 && ((AdaptationCheckpoint)this.adaptationCheckpoints.get((int)nextIndex)).totalBandwidth < totalBandwidth; ++nextIndex) {
        }
        AdaptationCheckpoint previous = (AdaptationCheckpoint)this.adaptationCheckpoints.get(nextIndex - 1);
        AdaptationCheckpoint next = (AdaptationCheckpoint)this.adaptationCheckpoints.get(nextIndex);
        float fractionBetweenCheckpoints = (float)(totalBandwidth - previous.totalBandwidth) / (float)(next.totalBandwidth - previous.totalBandwidth);
        return previous.allocatedBandwidth + (long)(fractionBetweenCheckpoints * (float)(next.allocatedBandwidth - previous.allocatedBandwidth));
    }

    private long getTotalAllocatableBandwidth(long chunkDurationUs) {
        this.latestBitrateEstimate = this.bandwidthMeter.getBitrateEstimate();
        long cautiousBandwidthEstimate = (long)((float)this.latestBitrateEstimate * this.bandwidthFraction);
        long timeToFirstByteEstimateUs = this.bandwidthMeter.getTimeToFirstByteEstimateUs();
        if (timeToFirstByteEstimateUs == -9223372036854775807L || chunkDurationUs == -9223372036854775807L) {
            return (long)((float)cautiousBandwidthEstimate / this.playbackSpeed);
        }
        float availableTimeToLoadUs = Math.max((float)chunkDurationUs / this.playbackSpeed - (float)timeToFirstByteEstimateUs, 0.0f);
        return (long)((float)cautiousBandwidthEstimate * availableTimeToLoadUs / (float)chunkDurationUs);
    }

    private static ImmutableList<ImmutableList<AdaptationCheckpoint>> getAdaptationCheckpoints(@NullableType ExoTrackSelection.Definition[] definitions) {
        int i;
        ArrayList<// Could not load outer class - annotation placement on inner may be incorrect
        @NullableType ImmutableList.Builder<AdaptationCheckpoint>> checkPointBuilders = new ArrayList<ImmutableList.Builder<AdaptationCheckpoint>>();
        for (int i2 = 0; i2 < definitions.length; ++i2) {
            if (definitions[i2] != null && definitions[i2].tracks.length > 1) {
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.add((Object)new AdaptationCheckpoint(0L, 0L));
                checkPointBuilders.add((ImmutableList.Builder<AdaptationCheckpoint>)builder);
                continue;
            }
            checkPointBuilders.add(null);
        }
        long[][] trackBitrates = AdaptiveTrackSelection.getSortedTrackBitrates(definitions);
        int[] currentTrackIndices = new int[trackBitrates.length];
        long[] currentTrackBitrates = new long[trackBitrates.length];
        for (int i3 = 0; i3 < trackBitrates.length; ++i3) {
            currentTrackBitrates[i3] = trackBitrates[i3].length == 0 ? 0L : trackBitrates[i3][0];
        }
        AdaptiveTrackSelection.addCheckpoint(checkPointBuilders, currentTrackBitrates);
        ImmutableList<Integer> switchOrder = AdaptiveTrackSelection.getSwitchOrder(trackBitrates);
        for (i = 0; i < switchOrder.size(); ++i) {
            int switchIndex;
            int n = switchIndex = ((Integer)switchOrder.get(i)).intValue();
            int n2 = currentTrackIndices[n] + 1;
            currentTrackIndices[n] = n2;
            int newTrackIndex = n2;
            currentTrackBitrates[switchIndex] = trackBitrates[switchIndex][newTrackIndex];
            AdaptiveTrackSelection.addCheckpoint(checkPointBuilders, currentTrackBitrates);
        }
        for (i = 0; i < definitions.length; ++i) {
            if (checkPointBuilders.get(i) == null) continue;
            int n = i;
            currentTrackBitrates[n] = currentTrackBitrates[n] * 2L;
        }
        AdaptiveTrackSelection.addCheckpoint(checkPointBuilders, currentTrackBitrates);
        ImmutableList.Builder output = ImmutableList.builder();
        for (int i4 = 0; i4 < checkPointBuilders.size(); ++i4) {
            ImmutableList.Builder builder = (ImmutableList.Builder)checkPointBuilders.get(i4);
            output.add((Object)(builder == null ? ImmutableList.of() : builder.build()));
        }
        return output.build();
    }

    private static long[][] getSortedTrackBitrates(@NullableType ExoTrackSelection.Definition[] definitions) {
        long[][] trackBitrates = new long[definitions.length][];
        for (int i = 0; i < definitions.length; ++i) {
            ExoTrackSelection.Definition definition = definitions[i];
            if (definition == null) {
                trackBitrates[i] = new long[0];
                continue;
            }
            trackBitrates[i] = new long[definition.tracks.length];
            for (int j = 0; j < definition.tracks.length; ++j) {
                long bitrate = definition.group.getFormat((int)definition.tracks[j]).bitrate;
                trackBitrates[i][j] = bitrate == -1L ? 0L : bitrate;
            }
            Arrays.sort(trackBitrates[i]);
        }
        return trackBitrates;
    }

    private static ImmutableList<Integer> getSwitchOrder(long[][] trackBitrates) {
        ListMultimap switchPoints = MultimapBuilder.treeKeys().arrayListValues().build();
        for (int i = 0; i < trackBitrates.length; ++i) {
            if (trackBitrates[i].length <= 1) continue;
            double[] logBitrates = new double[trackBitrates[i].length];
            for (int j = 0; j < trackBitrates[i].length; ++j) {
                logBitrates[j] = trackBitrates[i][j] == -1L ? 0.0 : Math.log(trackBitrates[i][j]);
            }
            double totalBitrateDiff = logBitrates[logBitrates.length - 1] - logBitrates[0];
            for (int j = 0; j < logBitrates.length - 1; ++j) {
                double switchBitrate = 0.5 * (logBitrates[j] + logBitrates[j + 1]);
                double switchPoint = totalBitrateDiff == 0.0 ? 1.0 : (switchBitrate - logBitrates[0]) / totalBitrateDiff;
                switchPoints.put((Object)switchPoint, (Object)i);
            }
        }
        return ImmutableList.copyOf((Collection)switchPoints.values());
    }

    private static void addCheckpoint(List<// Could not load outer class - annotation placement on inner may be incorrect
    @NullableType ImmutableList.Builder<AdaptationCheckpoint>> checkPointBuilders, long[] checkpointBitrates) {
        int i;
        long totalBitrate = 0L;
        for (i = 0; i < checkpointBitrates.length; ++i) {
            totalBitrate += checkpointBitrates[i];
        }
        for (i = 0; i < checkPointBuilders.size(); ++i) {
            ImmutableList.Builder<AdaptationCheckpoint> builder = checkPointBuilders.get(i);
            if (builder == null) continue;
            builder.add((Object)new AdaptationCheckpoint(totalBitrate, checkpointBitrates[i]));
        }
    }

    public static final class AdaptationCheckpoint {
        public final long totalBandwidth;
        public final long allocatedBandwidth;

        public AdaptationCheckpoint(long totalBandwidth, long allocatedBandwidth) {
            this.totalBandwidth = totalBandwidth;
            this.allocatedBandwidth = allocatedBandwidth;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AdaptationCheckpoint)) {
                return false;
            }
            AdaptationCheckpoint that = (AdaptationCheckpoint)o;
            return this.totalBandwidth == that.totalBandwidth && this.allocatedBandwidth == that.allocatedBandwidth;
        }

        public int hashCode() {
            return 31 * (int)this.totalBandwidth + (int)this.allocatedBandwidth;
        }
    }

    public static class Factory
    implements ExoTrackSelection.Factory {
        private final int minDurationForQualityIncreaseMs;
        private final int maxDurationForQualityDecreaseMs;
        private final int minDurationToRetainAfterDiscardMs;
        private final int maxWidthToDiscard;
        private final int maxHeightToDiscard;
        private final float bandwidthFraction;
        private final float bufferedFractionToLiveEdgeForQualityIncrease;
        private final Clock clock;

        public Factory() {
            this(10000, 25000, 25000, 0.7f);
        }

        public Factory(int minDurationForQualityIncreaseMs, int maxDurationForQualityDecreaseMs, int minDurationToRetainAfterDiscardMs, float bandwidthFraction) {
            this(minDurationForQualityIncreaseMs, maxDurationForQualityDecreaseMs, minDurationToRetainAfterDiscardMs, 1279, 719, bandwidthFraction, 0.75f, Clock.DEFAULT);
        }

        public Factory(int minDurationForQualityIncreaseMs, int maxDurationForQualityDecreaseMs, int minDurationToRetainAfterDiscardMs, int maxWidthToDiscard, int maxHeightToDiscard, float bandwidthFraction) {
            this(minDurationForQualityIncreaseMs, maxDurationForQualityDecreaseMs, minDurationToRetainAfterDiscardMs, maxWidthToDiscard, maxHeightToDiscard, bandwidthFraction, 0.75f, Clock.DEFAULT);
        }

        public Factory(int minDurationForQualityIncreaseMs, int maxDurationForQualityDecreaseMs, int minDurationToRetainAfterDiscardMs, float bandwidthFraction, float bufferedFractionToLiveEdgeForQualityIncrease, Clock clock) {
            this(minDurationForQualityIncreaseMs, maxDurationForQualityDecreaseMs, minDurationToRetainAfterDiscardMs, 1279, 719, bandwidthFraction, bufferedFractionToLiveEdgeForQualityIncrease, clock);
        }

        public Factory(int minDurationForQualityIncreaseMs, int maxDurationForQualityDecreaseMs, int minDurationToRetainAfterDiscardMs, int maxWidthToDiscard, int maxHeightToDiscard, float bandwidthFraction, float bufferedFractionToLiveEdgeForQualityIncrease, Clock clock) {
            this.minDurationForQualityIncreaseMs = minDurationForQualityIncreaseMs;
            this.maxDurationForQualityDecreaseMs = maxDurationForQualityDecreaseMs;
            this.minDurationToRetainAfterDiscardMs = minDurationToRetainAfterDiscardMs;
            this.maxWidthToDiscard = maxWidthToDiscard;
            this.maxHeightToDiscard = maxHeightToDiscard;
            this.bandwidthFraction = bandwidthFraction;
            this.bufferedFractionToLiveEdgeForQualityIncrease = bufferedFractionToLiveEdgeForQualityIncrease;
            this.clock = clock;
        }

        @Override
        public final @NullableType ExoTrackSelection[] createTrackSelections(@NullableType ExoTrackSelection.Definition[] definitions, BandwidthMeter bandwidthMeter, MediaSource.MediaPeriodId mediaPeriodId, Timeline timeline) {
            ImmutableList adaptationCheckpoints = AdaptiveTrackSelection.getAdaptationCheckpoints(definitions);
            ExoTrackSelection[] selections = new ExoTrackSelection[definitions.length];
            for (int i = 0; i < definitions.length; ++i) {
                ExoTrackSelection.Definition definition = definitions[i];
                if (definition == null || definition.tracks.length == 0) continue;
                selections[i] = definition.tracks.length == 1 ? new FixedTrackSelection(definition.group, definition.tracks[0], definition.type) : this.createAdaptiveTrackSelection(definition.group, definition.tracks, definition.type, bandwidthMeter, (ImmutableList<AdaptationCheckpoint>)((ImmutableList)adaptationCheckpoints.get(i)));
            }
            return selections;
        }

        protected AdaptiveTrackSelection createAdaptiveTrackSelection(TrackGroup group, int[] tracks, int type, BandwidthMeter bandwidthMeter, ImmutableList<AdaptationCheckpoint> adaptationCheckpoints) {
            return new AdaptiveTrackSelection(group, tracks, type, bandwidthMeter, (long)this.minDurationForQualityIncreaseMs, (long)this.maxDurationForQualityDecreaseMs, (long)this.minDurationToRetainAfterDiscardMs, this.maxWidthToDiscard, this.maxHeightToDiscard, this.bandwidthFraction, this.bufferedFractionToLiveEdgeForQualityIncrease, (List<AdaptationCheckpoint>)adaptationCheckpoints, this.clock);
        }
    }
}

