/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import android.content.Context;
import android.graphics.Point;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.Spatializer;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Pair;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.Bundleable;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RendererCapabilities;
import com.google.android.exoplayer2.RendererConfiguration;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectionOverride;
import com.google.android.exoplayer2.trackselection.TrackSelectionParameters;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.BundleableUtil;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Predicate;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.compatqual.NullableType;

@Deprecated
public class DefaultTrackSelector
extends MappingTrackSelector
implements RendererCapabilities.Listener {
    private static final String TAG = "DefaultTrackSelector";
    private static final String AUDIO_CHANNEL_COUNT_CONSTRAINTS_WARN_MESSAGE = "Audio channel count constraints cannot be applied without reference to Context. Build the track selector instance with one of the non-deprecated constructors that take a Context argument.";
    protected static final int SELECTION_ELIGIBILITY_NO = 0;
    protected static final int SELECTION_ELIGIBILITY_FIXED = 1;
    protected static final int SELECTION_ELIGIBILITY_ADAPTIVE = 2;
    private static final float FRACTION_TO_CONSIDER_FULLSCREEN = 0.98f;
    private static final Ordering<Integer> FORMAT_VALUE_ORDERING = Ordering.from((first, second) -> first == -1 ? (second == -1 ? 0 : -1) : (second == -1 ? 1 : first - second));
    private static final Ordering<Integer> NO_ORDER = Ordering.from((first, second) -> 0);
    private final Object lock = new Object();
    @Nullable
    public final Context context;
    private final ExoTrackSelection.Factory trackSelectionFactory;
    private final boolean deviceIsTV;
    @GuardedBy(value="lock")
    private Parameters parameters;
    @GuardedBy(value="lock")
    @Nullable
    private SpatializerWrapperV32 spatializer;
    @GuardedBy(value="lock")
    private AudioAttributes audioAttributes;

    public DefaultTrackSelector(Context context) {
        this(context, (ExoTrackSelection.Factory)new AdaptiveTrackSelection.Factory());
    }

    public DefaultTrackSelector(Context context, ExoTrackSelection.Factory trackSelectionFactory) {
        this(context, Parameters.getDefaults(context), trackSelectionFactory);
    }

    public DefaultTrackSelector(Context context, TrackSelectionParameters parameters) {
        this(context, parameters, new AdaptiveTrackSelection.Factory());
    }

    @Deprecated
    public DefaultTrackSelector(TrackSelectionParameters parameters, ExoTrackSelection.Factory trackSelectionFactory) {
        this(parameters, trackSelectionFactory, null);
    }

    public DefaultTrackSelector(Context context, TrackSelectionParameters parameters, ExoTrackSelection.Factory trackSelectionFactory) {
        this(parameters, trackSelectionFactory, context);
    }

    private DefaultTrackSelector(TrackSelectionParameters parameters, ExoTrackSelection.Factory trackSelectionFactory, @Nullable Context context) {
        this.context = context != null ? context.getApplicationContext() : null;
        this.trackSelectionFactory = trackSelectionFactory;
        if (parameters instanceof Parameters) {
            this.parameters = (Parameters)parameters;
        } else {
            Parameters defaultParameters = context == null ? Parameters.DEFAULT_WITHOUT_CONTEXT : Parameters.getDefaults(context);
            this.parameters = defaultParameters.buildUpon().set(parameters).build();
        }
        this.audioAttributes = AudioAttributes.DEFAULT;
        boolean bl = this.deviceIsTV = context != null && Util.isTv((Context)context);
        if (!this.deviceIsTV && context != null && Util.SDK_INT >= 32) {
            this.spatializer = SpatializerWrapperV32.tryCreateInstance(context);
        }
        if (this.parameters.constrainAudioChannelCountToDeviceCapabilities && context == null) {
            Log.w((String)TAG, (String)AUDIO_CHANNEL_COUNT_CONSTRAINTS_WARN_MESSAGE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.lock;
        synchronized (object) {
            if (Util.SDK_INT >= 32 && this.spatializer != null) {
                this.spatializer.release();
            }
        }
        super.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Parameters getParameters() {
        Object object = this.lock;
        synchronized (object) {
            return this.parameters;
        }
    }

    @Override
    public boolean isSetParametersSupported() {
        return true;
    }

    @Override
    public void setParameters(TrackSelectionParameters parameters) {
        if (parameters instanceof Parameters) {
            this.setParametersInternal((Parameters)parameters);
        }
        Parameters mergedParameters = new Parameters.Builder(this.getParameters()).set(parameters).build();
        this.setParametersInternal(mergedParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAudioAttributes(AudioAttributes audioAttributes) {
        boolean audioAttributesChanged;
        Object object = this.lock;
        synchronized (object) {
            audioAttributesChanged = !this.audioAttributes.equals((Object)audioAttributes);
            this.audioAttributes = audioAttributes;
        }
        if (audioAttributesChanged) {
            this.maybeInvalidateForAudioChannelCountConstraints();
        }
    }

    @Deprecated
    public void setParameters(ParametersBuilder parametersBuilder) {
        this.setParametersInternal(parametersBuilder.build());
    }

    public void setParameters(Parameters.Builder parametersBuilder) {
        this.setParametersInternal(parametersBuilder.build());
    }

    public Parameters.Builder buildUponParameters() {
        return this.getParameters().buildUpon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setParametersInternal(Parameters parameters) {
        boolean parametersChanged;
        Assertions.checkNotNull((Object)((Object)parameters));
        Object object = this.lock;
        synchronized (object) {
            parametersChanged = !this.parameters.equals((Object)parameters);
            this.parameters = parameters;
        }
        if (parametersChanged) {
            if (parameters.constrainAudioChannelCountToDeviceCapabilities && this.context == null) {
                Log.w((String)TAG, (String)AUDIO_CHANNEL_COUNT_CONSTRAINTS_WARN_MESSAGE);
            }
            this.invalidate();
        }
    }

    @Override
    @Nullable
    public RendererCapabilities.Listener getRendererCapabilitiesListener() {
        return this;
    }

    @Override
    public void onRendererCapabilitiesChanged(Renderer renderer) {
        this.maybeInvalidateForRendererCapabilitiesChange(renderer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final Pair<@NullableType RendererConfiguration[], @NullableType ExoTrackSelection[]> selectTracks(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] rendererFormatSupports, int[] rendererMixedMimeTypeAdaptationSupport, MediaSource.MediaPeriodId mediaPeriodId, Timeline timeline) throws ExoPlaybackException {
        Parameters parameters;
        Object object = this.lock;
        synchronized (object) {
            parameters = this.parameters;
            if (parameters.constrainAudioChannelCountToDeviceCapabilities && Util.SDK_INT >= 32 && this.spatializer != null) {
                this.spatializer.ensureInitialized(this, (Looper)Assertions.checkStateNotNull((Object)Looper.myLooper()));
            }
        }
        int rendererCount = mappedTrackInfo.getRendererCount();
        @NullableType ExoTrackSelection.Definition[] definitions = this.selectAllTracks(mappedTrackInfo, rendererFormatSupports, rendererMixedMimeTypeAdaptationSupport, parameters);
        DefaultTrackSelector.applyTrackSelectionOverrides(mappedTrackInfo, parameters, definitions);
        DefaultTrackSelector.applyLegacyRendererOverrides(mappedTrackInfo, parameters, definitions);
        for (int i = 0; i < rendererCount; ++i) {
            int rendererType = mappedTrackInfo.getRendererType(i);
            if (!parameters.getRendererDisabled(i) && !parameters.disabledTrackTypes.contains((Object)rendererType)) continue;
            definitions[i] = null;
        }
        @NullableType ExoTrackSelection[] rendererTrackSelections = this.trackSelectionFactory.createTrackSelections(definitions, this.getBandwidthMeter(), mediaPeriodId, timeline);
        @NullableType RendererConfiguration[] rendererConfigurations = new RendererConfiguration[rendererCount];
        for (int i = 0; i < rendererCount; ++i) {
            int rendererType = mappedTrackInfo.getRendererType(i);
            boolean forceRendererDisabled = parameters.getRendererDisabled(i) || parameters.disabledTrackTypes.contains((Object)rendererType);
            boolean rendererEnabled = !forceRendererDisabled && (mappedTrackInfo.getRendererType(i) == -2 || rendererTrackSelections[i] != null);
            rendererConfigurations[i] = rendererEnabled ? RendererConfiguration.DEFAULT : null;
        }
        if (parameters.tunnelingEnabled) {
            DefaultTrackSelector.maybeConfigureRenderersForTunneling(mappedTrackInfo, rendererFormatSupports, rendererConfigurations, rendererTrackSelections);
        }
        return Pair.create((Object)rendererConfigurations, (Object)rendererTrackSelections);
    }

    protected @NullableType ExoTrackSelection.Definition[] selectAllTracks(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] rendererFormatSupports, int[] rendererMixedMimeTypeAdaptationSupports, Parameters params) throws ExoPlaybackException {
        String selectedAudioLanguage;
        Pair<ExoTrackSelection.Definition, Integer> selectedText;
        Pair<ExoTrackSelection.Definition, Integer> selectedAudio;
        int rendererCount = mappedTrackInfo.getRendererCount();
        @NullableType ExoTrackSelection.Definition[] definitions = new ExoTrackSelection.Definition[rendererCount];
        Pair<ExoTrackSelection.Definition, Integer> selectedVideo = this.selectVideoTrack(mappedTrackInfo, rendererFormatSupports, rendererMixedMimeTypeAdaptationSupports, params);
        if (selectedVideo != null) {
            definitions[((Integer)selectedVideo.second).intValue()] = (ExoTrackSelection.Definition)selectedVideo.first;
        }
        if ((selectedAudio = this.selectAudioTrack(mappedTrackInfo, rendererFormatSupports, rendererMixedMimeTypeAdaptationSupports, params)) != null) {
            definitions[((Integer)selectedAudio.second).intValue()] = (ExoTrackSelection.Definition)selectedAudio.first;
        }
        if ((selectedText = this.selectTextTrack(mappedTrackInfo, rendererFormatSupports, params, selectedAudioLanguage = selectedAudio == null ? null : ((ExoTrackSelection.Definition)selectedAudio.first).group.getFormat((int)((ExoTrackSelection.Definition)selectedAudio.first).tracks[0]).language)) != null) {
            definitions[((Integer)selectedText.second).intValue()] = (ExoTrackSelection.Definition)selectedText.first;
        }
        for (int i = 0; i < rendererCount; ++i) {
            int trackType = mappedTrackInfo.getRendererType(i);
            if (trackType == 2 || trackType == 1 || trackType == 3) continue;
            definitions[i] = this.selectOtherTrack(trackType, mappedTrackInfo.getTrackGroups(i), rendererFormatSupports[i], params);
        }
        return definitions;
    }

    @Nullable
    protected Pair<ExoTrackSelection.Definition, Integer> selectVideoTrack(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] rendererFormatSupports, int[] mixedMimeTypeSupports, Parameters params) throws ExoPlaybackException {
        return this.selectTracksForType(2, mappedTrackInfo, rendererFormatSupports, (rendererIndex, group, support) -> VideoTrackInfo.createForTrackGroup(rendererIndex, group, params, support, mixedMimeTypeSupports[rendererIndex]), VideoTrackInfo::compareSelections);
    }

    @Nullable
    protected Pair<ExoTrackSelection.Definition, Integer> selectAudioTrack(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] rendererFormatSupports, int[] rendererMixedMimeTypeAdaptationSupports, Parameters params) throws ExoPlaybackException {
        boolean hasVideoRendererWithMappedTracks = false;
        for (int i = 0; i < mappedTrackInfo.getRendererCount(); ++i) {
            if (2 != mappedTrackInfo.getRendererType(i) || mappedTrackInfo.getTrackGroups((int)i).length <= 0) continue;
            hasVideoRendererWithMappedTracks = true;
            break;
        }
        boolean hasVideoRendererWithMappedTracksFinal = hasVideoRendererWithMappedTracks;
        return this.selectTracksForType(1, mappedTrackInfo, rendererFormatSupports, (rendererIndex, group, support) -> AudioTrackInfo.createForTrackGroup(rendererIndex, group, params, support, hasVideoRendererWithMappedTracksFinal, (Predicate<Format>)((Predicate)this::isAudioFormatWithinAudioChannelCountConstraints)), AudioTrackInfo::compareSelections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAudioFormatWithinAudioChannelCountConstraints(Format format) {
        Object object = this.lock;
        synchronized (object) {
            return !this.parameters.constrainAudioChannelCountToDeviceCapabilities || this.deviceIsTV || format.channelCount <= 2 || DefaultTrackSelector.isDolbyAudio(format) && (Util.SDK_INT < 32 || this.spatializer == null || !this.spatializer.isSpatializationSupported()) || Util.SDK_INT >= 32 && this.spatializer != null && this.spatializer.isSpatializationSupported() && this.spatializer.isAvailable() && this.spatializer.isEnabled() && this.spatializer.canBeSpatialized(this.audioAttributes, format);
        }
    }

    @Nullable
    protected Pair<ExoTrackSelection.Definition, Integer> selectTextTrack(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] rendererFormatSupports, Parameters params, @Nullable String selectedAudioLanguage) throws ExoPlaybackException {
        return this.selectTracksForType(3, mappedTrackInfo, rendererFormatSupports, (rendererIndex, group, support) -> TextTrackInfo.createForTrackGroup(rendererIndex, group, params, support, selectedAudioLanguage), TextTrackInfo::compareSelections);
    }

    @Nullable
    protected ExoTrackSelection.Definition selectOtherTrack(int trackType, TrackGroupArray groups, int[][] formatSupport, Parameters params) throws ExoPlaybackException {
        TrackGroup selectedGroup = null;
        int selectedTrackIndex = 0;
        OtherTrackScore selectedTrackScore = null;
        for (int groupIndex = 0; groupIndex < groups.length; ++groupIndex) {
            TrackGroup trackGroup = groups.get(groupIndex);
            int[] trackFormatSupport = formatSupport[groupIndex];
            for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                if (!DefaultTrackSelector.isSupported(trackFormatSupport[trackIndex], params.exceedRendererCapabilitiesIfNecessary)) continue;
                Format format = trackGroup.getFormat(trackIndex);
                OtherTrackScore trackScore = new OtherTrackScore(format, trackFormatSupport[trackIndex]);
                if (selectedTrackScore != null && trackScore.compareTo(selectedTrackScore) <= 0) continue;
                selectedGroup = trackGroup;
                selectedTrackIndex = trackIndex;
                selectedTrackScore = trackScore;
            }
        }
        return selectedGroup == null ? null : new ExoTrackSelection.Definition(selectedGroup, selectedTrackIndex);
    }

    @Nullable
    private <T extends TrackInfo<T>> Pair<ExoTrackSelection.Definition, Integer> selectTracksForType(int trackType, MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] formatSupport, TrackInfo.Factory<T> trackInfoFactory, Comparator<List<T>> selectionComparator) {
        ArrayList<Object> possibleSelections = new ArrayList<Object>();
        int rendererCount = mappedTrackInfo.getRendererCount();
        for (int rendererIndex = 0; rendererIndex < rendererCount; ++rendererIndex) {
            if (trackType != mappedTrackInfo.getRendererType(rendererIndex)) continue;
            TrackGroupArray groups = mappedTrackInfo.getTrackGroups(rendererIndex);
            for (int groupIndex = 0; groupIndex < groups.length; ++groupIndex) {
                TrackGroup trackGroup = groups.get(groupIndex);
                int[] groupSupport = formatSupport[rendererIndex][groupIndex];
                List<T> trackInfos = trackInfoFactory.create(rendererIndex, trackGroup, groupSupport);
                boolean[] usedTrackInSelection = new boolean[trackGroup.length];
                for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                    Object selection;
                    TrackInfo trackInfo = (TrackInfo)trackInfos.get(trackIndex);
                    int eligibility = trackInfo.getSelectionEligibility();
                    if (usedTrackInSelection[trackIndex] || eligibility == 0) continue;
                    if (eligibility == 1) {
                        selection = ImmutableList.of((Object)trackInfo);
                    } else {
                        selection = new ArrayList();
                        selection.add(trackInfo);
                        for (int i = trackIndex + 1; i < trackGroup.length; ++i) {
                            TrackInfo otherTrackInfo = (TrackInfo)trackInfos.get(i);
                            if (otherTrackInfo.getSelectionEligibility() != 2 || !trackInfo.isCompatibleForAdaptationWith(otherTrackInfo)) continue;
                            selection.add(otherTrackInfo);
                            usedTrackInSelection[i] = true;
                        }
                    }
                    possibleSelections.add(selection);
                }
            }
        }
        if (possibleSelections.isEmpty()) {
            return null;
        }
        List<T> bestSelection = Collections.max(possibleSelections, selectionComparator);
        int[] trackIndices = new int[bestSelection.size()];
        for (int i = 0; i < bestSelection.size(); ++i) {
            trackIndices[i] = ((TrackInfo)bestSelection.get((int)i)).trackIndex;
        }
        TrackInfo firstTrackInfo = (TrackInfo)bestSelection.get(0);
        return Pair.create((Object)new ExoTrackSelection.Definition(firstTrackInfo.trackGroup, trackIndices), (Object)firstTrackInfo.rendererIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeInvalidateForAudioChannelCountConstraints() {
        boolean shouldInvalidate;
        Object object = this.lock;
        synchronized (object) {
            shouldInvalidate = this.parameters.constrainAudioChannelCountToDeviceCapabilities && !this.deviceIsTV && Util.SDK_INT >= 32 && this.spatializer != null && this.spatializer.isSpatializationSupported();
        }
        if (shouldInvalidate) {
            this.invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeInvalidateForRendererCapabilitiesChange(Renderer renderer) {
        boolean shouldInvalidate;
        Object object = this.lock;
        synchronized (object) {
            shouldInvalidate = this.parameters.allowInvalidateSelectionsOnRendererCapabilitiesChange;
        }
        if (shouldInvalidate) {
            this.invalidateForRendererCapabilitiesChange(renderer);
        }
    }

    private static void applyTrackSelectionOverrides(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, TrackSelectionParameters params, @NullableType ExoTrackSelection.Definition[] outDefinitions) {
        int rendererIndex;
        int rendererCount = mappedTrackInfo.getRendererCount();
        HashMap<Integer, TrackSelectionOverride> overridesByType = new HashMap<Integer, TrackSelectionOverride>();
        for (rendererIndex = 0; rendererIndex < rendererCount; ++rendererIndex) {
            DefaultTrackSelector.collectTrackSelectionOverrides(mappedTrackInfo.getTrackGroups(rendererIndex), params, overridesByType);
        }
        DefaultTrackSelector.collectTrackSelectionOverrides(mappedTrackInfo.getUnmappedTrackGroups(), params, overridesByType);
        for (rendererIndex = 0; rendererIndex < rendererCount; ++rendererIndex) {
            int trackType = mappedTrackInfo.getRendererType(rendererIndex);
            TrackSelectionOverride overrideForType = overridesByType.get(trackType);
            if (overrideForType == null) continue;
            ExoTrackSelection.Definition selection = !overrideForType.trackIndices.isEmpty() && mappedTrackInfo.getTrackGroups(rendererIndex).indexOf(overrideForType.mediaTrackGroup) != -1 ? new ExoTrackSelection.Definition(overrideForType.mediaTrackGroup, Ints.toArray((Collection)overrideForType.trackIndices)) : null;
            outDefinitions[rendererIndex] = selection;
        }
    }

    private static void collectTrackSelectionOverrides(TrackGroupArray trackGroups, TrackSelectionParameters params, Map<Integer, TrackSelectionOverride> overridesByType) {
        for (int trackGroupIndex = 0; trackGroupIndex < trackGroups.length; ++trackGroupIndex) {
            TrackSelectionOverride existingOverride;
            TrackGroup trackGroup = trackGroups.get(trackGroupIndex);
            TrackSelectionOverride override = (TrackSelectionOverride)params.overrides.get((Object)trackGroup);
            if (override == null || (existingOverride = overridesByType.get(override.getType())) != null && (!existingOverride.trackIndices.isEmpty() || override.trackIndices.isEmpty())) continue;
            overridesByType.put(override.getType(), override);
        }
    }

    private static void applyLegacyRendererOverrides(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, Parameters params, @NullableType ExoTrackSelection.Definition[] outDefinitions) {
        int rendererCount = mappedTrackInfo.getRendererCount();
        for (int rendererIndex = 0; rendererIndex < rendererCount; ++rendererIndex) {
            TrackGroupArray trackGroups = mappedTrackInfo.getTrackGroups(rendererIndex);
            if (!params.hasSelectionOverride(rendererIndex, trackGroups)) continue;
            SelectionOverride override = params.getSelectionOverride(rendererIndex, trackGroups);
            ExoTrackSelection.Definition selection = override != null && override.tracks.length != 0 ? new ExoTrackSelection.Definition(trackGroups.get(override.groupIndex), override.tracks, override.type) : null;
            outDefinitions[rendererIndex] = selection;
        }
    }

    private static void maybeConfigureRenderersForTunneling(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, int[][][] renderererFormatSupports, @NullableType RendererConfiguration[] rendererConfigurations, @NullableType ExoTrackSelection[] trackSelections) {
        int tunnelingAudioRendererIndex = -1;
        int tunnelingVideoRendererIndex = -1;
        boolean enableTunneling = true;
        for (int i = 0; i < mappedTrackInfo.getRendererCount(); ++i) {
            int rendererType = mappedTrackInfo.getRendererType(i);
            ExoTrackSelection trackSelection = trackSelections[i];
            if (rendererType != 1 && rendererType != 2 || trackSelection == null || !DefaultTrackSelector.rendererSupportsTunneling(renderererFormatSupports[i], mappedTrackInfo.getTrackGroups(i), trackSelection)) continue;
            if (rendererType == 1) {
                if (tunnelingAudioRendererIndex != -1) {
                    enableTunneling = false;
                    break;
                }
                tunnelingAudioRendererIndex = i;
                continue;
            }
            if (tunnelingVideoRendererIndex != -1) {
                enableTunneling = false;
                break;
            }
            tunnelingVideoRendererIndex = i;
        }
        if (enableTunneling &= tunnelingAudioRendererIndex != -1 && tunnelingVideoRendererIndex != -1) {
            RendererConfiguration tunnelingRendererConfiguration;
            rendererConfigurations[tunnelingAudioRendererIndex] = tunnelingRendererConfiguration = new RendererConfiguration(true);
            rendererConfigurations[tunnelingVideoRendererIndex] = tunnelingRendererConfiguration;
        }
    }

    private static boolean rendererSupportsTunneling(int[][] formatSupport, TrackGroupArray trackGroups, ExoTrackSelection selection) {
        if (selection == null) {
            return false;
        }
        int trackGroupIndex = trackGroups.indexOf(selection.getTrackGroup());
        for (int i = 0; i < selection.length(); ++i) {
            int trackFormatSupport = formatSupport[trackGroupIndex][selection.getIndexInTrackGroup(i)];
            if (RendererCapabilities.getTunnelingSupport(trackFormatSupport) == 32) continue;
            return false;
        }
        return true;
    }

    protected static boolean isSupported(int formatSupport, boolean allowExceedsCapabilities) {
        int maskedSupport = RendererCapabilities.getFormatSupport(formatSupport);
        return maskedSupport == 4 || allowExceedsCapabilities && maskedSupport == 3;
    }

    @Nullable
    protected static String normalizeUndeterminedLanguageToNull(@Nullable String language) {
        return TextUtils.isEmpty((CharSequence)language) || TextUtils.equals((CharSequence)language, (CharSequence)"und") ? null : language;
    }

    protected static int getFormatLanguageScore(Format format, @Nullable String language, boolean allowUndeterminedFormatLanguage) {
        String queryMainLanguage;
        if (!TextUtils.isEmpty((CharSequence)language) && language.equals(format.language)) {
            return 4;
        }
        language = DefaultTrackSelector.normalizeUndeterminedLanguageToNull(language);
        String formatLanguage = DefaultTrackSelector.normalizeUndeterminedLanguageToNull(format.language);
        if (formatLanguage == null || language == null) {
            return allowUndeterminedFormatLanguage && formatLanguage == null ? 1 : 0;
        }
        if (formatLanguage.startsWith(language) || language.startsWith(formatLanguage)) {
            return 3;
        }
        String formatMainLanguage = Util.splitAtFirst((String)formatLanguage, (String)"-")[0];
        if (formatMainLanguage.equals(queryMainLanguage = Util.splitAtFirst((String)language, (String)"-")[0])) {
            return 2;
        }
        return 0;
    }

    private static int getMaxVideoPixelsToRetainForViewport(TrackGroup group, int viewportWidth, int viewportHeight, boolean orientationMayChange) {
        if (viewportWidth == Integer.MAX_VALUE || viewportHeight == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int maxVideoPixelsToRetain = Integer.MAX_VALUE;
        for (int i = 0; i < group.length; ++i) {
            Format format = group.getFormat(i);
            if (format.width <= 0 || format.height <= 0) continue;
            Point maxVideoSizeInViewport = DefaultTrackSelector.getMaxVideoSizeInViewport(orientationMayChange, viewportWidth, viewportHeight, format.width, format.height);
            int videoPixels = format.width * format.height;
            if (format.width < (int)((float)maxVideoSizeInViewport.x * 0.98f) || format.height < (int)((float)maxVideoSizeInViewport.y * 0.98f) || videoPixels >= maxVideoPixelsToRetain) continue;
            maxVideoPixelsToRetain = videoPixels;
        }
        return maxVideoPixelsToRetain;
    }

    private static Point getMaxVideoSizeInViewport(boolean orientationMayChange, int viewportWidth, int viewportHeight, int videoWidth, int videoHeight) {
        if (orientationMayChange && videoWidth > videoHeight != viewportWidth > viewportHeight) {
            int tempViewportWidth = viewportWidth;
            viewportWidth = viewportHeight;
            viewportHeight = tempViewportWidth;
        }
        if (videoWidth * viewportHeight >= videoHeight * viewportWidth) {
            return new Point(viewportWidth, Util.ceilDivide((int)(viewportWidth * videoHeight), (int)videoWidth));
        }
        return new Point(Util.ceilDivide((int)(viewportHeight * videoWidth), (int)videoHeight), viewportHeight);
    }

    private static int getRoleFlagMatchScore(int trackRoleFlags, int preferredRoleFlags) {
        if (trackRoleFlags != 0 && trackRoleFlags == preferredRoleFlags) {
            return Integer.MAX_VALUE;
        }
        return Integer.bitCount(trackRoleFlags & preferredRoleFlags);
    }

    private static int getVideoCodecPreferenceScore(@Nullable String mimeType) {
        if (mimeType == null) {
            return 0;
        }
        switch (mimeType) {
            case "video/dolby-vision": {
                return 5;
            }
            case "video/av01": {
                return 4;
            }
            case "video/hevc": {
                return 3;
            }
            case "video/x-vnd.on2.vp9": {
                return 2;
            }
            case "video/avc": {
                return 1;
            }
        }
        return 0;
    }

    private static boolean isDolbyAudio(Format format) {
        if (format.sampleMimeType == null) {
            return false;
        }
        switch (format.sampleMimeType) {
            case "audio/ac3": 
            case "audio/eac3": 
            case "audio/eac3-joc": 
            case "audio/ac4": {
                return true;
            }
        }
        return false;
    }

    public static final class Parameters
    extends TrackSelectionParameters
    implements Bundleable {
        public static final Parameters DEFAULT_WITHOUT_CONTEXT;
        @Deprecated
        public static final Parameters DEFAULT;
        public final boolean exceedVideoConstraintsIfNecessary;
        public final boolean allowVideoMixedMimeTypeAdaptiveness;
        public final boolean allowVideoNonSeamlessAdaptiveness;
        public final boolean allowVideoMixedDecoderSupportAdaptiveness;
        public final boolean exceedAudioConstraintsIfNecessary;
        public final boolean allowAudioMixedMimeTypeAdaptiveness;
        public final boolean allowAudioMixedSampleRateAdaptiveness;
        public final boolean allowAudioMixedChannelCountAdaptiveness;
        public final boolean allowAudioMixedDecoderSupportAdaptiveness;
        public final boolean constrainAudioChannelCountToDeviceCapabilities;
        public final boolean exceedRendererCapabilitiesIfNecessary;
        public final boolean tunnelingEnabled;
        public final boolean allowMultipleAdaptiveSelections;
        public final boolean allowInvalidateSelectionsOnRendererCapabilitiesChange;
        private final SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> selectionOverrides;
        private final SparseBooleanArray rendererDisabledFlags;
        private static final String FIELD_EXCEED_VIDEO_CONSTRAINTS_IF_NECESSARY;
        private static final String FIELD_ALLOW_VIDEO_MIXED_MIME_TYPE_ADAPTIVENESS;
        private static final String FIELD_ALLOW_VIDEO_NON_SEAMLESS_ADAPTIVENESS;
        private static final String FIELD_EXCEED_AUDIO_CONSTRAINTS_IF_NECESSARY;
        private static final String FIELD_ALLOW_AUDIO_MIXED_MIME_TYPE_ADAPTIVENESS;
        private static final String FIELD_ALLOW_AUDIO_MIXED_SAMPLE_RATE_ADAPTIVENESS;
        private static final String FIELD_ALLOW_AUDIO_MIXED_CHANNEL_COUNT_ADAPTIVENESS;
        private static final String FIELD_EXCEED_RENDERER_CAPABILITIES_IF_NECESSARY;
        private static final String FIELD_TUNNELING_ENABLED;
        private static final String FIELD_ALLOW_MULTIPLE_ADAPTIVE_SELECTIONS;
        private static final String FIELD_SELECTION_OVERRIDES_RENDERER_INDICES;
        private static final String FIELD_SELECTION_OVERRIDES_TRACK_GROUP_ARRAYS;
        private static final String FIELD_SELECTION_OVERRIDES;
        private static final String FIELD_RENDERER_DISABLED_INDICES;
        private static final String FIELD_ALLOW_VIDEO_MIXED_DECODER_SUPPORT_ADAPTIVENESS;
        private static final String FIELD_ALLOW_AUDIO_MIXED_DECODER_SUPPORT_ADAPTIVENESS;
        private static final String FIELD_CONSTRAIN_AUDIO_CHANNEL_COUNT_TO_DEVICE_CAPABILITIES;
        private static final String FIELD_ALLOW_INVALIDATE_SELECTIONS_ON_RENDERER_CAPABILITIES_CHANGE;
        public static final Bundleable.Creator<Parameters> CREATOR;

        public static Parameters getDefaults(Context context) {
            return new Builder(context).build();
        }

        private Parameters(Builder builder) {
            super((TrackSelectionParameters.Builder)builder);
            this.exceedVideoConstraintsIfNecessary = builder.exceedVideoConstraintsIfNecessary;
            this.allowVideoMixedMimeTypeAdaptiveness = builder.allowVideoMixedMimeTypeAdaptiveness;
            this.allowVideoNonSeamlessAdaptiveness = builder.allowVideoNonSeamlessAdaptiveness;
            this.allowVideoMixedDecoderSupportAdaptiveness = builder.allowVideoMixedDecoderSupportAdaptiveness;
            this.exceedAudioConstraintsIfNecessary = builder.exceedAudioConstraintsIfNecessary;
            this.allowAudioMixedMimeTypeAdaptiveness = builder.allowAudioMixedMimeTypeAdaptiveness;
            this.allowAudioMixedSampleRateAdaptiveness = builder.allowAudioMixedSampleRateAdaptiveness;
            this.allowAudioMixedChannelCountAdaptiveness = builder.allowAudioMixedChannelCountAdaptiveness;
            this.allowAudioMixedDecoderSupportAdaptiveness = builder.allowAudioMixedDecoderSupportAdaptiveness;
            this.constrainAudioChannelCountToDeviceCapabilities = builder.constrainAudioChannelCountToDeviceCapabilities;
            this.exceedRendererCapabilitiesIfNecessary = builder.exceedRendererCapabilitiesIfNecessary;
            this.tunnelingEnabled = builder.tunnelingEnabled;
            this.allowMultipleAdaptiveSelections = builder.allowMultipleAdaptiveSelections;
            this.allowInvalidateSelectionsOnRendererCapabilitiesChange = builder.allowInvalidateSelectionsOnRendererCapabilitiesChange;
            this.selectionOverrides = builder.selectionOverrides;
            this.rendererDisabledFlags = builder.rendererDisabledFlags;
        }

        public boolean getRendererDisabled(int rendererIndex) {
            return this.rendererDisabledFlags.get(rendererIndex);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Deprecated
        public boolean hasSelectionOverride(int rendererIndex, TrackGroupArray groups) {
            @NullableType Map overrides = (Map)this.selectionOverrides.get(rendererIndex);
            return overrides != null && overrides.containsKey(groups);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Deprecated
        @Nullable
        public SelectionOverride getSelectionOverride(int rendererIndex, TrackGroupArray groups) {
            @NullableType Map overrides = (Map)this.selectionOverrides.get(rendererIndex);
            return overrides != null ? (SelectionOverride)overrides.get(groups) : null;
        }

        public Builder buildUpon() {
            return new Builder(this);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Parameters other = (Parameters)((Object)obj);
            return super.equals((Object)other) && this.exceedVideoConstraintsIfNecessary == other.exceedVideoConstraintsIfNecessary && this.allowVideoMixedMimeTypeAdaptiveness == other.allowVideoMixedMimeTypeAdaptiveness && this.allowVideoNonSeamlessAdaptiveness == other.allowVideoNonSeamlessAdaptiveness && this.allowVideoMixedDecoderSupportAdaptiveness == other.allowVideoMixedDecoderSupportAdaptiveness && this.exceedAudioConstraintsIfNecessary == other.exceedAudioConstraintsIfNecessary && this.allowAudioMixedMimeTypeAdaptiveness == other.allowAudioMixedMimeTypeAdaptiveness && this.allowAudioMixedSampleRateAdaptiveness == other.allowAudioMixedSampleRateAdaptiveness && this.allowAudioMixedChannelCountAdaptiveness == other.allowAudioMixedChannelCountAdaptiveness && this.allowAudioMixedDecoderSupportAdaptiveness == other.allowAudioMixedDecoderSupportAdaptiveness && this.constrainAudioChannelCountToDeviceCapabilities == other.constrainAudioChannelCountToDeviceCapabilities && this.exceedRendererCapabilitiesIfNecessary == other.exceedRendererCapabilitiesIfNecessary && this.tunnelingEnabled == other.tunnelingEnabled && this.allowMultipleAdaptiveSelections == other.allowMultipleAdaptiveSelections && this.allowInvalidateSelectionsOnRendererCapabilitiesChange == other.allowInvalidateSelectionsOnRendererCapabilitiesChange && Parameters.areRendererDisabledFlagsEqual(this.rendererDisabledFlags, other.rendererDisabledFlags) && Parameters.areSelectionOverridesEqual(this.selectionOverrides, other.selectionOverrides);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + super.hashCode();
            result = 31 * result + (this.exceedVideoConstraintsIfNecessary ? 1 : 0);
            result = 31 * result + (this.allowVideoMixedMimeTypeAdaptiveness ? 1 : 0);
            result = 31 * result + (this.allowVideoNonSeamlessAdaptiveness ? 1 : 0);
            result = 31 * result + (this.allowVideoMixedDecoderSupportAdaptiveness ? 1 : 0);
            result = 31 * result + (this.exceedAudioConstraintsIfNecessary ? 1 : 0);
            result = 31 * result + (this.allowAudioMixedMimeTypeAdaptiveness ? 1 : 0);
            result = 31 * result + (this.allowAudioMixedSampleRateAdaptiveness ? 1 : 0);
            result = 31 * result + (this.allowAudioMixedChannelCountAdaptiveness ? 1 : 0);
            result = 31 * result + (this.allowAudioMixedDecoderSupportAdaptiveness ? 1 : 0);
            result = 31 * result + (this.constrainAudioChannelCountToDeviceCapabilities ? 1 : 0);
            result = 31 * result + (this.exceedRendererCapabilitiesIfNecessary ? 1 : 0);
            result = 31 * result + (this.tunnelingEnabled ? 1 : 0);
            result = 31 * result + (this.allowMultipleAdaptiveSelections ? 1 : 0);
            result = 31 * result + (this.allowInvalidateSelectionsOnRendererCapabilitiesChange ? 1 : 0);
            return result;
        }

        public Bundle toBundle() {
            Bundle bundle = super.toBundle();
            bundle.putBoolean(FIELD_EXCEED_VIDEO_CONSTRAINTS_IF_NECESSARY, this.exceedVideoConstraintsIfNecessary);
            bundle.putBoolean(FIELD_ALLOW_VIDEO_MIXED_MIME_TYPE_ADAPTIVENESS, this.allowVideoMixedMimeTypeAdaptiveness);
            bundle.putBoolean(FIELD_ALLOW_VIDEO_NON_SEAMLESS_ADAPTIVENESS, this.allowVideoNonSeamlessAdaptiveness);
            bundle.putBoolean(FIELD_ALLOW_VIDEO_MIXED_DECODER_SUPPORT_ADAPTIVENESS, this.allowVideoMixedDecoderSupportAdaptiveness);
            bundle.putBoolean(FIELD_EXCEED_AUDIO_CONSTRAINTS_IF_NECESSARY, this.exceedAudioConstraintsIfNecessary);
            bundle.putBoolean(FIELD_ALLOW_AUDIO_MIXED_MIME_TYPE_ADAPTIVENESS, this.allowAudioMixedMimeTypeAdaptiveness);
            bundle.putBoolean(FIELD_ALLOW_AUDIO_MIXED_SAMPLE_RATE_ADAPTIVENESS, this.allowAudioMixedSampleRateAdaptiveness);
            bundle.putBoolean(FIELD_ALLOW_AUDIO_MIXED_CHANNEL_COUNT_ADAPTIVENESS, this.allowAudioMixedChannelCountAdaptiveness);
            bundle.putBoolean(FIELD_ALLOW_AUDIO_MIXED_DECODER_SUPPORT_ADAPTIVENESS, this.allowAudioMixedDecoderSupportAdaptiveness);
            bundle.putBoolean(FIELD_CONSTRAIN_AUDIO_CHANNEL_COUNT_TO_DEVICE_CAPABILITIES, this.constrainAudioChannelCountToDeviceCapabilities);
            bundle.putBoolean(FIELD_EXCEED_RENDERER_CAPABILITIES_IF_NECESSARY, this.exceedRendererCapabilitiesIfNecessary);
            bundle.putBoolean(FIELD_TUNNELING_ENABLED, this.tunnelingEnabled);
            bundle.putBoolean(FIELD_ALLOW_MULTIPLE_ADAPTIVE_SELECTIONS, this.allowMultipleAdaptiveSelections);
            bundle.putBoolean(FIELD_ALLOW_INVALIDATE_SELECTIONS_ON_RENDERER_CAPABILITIES_CHANGE, this.allowInvalidateSelectionsOnRendererCapabilitiesChange);
            Parameters.putSelectionOverridesToBundle(bundle, this.selectionOverrides);
            bundle.putIntArray(FIELD_RENDERER_DISABLED_INDICES, Parameters.getKeysFromSparseBooleanArray(this.rendererDisabledFlags));
            return bundle;
        }

        private static void putSelectionOverridesToBundle(Bundle bundle, SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> selectionOverrides) {
            ArrayList<Integer> rendererIndices = new ArrayList<Integer>();
            ArrayList<TrackGroupArray> trackGroupArrays = new ArrayList<TrackGroupArray>();
            SparseArray selections = new SparseArray();
            for (int i = 0; i < selectionOverrides.size(); ++i) {
                int rendererIndex = selectionOverrides.keyAt(i);
                for (Map.Entry override : ((Map)selectionOverrides.valueAt(i)).entrySet()) {
                    SelectionOverride selection = (SelectionOverride)override.getValue();
                    if (selection != null) {
                        selections.put(trackGroupArrays.size(), (Object)selection);
                    }
                    trackGroupArrays.add((TrackGroupArray)override.getKey());
                    rendererIndices.add(rendererIndex);
                }
                bundle.putIntArray(FIELD_SELECTION_OVERRIDES_RENDERER_INDICES, Ints.toArray(rendererIndices));
                bundle.putParcelableArrayList(FIELD_SELECTION_OVERRIDES_TRACK_GROUP_ARRAYS, BundleableUtil.toBundleArrayList(trackGroupArrays));
                bundle.putSparseParcelableArray(FIELD_SELECTION_OVERRIDES, BundleableUtil.toBundleSparseArray((SparseArray)selections));
            }
        }

        private static int[] getKeysFromSparseBooleanArray(SparseBooleanArray sparseBooleanArray) {
            int[] keys = new int[sparseBooleanArray.size()];
            for (int i = 0; i < sparseBooleanArray.size(); ++i) {
                keys[i] = sparseBooleanArray.keyAt(i);
            }
            return keys;
        }

        private static boolean areRendererDisabledFlagsEqual(SparseBooleanArray first, SparseBooleanArray second) {
            int firstSize = first.size();
            if (second.size() != firstSize) {
                return false;
            }
            for (int indexInFirst = 0; indexInFirst < firstSize; ++indexInFirst) {
                if (second.indexOfKey(first.keyAt(indexInFirst)) >= 0) continue;
                return false;
            }
            return true;
        }

        private static boolean areSelectionOverridesEqual(SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> first, SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> second) {
            int firstSize = first.size();
            if (second.size() != firstSize) {
                return false;
            }
            for (int indexInFirst = 0; indexInFirst < firstSize; ++indexInFirst) {
                int indexInSecond = second.indexOfKey(first.keyAt(indexInFirst));
                if (indexInSecond >= 0 && Parameters.areSelectionOverridesEqual((Map)first.valueAt(indexInFirst), (Map)second.valueAt(indexInSecond))) continue;
                return false;
            }
            return true;
        }

        private static boolean areSelectionOverridesEqual(Map<TrackGroupArray, @NullableType SelectionOverride> first, Map<TrackGroupArray, @NullableType SelectionOverride> second) {
            int firstSize = first.size();
            if (second.size() != firstSize) {
                return false;
            }
            for (Map.Entry<TrackGroupArray, SelectionOverride> firstEntry : first.entrySet()) {
                TrackGroupArray key = firstEntry.getKey();
                if (second.containsKey(key) && Util.areEqual((Object)firstEntry.getValue(), (Object)second.get(key))) continue;
                return false;
            }
            return true;
        }

        static {
            DEFAULT = DEFAULT_WITHOUT_CONTEXT = new Builder().build();
            FIELD_EXCEED_VIDEO_CONSTRAINTS_IF_NECESSARY = Util.intToStringMaxRadix((int)1000);
            FIELD_ALLOW_VIDEO_MIXED_MIME_TYPE_ADAPTIVENESS = Util.intToStringMaxRadix((int)1001);
            FIELD_ALLOW_VIDEO_NON_SEAMLESS_ADAPTIVENESS = Util.intToStringMaxRadix((int)1002);
            FIELD_EXCEED_AUDIO_CONSTRAINTS_IF_NECESSARY = Util.intToStringMaxRadix((int)1003);
            FIELD_ALLOW_AUDIO_MIXED_MIME_TYPE_ADAPTIVENESS = Util.intToStringMaxRadix((int)1004);
            FIELD_ALLOW_AUDIO_MIXED_SAMPLE_RATE_ADAPTIVENESS = Util.intToStringMaxRadix((int)1005);
            FIELD_ALLOW_AUDIO_MIXED_CHANNEL_COUNT_ADAPTIVENESS = Util.intToStringMaxRadix((int)1006);
            FIELD_EXCEED_RENDERER_CAPABILITIES_IF_NECESSARY = Util.intToStringMaxRadix((int)1007);
            FIELD_TUNNELING_ENABLED = Util.intToStringMaxRadix((int)1008);
            FIELD_ALLOW_MULTIPLE_ADAPTIVE_SELECTIONS = Util.intToStringMaxRadix((int)1009);
            FIELD_SELECTION_OVERRIDES_RENDERER_INDICES = Util.intToStringMaxRadix((int)1010);
            FIELD_SELECTION_OVERRIDES_TRACK_GROUP_ARRAYS = Util.intToStringMaxRadix((int)1011);
            FIELD_SELECTION_OVERRIDES = Util.intToStringMaxRadix((int)1012);
            FIELD_RENDERER_DISABLED_INDICES = Util.intToStringMaxRadix((int)1013);
            FIELD_ALLOW_VIDEO_MIXED_DECODER_SUPPORT_ADAPTIVENESS = Util.intToStringMaxRadix((int)1014);
            FIELD_ALLOW_AUDIO_MIXED_DECODER_SUPPORT_ADAPTIVENESS = Util.intToStringMaxRadix((int)1015);
            FIELD_CONSTRAIN_AUDIO_CHANNEL_COUNT_TO_DEVICE_CAPABILITIES = Util.intToStringMaxRadix((int)1016);
            FIELD_ALLOW_INVALIDATE_SELECTIONS_ON_RENDERER_CAPABILITIES_CHANGE = Util.intToStringMaxRadix((int)1017);
            CREATOR = bundle -> new Builder(bundle).build();
        }

        public static final class Builder
        extends TrackSelectionParameters.Builder {
            private boolean exceedVideoConstraintsIfNecessary;
            private boolean allowVideoMixedMimeTypeAdaptiveness;
            private boolean allowVideoNonSeamlessAdaptiveness;
            private boolean allowVideoMixedDecoderSupportAdaptiveness;
            private boolean exceedAudioConstraintsIfNecessary;
            private boolean allowAudioMixedMimeTypeAdaptiveness;
            private boolean allowAudioMixedSampleRateAdaptiveness;
            private boolean allowAudioMixedChannelCountAdaptiveness;
            private boolean allowAudioMixedDecoderSupportAdaptiveness;
            private boolean constrainAudioChannelCountToDeviceCapabilities;
            private boolean exceedRendererCapabilitiesIfNecessary;
            private boolean tunnelingEnabled;
            private boolean allowMultipleAdaptiveSelections;
            private boolean allowInvalidateSelectionsOnRendererCapabilitiesChange;
            private final SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> selectionOverrides;
            private final SparseBooleanArray rendererDisabledFlags;

            @Deprecated
            public Builder() {
                this.selectionOverrides = new SparseArray();
                this.rendererDisabledFlags = new SparseBooleanArray();
                this.init();
            }

            public Builder(Context context) {
                super(context);
                this.selectionOverrides = new SparseArray();
                this.rendererDisabledFlags = new SparseBooleanArray();
                this.init();
            }

            private Builder(Parameters initialValues) {
                super((TrackSelectionParameters)initialValues);
                this.exceedVideoConstraintsIfNecessary = initialValues.exceedVideoConstraintsIfNecessary;
                this.allowVideoMixedMimeTypeAdaptiveness = initialValues.allowVideoMixedMimeTypeAdaptiveness;
                this.allowVideoNonSeamlessAdaptiveness = initialValues.allowVideoNonSeamlessAdaptiveness;
                this.allowVideoMixedDecoderSupportAdaptiveness = initialValues.allowVideoMixedDecoderSupportAdaptiveness;
                this.exceedAudioConstraintsIfNecessary = initialValues.exceedAudioConstraintsIfNecessary;
                this.allowAudioMixedMimeTypeAdaptiveness = initialValues.allowAudioMixedMimeTypeAdaptiveness;
                this.allowAudioMixedSampleRateAdaptiveness = initialValues.allowAudioMixedSampleRateAdaptiveness;
                this.allowAudioMixedChannelCountAdaptiveness = initialValues.allowAudioMixedChannelCountAdaptiveness;
                this.allowAudioMixedDecoderSupportAdaptiveness = initialValues.allowAudioMixedDecoderSupportAdaptiveness;
                this.constrainAudioChannelCountToDeviceCapabilities = initialValues.constrainAudioChannelCountToDeviceCapabilities;
                this.exceedRendererCapabilitiesIfNecessary = initialValues.exceedRendererCapabilitiesIfNecessary;
                this.tunnelingEnabled = initialValues.tunnelingEnabled;
                this.allowMultipleAdaptiveSelections = initialValues.allowMultipleAdaptiveSelections;
                this.allowInvalidateSelectionsOnRendererCapabilitiesChange = initialValues.allowInvalidateSelectionsOnRendererCapabilitiesChange;
                this.selectionOverrides = Builder.cloneSelectionOverrides((SparseArray<Map<TrackGroupArray, SelectionOverride>>)initialValues.selectionOverrides);
                this.rendererDisabledFlags = initialValues.rendererDisabledFlags.clone();
            }

            private Builder(Bundle bundle) {
                super(bundle);
                this.init();
                Parameters defaultValue = DEFAULT_WITHOUT_CONTEXT;
                this.setExceedVideoConstraintsIfNecessary(bundle.getBoolean(FIELD_EXCEED_VIDEO_CONSTRAINTS_IF_NECESSARY, defaultValue.exceedVideoConstraintsIfNecessary));
                this.setAllowVideoMixedMimeTypeAdaptiveness(bundle.getBoolean(FIELD_ALLOW_VIDEO_MIXED_MIME_TYPE_ADAPTIVENESS, defaultValue.allowVideoMixedMimeTypeAdaptiveness));
                this.setAllowVideoNonSeamlessAdaptiveness(bundle.getBoolean(FIELD_ALLOW_VIDEO_NON_SEAMLESS_ADAPTIVENESS, defaultValue.allowVideoNonSeamlessAdaptiveness));
                this.setAllowVideoMixedDecoderSupportAdaptiveness(bundle.getBoolean(FIELD_ALLOW_VIDEO_MIXED_DECODER_SUPPORT_ADAPTIVENESS, defaultValue.allowVideoMixedDecoderSupportAdaptiveness));
                this.setExceedAudioConstraintsIfNecessary(bundle.getBoolean(FIELD_EXCEED_AUDIO_CONSTRAINTS_IF_NECESSARY, defaultValue.exceedAudioConstraintsIfNecessary));
                this.setAllowAudioMixedMimeTypeAdaptiveness(bundle.getBoolean(FIELD_ALLOW_AUDIO_MIXED_MIME_TYPE_ADAPTIVENESS, defaultValue.allowAudioMixedMimeTypeAdaptiveness));
                this.setAllowAudioMixedSampleRateAdaptiveness(bundle.getBoolean(FIELD_ALLOW_AUDIO_MIXED_SAMPLE_RATE_ADAPTIVENESS, defaultValue.allowAudioMixedSampleRateAdaptiveness));
                this.setAllowAudioMixedChannelCountAdaptiveness(bundle.getBoolean(FIELD_ALLOW_AUDIO_MIXED_CHANNEL_COUNT_ADAPTIVENESS, defaultValue.allowAudioMixedChannelCountAdaptiveness));
                this.setAllowAudioMixedDecoderSupportAdaptiveness(bundle.getBoolean(FIELD_ALLOW_AUDIO_MIXED_DECODER_SUPPORT_ADAPTIVENESS, defaultValue.allowAudioMixedDecoderSupportAdaptiveness));
                this.setConstrainAudioChannelCountToDeviceCapabilities(bundle.getBoolean(FIELD_CONSTRAIN_AUDIO_CHANNEL_COUNT_TO_DEVICE_CAPABILITIES, defaultValue.constrainAudioChannelCountToDeviceCapabilities));
                this.setExceedRendererCapabilitiesIfNecessary(bundle.getBoolean(FIELD_EXCEED_RENDERER_CAPABILITIES_IF_NECESSARY, defaultValue.exceedRendererCapabilitiesIfNecessary));
                this.setTunnelingEnabled(bundle.getBoolean(FIELD_TUNNELING_ENABLED, defaultValue.tunnelingEnabled));
                this.setAllowMultipleAdaptiveSelections(bundle.getBoolean(FIELD_ALLOW_MULTIPLE_ADAPTIVE_SELECTIONS, defaultValue.allowMultipleAdaptiveSelections));
                this.setAllowInvalidateSelectionsOnRendererCapabilitiesChange(bundle.getBoolean(FIELD_ALLOW_INVALIDATE_SELECTIONS_ON_RENDERER_CAPABILITIES_CHANGE, defaultValue.allowInvalidateSelectionsOnRendererCapabilitiesChange));
                this.selectionOverrides = new SparseArray();
                this.setSelectionOverridesFromBundle(bundle);
                this.rendererDisabledFlags = this.makeSparseBooleanArrayFromTrueKeys(bundle.getIntArray(FIELD_RENDERER_DISABLED_INDICES));
            }

            @CanIgnoreReturnValue
            protected Builder set(TrackSelectionParameters parameters) {
                super.set(parameters);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMaxVideoSizeSd() {
                super.setMaxVideoSizeSd();
                return this;
            }

            @CanIgnoreReturnValue
            public Builder clearVideoSizeConstraints() {
                super.clearVideoSizeConstraints();
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMaxVideoSize(int maxVideoWidth, int maxVideoHeight) {
                super.setMaxVideoSize(maxVideoWidth, maxVideoHeight);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMaxVideoFrameRate(int maxVideoFrameRate) {
                super.setMaxVideoFrameRate(maxVideoFrameRate);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMaxVideoBitrate(int maxVideoBitrate) {
                super.setMaxVideoBitrate(maxVideoBitrate);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMinVideoSize(int minVideoWidth, int minVideoHeight) {
                super.setMinVideoSize(minVideoWidth, minVideoHeight);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMinVideoFrameRate(int minVideoFrameRate) {
                super.setMinVideoFrameRate(minVideoFrameRate);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMinVideoBitrate(int minVideoBitrate) {
                super.setMinVideoBitrate(minVideoBitrate);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setExceedVideoConstraintsIfNecessary(boolean exceedVideoConstraintsIfNecessary) {
                this.exceedVideoConstraintsIfNecessary = exceedVideoConstraintsIfNecessary;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setAllowVideoMixedMimeTypeAdaptiveness(boolean allowVideoMixedMimeTypeAdaptiveness) {
                this.allowVideoMixedMimeTypeAdaptiveness = allowVideoMixedMimeTypeAdaptiveness;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setAllowVideoNonSeamlessAdaptiveness(boolean allowVideoNonSeamlessAdaptiveness) {
                this.allowVideoNonSeamlessAdaptiveness = allowVideoNonSeamlessAdaptiveness;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setAllowVideoMixedDecoderSupportAdaptiveness(boolean allowVideoMixedDecoderSupportAdaptiveness) {
                this.allowVideoMixedDecoderSupportAdaptiveness = allowVideoMixedDecoderSupportAdaptiveness;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setViewportSizeToPhysicalDisplaySize(Context context, boolean viewportOrientationMayChange) {
                super.setViewportSizeToPhysicalDisplaySize(context, viewportOrientationMayChange);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder clearViewportSizeConstraints() {
                super.clearViewportSizeConstraints();
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setViewportSize(int viewportWidth, int viewportHeight, boolean viewportOrientationMayChange) {
                super.setViewportSize(viewportWidth, viewportHeight, viewportOrientationMayChange);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPreferredVideoMimeType(@Nullable String mimeType) {
                super.setPreferredVideoMimeType(mimeType);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPreferredVideoMimeTypes(String ... mimeTypes) {
                super.setPreferredVideoMimeTypes(mimeTypes);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPreferredVideoRoleFlags(int preferredVideoRoleFlags) {
                super.setPreferredVideoRoleFlags(preferredVideoRoleFlags);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPreferredAudioLanguage(@Nullable String preferredAudioLanguage) {
                super.setPreferredAudioLanguage(preferredAudioLanguage);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPreferredAudioLanguages(String ... preferredAudioLanguages) {
                super.setPreferredAudioLanguages(preferredAudioLanguages);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPreferredAudioRoleFlags(int preferredAudioRoleFlags) {
                super.setPreferredAudioRoleFlags(preferredAudioRoleFlags);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMaxAudioChannelCount(int maxAudioChannelCount) {
                super.setMaxAudioChannelCount(maxAudioChannelCount);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMaxAudioBitrate(int maxAudioBitrate) {
                super.setMaxAudioBitrate(maxAudioBitrate);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setExceedAudioConstraintsIfNecessary(boolean exceedAudioConstraintsIfNecessary) {
                this.exceedAudioConstraintsIfNecessary = exceedAudioConstraintsIfNecessary;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setAllowAudioMixedMimeTypeAdaptiveness(boolean allowAudioMixedMimeTypeAdaptiveness) {
                this.allowAudioMixedMimeTypeAdaptiveness = allowAudioMixedMimeTypeAdaptiveness;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setAllowAudioMixedSampleRateAdaptiveness(boolean allowAudioMixedSampleRateAdaptiveness) {
                this.allowAudioMixedSampleRateAdaptiveness = allowAudioMixedSampleRateAdaptiveness;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setAllowAudioMixedChannelCountAdaptiveness(boolean allowAudioMixedChannelCountAdaptiveness) {
                this.allowAudioMixedChannelCountAdaptiveness = allowAudioMixedChannelCountAdaptiveness;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setAllowAudioMixedDecoderSupportAdaptiveness(boolean allowAudioMixedDecoderSupportAdaptiveness) {
                this.allowAudioMixedDecoderSupportAdaptiveness = allowAudioMixedDecoderSupportAdaptiveness;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPreferredAudioMimeType(@Nullable String mimeType) {
                super.setPreferredAudioMimeType(mimeType);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPreferredAudioMimeTypes(String ... mimeTypes) {
                super.setPreferredAudioMimeTypes(mimeTypes);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setConstrainAudioChannelCountToDeviceCapabilities(boolean enabled) {
                this.constrainAudioChannelCountToDeviceCapabilities = enabled;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(Context context) {
                super.setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(context);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPreferredTextLanguage(@Nullable String preferredTextLanguage) {
                super.setPreferredTextLanguage(preferredTextLanguage);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPreferredTextLanguages(String ... preferredTextLanguages) {
                super.setPreferredTextLanguages(preferredTextLanguages);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setPreferredTextRoleFlags(int preferredTextRoleFlags) {
                super.setPreferredTextRoleFlags(preferredTextRoleFlags);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setIgnoredTextSelectionFlags(int ignoredTextSelectionFlags) {
                super.setIgnoredTextSelectionFlags(ignoredTextSelectionFlags);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setSelectUndeterminedTextLanguage(boolean selectUndeterminedTextLanguage) {
                super.setSelectUndeterminedTextLanguage(selectUndeterminedTextLanguage);
                return this;
            }

            @Deprecated
            @CanIgnoreReturnValue
            public Builder setDisabledTextTrackSelectionFlags(int disabledTextTrackSelectionFlags) {
                return this.setIgnoredTextSelectionFlags(disabledTextTrackSelectionFlags);
            }

            @CanIgnoreReturnValue
            public Builder setForceLowestBitrate(boolean forceLowestBitrate) {
                super.setForceLowestBitrate(forceLowestBitrate);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setForceHighestSupportedBitrate(boolean forceHighestSupportedBitrate) {
                super.setForceHighestSupportedBitrate(forceHighestSupportedBitrate);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setAllowInvalidateSelectionsOnRendererCapabilitiesChange(boolean allowInvalidateSelectionsOnRendererCapabilitiesChange) {
                this.allowInvalidateSelectionsOnRendererCapabilitiesChange = allowInvalidateSelectionsOnRendererCapabilitiesChange;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder addOverride(TrackSelectionOverride override) {
                super.addOverride(override);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder clearOverride(TrackGroup trackGroup) {
                super.clearOverride(trackGroup);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setOverrideForType(TrackSelectionOverride override) {
                super.setOverrideForType(override);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder clearOverridesOfType(int trackType) {
                super.clearOverridesOfType(trackType);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder clearOverrides() {
                super.clearOverrides();
                return this;
            }

            @Deprecated
            @CanIgnoreReturnValue
            public Builder setDisabledTrackTypes(Set<Integer> disabledTrackTypes) {
                super.setDisabledTrackTypes(disabledTrackTypes);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setTrackTypeDisabled(int trackType, boolean disabled) {
                super.setTrackTypeDisabled(trackType, disabled);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setExceedRendererCapabilitiesIfNecessary(boolean exceedRendererCapabilitiesIfNecessary) {
                this.exceedRendererCapabilitiesIfNecessary = exceedRendererCapabilitiesIfNecessary;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setTunnelingEnabled(boolean tunnelingEnabled) {
                this.tunnelingEnabled = tunnelingEnabled;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setAllowMultipleAdaptiveSelections(boolean allowMultipleAdaptiveSelections) {
                this.allowMultipleAdaptiveSelections = allowMultipleAdaptiveSelections;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setRendererDisabled(int rendererIndex, boolean disabled) {
                if (this.rendererDisabledFlags.get(rendererIndex) == disabled) {
                    return this;
                }
                if (disabled) {
                    this.rendererDisabledFlags.put(rendererIndex, true);
                } else {
                    this.rendererDisabledFlags.delete(rendererIndex);
                }
                return this;
            }

            @Deprecated
            @CanIgnoreReturnValue
            public Builder setSelectionOverride(int rendererIndex, TrackGroupArray groups, @Nullable SelectionOverride override) {
                HashMap<TrackGroupArray, @NullableType SelectionOverride> overrides = (HashMap<TrackGroupArray, SelectionOverride>)this.selectionOverrides.get(rendererIndex);
                if (overrides == null) {
                    overrides = new HashMap<TrackGroupArray, SelectionOverride>();
                    this.selectionOverrides.put(rendererIndex, overrides);
                }
                if (overrides.containsKey(groups) && Util.areEqual(overrides.get(groups), (Object)override)) {
                    return this;
                }
                overrides.put(groups, override);
                return this;
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Deprecated
            @CanIgnoreReturnValue
            public Builder clearSelectionOverride(int rendererIndex, TrackGroupArray groups) {
                @NullableType Map overrides = (Map)this.selectionOverrides.get(rendererIndex);
                if (overrides == null || !overrides.containsKey(groups)) {
                    return this;
                }
                overrides.remove(groups);
                if (overrides.isEmpty()) {
                    this.selectionOverrides.remove(rendererIndex);
                }
                return this;
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @Deprecated
            @CanIgnoreReturnValue
            public Builder clearSelectionOverrides(int rendererIndex) {
                @NullableType Map overrides = (Map)this.selectionOverrides.get(rendererIndex);
                if (overrides == null || overrides.isEmpty()) {
                    return this;
                }
                this.selectionOverrides.remove(rendererIndex);
                return this;
            }

            @Deprecated
            @CanIgnoreReturnValue
            public Builder clearSelectionOverrides() {
                if (this.selectionOverrides.size() == 0) {
                    return this;
                }
                this.selectionOverrides.clear();
                return this;
            }

            public Parameters build() {
                return new Parameters(this);
            }

            private void init() {
                this.exceedVideoConstraintsIfNecessary = true;
                this.allowVideoMixedMimeTypeAdaptiveness = false;
                this.allowVideoNonSeamlessAdaptiveness = true;
                this.allowVideoMixedDecoderSupportAdaptiveness = false;
                this.exceedAudioConstraintsIfNecessary = true;
                this.allowAudioMixedMimeTypeAdaptiveness = false;
                this.allowAudioMixedSampleRateAdaptiveness = false;
                this.allowAudioMixedChannelCountAdaptiveness = false;
                this.allowAudioMixedDecoderSupportAdaptiveness = false;
                this.constrainAudioChannelCountToDeviceCapabilities = true;
                this.exceedRendererCapabilitiesIfNecessary = true;
                this.tunnelingEnabled = false;
                this.allowMultipleAdaptiveSelections = true;
                this.allowInvalidateSelectionsOnRendererCapabilitiesChange = false;
            }

            /*
             * Issues handling annotations - annotations may be inaccurate
             */
            private static SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> cloneSelectionOverrides(SparseArray<Map<TrackGroupArray, @NullableType SelectionOverride>> selectionOverrides) {
                @NullableType SparseArray clone = new SparseArray();
                for (int i = 0; i < selectionOverrides.size(); ++i) {
                    clone.put(selectionOverrides.keyAt(i), new HashMap((Map)selectionOverrides.valueAt(i)));
                }
                return clone;
            }

            private void setSelectionOverridesFromBundle(Bundle bundle) {
                SparseArray selectionOverrides;
                int[] rendererIndices = bundle.getIntArray(FIELD_SELECTION_OVERRIDES_RENDERER_INDICES);
                ArrayList trackGroupArrayBundles = bundle.getParcelableArrayList(FIELD_SELECTION_OVERRIDES_TRACK_GROUP_ARRAYS);
                ImmutableList trackGroupArrays = trackGroupArrayBundles == null ? ImmutableList.of() : BundleableUtil.fromBundleList(TrackGroupArray.CREATOR, (List)trackGroupArrayBundles);
                SparseArray selectionOverrideBundles = bundle.getSparseParcelableArray(FIELD_SELECTION_OVERRIDES);
                SparseArray sparseArray = selectionOverrides = selectionOverrideBundles == null ? new SparseArray() : BundleableUtil.fromBundleSparseArray(SelectionOverride.CREATOR, (SparseArray)selectionOverrideBundles);
                if (rendererIndices == null || rendererIndices.length != trackGroupArrays.size()) {
                    return;
                }
                for (int i = 0; i < rendererIndices.length; ++i) {
                    int rendererIndex = rendererIndices[i];
                    TrackGroupArray groups = (TrackGroupArray)trackGroupArrays.get(i);
                    SelectionOverride selectionOverride = (SelectionOverride)selectionOverrides.get(i);
                    this.setSelectionOverride(rendererIndex, groups, selectionOverride);
                }
            }

            private SparseBooleanArray makeSparseBooleanArrayFromTrueKeys(@Nullable int[] trueKeys) {
                if (trueKeys == null) {
                    return new SparseBooleanArray();
                }
                SparseBooleanArray sparseBooleanArray = new SparseBooleanArray(trueKeys.length);
                for (int trueKey : trueKeys) {
                    sparseBooleanArray.append(trueKey, true);
                }
                return sparseBooleanArray;
            }
        }
    }

    @RequiresApi(value=32)
    private static class SpatializerWrapperV32 {
        private final Spatializer spatializer;
        private final boolean spatializationSupported;
        @Nullable
        private Handler handler;
        @Nullable
        private Spatializer.OnSpatializerStateChangedListener listener;

        @Nullable
        public static SpatializerWrapperV32 tryCreateInstance(Context context) {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            return audioManager == null ? null : new SpatializerWrapperV32(audioManager.getSpatializer());
        }

        private SpatializerWrapperV32(Spatializer spatializer) {
            this.spatializer = spatializer;
            this.spatializationSupported = spatializer.getImmersiveAudioLevel() != 0;
        }

        public void ensureInitialized(final DefaultTrackSelector defaultTrackSelector, Looper looper) {
            if (this.listener != null || this.handler != null) {
                return;
            }
            this.listener = new Spatializer.OnSpatializerStateChangedListener(){

                public void onSpatializerEnabledChanged(Spatializer spatializer, boolean enabled) {
                    defaultTrackSelector.maybeInvalidateForAudioChannelCountConstraints();
                }

                public void onSpatializerAvailableChanged(Spatializer spatializer, boolean available) {
                    defaultTrackSelector.maybeInvalidateForAudioChannelCountConstraints();
                }
            };
            this.handler = new Handler(looper);
            this.spatializer.addOnSpatializerStateChangedListener(arg_0 -> ((Handler)this.handler).post(arg_0), this.listener);
        }

        public boolean isSpatializationSupported() {
            return this.spatializationSupported;
        }

        public boolean isAvailable() {
            return this.spatializer.isAvailable();
        }

        public boolean isEnabled() {
            return this.spatializer.isEnabled();
        }

        public boolean canBeSpatialized(AudioAttributes audioAttributes, Format format) {
            int linearChannelCount = "audio/eac3-joc".equals(format.sampleMimeType) && format.channelCount == 16 ? 12 : format.channelCount;
            AudioFormat.Builder builder = new AudioFormat.Builder().setEncoding(2).setChannelMask(Util.getAudioTrackChannelConfig((int)linearChannelCount));
            if (format.sampleRate != -1) {
                builder.setSampleRate(format.sampleRate);
            }
            return this.spatializer.canBeSpatialized(audioAttributes.getAudioAttributesV21().audioAttributes, builder.build());
        }

        public void release() {
            if (this.listener == null || this.handler == null) {
                return;
            }
            this.spatializer.removeOnSpatializerStateChangedListener(this.listener);
            ((Handler)Util.castNonNull((Object)this.handler)).removeCallbacksAndMessages(null);
            this.handler = null;
            this.listener = null;
        }
    }

    @Deprecated
    public static final class ParametersBuilder
    extends TrackSelectionParameters.Builder {
        private final Parameters.Builder delegate;

        @Deprecated
        public ParametersBuilder() {
            this.delegate = new Parameters.Builder();
        }

        public ParametersBuilder(Context context) {
            this.delegate = new Parameters.Builder(context);
        }

        @CanIgnoreReturnValue
        protected ParametersBuilder set(TrackSelectionParameters parameters) {
            this.delegate.set(parameters);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setMaxVideoSizeSd() {
            this.delegate.setMaxVideoSizeSd();
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder clearVideoSizeConstraints() {
            this.delegate.clearVideoSizeConstraints();
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setMaxVideoSize(int maxVideoWidth, int maxVideoHeight) {
            this.delegate.setMaxVideoSize(maxVideoWidth, maxVideoHeight);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setMaxVideoFrameRate(int maxVideoFrameRate) {
            this.delegate.setMaxVideoFrameRate(maxVideoFrameRate);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setMaxVideoBitrate(int maxVideoBitrate) {
            this.delegate.setMaxVideoBitrate(maxVideoBitrate);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setMinVideoSize(int minVideoWidth, int minVideoHeight) {
            this.delegate.setMinVideoSize(minVideoWidth, minVideoHeight);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setMinVideoFrameRate(int minVideoFrameRate) {
            this.delegate.setMinVideoFrameRate(minVideoFrameRate);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setMinVideoBitrate(int minVideoBitrate) {
            this.delegate.setMinVideoBitrate(minVideoBitrate);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setExceedVideoConstraintsIfNecessary(boolean exceedVideoConstraintsIfNecessary) {
            this.delegate.setExceedVideoConstraintsIfNecessary(exceedVideoConstraintsIfNecessary);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setAllowVideoMixedMimeTypeAdaptiveness(boolean allowVideoMixedMimeTypeAdaptiveness) {
            this.delegate.setAllowVideoMixedMimeTypeAdaptiveness(allowVideoMixedMimeTypeAdaptiveness);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setAllowVideoNonSeamlessAdaptiveness(boolean allowVideoNonSeamlessAdaptiveness) {
            this.delegate.setAllowVideoNonSeamlessAdaptiveness(allowVideoNonSeamlessAdaptiveness);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setAllowVideoMixedDecoderSupportAdaptiveness(boolean allowVideoMixedDecoderSupportAdaptiveness) {
            this.delegate.setAllowVideoMixedDecoderSupportAdaptiveness(allowVideoMixedDecoderSupportAdaptiveness);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setViewportSizeToPhysicalDisplaySize(Context context, boolean viewportOrientationMayChange) {
            this.delegate.setViewportSizeToPhysicalDisplaySize(context, viewportOrientationMayChange);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder clearViewportSizeConstraints() {
            this.delegate.clearViewportSizeConstraints();
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setViewportSize(int viewportWidth, int viewportHeight, boolean viewportOrientationMayChange) {
            this.delegate.setViewportSize(viewportWidth, viewportHeight, viewportOrientationMayChange);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setPreferredVideoMimeType(@Nullable String mimeType) {
            this.delegate.setPreferredVideoMimeType(mimeType);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setPreferredVideoMimeTypes(String ... mimeTypes) {
            this.delegate.setPreferredVideoMimeTypes(mimeTypes);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setPreferredVideoRoleFlags(int preferredVideoRoleFlags) {
            this.delegate.setPreferredVideoRoleFlags(preferredVideoRoleFlags);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setPreferredAudioLanguage(@Nullable String preferredAudioLanguage) {
            this.delegate.setPreferredAudioLanguage(preferredAudioLanguage);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setPreferredAudioLanguages(String ... preferredAudioLanguages) {
            this.delegate.setPreferredAudioLanguages(preferredAudioLanguages);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setPreferredAudioRoleFlags(int preferredAudioRoleFlags) {
            this.delegate.setPreferredAudioRoleFlags(preferredAudioRoleFlags);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setMaxAudioChannelCount(int maxAudioChannelCount) {
            this.delegate.setMaxAudioChannelCount(maxAudioChannelCount);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setMaxAudioBitrate(int maxAudioBitrate) {
            this.delegate.setMaxAudioBitrate(maxAudioBitrate);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setExceedAudioConstraintsIfNecessary(boolean exceedAudioConstraintsIfNecessary) {
            this.delegate.setExceedAudioConstraintsIfNecessary(exceedAudioConstraintsIfNecessary);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setAllowAudioMixedMimeTypeAdaptiveness(boolean allowAudioMixedMimeTypeAdaptiveness) {
            this.delegate.setAllowAudioMixedMimeTypeAdaptiveness(allowAudioMixedMimeTypeAdaptiveness);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setAllowAudioMixedSampleRateAdaptiveness(boolean allowAudioMixedSampleRateAdaptiveness) {
            this.delegate.setAllowAudioMixedSampleRateAdaptiveness(allowAudioMixedSampleRateAdaptiveness);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setAllowAudioMixedChannelCountAdaptiveness(boolean allowAudioMixedChannelCountAdaptiveness) {
            this.delegate.setAllowAudioMixedChannelCountAdaptiveness(allowAudioMixedChannelCountAdaptiveness);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setAllowAudioMixedDecoderSupportAdaptiveness(boolean allowAudioMixedDecoderSupportAdaptiveness) {
            this.delegate.setAllowAudioMixedDecoderSupportAdaptiveness(allowAudioMixedDecoderSupportAdaptiveness);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setPreferredAudioMimeType(@Nullable String mimeType) {
            this.delegate.setPreferredAudioMimeType(mimeType);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setPreferredAudioMimeTypes(String ... mimeTypes) {
            this.delegate.setPreferredAudioMimeTypes(mimeTypes);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(Context context) {
            this.delegate.setPreferredTextLanguageAndRoleFlagsToCaptioningManagerSettings(context);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setPreferredTextLanguage(@Nullable String preferredTextLanguage) {
            this.delegate.setPreferredTextLanguage(preferredTextLanguage);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setPreferredTextLanguages(String ... preferredTextLanguages) {
            this.delegate.setPreferredTextLanguages(preferredTextLanguages);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setPreferredTextRoleFlags(int preferredTextRoleFlags) {
            this.delegate.setPreferredTextRoleFlags(preferredTextRoleFlags);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setIgnoredTextSelectionFlags(int ignoredTextSelectionFlags) {
            this.delegate.setIgnoredTextSelectionFlags(ignoredTextSelectionFlags);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setSelectUndeterminedTextLanguage(boolean selectUndeterminedTextLanguage) {
            this.delegate.setSelectUndeterminedTextLanguage(selectUndeterminedTextLanguage);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public ParametersBuilder setDisabledTextTrackSelectionFlags(int disabledTextTrackSelectionFlags) {
            this.delegate.setDisabledTextTrackSelectionFlags(disabledTextTrackSelectionFlags);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setForceLowestBitrate(boolean forceLowestBitrate) {
            this.delegate.setForceLowestBitrate(forceLowestBitrate);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setForceHighestSupportedBitrate(boolean forceHighestSupportedBitrate) {
            this.delegate.setForceHighestSupportedBitrate(forceHighestSupportedBitrate);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder addOverride(TrackSelectionOverride override) {
            this.delegate.addOverride(override);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder clearOverride(TrackGroup trackGroup) {
            this.delegate.clearOverride(trackGroup);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setOverrideForType(TrackSelectionOverride override) {
            this.delegate.setOverrideForType(override);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder clearOverridesOfType(int trackType) {
            this.delegate.clearOverridesOfType(trackType);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder clearOverrides() {
            this.delegate.clearOverrides();
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public ParametersBuilder setDisabledTrackTypes(Set<Integer> disabledTrackTypes) {
            this.delegate.setDisabledTrackTypes((Set)disabledTrackTypes);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setTrackTypeDisabled(int trackType, boolean disabled) {
            this.delegate.setTrackTypeDisabled(trackType, disabled);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setExceedRendererCapabilitiesIfNecessary(boolean exceedRendererCapabilitiesIfNecessary) {
            this.delegate.setExceedRendererCapabilitiesIfNecessary(exceedRendererCapabilitiesIfNecessary);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setTunnelingEnabled(boolean tunnelingEnabled) {
            this.delegate.setTunnelingEnabled(tunnelingEnabled);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setAllowMultipleAdaptiveSelections(boolean allowMultipleAdaptiveSelections) {
            this.delegate.setAllowMultipleAdaptiveSelections(allowMultipleAdaptiveSelections);
            return this;
        }

        @CanIgnoreReturnValue
        public ParametersBuilder setRendererDisabled(int rendererIndex, boolean disabled) {
            this.delegate.setRendererDisabled(rendererIndex, disabled);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public ParametersBuilder setSelectionOverride(int rendererIndex, TrackGroupArray groups, @Nullable SelectionOverride override) {
            this.delegate.setSelectionOverride(rendererIndex, groups, override);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public ParametersBuilder clearSelectionOverride(int rendererIndex, TrackGroupArray groups) {
            this.delegate.clearSelectionOverride(rendererIndex, groups);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public ParametersBuilder clearSelectionOverrides(int rendererIndex) {
            this.delegate.clearSelectionOverrides(rendererIndex);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public ParametersBuilder clearSelectionOverrides() {
            this.delegate.clearSelectionOverrides();
            return this;
        }

        public Parameters build() {
            return this.delegate.build();
        }
    }

    private static abstract class TrackInfo<T extends TrackInfo<T>> {
        public final int rendererIndex;
        public final TrackGroup trackGroup;
        public final int trackIndex;
        public final Format format;

        public TrackInfo(int rendererIndex, TrackGroup trackGroup, int trackIndex) {
            this.rendererIndex = rendererIndex;
            this.trackGroup = trackGroup;
            this.trackIndex = trackIndex;
            this.format = trackGroup.getFormat(trackIndex);
        }

        public abstract int getSelectionEligibility();

        public abstract boolean isCompatibleForAdaptationWith(T var1);

        public static interface Factory<T extends TrackInfo<T>> {
            public List<T> create(int var1, TrackGroup var2, int[] var3);
        }
    }

    private static final class OtherTrackScore
    implements Comparable<OtherTrackScore> {
        private final boolean isDefault;
        private final boolean isWithinRendererCapabilities;

        public OtherTrackScore(Format format, int trackFormatSupport) {
            this.isDefault = (format.selectionFlags & 1) != 0;
            this.isWithinRendererCapabilities = DefaultTrackSelector.isSupported(trackFormatSupport, false);
        }

        @Override
        public int compareTo(OtherTrackScore other) {
            return ComparisonChain.start().compareFalseFirst(this.isWithinRendererCapabilities, other.isWithinRendererCapabilities).compareFalseFirst(this.isDefault, other.isDefault).result();
        }
    }

    public static final class SelectionOverride
    implements Bundleable {
        public final int groupIndex;
        public final int[] tracks;
        public final int length;
        public final int type;
        private static final String FIELD_GROUP_INDEX = Util.intToStringMaxRadix((int)0);
        private static final String FIELD_TRACKS = Util.intToStringMaxRadix((int)1);
        private static final String FIELD_TRACK_TYPE = Util.intToStringMaxRadix((int)2);
        public static final Bundleable.Creator<SelectionOverride> CREATOR = bundle -> {
            int groupIndex = bundle.getInt(FIELD_GROUP_INDEX, -1);
            int[] tracks = bundle.getIntArray(FIELD_TRACKS);
            int trackType = bundle.getInt(FIELD_TRACK_TYPE, -1);
            Assertions.checkArgument((groupIndex >= 0 && trackType >= 0 ? 1 : 0) != 0);
            Assertions.checkNotNull((Object)tracks);
            return new SelectionOverride(groupIndex, tracks, trackType);
        };

        public SelectionOverride(int groupIndex, int ... tracks) {
            this(groupIndex, tracks, 0);
        }

        public SelectionOverride(int groupIndex, int[] tracks, int type) {
            this.groupIndex = groupIndex;
            this.tracks = Arrays.copyOf(tracks, tracks.length);
            this.length = tracks.length;
            this.type = type;
            Arrays.sort(this.tracks);
        }

        public boolean containsTrack(int track) {
            for (int overrideTrack : this.tracks) {
                if (overrideTrack != track) continue;
                return true;
            }
            return false;
        }

        public int hashCode() {
            int hash = 31 * this.groupIndex + Arrays.hashCode(this.tracks);
            return 31 * hash + this.type;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SelectionOverride other = (SelectionOverride)obj;
            return this.groupIndex == other.groupIndex && Arrays.equals(this.tracks, other.tracks) && this.type == other.type;
        }

        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putInt(FIELD_GROUP_INDEX, this.groupIndex);
            bundle.putIntArray(FIELD_TRACKS, this.tracks);
            bundle.putInt(FIELD_TRACK_TYPE, this.type);
            return bundle;
        }
    }

    private static final class TextTrackInfo
    extends TrackInfo<TextTrackInfo>
    implements Comparable<TextTrackInfo> {
        private final int selectionEligibility;
        private final boolean isWithinRendererCapabilities;
        private final boolean isDefault;
        private final boolean isForced;
        private final int preferredLanguageIndex;
        private final int preferredLanguageScore;
        private final int preferredRoleFlagsScore;
        private final int selectedAudioLanguageScore;
        private final boolean hasCaptionRoleFlags;

        public static ImmutableList<TextTrackInfo> createForTrackGroup(int rendererIndex, TrackGroup trackGroup, Parameters params, int[] formatSupport, @Nullable String selectedAudioLanguage) {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (int i = 0; i < trackGroup.length; ++i) {
                listBuilder.add((Object)new TextTrackInfo(rendererIndex, trackGroup, i, params, formatSupport[i], selectedAudioLanguage));
            }
            return listBuilder.build();
        }

        public TextTrackInfo(int rendererIndex, TrackGroup trackGroup, int trackIndex, Parameters parameters, int trackFormatSupport, @Nullable String selectedAudioLanguage) {
            super(rendererIndex, trackGroup, trackIndex);
            this.isWithinRendererCapabilities = DefaultTrackSelector.isSupported(trackFormatSupport, false);
            int maskedSelectionFlags = this.format.selectionFlags & ~parameters.ignoredTextSelectionFlags;
            this.isDefault = (maskedSelectionFlags & 1) != 0;
            this.isForced = (maskedSelectionFlags & 2) != 0;
            int bestLanguageIndex = Integer.MAX_VALUE;
            int bestLanguageScore = 0;
            ImmutableList preferredLanguages = parameters.preferredTextLanguages.isEmpty() ? ImmutableList.of((Object)"") : parameters.preferredTextLanguages;
            for (int i = 0; i < preferredLanguages.size(); ++i) {
                int score = DefaultTrackSelector.getFormatLanguageScore(this.format, (String)preferredLanguages.get(i), parameters.selectUndeterminedTextLanguage);
                if (score <= 0) continue;
                bestLanguageIndex = i;
                bestLanguageScore = score;
                break;
            }
            this.preferredLanguageIndex = bestLanguageIndex;
            this.preferredLanguageScore = bestLanguageScore;
            this.preferredRoleFlagsScore = DefaultTrackSelector.getRoleFlagMatchScore(this.format.roleFlags, parameters.preferredTextRoleFlags);
            this.hasCaptionRoleFlags = (this.format.roleFlags & 0x440) != 0;
            boolean selectedAudioLanguageUndetermined = DefaultTrackSelector.normalizeUndeterminedLanguageToNull(selectedAudioLanguage) == null;
            this.selectedAudioLanguageScore = DefaultTrackSelector.getFormatLanguageScore(this.format, selectedAudioLanguage, selectedAudioLanguageUndetermined);
            boolean isWithinConstraints = this.preferredLanguageScore > 0 || parameters.preferredTextLanguages.isEmpty() && this.preferredRoleFlagsScore > 0 || this.isDefault || this.isForced && this.selectedAudioLanguageScore > 0;
            this.selectionEligibility = DefaultTrackSelector.isSupported(trackFormatSupport, parameters.exceedRendererCapabilitiesIfNecessary) && isWithinConstraints ? 1 : 0;
        }

        @Override
        public int getSelectionEligibility() {
            return this.selectionEligibility;
        }

        @Override
        public boolean isCompatibleForAdaptationWith(TextTrackInfo otherTrack) {
            return false;
        }

        @Override
        public int compareTo(TextTrackInfo other) {
            ComparisonChain chain = ComparisonChain.start().compareFalseFirst(this.isWithinRendererCapabilities, other.isWithinRendererCapabilities).compare((Object)this.preferredLanguageIndex, (Object)other.preferredLanguageIndex, (Comparator)Ordering.natural().reverse()).compare(this.preferredLanguageScore, other.preferredLanguageScore).compare(this.preferredRoleFlagsScore, other.preferredRoleFlagsScore).compareFalseFirst(this.isDefault, other.isDefault).compare((Object)this.isForced, (Object)other.isForced, (Comparator)(this.preferredLanguageScore == 0 ? Ordering.natural() : Ordering.natural().reverse())).compare(this.selectedAudioLanguageScore, other.selectedAudioLanguageScore);
            if (this.preferredRoleFlagsScore == 0) {
                chain = chain.compareTrueFirst(this.hasCaptionRoleFlags, other.hasCaptionRoleFlags);
            }
            return chain.result();
        }

        public static int compareSelections(List<TextTrackInfo> infos1, List<TextTrackInfo> infos2) {
            return infos1.get(0).compareTo(infos2.get(0));
        }
    }

    private static final class AudioTrackInfo
    extends TrackInfo<AudioTrackInfo>
    implements Comparable<AudioTrackInfo> {
        private final int selectionEligibility;
        private final boolean isWithinConstraints;
        @Nullable
        private final String language;
        private final Parameters parameters;
        private final boolean isWithinRendererCapabilities;
        private final int preferredLanguageScore;
        private final int preferredLanguageIndex;
        private final int preferredRoleFlagsScore;
        private final boolean hasMainOrNoRoleFlag;
        private final int localeLanguageMatchIndex;
        private final int localeLanguageScore;
        private final boolean isDefaultSelectionFlag;
        private final int channelCount;
        private final int sampleRate;
        private final int bitrate;
        private final int preferredMimeTypeMatchIndex;
        private final boolean usesPrimaryDecoder;
        private final boolean usesHardwareAcceleration;

        public static ImmutableList<AudioTrackInfo> createForTrackGroup(int rendererIndex, TrackGroup trackGroup, Parameters params, int[] formatSupport, boolean hasMappedVideoTracks, Predicate<Format> withinAudioChannelCountConstraints) {
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (int i = 0; i < trackGroup.length; ++i) {
                listBuilder.add((Object)new AudioTrackInfo(rendererIndex, trackGroup, i, params, formatSupport[i], hasMappedVideoTracks, withinAudioChannelCountConstraints));
            }
            return listBuilder.build();
        }

        public AudioTrackInfo(int rendererIndex, TrackGroup trackGroup, int trackIndex, Parameters parameters, int formatSupport, boolean hasMappedVideoTracks, Predicate<Format> withinAudioChannelCountConstraints) {
            super(rendererIndex, trackGroup, trackIndex);
            this.parameters = parameters;
            this.language = DefaultTrackSelector.normalizeUndeterminedLanguageToNull(this.format.language);
            this.isWithinRendererCapabilities = DefaultTrackSelector.isSupported(formatSupport, false);
            int bestLanguageScore = 0;
            int bestLanguageIndex = Integer.MAX_VALUE;
            for (int i = 0; i < parameters.preferredAudioLanguages.size(); ++i) {
                int score = DefaultTrackSelector.getFormatLanguageScore(this.format, (String)parameters.preferredAudioLanguages.get(i), false);
                if (score <= 0) continue;
                bestLanguageIndex = i;
                bestLanguageScore = score;
                break;
            }
            this.preferredLanguageIndex = bestLanguageIndex;
            this.preferredLanguageScore = bestLanguageScore;
            this.preferredRoleFlagsScore = DefaultTrackSelector.getRoleFlagMatchScore(this.format.roleFlags, parameters.preferredAudioRoleFlags);
            this.hasMainOrNoRoleFlag = this.format.roleFlags == 0 || (this.format.roleFlags & 1) != 0;
            this.isDefaultSelectionFlag = (this.format.selectionFlags & 1) != 0;
            this.channelCount = this.format.channelCount;
            this.sampleRate = this.format.sampleRate;
            this.bitrate = this.format.bitrate;
            this.isWithinConstraints = !(this.format.bitrate != -1 && this.format.bitrate > parameters.maxAudioBitrate || this.format.channelCount != -1 && this.format.channelCount > parameters.maxAudioChannelCount || !withinAudioChannelCountConstraints.apply((Object)this.format));
            String[] localeLanguages = Util.getSystemLanguageCodes();
            int bestLocaleMatchIndex = Integer.MAX_VALUE;
            int bestLocaleMatchScore = 0;
            for (int i = 0; i < localeLanguages.length; ++i) {
                int score = DefaultTrackSelector.getFormatLanguageScore(this.format, localeLanguages[i], false);
                if (score <= 0) continue;
                bestLocaleMatchIndex = i;
                bestLocaleMatchScore = score;
                break;
            }
            this.localeLanguageMatchIndex = bestLocaleMatchIndex;
            this.localeLanguageScore = bestLocaleMatchScore;
            int bestMimeTypeMatchIndex = Integer.MAX_VALUE;
            for (int i = 0; i < parameters.preferredAudioMimeTypes.size(); ++i) {
                if (this.format.sampleMimeType == null || !this.format.sampleMimeType.equals(parameters.preferredAudioMimeTypes.get(i))) continue;
                bestMimeTypeMatchIndex = i;
                break;
            }
            this.preferredMimeTypeMatchIndex = bestMimeTypeMatchIndex;
            this.usesPrimaryDecoder = RendererCapabilities.getDecoderSupport(formatSupport) == 128;
            this.usesHardwareAcceleration = RendererCapabilities.getHardwareAccelerationSupport(formatSupport) == 64;
            this.selectionEligibility = this.evaluateSelectionEligibility(formatSupport, hasMappedVideoTracks);
        }

        @Override
        public int getSelectionEligibility() {
            return this.selectionEligibility;
        }

        @Override
        public boolean isCompatibleForAdaptationWith(AudioTrackInfo otherTrack) {
            return (this.parameters.allowAudioMixedChannelCountAdaptiveness || this.format.channelCount != -1 && this.format.channelCount == otherTrack.format.channelCount) && (this.parameters.allowAudioMixedMimeTypeAdaptiveness || this.format.sampleMimeType != null && TextUtils.equals((CharSequence)this.format.sampleMimeType, (CharSequence)otherTrack.format.sampleMimeType)) && (this.parameters.allowAudioMixedSampleRateAdaptiveness || this.format.sampleRate != -1 && this.format.sampleRate == otherTrack.format.sampleRate) && (this.parameters.allowAudioMixedDecoderSupportAdaptiveness || this.usesPrimaryDecoder == otherTrack.usesPrimaryDecoder && this.usesHardwareAcceleration == otherTrack.usesHardwareAcceleration);
        }

        @Override
        public int compareTo(AudioTrackInfo other) {
            Ordering qualityOrdering = this.isWithinConstraints && this.isWithinRendererCapabilities ? FORMAT_VALUE_ORDERING : FORMAT_VALUE_ORDERING.reverse();
            return ComparisonChain.start().compareFalseFirst(this.isWithinRendererCapabilities, other.isWithinRendererCapabilities).compare((Object)this.preferredLanguageIndex, (Object)other.preferredLanguageIndex, (Comparator)Ordering.natural().reverse()).compare(this.preferredLanguageScore, other.preferredLanguageScore).compare(this.preferredRoleFlagsScore, other.preferredRoleFlagsScore).compareFalseFirst(this.isDefaultSelectionFlag, other.isDefaultSelectionFlag).compareFalseFirst(this.hasMainOrNoRoleFlag, other.hasMainOrNoRoleFlag).compare((Object)this.localeLanguageMatchIndex, (Object)other.localeLanguageMatchIndex, (Comparator)Ordering.natural().reverse()).compare(this.localeLanguageScore, other.localeLanguageScore).compareFalseFirst(this.isWithinConstraints, other.isWithinConstraints).compare((Object)this.preferredMimeTypeMatchIndex, (Object)other.preferredMimeTypeMatchIndex, (Comparator)Ordering.natural().reverse()).compare((Object)this.bitrate, (Object)other.bitrate, (Comparator)(this.parameters.forceLowestBitrate ? FORMAT_VALUE_ORDERING.reverse() : NO_ORDER)).compareFalseFirst(this.usesPrimaryDecoder, other.usesPrimaryDecoder).compareFalseFirst(this.usesHardwareAcceleration, other.usesHardwareAcceleration).compare((Object)this.channelCount, (Object)other.channelCount, (Comparator)qualityOrdering).compare((Object)this.sampleRate, (Object)other.sampleRate, (Comparator)qualityOrdering).compare((Object)this.bitrate, (Object)other.bitrate, (Comparator)(Util.areEqual((Object)this.language, (Object)other.language) ? qualityOrdering : NO_ORDER)).result();
        }

        private int evaluateSelectionEligibility(int rendererSupport, boolean hasMappedVideoTracks) {
            if (!DefaultTrackSelector.isSupported(rendererSupport, this.parameters.exceedRendererCapabilitiesIfNecessary)) {
                return 0;
            }
            if (!this.isWithinConstraints && !this.parameters.exceedAudioConstraintsIfNecessary) {
                return 0;
            }
            return DefaultTrackSelector.isSupported(rendererSupport, false) && this.isWithinConstraints && this.format.bitrate != -1 && !this.parameters.forceHighestSupportedBitrate && !this.parameters.forceLowestBitrate && (this.parameters.allowMultipleAdaptiveSelections || !hasMappedVideoTracks) ? 2 : 1;
        }

        public static int compareSelections(List<AudioTrackInfo> infos1, List<AudioTrackInfo> infos2) {
            return Collections.max(infos1).compareTo(Collections.max(infos2));
        }
    }

    private static final class VideoTrackInfo
    extends TrackInfo<VideoTrackInfo> {
        private final boolean isWithinMaxConstraints;
        private final Parameters parameters;
        private final boolean isWithinMinConstraints;
        private final boolean isWithinRendererCapabilities;
        private final int bitrate;
        private final int pixelCount;
        private final int preferredMimeTypeMatchIndex;
        private final int preferredRoleFlagsScore;
        private final boolean hasMainOrNoRoleFlag;
        private final boolean allowMixedMimeTypes;
        private final int selectionEligibility;
        private final boolean usesPrimaryDecoder;
        private final boolean usesHardwareAcceleration;
        private final int codecPreferenceScore;

        public static ImmutableList<VideoTrackInfo> createForTrackGroup(int rendererIndex, TrackGroup trackGroup, Parameters params, int[] formatSupport, int mixedMimeTypeAdaptionSupport) {
            int maxPixelsToRetainForViewport = DefaultTrackSelector.getMaxVideoPixelsToRetainForViewport(trackGroup, params.viewportWidth, params.viewportHeight, params.viewportOrientationMayChange);
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            for (int i = 0; i < trackGroup.length; ++i) {
                int pixelCount = trackGroup.getFormat(i).getPixelCount();
                boolean isSuitableForViewport = maxPixelsToRetainForViewport == Integer.MAX_VALUE || pixelCount != -1 && pixelCount <= maxPixelsToRetainForViewport;
                listBuilder.add((Object)new VideoTrackInfo(rendererIndex, trackGroup, i, params, formatSupport[i], mixedMimeTypeAdaptionSupport, isSuitableForViewport));
            }
            return listBuilder.build();
        }

        public VideoTrackInfo(int rendererIndex, TrackGroup trackGroup, int trackIndex, Parameters parameters, int formatSupport, int mixedMimeTypeAdaptationSupport, boolean isSuitableForViewport) {
            super(rendererIndex, trackGroup, trackIndex);
            this.parameters = parameters;
            int requiredAdaptiveSupport = parameters.allowVideoNonSeamlessAdaptiveness ? 24 : 16;
            this.allowMixedMimeTypes = parameters.allowVideoMixedMimeTypeAdaptiveness && (mixedMimeTypeAdaptationSupport & requiredAdaptiveSupport) != 0;
            this.isWithinMaxConstraints = !(!isSuitableForViewport || this.format.width != -1 && this.format.width > parameters.maxVideoWidth || this.format.height != -1 && this.format.height > parameters.maxVideoHeight || this.format.frameRate != -1.0f && !(this.format.frameRate <= (float)parameters.maxVideoFrameRate) || this.format.bitrate != -1 && this.format.bitrate > parameters.maxVideoBitrate);
            this.isWithinMinConstraints = !(!isSuitableForViewport || this.format.width != -1 && this.format.width < parameters.minVideoWidth || this.format.height != -1 && this.format.height < parameters.minVideoHeight || this.format.frameRate != -1.0f && !(this.format.frameRate >= (float)parameters.minVideoFrameRate) || this.format.bitrate != -1 && this.format.bitrate < parameters.minVideoBitrate);
            this.isWithinRendererCapabilities = DefaultTrackSelector.isSupported(formatSupport, false);
            this.bitrate = this.format.bitrate;
            this.pixelCount = this.format.getPixelCount();
            this.preferredRoleFlagsScore = DefaultTrackSelector.getRoleFlagMatchScore(this.format.roleFlags, parameters.preferredVideoRoleFlags);
            this.hasMainOrNoRoleFlag = this.format.roleFlags == 0 || (this.format.roleFlags & 1) != 0;
            int bestMimeTypeMatchIndex = Integer.MAX_VALUE;
            for (int i = 0; i < parameters.preferredVideoMimeTypes.size(); ++i) {
                if (this.format.sampleMimeType == null || !this.format.sampleMimeType.equals(parameters.preferredVideoMimeTypes.get(i))) continue;
                bestMimeTypeMatchIndex = i;
                break;
            }
            this.preferredMimeTypeMatchIndex = bestMimeTypeMatchIndex;
            this.usesPrimaryDecoder = RendererCapabilities.getDecoderSupport(formatSupport) == 128;
            this.usesHardwareAcceleration = RendererCapabilities.getHardwareAccelerationSupport(formatSupport) == 64;
            this.codecPreferenceScore = DefaultTrackSelector.getVideoCodecPreferenceScore(this.format.sampleMimeType);
            this.selectionEligibility = this.evaluateSelectionEligibility(formatSupport, requiredAdaptiveSupport);
        }

        @Override
        public int getSelectionEligibility() {
            return this.selectionEligibility;
        }

        @Override
        public boolean isCompatibleForAdaptationWith(VideoTrackInfo otherTrack) {
            return (this.allowMixedMimeTypes || Util.areEqual((Object)this.format.sampleMimeType, (Object)otherTrack.format.sampleMimeType)) && (this.parameters.allowVideoMixedDecoderSupportAdaptiveness || this.usesPrimaryDecoder == otherTrack.usesPrimaryDecoder && this.usesHardwareAcceleration == otherTrack.usesHardwareAcceleration);
        }

        private int evaluateSelectionEligibility(int rendererSupport, int requiredAdaptiveSupport) {
            if ((this.format.roleFlags & 0x4000) != 0) {
                return 0;
            }
            if (!DefaultTrackSelector.isSupported(rendererSupport, this.parameters.exceedRendererCapabilitiesIfNecessary)) {
                return 0;
            }
            if (!this.isWithinMaxConstraints && !this.parameters.exceedVideoConstraintsIfNecessary) {
                return 0;
            }
            return DefaultTrackSelector.isSupported(rendererSupport, false) && this.isWithinMinConstraints && this.isWithinMaxConstraints && this.format.bitrate != -1 && !this.parameters.forceHighestSupportedBitrate && !this.parameters.forceLowestBitrate && (rendererSupport & requiredAdaptiveSupport) != 0 ? 2 : 1;
        }

        private static int compareNonQualityPreferences(VideoTrackInfo info1, VideoTrackInfo info2) {
            ComparisonChain chain = ComparisonChain.start().compareFalseFirst(info1.isWithinRendererCapabilities, info2.isWithinRendererCapabilities).compare(info1.preferredRoleFlagsScore, info2.preferredRoleFlagsScore).compareFalseFirst(info1.hasMainOrNoRoleFlag, info2.hasMainOrNoRoleFlag).compareFalseFirst(info1.isWithinMaxConstraints, info2.isWithinMaxConstraints).compareFalseFirst(info1.isWithinMinConstraints, info2.isWithinMinConstraints).compare((Object)info1.preferredMimeTypeMatchIndex, (Object)info2.preferredMimeTypeMatchIndex, (Comparator)Ordering.natural().reverse()).compareFalseFirst(info1.usesPrimaryDecoder, info2.usesPrimaryDecoder).compareFalseFirst(info1.usesHardwareAcceleration, info2.usesHardwareAcceleration);
            if (info1.usesPrimaryDecoder && info1.usesHardwareAcceleration) {
                chain = chain.compare(info1.codecPreferenceScore, info2.codecPreferenceScore);
            }
            return chain.result();
        }

        private static int compareQualityPreferences(VideoTrackInfo info1, VideoTrackInfo info2) {
            Ordering qualityOrdering = info1.isWithinMaxConstraints && info1.isWithinRendererCapabilities ? FORMAT_VALUE_ORDERING : FORMAT_VALUE_ORDERING.reverse();
            return ComparisonChain.start().compare((Object)info1.bitrate, (Object)info2.bitrate, (Comparator)(info1.parameters.forceLowestBitrate ? FORMAT_VALUE_ORDERING.reverse() : NO_ORDER)).compare((Object)info1.pixelCount, (Object)info2.pixelCount, (Comparator)qualityOrdering).compare((Object)info1.bitrate, (Object)info2.bitrate, (Comparator)qualityOrdering).result();
        }

        public static int compareSelections(List<VideoTrackInfo> infos1, List<VideoTrackInfo> infos2) {
            return ComparisonChain.start().compare((Object)Collections.max(infos1, VideoTrackInfo::compareNonQualityPreferences), (Object)Collections.max(infos2, VideoTrackInfo::compareNonQualityPreferences), VideoTrackInfo::compareNonQualityPreferences).compare(infos1.size(), infos2.size()).compare((Object)Collections.max(infos1, VideoTrackInfo::compareQualityPreferences), (Object)Collections.max(infos2, VideoTrackInfo::compareQualityPreferences), VideoTrackInfo::compareQualityPreferences).result();
        }
    }
}

