/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.chunk.MediaChunk;
import com.google.android.exoplayer2.source.chunk.MediaChunkIterator;
import com.google.android.exoplayer2.trackselection.BaseTrackSelection;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionUtil;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import java.util.List;
import java.util.Random;
import org.checkerframework.checker.nullness.compatqual.NullableType;

@Deprecated
public final class RandomTrackSelection
extends BaseTrackSelection {
    private final Random random;
    private int selectedIndex;

    public RandomTrackSelection(TrackGroup group, int[] tracks, int type, Random random) {
        super(group, tracks, type);
        this.random = random;
        this.selectedIndex = random.nextInt(this.length);
    }

    @Override
    public void updateSelectedTrack(long playbackPositionUs, long bufferedDurationUs, long availableDurationUs, List<? extends MediaChunk> queue, MediaChunkIterator[] mediaChunkIterators) {
        int i;
        long nowMs = SystemClock.elapsedRealtime();
        int allowedFormatCount = 0;
        for (i = 0; i < this.length; ++i) {
            if (this.isTrackExcluded(i, nowMs)) continue;
            ++allowedFormatCount;
        }
        this.selectedIndex = this.random.nextInt(allowedFormatCount);
        if (allowedFormatCount != this.length) {
            allowedFormatCount = 0;
            for (i = 0; i < this.length; ++i) {
                if (this.isTrackExcluded(i, nowMs) || this.selectedIndex != allowedFormatCount++) continue;
                this.selectedIndex = i;
                return;
            }
        }
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public int getSelectionReason() {
        return 3;
    }

    @Override
    @Nullable
    public Object getSelectionData() {
        return null;
    }

    public static final class Factory
    implements ExoTrackSelection.Factory {
        private final Random random;

        public Factory() {
            this.random = new Random();
        }

        public Factory(int seed) {
            this.random = new Random(seed);
        }

        @Override
        public @NullableType ExoTrackSelection[] createTrackSelections(@NullableType ExoTrackSelection.Definition[] definitions, BandwidthMeter bandwidthMeter, MediaSource.MediaPeriodId mediaPeriodId, Timeline timeline) {
            return TrackSelectionUtil.createTrackSelectionsForDefinitions(definitions, definition -> new RandomTrackSelection(definition.group, definition.tracks, definition.type, this.random));
        }
    }
}

