/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.trackselection;

import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Tracks;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.trackselection.FixedTrackSelection;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.compatqual.NullableType;

@Deprecated
public final class TrackSelectionUtil {
    private TrackSelectionUtil() {
    }

    public static @NullableType ExoTrackSelection[] createTrackSelectionsForDefinitions(@NullableType ExoTrackSelection.Definition[] definitions, AdaptiveTrackSelectionFactory adaptiveTrackSelectionFactory) {
        ExoTrackSelection[] selections = new ExoTrackSelection[definitions.length];
        boolean createdAdaptiveTrackSelection = false;
        for (int i = 0; i < definitions.length; ++i) {
            ExoTrackSelection.Definition definition = definitions[i];
            if (definition == null) continue;
            if (definition.tracks.length > 1 && !createdAdaptiveTrackSelection) {
                createdAdaptiveTrackSelection = true;
                selections[i] = adaptiveTrackSelectionFactory.createAdaptiveTrackSelection(definition);
                continue;
            }
            selections[i] = new FixedTrackSelection(definition.group, definition.tracks[0], definition.type);
        }
        return selections;
    }

    public static DefaultTrackSelector.Parameters updateParametersWithOverride(DefaultTrackSelector.Parameters parameters, int rendererIndex, TrackGroupArray trackGroupArray, boolean isDisabled, @Nullable DefaultTrackSelector.SelectionOverride override) {
        DefaultTrackSelector.Parameters.Builder builder = parameters.buildUpon().clearSelectionOverrides(rendererIndex).setRendererDisabled(rendererIndex, isDisabled);
        if (override != null) {
            builder.setSelectionOverride(rendererIndex, trackGroupArray, override);
        }
        return builder.build();
    }

    public static LoadErrorHandlingPolicy.FallbackOptions createFallbackOptions(ExoTrackSelection trackSelection) {
        long nowMs = SystemClock.elapsedRealtime();
        int numberOfTracks = trackSelection.length();
        int numberOfExcludedTracks = 0;
        for (int i = 0; i < numberOfTracks; ++i) {
            if (!trackSelection.isTrackExcluded(i, nowMs)) continue;
            ++numberOfExcludedTracks;
        }
        return new LoadErrorHandlingPolicy.FallbackOptions(1, 0, numberOfTracks, numberOfExcludedTracks);
    }

    public static Tracks buildTracks(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, @NullableType TrackSelection[] selections) {
        List[] listSelections = new List[selections.length];
        for (int i = 0; i < selections.length; ++i) {
            TrackSelection selection = selections[i];
            listSelections[i] = selection != null ? ImmutableList.of((Object)selection) : ImmutableList.of();
        }
        return TrackSelectionUtil.buildTracks(mappedTrackInfo, listSelections);
    }

    public static Tracks buildTracks(MappingTrackSelector.MappedTrackInfo mappedTrackInfo, List<? extends TrackSelection>[] selections) {
        ImmutableList.Builder trackGroups = new ImmutableList.Builder();
        for (int rendererIndex = 0; rendererIndex < mappedTrackInfo.getRendererCount(); ++rendererIndex) {
            TrackGroupArray trackGroupArray = mappedTrackInfo.getTrackGroups(rendererIndex);
            List<? extends TrackSelection> rendererTrackSelections = selections[rendererIndex];
            for (int groupIndex = 0; groupIndex < trackGroupArray.length; ++groupIndex) {
                TrackGroup trackGroup = trackGroupArray.get(groupIndex);
                boolean adaptiveSupported = mappedTrackInfo.getAdaptiveSupport(rendererIndex, groupIndex, false) != 0;
                int[] trackSupport = new int[trackGroup.length];
                boolean[] selected = new boolean[trackGroup.length];
                for (int trackIndex = 0; trackIndex < trackGroup.length; ++trackIndex) {
                    trackSupport[trackIndex] = mappedTrackInfo.getTrackSupport(rendererIndex, groupIndex, trackIndex);
                    boolean isTrackSelected = false;
                    for (int i = 0; i < rendererTrackSelections.size(); ++i) {
                        TrackSelection trackSelection = rendererTrackSelections.get(i);
                        if (!trackSelection.getTrackGroup().equals((Object)trackGroup) || trackSelection.indexOf(trackIndex) == -1) continue;
                        isTrackSelected = true;
                        break;
                    }
                    selected[trackIndex] = isTrackSelected;
                }
                trackGroups.add((Object)new Tracks.Group(trackGroup, adaptiveSupported, trackSupport, selected));
            }
        }
        TrackGroupArray unmappedTrackGroups = mappedTrackInfo.getUnmappedTrackGroups();
        for (int groupIndex = 0; groupIndex < unmappedTrackGroups.length; ++groupIndex) {
            TrackGroup trackGroup = unmappedTrackGroups.get(groupIndex);
            int[] trackSupport = new int[trackGroup.length];
            Arrays.fill(trackSupport, 0);
            boolean[] selected = new boolean[trackGroup.length];
            trackGroups.add((Object)new Tracks.Group(trackGroup, false, trackSupport, selected));
        }
        return new Tracks((List)trackGroups.build());
    }

    public static interface AdaptiveTrackSelectionFactory {
        public ExoTrackSelection createAdaptiveTrackSelection(ExoTrackSelection.Definition var1);
    }
}

