/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.trackselection.ExoTrackSelection;
import com.google.android.exoplayer2.upstream.CmcdConfiguration;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Deprecated
public final class CmcdHeadersFactory {
    public static final String STREAMING_FORMAT_DASH = "d";
    public static final String STREAMING_FORMAT_HLS = "h";
    public static final String STREAMING_FORMAT_SS = "s";
    public static final String STREAM_TYPE_VOD = "v";
    public static final String STREAM_TYPE_LIVE = "l";
    public static final String OBJECT_TYPE_INIT_SEGMENT = "i";
    public static final String OBJECT_TYPE_AUDIO_ONLY = "a";
    public static final String OBJECT_TYPE_VIDEO_ONLY = "v";
    public static final String OBJECT_TYPE_MUXED_AUDIO_AND_VIDEO = "av";
    private final CmcdConfiguration cmcdConfiguration;
    private final ExoTrackSelection trackSelection;
    private final long bufferedDurationUs;
    private final String streamingFormat;
    private final boolean isLive;
    private long chunkDurationUs;
    @Nullable
    private String objectType;

    @Nullable
    public static String getObjectType(ExoTrackSelection trackSelection) {
        Assertions.checkArgument((trackSelection != null ? 1 : 0) != 0);
        int trackType = MimeTypes.getTrackType((String)trackSelection.getSelectedFormat().sampleMimeType);
        if (trackType == -1) {
            trackType = MimeTypes.getTrackType((String)trackSelection.getSelectedFormat().containerMimeType);
        }
        if (trackType == 1) {
            return OBJECT_TYPE_AUDIO_ONLY;
        }
        if (trackType == 2) {
            return "v";
        }
        return null;
    }

    public CmcdHeadersFactory(CmcdConfiguration cmcdConfiguration, ExoTrackSelection trackSelection, long bufferedDurationUs, String streamingFormat, boolean isLive) {
        Assertions.checkArgument((bufferedDurationUs >= 0L ? 1 : 0) != 0);
        this.cmcdConfiguration = cmcdConfiguration;
        this.trackSelection = trackSelection;
        this.bufferedDurationUs = bufferedDurationUs;
        this.streamingFormat = streamingFormat;
        this.isLive = isLive;
        this.chunkDurationUs = -9223372036854775807L;
    }

    @CanIgnoreReturnValue
    public CmcdHeadersFactory setChunkDurationUs(long chunkDurationUs) {
        Assertions.checkArgument((chunkDurationUs >= 0L ? 1 : 0) != 0);
        this.chunkDurationUs = chunkDurationUs;
        return this;
    }

    @CanIgnoreReturnValue
    public CmcdHeadersFactory setObjectType(@Nullable String objectType) {
        this.objectType = objectType;
        return this;
    }

    public ImmutableMap<String, String> createHttpRequestHeaders() {
        ImmutableMap<String, String> customData = this.cmcdConfiguration.requestConfig.getCustomData();
        int bitrateKbps = Util.ceilDivide((int)this.trackSelection.getSelectedFormat().bitrate, (int)1000);
        CmcdObject.Builder cmcdObject = new CmcdObject.Builder().setCustomData((String)customData.get((Object)"CMCD-Object"));
        if (!this.getIsInitSegment()) {
            if (this.cmcdConfiguration.isBitrateLoggingAllowed()) {
                cmcdObject.setBitrateKbps(bitrateKbps);
            }
            if (this.cmcdConfiguration.isTopBitrateLoggingAllowed()) {
                TrackGroup trackGroup = this.trackSelection.getTrackGroup();
                int topBitrate = this.trackSelection.getSelectedFormat().bitrate;
                for (int i = 0; i < trackGroup.length; ++i) {
                    topBitrate = Math.max(topBitrate, trackGroup.getFormat((int)i).bitrate);
                }
                cmcdObject.setTopBitrateKbps(Util.ceilDivide((int)topBitrate, (int)1000));
            }
            if (this.cmcdConfiguration.isObjectDurationLoggingAllowed() && this.chunkDurationUs != -9223372036854775807L) {
                cmcdObject.setObjectDurationMs(this.chunkDurationUs / 1000L);
            }
        }
        if (this.cmcdConfiguration.isObjectTypeLoggingAllowed()) {
            cmcdObject.setObjectType(this.objectType);
        }
        CmcdRequest.Builder cmcdRequest = new CmcdRequest.Builder().setCustomData((String)customData.get((Object)"CMCD-Request"));
        if (!this.getIsInitSegment() && this.cmcdConfiguration.isBufferLengthLoggingAllowed()) {
            cmcdRequest.setBufferLengthMs(this.bufferedDurationUs / 1000L);
        }
        if (this.cmcdConfiguration.isMeasuredThroughputLoggingAllowed() && this.trackSelection.getLatestBitrateEstimate() != Long.MIN_VALUE) {
            cmcdRequest.setMeasuredThroughputInKbps(Util.ceilDivide((long)this.trackSelection.getLatestBitrateEstimate(), (long)1000L));
        }
        CmcdSession.Builder cmcdSession = new CmcdSession.Builder().setCustomData((String)customData.get((Object)"CMCD-Session"));
        if (this.cmcdConfiguration.isContentIdLoggingAllowed()) {
            cmcdSession.setContentId(this.cmcdConfiguration.contentId);
        }
        if (this.cmcdConfiguration.isSessionIdLoggingAllowed()) {
            cmcdSession.setSessionId(this.cmcdConfiguration.sessionId);
        }
        if (this.cmcdConfiguration.isStreamingFormatLoggingAllowed()) {
            cmcdSession.setStreamingFormat(this.streamingFormat);
        }
        if (this.cmcdConfiguration.isStreamTypeLoggingAllowed()) {
            cmcdSession.setStreamType(this.isLive ? STREAM_TYPE_LIVE : "v");
        }
        CmcdStatus.Builder cmcdStatus = new CmcdStatus.Builder().setCustomData((String)customData.get((Object)"CMCD-Status"));
        if (this.cmcdConfiguration.isMaximumRequestThroughputLoggingAllowed()) {
            cmcdStatus.setMaximumRequestedThroughputKbps(this.cmcdConfiguration.requestConfig.getRequestedMaximumThroughputKbps(bitrateKbps));
        }
        ImmutableMap.Builder httpRequestHeaders = ImmutableMap.builder();
        cmcdObject.build().populateHttpRequestHeaders((ImmutableMap.Builder<String, String>)httpRequestHeaders);
        cmcdRequest.build().populateHttpRequestHeaders((ImmutableMap.Builder<String, String>)httpRequestHeaders);
        cmcdSession.build().populateHttpRequestHeaders((ImmutableMap.Builder<String, String>)httpRequestHeaders);
        cmcdStatus.build().populateHttpRequestHeaders((ImmutableMap.Builder<String, String>)httpRequestHeaders);
        return httpRequestHeaders.buildOrThrow();
    }

    private boolean getIsInitSegment() {
        return this.objectType != null && this.objectType.equals(OBJECT_TYPE_INIT_SEGMENT);
    }

    private static final class CmcdObject {
        public final int bitrateKbps;
        public final int topBitrateKbps;
        public final long objectDurationMs;
        @Nullable
        public final String objectType;
        @Nullable
        public final String customData;

        private CmcdObject(Builder builder) {
            this.bitrateKbps = builder.bitrateKbps;
            this.topBitrateKbps = builder.topBitrateKbps;
            this.objectDurationMs = builder.objectDurationMs;
            this.objectType = builder.objectType;
            this.customData = builder.customData;
        }

        public void populateHttpRequestHeaders(ImmutableMap.Builder<String, String> httpRequestHeaders) {
            StringBuilder headerValue = new StringBuilder();
            if (this.bitrateKbps != -2147483647) {
                headerValue.append(Util.formatInvariant((String)"%s=%d,", (Object[])new Object[]{"br", this.bitrateKbps}));
            }
            if (this.topBitrateKbps != -2147483647) {
                headerValue.append(Util.formatInvariant((String)"%s=%d,", (Object[])new Object[]{"tb", this.topBitrateKbps}));
            }
            if (this.objectDurationMs != -9223372036854775807L) {
                headerValue.append(Util.formatInvariant((String)"%s=%d,", (Object[])new Object[]{CmcdHeadersFactory.STREAMING_FORMAT_DASH, this.objectDurationMs}));
            }
            if (!TextUtils.isEmpty((CharSequence)this.objectType)) {
                headerValue.append(Util.formatInvariant((String)"%s=%s,", (Object[])new Object[]{"ot", this.objectType}));
            }
            if (!TextUtils.isEmpty((CharSequence)this.customData)) {
                headerValue.append(Util.formatInvariant((String)"%s,", (Object[])new Object[]{this.customData}));
            }
            if (headerValue.length() == 0) {
                return;
            }
            headerValue.setLength(headerValue.length() - 1);
            httpRequestHeaders.put((Object)"CMCD-Object", (Object)headerValue.toString());
        }

        public static final class Builder {
            private int bitrateKbps = -2147483647;
            private int topBitrateKbps = -2147483647;
            private long objectDurationMs = -9223372036854775807L;
            @Nullable
            private String objectType;
            @Nullable
            private String customData;

            @CanIgnoreReturnValue
            public Builder setBitrateKbps(int bitrateKbps) {
                this.bitrateKbps = bitrateKbps;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setTopBitrateKbps(int topBitrateKbps) {
                this.topBitrateKbps = topBitrateKbps;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setObjectDurationMs(long objectDurationMs) {
                Assertions.checkArgument((objectDurationMs >= 0L ? 1 : 0) != 0);
                this.objectDurationMs = objectDurationMs;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setObjectType(@Nullable String objectType) {
                this.objectType = objectType;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setCustomData(@Nullable String customData) {
                this.customData = customData;
                return this;
            }

            public CmcdObject build() {
                return new CmcdObject(this);
            }
        }
    }

    private static final class CmcdRequest {
        public final long bufferLengthMs;
        public final long measuredThroughputInKbps;
        @Nullable
        public final String customData;

        private CmcdRequest(Builder builder) {
            this.bufferLengthMs = builder.bufferLengthMs;
            this.measuredThroughputInKbps = builder.measuredThroughputInKbps;
            this.customData = builder.customData;
        }

        public void populateHttpRequestHeaders(ImmutableMap.Builder<String, String> httpRequestHeaders) {
            StringBuilder headerValue = new StringBuilder();
            if (this.bufferLengthMs != -9223372036854775807L) {
                headerValue.append(Util.formatInvariant((String)"%s=%d,", (Object[])new Object[]{"bl", this.bufferLengthMs}));
            }
            if (this.measuredThroughputInKbps != Long.MIN_VALUE) {
                headerValue.append(Util.formatInvariant((String)"%s=%d,", (Object[])new Object[]{"mtp", this.measuredThroughputInKbps}));
            }
            if (!TextUtils.isEmpty((CharSequence)this.customData)) {
                headerValue.append(Util.formatInvariant((String)"%s,", (Object[])new Object[]{this.customData}));
            }
            if (headerValue.length() == 0) {
                return;
            }
            headerValue.setLength(headerValue.length() - 1);
            httpRequestHeaders.put((Object)"CMCD-Request", (Object)headerValue.toString());
        }

        public static final class Builder {
            private long bufferLengthMs = -9223372036854775807L;
            private long measuredThroughputInKbps = Long.MIN_VALUE;
            @Nullable
            private String customData;

            @CanIgnoreReturnValue
            public Builder setBufferLengthMs(long bufferLengthMs) {
                Assertions.checkArgument((bufferLengthMs >= 0L ? 1 : 0) != 0);
                this.bufferLengthMs = (bufferLengthMs + 50L) / 100L * 100L;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setMeasuredThroughputInKbps(long measuredThroughputInKbps) {
                Assertions.checkArgument((measuredThroughputInKbps >= 0L ? 1 : 0) != 0);
                this.measuredThroughputInKbps = (measuredThroughputInKbps + 50L) / 100L * 100L;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setCustomData(@Nullable String customData) {
                this.customData = customData;
                return this;
            }

            public CmcdRequest build() {
                return new CmcdRequest(this);
            }
        }
    }

    private static final class CmcdSession {
        public static final int VERSION = 1;
        @Nullable
        public final String contentId;
        @Nullable
        public final String sessionId;
        @Nullable
        public final String streamingFormat;
        @Nullable
        public final String streamType;
        @Nullable
        public final String customData;

        private CmcdSession(Builder builder) {
            this.contentId = builder.contentId;
            this.sessionId = builder.sessionId;
            this.streamingFormat = builder.streamingFormat;
            this.streamType = builder.streamType;
            this.customData = builder.customData;
        }

        public void populateHttpRequestHeaders(ImmutableMap.Builder<String, String> httpRequestHeaders) {
            StringBuilder headerValue = new StringBuilder();
            if (!TextUtils.isEmpty((CharSequence)this.contentId)) {
                headerValue.append(Util.formatInvariant((String)"%s=\"%s\",", (Object[])new Object[]{"cid", this.contentId}));
            }
            if (!TextUtils.isEmpty((CharSequence)this.sessionId)) {
                headerValue.append(Util.formatInvariant((String)"%s=\"%s\",", (Object[])new Object[]{"sid", this.sessionId}));
            }
            if (!TextUtils.isEmpty((CharSequence)this.streamingFormat)) {
                headerValue.append(Util.formatInvariant((String)"%s=%s,", (Object[])new Object[]{"sf", this.streamingFormat}));
            }
            if (!TextUtils.isEmpty((CharSequence)this.streamType)) {
                headerValue.append(Util.formatInvariant((String)"%s=%s,", (Object[])new Object[]{"st", this.streamType}));
            }
            if (!TextUtils.isEmpty((CharSequence)this.customData)) {
                headerValue.append(Util.formatInvariant((String)"%s,", (Object[])new Object[]{this.customData}));
            }
            if (headerValue.length() == 0) {
                return;
            }
            headerValue.setLength(headerValue.length() - 1);
            httpRequestHeaders.put((Object)"CMCD-Session", (Object)headerValue.toString());
        }

        public static final class Builder {
            @Nullable
            private String contentId;
            @Nullable
            private String sessionId;
            @Nullable
            private String streamingFormat;
            @Nullable
            private String streamType;
            @Nullable
            private String customData;

            @CanIgnoreReturnValue
            public Builder setContentId(@Nullable String contentId) {
                Assertions.checkArgument((contentId == null || contentId.length() <= 64 ? 1 : 0) != 0);
                this.contentId = contentId;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setSessionId(@Nullable String sessionId) {
                Assertions.checkArgument((sessionId == null || sessionId.length() <= 64 ? 1 : 0) != 0);
                this.sessionId = sessionId;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setStreamingFormat(@Nullable String streamingFormat) {
                this.streamingFormat = streamingFormat;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setStreamType(@Nullable String streamType) {
                this.streamType = streamType;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setCustomData(@Nullable String customData) {
                this.customData = customData;
                return this;
            }

            public CmcdSession build() {
                return new CmcdSession(this);
            }
        }
    }

    private static final class CmcdStatus {
        public final int maximumRequestedThroughputKbps;
        @Nullable
        public final String customData;

        private CmcdStatus(Builder builder) {
            this.maximumRequestedThroughputKbps = builder.maximumRequestedThroughputKbps;
            this.customData = builder.customData;
        }

        public void populateHttpRequestHeaders(ImmutableMap.Builder<String, String> httpRequestHeaders) {
            StringBuilder headerValue = new StringBuilder();
            if (this.maximumRequestedThroughputKbps != -2147483647) {
                headerValue.append(Util.formatInvariant((String)"%s=%d,", (Object[])new Object[]{"rtp", this.maximumRequestedThroughputKbps}));
            }
            if (!TextUtils.isEmpty((CharSequence)this.customData)) {
                headerValue.append(Util.formatInvariant((String)"%s,", (Object[])new Object[]{this.customData}));
            }
            if (headerValue.length() == 0) {
                return;
            }
            headerValue.setLength(headerValue.length() - 1);
            httpRequestHeaders.put((Object)"CMCD-Status", (Object)headerValue.toString());
        }

        public static final class Builder {
            private int maximumRequestedThroughputKbps = -2147483647;
            @Nullable
            private String customData;

            @CanIgnoreReturnValue
            public Builder setMaximumRequestedThroughputKbps(int maximumRequestedThroughputKbps) {
                Assertions.checkArgument((maximumRequestedThroughputKbps == -2147483647 || maximumRequestedThroughputKbps >= 0 ? 1 : 0) != 0);
                this.maximumRequestedThroughputKbps = maximumRequestedThroughputKbps == -2147483647 ? maximumRequestedThroughputKbps : (maximumRequestedThroughputKbps + 50) / 100 * 100;
                return this;
            }

            @CanIgnoreReturnValue
            public Builder setCustomData(@Nullable String customData) {
                this.customData = customData;
                return this;
            }

            public CmcdStatus build() {
                return new CmcdStatus(this);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @Target(value={ElementType.TYPE_USE})
    public static @interface ObjectType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @Target(value={ElementType.TYPE_USE})
    public static @interface StreamType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @Target(value={ElementType.TYPE_USE})
    public static @interface StreamingFormat {
    }
}

