/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.Allocation;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.util.Arrays;
import org.checkerframework.checker.nullness.compatqual.NullableType;

@Deprecated
public final class DefaultAllocator
implements Allocator {
    private static final int AVAILABLE_EXTRA_CAPACITY = 100;
    private final boolean trimOnReset;
    private final int individualAllocationSize;
    @Nullable
    private final byte[] initialAllocationBlock;
    private int targetBufferSize;
    private int allocatedCount;
    private int availableCount;
    private @NullableType Allocation[] availableAllocations;

    public DefaultAllocator(boolean trimOnReset, int individualAllocationSize) {
        this(trimOnReset, individualAllocationSize, 0);
    }

    public DefaultAllocator(boolean trimOnReset, int individualAllocationSize, int initialAllocationCount) {
        Assertions.checkArgument((individualAllocationSize > 0 ? 1 : 0) != 0);
        Assertions.checkArgument((initialAllocationCount >= 0 ? 1 : 0) != 0);
        this.trimOnReset = trimOnReset;
        this.individualAllocationSize = individualAllocationSize;
        this.availableCount = initialAllocationCount;
        this.availableAllocations = new Allocation[initialAllocationCount + 100];
        if (initialAllocationCount > 0) {
            this.initialAllocationBlock = new byte[initialAllocationCount * individualAllocationSize];
            for (int i = 0; i < initialAllocationCount; ++i) {
                int allocationOffset = i * individualAllocationSize;
                this.availableAllocations[i] = new Allocation(this.initialAllocationBlock, allocationOffset);
            }
        } else {
            this.initialAllocationBlock = null;
        }
    }

    public synchronized void reset() {
        if (this.trimOnReset) {
            this.setTargetBufferSize(0);
        }
    }

    public synchronized void setTargetBufferSize(int targetBufferSize) {
        boolean targetBufferSizeReduced = targetBufferSize < this.targetBufferSize;
        this.targetBufferSize = targetBufferSize;
        if (targetBufferSizeReduced) {
            this.trim();
        }
    }

    @Override
    public synchronized Allocation allocate() {
        Allocation allocation;
        ++this.allocatedCount;
        if (this.availableCount > 0) {
            allocation = (Allocation)Assertions.checkNotNull((Object)this.availableAllocations[--this.availableCount]);
            this.availableAllocations[this.availableCount] = null;
        } else {
            allocation = new Allocation(new byte[this.individualAllocationSize], 0);
            if (this.allocatedCount > this.availableAllocations.length) {
                this.availableAllocations = Arrays.copyOf(this.availableAllocations, this.availableAllocations.length * 2);
            }
        }
        return allocation;
    }

    @Override
    public synchronized void release(Allocation allocation) {
        this.availableAllocations[this.availableCount++] = allocation;
        --this.allocatedCount;
        this.notifyAll();
    }

    @Override
    public synchronized void release(@Nullable Allocator.AllocationNode allocationNode) {
        while (allocationNode != null) {
            this.availableAllocations[this.availableCount++] = allocationNode.getAllocation();
            --this.allocatedCount;
            allocationNode = allocationNode.next();
        }
        this.notifyAll();
    }

    @Override
    public synchronized void trim() {
        int targetAllocationCount = Util.ceilDivide((int)this.targetBufferSize, (int)this.individualAllocationSize);
        int targetAvailableCount = Math.max(0, targetAllocationCount - this.allocatedCount);
        if (targetAvailableCount >= this.availableCount) {
            return;
        }
        if (this.initialAllocationBlock != null) {
            int lowIndex = 0;
            int highIndex = this.availableCount - 1;
            while (lowIndex <= highIndex) {
                Allocation lowAllocation = (Allocation)Assertions.checkNotNull((Object)this.availableAllocations[lowIndex]);
                if (lowAllocation.data == this.initialAllocationBlock) {
                    ++lowIndex;
                    continue;
                }
                Allocation highAllocation = (Allocation)Assertions.checkNotNull((Object)this.availableAllocations[highIndex]);
                if (highAllocation.data != this.initialAllocationBlock) {
                    --highIndex;
                    continue;
                }
                this.availableAllocations[lowIndex++] = highAllocation;
                this.availableAllocations[highIndex--] = lowAllocation;
            }
            if ((targetAvailableCount = Math.max(targetAvailableCount, lowIndex)) >= this.availableCount) {
                return;
            }
        }
        Arrays.fill(this.availableAllocations, targetAvailableCount, this.availableCount, null);
        this.availableCount = targetAvailableCount;
    }

    @Override
    public synchronized int getTotalBytesAllocated() {
        return this.allocatedCount * this.individualAllocationSize;
    }

    @Override
    public int getIndividualAllocationLength() {
        return this.individualAllocationSize;
    }
}

