/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.LoaderErrorThrower;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.TraceUtil;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import java.util.concurrent.ExecutorService;

@Deprecated
public final class Loader
implements LoaderErrorThrower {
    private static final String THREAD_NAME_PREFIX = "ExoPlayer:Loader:";
    private static final int ACTION_TYPE_RETRY = 0;
    private static final int ACTION_TYPE_RETRY_AND_RESET_ERROR_COUNT = 1;
    private static final int ACTION_TYPE_DONT_RETRY = 2;
    private static final int ACTION_TYPE_DONT_RETRY_FATAL = 3;
    public static final LoadErrorAction RETRY = Loader.createRetryAction(false, -9223372036854775807L);
    public static final LoadErrorAction RETRY_RESET_ERROR_COUNT = Loader.createRetryAction(true, -9223372036854775807L);
    public static final LoadErrorAction DONT_RETRY = new LoadErrorAction(2, -9223372036854775807L);
    public static final LoadErrorAction DONT_RETRY_FATAL = new LoadErrorAction(3, -9223372036854775807L);
    private final ExecutorService downloadExecutorService;
    @Nullable
    private LoadTask<? extends Loadable> currentTask;
    @Nullable
    private IOException fatalError;

    public Loader(String threadNameSuffix) {
        this.downloadExecutorService = Util.newSingleThreadExecutor((String)(THREAD_NAME_PREFIX + threadNameSuffix));
    }

    public static LoadErrorAction createRetryAction(boolean resetErrorCount, long retryDelayMillis) {
        return new LoadErrorAction(resetErrorCount ? 1 : 0, retryDelayMillis);
    }

    public boolean hasFatalError() {
        return this.fatalError != null;
    }

    public void clearFatalError() {
        this.fatalError = null;
    }

    public <T extends Loadable> long startLoading(T loadable, Callback<T> callback, int defaultMinRetryCount) {
        Looper looper = (Looper)Assertions.checkStateNotNull((Object)Looper.myLooper());
        this.fatalError = null;
        long startTimeMs = SystemClock.elapsedRealtime();
        new LoadTask(this, looper, loadable, callback, defaultMinRetryCount, startTimeMs).start(0L);
        return startTimeMs;
    }

    public boolean isLoading() {
        return this.currentTask != null;
    }

    public void cancelLoading() {
        ((LoadTask)Assertions.checkStateNotNull(this.currentTask)).cancel(false);
    }

    public void release() {
        this.release(null);
    }

    public void release(@Nullable ReleaseCallback callback) {
        if (this.currentTask != null) {
            this.currentTask.cancel(true);
        }
        if (callback != null) {
            this.downloadExecutorService.execute(new ReleaseTask(callback));
        }
        this.downloadExecutorService.shutdown();
    }

    @Override
    public void maybeThrowError() throws IOException {
        this.maybeThrowError(Integer.MIN_VALUE);
    }

    @Override
    public void maybeThrowError(int minRetryCount) throws IOException {
        if (this.fatalError != null) {
            throw this.fatalError;
        }
        if (this.currentTask != null) {
            this.currentTask.maybeThrowError(minRetryCount == Integer.MIN_VALUE ? this.currentTask.defaultMinRetryCount : minRetryCount);
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private final class LoadTask<T extends Loadable>
    extends Handler
    implements Runnable {
        private static final String TAG = "LoadTask";
        private static final int MSG_START = 0;
        private static final int MSG_FINISH = 1;
        private static final int MSG_IO_EXCEPTION = 2;
        private static final int MSG_FATAL_ERROR = 3;
        public final int defaultMinRetryCount;
        private final T loadable;
        private final long startTimeMs;
        @Nullable
        private Callback<T> callback;
        @Nullable
        private IOException currentError;
        private int errorCount;
        @Nullable
        private Thread executorThread;
        private boolean canceled;
        private volatile boolean released;
        final /* synthetic */ Loader this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public LoadTask(Looper loadable, T callback, Callback<T> defaultMinRetryCount, int startTimeMs, long l2) {
            void looper;
            this.this$0 = (Loader)l;
            super((Looper)looper);
            this.loadable = loadable;
            this.callback = callback;
            this.defaultMinRetryCount = (int)defaultMinRetryCount;
            this.startTimeMs = startTimeMs;
        }

        public void maybeThrowError(int minRetryCount) throws IOException {
            if (this.currentError != null && this.errorCount > minRetryCount) {
                throw this.currentError;
            }
        }

        public void start(long delayMillis) {
            Assertions.checkState((this.this$0.currentTask == null ? 1 : 0) != 0);
            this.this$0.currentTask = this;
            if (delayMillis > 0L) {
                this.sendEmptyMessageDelayed(0, delayMillis);
            } else {
                this.execute();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(boolean released) {
            this.released = released;
            this.currentError = null;
            if (this.hasMessages(0)) {
                this.canceled = true;
                this.removeMessages(0);
                if (!released) {
                    this.sendEmptyMessage(1);
                }
            } else {
                LoadTask loadTask = this;
                synchronized (loadTask) {
                    this.canceled = true;
                    this.loadable.cancelLoad();
                    Thread executorThread = this.executorThread;
                    if (executorThread != null) {
                        executorThread.interrupt();
                    }
                }
            }
            if (released) {
                this.finish();
                long nowMs = SystemClock.elapsedRealtime();
                ((Callback)Assertions.checkNotNull(this.callback)).onLoadCanceled(this.loadable, nowMs, nowMs - this.startTimeMs, true);
                this.callback = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                boolean shouldLoad;
                LoadTask loadTask = this;
                synchronized (loadTask) {
                    shouldLoad = !this.canceled;
                    this.executorThread = Thread.currentThread();
                }
                if (shouldLoad) {
                    TraceUtil.beginSection((String)("load:" + this.loadable.getClass().getSimpleName()));
                    try {
                        this.loadable.load();
                    }
                    finally {
                        TraceUtil.endSection();
                    }
                }
                loadTask = this;
                synchronized (loadTask) {
                    this.executorThread = null;
                    Thread.interrupted();
                }
                if (!this.released) {
                    this.sendEmptyMessage(1);
                }
            }
            catch (IOException e) {
                if (!this.released) {
                    this.obtainMessage(2, e).sendToTarget();
                }
            }
            catch (Exception e) {
                if (!this.released) {
                    Log.e((String)TAG, (String)"Unexpected exception loading stream", (Throwable)e);
                    this.obtainMessage(2, new UnexpectedLoaderException(e)).sendToTarget();
                }
            }
            catch (OutOfMemoryError e) {
                if (!this.released) {
                    Log.e((String)TAG, (String)"OutOfMemory error loading stream", (Throwable)e);
                    this.obtainMessage(2, new UnexpectedLoaderException(e)).sendToTarget();
                }
            }
            catch (Error e) {
                if (!this.released) {
                    Log.e((String)TAG, (String)"Unexpected error loading stream", (Throwable)e);
                    this.obtainMessage(3, e).sendToTarget();
                }
                throw e;
            }
        }

        public void handleMessage(Message msg) {
            if (this.released) {
                return;
            }
            if (msg.what == 0) {
                this.execute();
                return;
            }
            if (msg.what == 3) {
                throw (Error)msg.obj;
            }
            this.finish();
            long nowMs = SystemClock.elapsedRealtime();
            long durationMs = nowMs - this.startTimeMs;
            Callback callback = (Callback)Assertions.checkNotNull(this.callback);
            if (this.canceled) {
                callback.onLoadCanceled(this.loadable, nowMs, durationMs, false);
                return;
            }
            switch (msg.what) {
                case 1: {
                    try {
                        callback.onLoadCompleted(this.loadable, nowMs, durationMs);
                    }
                    catch (RuntimeException e) {
                        Log.e((String)TAG, (String)"Unexpected exception handling load completed", (Throwable)e);
                        this.this$0.fatalError = new UnexpectedLoaderException(e);
                    }
                    break;
                }
                case 2: {
                    this.currentError = (IOException)msg.obj;
                    ++this.errorCount;
                    LoadErrorAction action = callback.onLoadError(this.loadable, nowMs, durationMs, this.currentError, this.errorCount);
                    if (action.type == 3) {
                        this.this$0.fatalError = this.currentError;
                        break;
                    }
                    if (action.type == 2) break;
                    if (action.type == 1) {
                        this.errorCount = 1;
                    }
                    this.start(action.retryDelayMillis != -9223372036854775807L ? action.retryDelayMillis : this.getRetryDelayMillis());
                    break;
                }
            }
        }

        private void execute() {
            this.currentError = null;
            this.this$0.downloadExecutorService.execute((Runnable)Assertions.checkNotNull((Object)this.this$0.currentTask));
        }

        private void finish() {
            this.this$0.currentTask = null;
        }

        private long getRetryDelayMillis() {
            return Math.min((this.errorCount - 1) * 1000, 5000);
        }
    }

    public static final class LoadErrorAction {
        private final int type;
        private final long retryDelayMillis;

        private LoadErrorAction(int type, long retryDelayMillis) {
            this.type = type;
            this.retryDelayMillis = retryDelayMillis;
        }

        public boolean isRetry() {
            return this.type == 0 || this.type == 1;
        }
    }

    public static interface Loadable {
        public void cancelLoad();

        public void load() throws IOException;
    }

    public static interface Callback<T extends Loadable> {
        public void onLoadCompleted(T var1, long var2, long var4);

        public void onLoadCanceled(T var1, long var2, long var4, boolean var6);

        public LoadErrorAction onLoadError(T var1, long var2, long var4, IOException var6, int var7);
    }

    public static interface ReleaseCallback {
        public void onLoaderReleased();
    }

    private static final class ReleaseTask
    implements Runnable {
        private final ReleaseCallback callback;

        public ReleaseTask(ReleaseCallback callback) {
            this.callback = callback;
        }

        @Override
        public void run() {
            this.callback.onLoaderReleased();
        }
    }

    public static final class UnexpectedLoaderException
    extends IOException {
        public UnexpectedLoaderException(Throwable cause) {
            super("Unexpected " + cause.getClass().getSimpleName() + ": " + cause.getMessage(), cause);
        }
    }
}

