/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream.experimental;

import com.google.android.exoplayer2.upstream.experimental.BandwidthStatistic;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayDeque;
import java.util.TreeSet;

@Deprecated
public class SlidingPercentileBandwidthStatistic
implements BandwidthStatistic {
    public static final int DEFAULT_MAX_SAMPLES_COUNT = 10;
    public static final double DEFAULT_PERCENTILE = 0.5;
    private final int maxSampleCount;
    private final double percentile;
    private final ArrayDeque<Sample> samples;
    private final TreeSet<Sample> sortedSamples;
    private double weightSum;
    private long bitrateEstimate;

    public SlidingPercentileBandwidthStatistic() {
        this(10, 0.5);
    }

    public SlidingPercentileBandwidthStatistic(int maxSampleCount, double percentile) {
        Assertions.checkArgument((percentile >= 0.0 && percentile <= 1.0 ? 1 : 0) != 0);
        this.maxSampleCount = maxSampleCount;
        this.percentile = percentile;
        this.samples = new ArrayDeque();
        this.sortedSamples = new TreeSet();
        this.bitrateEstimate = Long.MIN_VALUE;
    }

    @Override
    public void addSample(long bytes, long durationUs) {
        while (this.samples.size() >= this.maxSampleCount) {
            Sample removedSample = this.samples.remove();
            this.sortedSamples.remove(removedSample);
            this.weightSum -= removedSample.weight;
        }
        double weight = Math.sqrt(bytes);
        long bitrate = bytes * 8000000L / durationUs;
        Sample sample = new Sample(bitrate, weight);
        this.samples.add(sample);
        this.sortedSamples.add(sample);
        this.weightSum += weight;
        this.bitrateEstimate = this.calculateBitrateEstimate();
    }

    @Override
    public long getBandwidthEstimate() {
        return this.bitrateEstimate;
    }

    @Override
    public void reset() {
        this.samples.clear();
        this.sortedSamples.clear();
        this.weightSum = 0.0;
        this.bitrateEstimate = Long.MIN_VALUE;
    }

    private long calculateBitrateEstimate() {
        if (this.samples.isEmpty()) {
            return Long.MIN_VALUE;
        }
        double targetWeightSum = this.weightSum * this.percentile;
        double previousPartialWeightSum = 0.0;
        long previousSampleBitrate = 0L;
        double nextPartialWeightSum = 0.0;
        for (Sample sample : this.sortedSamples) {
            if ((nextPartialWeightSum += sample.weight / 2.0) >= targetWeightSum) {
                if (previousSampleBitrate == 0L) {
                    return sample.bitrate;
                }
                double partialBitrateBetweenSamples = (double)(sample.bitrate - previousSampleBitrate) * (targetWeightSum - previousPartialWeightSum) / (nextPartialWeightSum - previousPartialWeightSum);
                return previousSampleBitrate + (long)partialBitrateBetweenSamples;
            }
            previousSampleBitrate = sample.bitrate;
            previousPartialWeightSum = nextPartialWeightSum;
            nextPartialWeightSum += sample.weight / 2.0;
        }
        return previousSampleBitrate;
    }

    private static class Sample
    implements Comparable<Sample> {
        private final long bitrate;
        private final double weight;

        public Sample(long bitrate, double weight) {
            this.bitrate = bitrate;
            this.weight = weight;
        }

        @Override
        public int compareTo(Sample other) {
            return Util.compareLong((long)this.bitrate, (long)other.bitrate);
        }
    }
}

