/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream.experimental;

import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.upstream.experimental.BandwidthStatistic;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayDeque;
import java.util.Deque;

@Deprecated
public class SlidingWeightedAverageBandwidthStatistic
implements BandwidthStatistic {
    public static final int DEFAULT_MAX_SAMPLES_COUNT = 10;
    private final ArrayDeque<Sample> samples = new ArrayDeque();
    private final SampleEvictionFunction sampleEvictionFunction;
    private final Clock clock;
    private double bitrateWeightProductSum;
    private double weightSum;

    public static SampleEvictionFunction getMaxCountEvictionFunction(long maxSamplesCount) {
        return samples -> (long)samples.size() >= maxSamplesCount;
    }

    public static SampleEvictionFunction getAgeBasedEvictionFunction(long maxAgeMs) {
        return SlidingWeightedAverageBandwidthStatistic.getAgeBasedEvictionFunction(maxAgeMs, Clock.DEFAULT);
    }

    @VisibleForTesting
    static SampleEvictionFunction getAgeBasedEvictionFunction(long maxAgeMs, Clock clock) {
        return samples -> {
            if (samples.isEmpty()) {
                return false;
            }
            return ((Sample)Util.castNonNull((Object)((Sample)samples.peek()))).timeAddedMs + maxAgeMs < clock.elapsedRealtime();
        };
    }

    public SlidingWeightedAverageBandwidthStatistic() {
        this(SlidingWeightedAverageBandwidthStatistic.getMaxCountEvictionFunction(10L));
    }

    public SlidingWeightedAverageBandwidthStatistic(SampleEvictionFunction sampleEvictionFunction) {
        this(sampleEvictionFunction, Clock.DEFAULT);
    }

    @VisibleForTesting
    SlidingWeightedAverageBandwidthStatistic(SampleEvictionFunction sampleEvictionFunction, Clock clock) {
        this.sampleEvictionFunction = sampleEvictionFunction;
        this.clock = clock;
    }

    @Override
    public void addSample(long bytes, long durationUs) {
        while (this.sampleEvictionFunction.shouldEvictSample(this.samples)) {
            Sample sample = this.samples.remove();
            this.bitrateWeightProductSum -= (double)sample.bitrate * sample.weight;
            this.weightSum -= sample.weight;
        }
        double weight = Math.sqrt(bytes);
        long bitrate = bytes * 8000000L / durationUs;
        Sample sample = new Sample(bitrate, weight, this.clock.elapsedRealtime());
        this.samples.add(sample);
        this.bitrateWeightProductSum += (double)sample.bitrate * sample.weight;
        this.weightSum += sample.weight;
    }

    @Override
    public long getBandwidthEstimate() {
        if (this.samples.isEmpty()) {
            return Long.MIN_VALUE;
        }
        return (long)(this.bitrateWeightProductSum / this.weightSum);
    }

    @Override
    public void reset() {
        this.samples.clear();
        this.bitrateWeightProductSum = 0.0;
        this.weightSum = 0.0;
    }

    public static interface SampleEvictionFunction {
        public boolean shouldEvictSample(Deque<Sample> var1);
    }

    public static class Sample {
        public final long bitrate;
        public final double weight;
        public final long timeAddedMs;

        public Sample(long bitrate, double weight, long timeAddedMs) {
            this.bitrate = bitrate;
            this.weight = weight;
            this.timeAddedMs = timeAddedMs;
        }
    }
}

