/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.util;

import android.annotation.SuppressLint;
import android.os.Looper;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.video.ColorInfo;
import java.util.Locale;

@Deprecated
public class DebugTextViewHelper {
    private static final int REFRESH_INTERVAL_MS = 1000;
    private final ExoPlayer player;
    private final TextView textView;
    private final Updater updater;
    private boolean started;

    public DebugTextViewHelper(ExoPlayer player, TextView textView) {
        Assertions.checkArgument((player.getApplicationLooper() == Looper.getMainLooper() ? 1 : 0) != 0);
        this.player = player;
        this.textView = textView;
        this.updater = new Updater();
    }

    public final void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.player.addListener(this.updater);
        this.updateAndPost();
    }

    public final void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        this.player.removeListener(this.updater);
        this.textView.removeCallbacks((Runnable)this.updater);
    }

    @SuppressLint(value={"SetTextI18n"})
    protected final void updateAndPost() {
        this.textView.setText((CharSequence)this.getDebugString());
        this.textView.removeCallbacks((Runnable)this.updater);
        this.textView.postDelayed((Runnable)this.updater, 1000L);
    }

    protected String getDebugString() {
        return this.getPlayerStateString() + this.getVideoString() + this.getAudioString();
    }

    protected String getPlayerStateString() {
        String playbackStateString;
        switch (this.player.getPlaybackState()) {
            case 2: {
                playbackStateString = "buffering";
                break;
            }
            case 4: {
                playbackStateString = "ended";
                break;
            }
            case 1: {
                playbackStateString = "idle";
                break;
            }
            case 3: {
                playbackStateString = "ready";
                break;
            }
            default: {
                playbackStateString = "unknown";
            }
        }
        return String.format("playWhenReady:%s playbackState:%s item:%s", this.player.getPlayWhenReady(), playbackStateString, this.player.getCurrentMediaItemIndex());
    }

    protected String getVideoString() {
        Format format = this.player.getVideoFormat();
        DecoderCounters decoderCounters = this.player.getVideoDecoderCounters();
        if (format == null || decoderCounters == null) {
            return "";
        }
        return "\n" + format.sampleMimeType + "(id:" + format.id + " r:" + format.width + "x" + format.height + DebugTextViewHelper.getColorInfoString(format.colorInfo) + DebugTextViewHelper.getPixelAspectRatioString(format.pixelWidthHeightRatio) + DebugTextViewHelper.getDecoderCountersBufferCountString(decoderCounters) + " vfpo: " + DebugTextViewHelper.getVideoFrameProcessingOffsetAverageString(decoderCounters.totalVideoFrameProcessingOffsetUs, decoderCounters.videoFrameProcessingOffsetCount) + ")";
    }

    protected String getAudioString() {
        Format format = this.player.getAudioFormat();
        DecoderCounters decoderCounters = this.player.getAudioDecoderCounters();
        if (format == null || decoderCounters == null) {
            return "";
        }
        return "\n" + format.sampleMimeType + "(id:" + format.id + " hz:" + format.sampleRate + " ch:" + format.channelCount + DebugTextViewHelper.getDecoderCountersBufferCountString(decoderCounters) + ")";
    }

    private static String getDecoderCountersBufferCountString(DecoderCounters counters) {
        if (counters == null) {
            return "";
        }
        counters.ensureUpdated();
        return " sib:" + counters.skippedInputBufferCount + " sb:" + counters.skippedOutputBufferCount + " rb:" + counters.renderedOutputBufferCount + " db:" + counters.droppedBufferCount + " mcdb:" + counters.maxConsecutiveDroppedBufferCount + " dk:" + counters.droppedToKeyframeCount;
    }

    private static String getColorInfoString(@Nullable ColorInfo colorInfo) {
        return colorInfo != null && colorInfo.isValid() ? " colr:" + colorInfo.toLogString() : "";
    }

    private static String getPixelAspectRatioString(float pixelAspectRatio) {
        return pixelAspectRatio == -1.0f || pixelAspectRatio == 1.0f ? "" : " par:" + String.format(Locale.US, "%.02f", Float.valueOf(pixelAspectRatio));
    }

    private static String getVideoFrameProcessingOffsetAverageString(long totalOffsetUs, int frameCount) {
        if (frameCount == 0) {
            return "N/A";
        }
        long averageUs = (long)((double)totalOffsetUs / (double)frameCount);
        return String.valueOf(averageUs);
    }

    private final class Updater
    implements Player.Listener,
    Runnable {
        private Updater() {
        }

        public void onPlaybackStateChanged(int playbackState) {
            DebugTextViewHelper.this.updateAndPost();
        }

        public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
            DebugTextViewHelper.this.updateAndPost();
        }

        public void onPositionDiscontinuity(Player.PositionInfo oldPosition, Player.PositionInfo newPosition, int reason) {
            DebugTextViewHelper.this.updateAndPost();
        }

        @Override
        public void run() {
            DebugTextViewHelper.this.updateAndPost();
        }
    }
}

