/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.video;

import androidx.annotation.VisibleForTesting;
import java.util.Arrays;

@Deprecated
final class FixedFrameRateEstimator {
    public static final int CONSECUTIVE_MATCHING_FRAME_DURATIONS_FOR_SYNC = 15;
    @VisibleForTesting
    static final long MAX_MATCHING_FRAME_DIFFERENCE_NS = 1000000L;
    private Matcher currentMatcher = new Matcher();
    private Matcher candidateMatcher = new Matcher();
    private boolean candidateMatcherActive;
    private boolean switchToCandidateMatcherWhenSynced;
    private long lastFramePresentationTimeNs = -9223372036854775807L;
    private int framesWithoutSyncCount;

    public void reset() {
        this.currentMatcher.reset();
        this.candidateMatcher.reset();
        this.candidateMatcherActive = false;
        this.lastFramePresentationTimeNs = -9223372036854775807L;
        this.framesWithoutSyncCount = 0;
    }

    public void onNextFrame(long framePresentationTimeNs) {
        this.currentMatcher.onNextFrame(framePresentationTimeNs);
        if (this.currentMatcher.isSynced() && !this.switchToCandidateMatcherWhenSynced) {
            this.candidateMatcherActive = false;
        } else if (this.lastFramePresentationTimeNs != -9223372036854775807L) {
            if (!this.candidateMatcherActive || this.candidateMatcher.isLastFrameOutlier()) {
                this.candidateMatcher.reset();
                this.candidateMatcher.onNextFrame(this.lastFramePresentationTimeNs);
            }
            this.candidateMatcherActive = true;
            this.candidateMatcher.onNextFrame(framePresentationTimeNs);
        }
        if (this.candidateMatcherActive && this.candidateMatcher.isSynced()) {
            Matcher previousMatcher = this.currentMatcher;
            this.currentMatcher = this.candidateMatcher;
            this.candidateMatcher = previousMatcher;
            this.candidateMatcherActive = false;
            this.switchToCandidateMatcherWhenSynced = false;
        }
        this.lastFramePresentationTimeNs = framePresentationTimeNs;
        this.framesWithoutSyncCount = this.currentMatcher.isSynced() ? 0 : this.framesWithoutSyncCount + 1;
    }

    public boolean isSynced() {
        return this.currentMatcher.isSynced();
    }

    public int getFramesWithoutSyncCount() {
        return this.framesWithoutSyncCount;
    }

    public long getMatchingFrameDurationSumNs() {
        return this.isSynced() ? this.currentMatcher.getMatchingFrameDurationSumNs() : -9223372036854775807L;
    }

    public long getFrameDurationNs() {
        return this.isSynced() ? this.currentMatcher.getFrameDurationNs() : -9223372036854775807L;
    }

    public float getFrameRate() {
        return this.isSynced() ? (float)(1.0E9 / (double)this.currentMatcher.getFrameDurationNs()) : -1.0f;
    }

    private static final class Matcher {
        private long firstFramePresentationTimeNs;
        private long firstFrameDurationNs;
        private long lastFramePresentationTimeNs;
        private long frameCount;
        private long matchingFrameCount;
        private long matchingFrameDurationSumNs;
        private final boolean[] recentFrameOutlierFlags = new boolean[15];
        private int recentFrameOutlierCount;

        public void reset() {
            this.frameCount = 0L;
            this.matchingFrameCount = 0L;
            this.matchingFrameDurationSumNs = 0L;
            this.recentFrameOutlierCount = 0;
            Arrays.fill(this.recentFrameOutlierFlags, false);
        }

        public boolean isSynced() {
            return this.frameCount > 15L && this.recentFrameOutlierCount == 0;
        }

        public boolean isLastFrameOutlier() {
            if (this.frameCount == 0L) {
                return false;
            }
            return this.recentFrameOutlierFlags[Matcher.getRecentFrameOutlierIndex(this.frameCount - 1L)];
        }

        public long getMatchingFrameDurationSumNs() {
            return this.matchingFrameDurationSumNs;
        }

        public long getFrameDurationNs() {
            return this.matchingFrameCount == 0L ? 0L : this.matchingFrameDurationSumNs / this.matchingFrameCount;
        }

        public void onNextFrame(long framePresentationTimeNs) {
            if (this.frameCount == 0L) {
                this.firstFramePresentationTimeNs = framePresentationTimeNs;
            } else if (this.frameCount == 1L) {
                this.matchingFrameDurationSumNs = this.firstFrameDurationNs = framePresentationTimeNs - this.firstFramePresentationTimeNs;
                this.matchingFrameCount = 1L;
            } else {
                long lastFrameDurationNs = framePresentationTimeNs - this.lastFramePresentationTimeNs;
                int recentFrameOutlierIndex = Matcher.getRecentFrameOutlierIndex(this.frameCount);
                if (Math.abs(lastFrameDurationNs - this.firstFrameDurationNs) <= 1000000L) {
                    ++this.matchingFrameCount;
                    this.matchingFrameDurationSumNs += lastFrameDurationNs;
                    if (this.recentFrameOutlierFlags[recentFrameOutlierIndex]) {
                        this.recentFrameOutlierFlags[recentFrameOutlierIndex] = false;
                        --this.recentFrameOutlierCount;
                    }
                } else if (!this.recentFrameOutlierFlags[recentFrameOutlierIndex]) {
                    this.recentFrameOutlierFlags[recentFrameOutlierIndex] = true;
                    ++this.recentFrameOutlierCount;
                }
            }
            ++this.frameCount;
            this.lastFramePresentationTimeNs = framePresentationTimeNs;
        }

        private static int getRecentFrameOutlierIndex(long frameCount) {
            return (int)(frameCount % 15L);
        }
    }
}

