/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.video;

import android.content.Context;
import android.hardware.display.DisplayManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.view.Choreographer;
import android.view.Display;
import android.view.Surface;
import android.view.WindowManager;
import androidx.annotation.DoNotInline;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.FixedFrameRateEstimator;
import com.google.android.exoplayer2.video.PlaceholderSurface;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@Deprecated
public final class VideoFrameReleaseHelper {
    private static final String TAG = "VideoFrameReleaseHelper";
    private static final long MINIMUM_MATCHING_FRAME_DURATION_FOR_HIGH_CONFIDENCE_NS = 5000000000L;
    private static final float MINIMUM_MEDIA_FRAME_RATE_CHANGE_FOR_UPDATE_HIGH_CONFIDENCE = 0.02f;
    private static final float MINIMUM_MEDIA_FRAME_RATE_CHANGE_FOR_UPDATE_LOW_CONFIDENCE = 1.0f;
    private static final int MINIMUM_FRAMES_WITHOUT_SYNC_TO_CLEAR_SURFACE_FRAME_RATE = 30;
    private static final long VSYNC_SAMPLE_UPDATE_PERIOD_MS = 500L;
    private static final long MAX_ALLOWED_ADJUSTMENT_NS = 20000000L;
    private static final long VSYNC_OFFSET_PERCENTAGE = 80L;
    private final FixedFrameRateEstimator frameRateEstimator = new FixedFrameRateEstimator();
    @Nullable
    private final DisplayHelper displayHelper;
    @Nullable
    private final VSyncSampler vsyncSampler;
    private boolean started;
    @Nullable
    private Surface surface;
    private float formatFrameRate;
    private float surfaceMediaFrameRate;
    private float surfacePlaybackFrameRate;
    private float playbackSpeed;
    private int changeFrameRateStrategy;
    private long vsyncDurationNs;
    private long vsyncOffsetNs;
    private long frameIndex;
    private long pendingLastAdjustedFrameIndex;
    private long pendingLastAdjustedReleaseTimeNs;
    private long lastAdjustedFrameIndex;
    private long lastAdjustedReleaseTimeNs;

    public VideoFrameReleaseHelper(@Nullable Context context) {
        this.displayHelper = VideoFrameReleaseHelper.maybeBuildDisplayHelper(context);
        this.vsyncSampler = this.displayHelper != null ? VSyncSampler.getInstance() : null;
        this.vsyncDurationNs = -9223372036854775807L;
        this.vsyncOffsetNs = -9223372036854775807L;
        this.formatFrameRate = -1.0f;
        this.playbackSpeed = 1.0f;
        this.changeFrameRateStrategy = 0;
    }

    public void setChangeFrameRateStrategy(int changeFrameRateStrategy) {
        if (this.changeFrameRateStrategy == changeFrameRateStrategy) {
            return;
        }
        this.changeFrameRateStrategy = changeFrameRateStrategy;
        this.updateSurfacePlaybackFrameRate(true);
    }

    public void onStarted() {
        this.started = true;
        this.resetAdjustment();
        if (this.displayHelper != null) {
            ((VSyncSampler)Assertions.checkNotNull((Object)this.vsyncSampler)).addObserver();
            this.displayHelper.register(this::updateDefaultDisplayRefreshRateParams);
        }
        this.updateSurfacePlaybackFrameRate(false);
    }

    public void onSurfaceChanged(@Nullable Surface surface) {
        if (surface instanceof PlaceholderSurface) {
            surface = null;
        }
        if (this.surface == surface) {
            return;
        }
        this.clearSurfaceFrameRate();
        this.surface = surface;
        this.updateSurfacePlaybackFrameRate(true);
    }

    public void onPositionReset() {
        this.resetAdjustment();
    }

    public void onPlaybackSpeed(float playbackSpeed) {
        this.playbackSpeed = playbackSpeed;
        this.resetAdjustment();
        this.updateSurfacePlaybackFrameRate(false);
    }

    public void onFormatChanged(float formatFrameRate) {
        this.formatFrameRate = formatFrameRate;
        this.frameRateEstimator.reset();
        this.updateSurfaceMediaFrameRate();
    }

    public void onNextFrame(long framePresentationTimeUs) {
        if (this.pendingLastAdjustedFrameIndex != -1L) {
            this.lastAdjustedFrameIndex = this.pendingLastAdjustedFrameIndex;
            this.lastAdjustedReleaseTimeNs = this.pendingLastAdjustedReleaseTimeNs;
        }
        ++this.frameIndex;
        this.frameRateEstimator.onNextFrame(framePresentationTimeUs * 1000L);
        this.updateSurfaceMediaFrameRate();
    }

    public void onStopped() {
        this.started = false;
        if (this.displayHelper != null) {
            this.displayHelper.unregister();
            ((VSyncSampler)Assertions.checkNotNull((Object)this.vsyncSampler)).removeObserver();
        }
        this.clearSurfaceFrameRate();
    }

    public long adjustReleaseTime(long releaseTimeNs) {
        long adjustedReleaseTimeNs = releaseTimeNs;
        if (this.lastAdjustedFrameIndex != -1L && this.frameRateEstimator.isSynced()) {
            long frameDurationNs = this.frameRateEstimator.getFrameDurationNs();
            long candidateAdjustedReleaseTimeNs = this.lastAdjustedReleaseTimeNs + (long)((float)(frameDurationNs * (this.frameIndex - this.lastAdjustedFrameIndex)) / this.playbackSpeed);
            if (VideoFrameReleaseHelper.adjustmentAllowed(releaseTimeNs, candidateAdjustedReleaseTimeNs)) {
                adjustedReleaseTimeNs = candidateAdjustedReleaseTimeNs;
            } else {
                this.resetAdjustment();
            }
        }
        this.pendingLastAdjustedFrameIndex = this.frameIndex;
        this.pendingLastAdjustedReleaseTimeNs = adjustedReleaseTimeNs;
        if (this.vsyncSampler == null || this.vsyncDurationNs == -9223372036854775807L) {
            return adjustedReleaseTimeNs;
        }
        long sampledVsyncTimeNs = this.vsyncSampler.sampledVsyncTimeNs;
        if (sampledVsyncTimeNs == -9223372036854775807L) {
            return adjustedReleaseTimeNs;
        }
        long snappedTimeNs = VideoFrameReleaseHelper.closestVsync(adjustedReleaseTimeNs, sampledVsyncTimeNs, this.vsyncDurationNs);
        return snappedTimeNs - this.vsyncOffsetNs;
    }

    private void resetAdjustment() {
        this.frameIndex = 0L;
        this.lastAdjustedFrameIndex = -1L;
        this.pendingLastAdjustedFrameIndex = -1L;
    }

    private static boolean adjustmentAllowed(long unadjustedReleaseTimeNs, long adjustedReleaseTimeNs) {
        return Math.abs(unadjustedReleaseTimeNs - adjustedReleaseTimeNs) <= 20000000L;
    }

    private void updateSurfaceMediaFrameRate() {
        boolean shouldUpdate;
        float candidateFrameRate;
        if (Util.SDK_INT < 30 || this.surface == null) {
            return;
        }
        float f = candidateFrameRate = this.frameRateEstimator.isSynced() ? this.frameRateEstimator.getFrameRate() : this.formatFrameRate;
        if (candidateFrameRate == this.surfaceMediaFrameRate) {
            return;
        }
        if (candidateFrameRate != -1.0f && this.surfaceMediaFrameRate != -1.0f) {
            boolean candidateIsHighConfidence = this.frameRateEstimator.isSynced() && this.frameRateEstimator.getMatchingFrameDurationSumNs() >= 5000000000L;
            float minimumChangeForUpdate = candidateIsHighConfidence ? 0.02f : 1.0f;
            shouldUpdate = Math.abs(candidateFrameRate - this.surfaceMediaFrameRate) >= minimumChangeForUpdate;
        } else if (candidateFrameRate != -1.0f) {
            shouldUpdate = true;
        } else {
            boolean bl = shouldUpdate = this.frameRateEstimator.getFramesWithoutSyncCount() >= 30;
        }
        if (shouldUpdate) {
            this.surfaceMediaFrameRate = candidateFrameRate;
            this.updateSurfacePlaybackFrameRate(false);
        }
    }

    private void updateSurfacePlaybackFrameRate(boolean forceUpdate) {
        if (Util.SDK_INT < 30 || this.surface == null || this.changeFrameRateStrategy == Integer.MIN_VALUE) {
            return;
        }
        float surfacePlaybackFrameRate = 0.0f;
        if (this.started && this.surfaceMediaFrameRate != -1.0f) {
            surfacePlaybackFrameRate = this.surfaceMediaFrameRate * this.playbackSpeed;
        }
        if (!forceUpdate && this.surfacePlaybackFrameRate == surfacePlaybackFrameRate) {
            return;
        }
        this.surfacePlaybackFrameRate = surfacePlaybackFrameRate;
        Api30.setSurfaceFrameRate(this.surface, surfacePlaybackFrameRate);
    }

    private void clearSurfaceFrameRate() {
        if (Util.SDK_INT < 30 || this.surface == null || this.changeFrameRateStrategy == Integer.MIN_VALUE || this.surfacePlaybackFrameRate == 0.0f) {
            return;
        }
        this.surfacePlaybackFrameRate = 0.0f;
        Api30.setSurfaceFrameRate(this.surface, 0.0f);
    }

    private void updateDefaultDisplayRefreshRateParams(@Nullable Display defaultDisplay) {
        if (defaultDisplay != null) {
            double defaultDisplayRefreshRate = defaultDisplay.getRefreshRate();
            this.vsyncDurationNs = (long)(1.0E9 / defaultDisplayRefreshRate);
            this.vsyncOffsetNs = this.vsyncDurationNs * 80L / 100L;
        } else {
            Log.w((String)TAG, (String)"Unable to query display refresh rate");
            this.vsyncDurationNs = -9223372036854775807L;
            this.vsyncOffsetNs = -9223372036854775807L;
        }
    }

    private static long closestVsync(long releaseTime, long sampledVsyncTime, long vsyncDuration) {
        long snappedAfterNs;
        long snappedBeforeNs;
        long vsyncCount = (releaseTime - sampledVsyncTime) / vsyncDuration;
        long snappedTimeNs = sampledVsyncTime + vsyncDuration * vsyncCount;
        if (releaseTime <= snappedTimeNs) {
            snappedBeforeNs = snappedTimeNs - vsyncDuration;
            snappedAfterNs = snappedTimeNs;
        } else {
            snappedBeforeNs = snappedTimeNs;
            snappedAfterNs = snappedTimeNs + vsyncDuration;
        }
        long snappedAfterDiff = snappedAfterNs - releaseTime;
        long snappedBeforeDiff = releaseTime - snappedBeforeNs;
        return snappedAfterDiff < snappedBeforeDiff ? snappedAfterNs : snappedBeforeNs;
    }

    @Nullable
    private static DisplayHelper maybeBuildDisplayHelper(@Nullable Context context) {
        DisplayHelper displayHelper = null;
        if (context != null) {
            context = context.getApplicationContext();
            if (Util.SDK_INT >= 17) {
                displayHelper = DisplayHelperV17.maybeBuildNewInstance(context);
            }
            if (displayHelper == null) {
                displayHelper = DisplayHelperV16.maybeBuildNewInstance(context);
            }
        }
        return displayHelper;
    }

    private static interface DisplayHelper {
        public void register(Listener var1);

        public void unregister();

        public static interface Listener {
            public void onDefaultDisplayChanged(@Nullable Display var1);
        }
    }

    private static final class VSyncSampler
    implements Choreographer.FrameCallback,
    Handler.Callback {
        public volatile long sampledVsyncTimeNs = -9223372036854775807L;
        private static final int CREATE_CHOREOGRAPHER = 0;
        private static final int MSG_ADD_OBSERVER = 1;
        private static final int MSG_REMOVE_OBSERVER = 2;
        private static final VSyncSampler INSTANCE = new VSyncSampler();
        private final Handler handler;
        private final HandlerThread choreographerOwnerThread = new HandlerThread("ExoPlayer:FrameReleaseChoreographer");
        private @MonotonicNonNull Choreographer choreographer;
        private int observerCount;

        public static VSyncSampler getInstance() {
            return INSTANCE;
        }

        private VSyncSampler() {
            this.choreographerOwnerThread.start();
            this.handler = Util.createHandler((Looper)this.choreographerOwnerThread.getLooper(), (Handler.Callback)this);
            this.handler.sendEmptyMessage(0);
        }

        public void addObserver() {
            this.handler.sendEmptyMessage(1);
        }

        public void removeObserver() {
            this.handler.sendEmptyMessage(2);
        }

        public void doFrame(long vsyncTimeNs) {
            this.sampledVsyncTimeNs = vsyncTimeNs;
            ((Choreographer)Assertions.checkNotNull((Object)this.choreographer)).postFrameCallbackDelayed((Choreographer.FrameCallback)this, 500L);
        }

        public boolean handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    this.createChoreographerInstanceInternal();
                    return true;
                }
                case 1: {
                    this.addObserverInternal();
                    return true;
                }
                case 2: {
                    this.removeObserverInternal();
                    return true;
                }
            }
            return false;
        }

        private void createChoreographerInstanceInternal() {
            try {
                this.choreographer = Choreographer.getInstance();
            }
            catch (RuntimeException e) {
                Log.w((String)VideoFrameReleaseHelper.TAG, (String)"Vsync sampling disabled due to platform error", (Throwable)e);
            }
        }

        private void addObserverInternal() {
            if (this.choreographer != null) {
                ++this.observerCount;
                if (this.observerCount == 1) {
                    this.choreographer.postFrameCallback((Choreographer.FrameCallback)this);
                }
            }
        }

        private void removeObserverInternal() {
            if (this.choreographer != null) {
                --this.observerCount;
                if (this.observerCount == 0) {
                    this.choreographer.removeFrameCallback((Choreographer.FrameCallback)this);
                    this.sampledVsyncTimeNs = -9223372036854775807L;
                }
            }
        }
    }

    @RequiresApi(value=30)
    private static final class Api30 {
        private Api30() {
        }

        @DoNotInline
        public static void setSurfaceFrameRate(Surface surface, float frameRate) {
            int compatibility = frameRate == 0.0f ? 0 : 1;
            try {
                surface.setFrameRate(frameRate, compatibility);
            }
            catch (IllegalStateException e) {
                Log.e((String)VideoFrameReleaseHelper.TAG, (String)"Failed to call Surface.setFrameRate", (Throwable)e);
            }
        }
    }

    @RequiresApi(value=17)
    private static final class DisplayHelperV17
    implements DisplayHelper,
    DisplayManager.DisplayListener {
        private final DisplayManager displayManager;
        @Nullable
        private DisplayHelper.Listener listener;

        @Nullable
        public static DisplayHelper maybeBuildNewInstance(Context context) {
            DisplayManager displayManager = (DisplayManager)context.getSystemService("display");
            return displayManager != null ? new DisplayHelperV17(displayManager) : null;
        }

        private DisplayHelperV17(DisplayManager displayManager) {
            this.displayManager = displayManager;
        }

        @Override
        public void register(DisplayHelper.Listener listener) {
            this.listener = listener;
            this.displayManager.registerDisplayListener((DisplayManager.DisplayListener)this, Util.createHandlerForCurrentLooper());
            listener.onDefaultDisplayChanged(this.getDefaultDisplay());
        }

        @Override
        public void unregister() {
            this.displayManager.unregisterDisplayListener((DisplayManager.DisplayListener)this);
            this.listener = null;
        }

        public void onDisplayChanged(int displayId) {
            if (this.listener != null && displayId == 0) {
                this.listener.onDefaultDisplayChanged(this.getDefaultDisplay());
            }
        }

        public void onDisplayAdded(int displayId) {
        }

        public void onDisplayRemoved(int displayId) {
        }

        private Display getDefaultDisplay() {
            return this.displayManager.getDisplay(0);
        }
    }

    private static final class DisplayHelperV16
    implements DisplayHelper {
        private final WindowManager windowManager;

        @Nullable
        public static DisplayHelper maybeBuildNewInstance(Context context) {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            return windowManager != null ? new DisplayHelperV16(windowManager) : null;
        }

        private DisplayHelperV16(WindowManager windowManager) {
            this.windowManager = windowManager;
        }

        @Override
        public void register(DisplayHelper.Listener listener) {
            listener.onDefaultDisplayChanged(this.windowManager.getDefaultDisplay());
        }

        @Override
        public void unregister() {
        }
    }
}

