/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.video.spherical;

import android.opengl.GLES20;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.GlProgram;
import com.google.android.exoplayer2.util.GlUtil;
import com.google.android.exoplayer2.video.spherical.Projection;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@Deprecated
final class ProjectionRenderer {
    private static final String TAG = "ProjectionRenderer";
    private static final String VERTEX_SHADER = "uniform mat4 uMvpMatrix;\nuniform mat3 uTexMatrix;\nattribute vec4 aPosition;\nattribute vec2 aTexCoords;\nvarying vec2 vTexCoords;\n// Standard transformation.\nvoid main() {\n  gl_Position = uMvpMatrix * aPosition;\n  vTexCoords = (uTexMatrix * vec3(aTexCoords, 1)).xy;\n}\n";
    private static final String FRAGMENT_SHADER = "// This is required since the texture data is GL_TEXTURE_EXTERNAL_OES.\n#extension GL_OES_EGL_image_external : require\nprecision mediump float;\n// Standard texture rendering shader.\nuniform samplerExternalOES uTexture;\nvarying vec2 vTexCoords;\nvoid main() {\n  gl_FragColor = texture2D(uTexture, vTexCoords);\n}\n";
    private static final float[] TEX_MATRIX_WHOLE = new float[]{1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 1.0f};
    private static final float[] TEX_MATRIX_TOP = new float[]{1.0f, 0.0f, 0.0f, 0.0f, -0.5f, 0.0f, 0.0f, 0.5f, 1.0f};
    private static final float[] TEX_MATRIX_BOTTOM = new float[]{1.0f, 0.0f, 0.0f, 0.0f, -0.5f, 0.0f, 0.0f, 1.0f, 1.0f};
    private static final float[] TEX_MATRIX_LEFT = new float[]{0.5f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 1.0f};
    private static final float[] TEX_MATRIX_RIGHT = new float[]{0.5f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.5f, 1.0f, 1.0f};
    private int stereoMode;
    @Nullable
    private MeshData leftMeshData;
    @Nullable
    private MeshData rightMeshData;
    private @MonotonicNonNull GlProgram program;
    private int mvpMatrixHandle;
    private int uTexMatrixHandle;
    private int positionHandle;
    private int texCoordsHandle;
    private int textureHandle;

    ProjectionRenderer() {
    }

    public static boolean isSupported(Projection projection) {
        Projection.Mesh leftMesh = projection.leftMesh;
        Projection.Mesh rightMesh = projection.rightMesh;
        return leftMesh.getSubMeshCount() == 1 && leftMesh.getSubMesh((int)0).textureId == 0 && rightMesh.getSubMeshCount() == 1 && rightMesh.getSubMesh((int)0).textureId == 0;
    }

    public void setProjection(Projection projection) {
        if (!ProjectionRenderer.isSupported(projection)) {
            return;
        }
        this.stereoMode = projection.stereoMode;
        this.leftMeshData = new MeshData(projection.leftMesh.getSubMesh(0));
        this.rightMeshData = projection.singleMesh ? this.leftMeshData : new MeshData(projection.rightMesh.getSubMesh(0));
    }

    public void init() {
        try {
            this.program = new GlProgram(VERTEX_SHADER, FRAGMENT_SHADER);
            this.mvpMatrixHandle = this.program.getUniformLocation("uMvpMatrix");
            this.uTexMatrixHandle = this.program.getUniformLocation("uTexMatrix");
            this.positionHandle = this.program.getAttributeArrayLocationAndEnable("aPosition");
            this.texCoordsHandle = this.program.getAttributeArrayLocationAndEnable("aTexCoords");
            this.textureHandle = this.program.getUniformLocation("uTexture");
        }
        catch (GlUtil.GlException e) {
            Log.e((String)TAG, (String)"Failed to initialize the program", (Throwable)e);
        }
    }

    public void draw(int textureId, float[] mvpMatrix, boolean rightEye) {
        MeshData meshData;
        MeshData meshData2 = meshData = rightEye ? this.rightMeshData : this.leftMeshData;
        if (meshData == null) {
            return;
        }
        float[] texMatrix = this.stereoMode == 1 ? (rightEye ? TEX_MATRIX_BOTTOM : TEX_MATRIX_TOP) : (this.stereoMode == 2 ? (rightEye ? TEX_MATRIX_RIGHT : TEX_MATRIX_LEFT) : TEX_MATRIX_WHOLE);
        GLES20.glUniformMatrix3fv((int)this.uTexMatrixHandle, (int)1, (boolean)false, (float[])texMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.mvpMatrixHandle, (int)1, (boolean)false, (float[])mvpMatrix, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)textureId);
        GLES20.glUniform1i((int)this.textureHandle, (int)0);
        try {
            GlUtil.checkGlError();
        }
        catch (GlUtil.GlException e) {
            Log.e((String)TAG, (String)"Failed to bind uniforms", (Throwable)e);
        }
        GLES20.glVertexAttribPointer((int)this.positionHandle, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)meshData.vertexBuffer);
        try {
            GlUtil.checkGlError();
        }
        catch (GlUtil.GlException e) {
            Log.e((String)TAG, (String)"Failed to load position data", (Throwable)e);
        }
        GLES20.glVertexAttribPointer((int)this.texCoordsHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)meshData.textureBuffer);
        try {
            GlUtil.checkGlError();
        }
        catch (GlUtil.GlException e) {
            Log.e((String)TAG, (String)"Failed to load texture data", (Throwable)e);
        }
        GLES20.glDrawArrays((int)meshData.drawMode, (int)0, (int)meshData.vertexCount);
        try {
            GlUtil.checkGlError();
        }
        catch (GlUtil.GlException e) {
            Log.e((String)TAG, (String)"Failed to render", (Throwable)e);
        }
    }

    public void shutdown() {
        if (this.program != null) {
            try {
                this.program.delete();
            }
            catch (GlUtil.GlException e) {
                Log.e((String)TAG, (String)"Failed to delete the shader program", (Throwable)e);
            }
        }
    }

    private static class MeshData {
        private final int vertexCount;
        private final FloatBuffer vertexBuffer;
        private final FloatBuffer textureBuffer;
        private final int drawMode;

        public MeshData(Projection.SubMesh subMesh) {
            this.vertexCount = subMesh.getVertexCount();
            this.vertexBuffer = GlUtil.createBuffer((float[])subMesh.vertices);
            this.textureBuffer = GlUtil.createBuffer((float[])subMesh.textureCoords);
            switch (subMesh.mode) {
                case 1: {
                    this.drawMode = 5;
                    break;
                }
                case 2: {
                    this.drawMode = 6;
                    break;
                }
                default: {
                    this.drawMode = 4;
                }
            }
        }
    }
}

