/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.BaseDataSource;
import com.google.android.exoplayer2.upstream.DataSourceException;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.util.Assertions;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;

public final class UdpDataSource
extends BaseDataSource {
    public static final int DEFAULT_MAX_PACKET_SIZE = 2000;
    public static final int DEFAULT_SOCKET_TIMEOUT_MILLIS = 8000;
    public static final int UDP_PORT_UNSET = -1;
    private final int socketTimeoutMillis;
    private final byte[] packetBuffer;
    private final DatagramPacket packet;
    @Nullable
    private Uri uri;
    @Nullable
    private DatagramSocket socket;
    @Nullable
    private MulticastSocket multicastSocket;
    @Nullable
    private InetAddress address;
    private boolean opened;
    private int packetRemaining;

    public UdpDataSource() {
        this(2000);
    }

    public UdpDataSource(int maxPacketSize) {
        this(maxPacketSize, 8000);
    }

    public UdpDataSource(int maxPacketSize, int socketTimeoutMillis) {
        super(true);
        this.socketTimeoutMillis = socketTimeoutMillis;
        this.packetBuffer = new byte[maxPacketSize];
        this.packet = new DatagramPacket(this.packetBuffer, 0, maxPacketSize);
    }

    @Override
    public long open(DataSpec dataSpec) throws UdpDataSourceException {
        this.uri = dataSpec.uri;
        String host = (String)Assertions.checkNotNull((Object)this.uri.getHost());
        int port = this.uri.getPort();
        this.transferInitializing(dataSpec);
        try {
            this.address = InetAddress.getByName(host);
            InetSocketAddress socketAddress = new InetSocketAddress(this.address, port);
            if (this.address.isMulticastAddress()) {
                this.multicastSocket = new MulticastSocket(socketAddress);
                this.multicastSocket.joinGroup(this.address);
                this.socket = this.multicastSocket;
            } else {
                this.socket = new DatagramSocket(socketAddress);
            }
            this.socket.setSoTimeout(this.socketTimeoutMillis);
        }
        catch (SecurityException e) {
            throw new UdpDataSourceException(e, 2006);
        }
        catch (IOException e) {
            throw new UdpDataSourceException(e, 2001);
        }
        this.opened = true;
        this.transferStarted(dataSpec);
        return -1L;
    }

    public int read(byte[] buffer, int offset, int length) throws UdpDataSourceException {
        if (length == 0) {
            return 0;
        }
        if (this.packetRemaining == 0) {
            try {
                ((DatagramSocket)Assertions.checkNotNull((Object)this.socket)).receive(this.packet);
            }
            catch (SocketTimeoutException e) {
                throw new UdpDataSourceException(e, 2002);
            }
            catch (IOException e) {
                throw new UdpDataSourceException(e, 2001);
            }
            this.packetRemaining = this.packet.getLength();
            this.bytesTransferred(this.packetRemaining);
        }
        int packetOffset = this.packet.getLength() - this.packetRemaining;
        int bytesToRead = Math.min(this.packetRemaining, length);
        System.arraycopy(this.packetBuffer, packetOffset, buffer, offset, bytesToRead);
        this.packetRemaining -= bytesToRead;
        return bytesToRead;
    }

    @Override
    @Nullable
    public Uri getUri() {
        return this.uri;
    }

    @Override
    public void close() {
        this.uri = null;
        if (this.multicastSocket != null) {
            try {
                this.multicastSocket.leaveGroup((InetAddress)Assertions.checkNotNull((Object)this.address));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.multicastSocket = null;
        }
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
        this.address = null;
        this.packetRemaining = 0;
        if (this.opened) {
            this.opened = false;
            this.transferEnded();
        }
    }

    public int getLocalPort() {
        if (this.socket == null) {
            return -1;
        }
        return this.socket.getLocalPort();
    }

    public static final class UdpDataSourceException
    extends DataSourceException {
        public UdpDataSourceException(Throwable cause, int errorCode) {
            super(cause, errorCode);
        }
    }
}

