/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.upstream.cache;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.upstream.cache.CacheSpan;
import com.google.android.exoplayer2.upstream.cache.ContentMetadataMutations;
import com.google.android.exoplayer2.upstream.cache.DefaultContentMetadata;
import com.google.android.exoplayer2.upstream.cache.SimpleCacheSpan;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import java.io.File;
import java.util.ArrayList;
import java.util.TreeSet;

final class CachedContent {
    private static final String TAG = "CachedContent";
    public final int id;
    public final String key;
    private final TreeSet<SimpleCacheSpan> cachedSpans;
    private final ArrayList<Range> lockedRanges;
    private DefaultContentMetadata metadata;

    public CachedContent(int id, String key) {
        this(id, key, DefaultContentMetadata.EMPTY);
    }

    public CachedContent(int id, String key, DefaultContentMetadata metadata) {
        this.id = id;
        this.key = key;
        this.metadata = metadata;
        this.cachedSpans = new TreeSet();
        this.lockedRanges = new ArrayList();
    }

    public DefaultContentMetadata getMetadata() {
        return this.metadata;
    }

    public boolean applyMetadataMutations(ContentMetadataMutations mutations) {
        DefaultContentMetadata oldMetadata = this.metadata;
        this.metadata = this.metadata.copyWithMutationsApplied(mutations);
        return !this.metadata.equals(oldMetadata);
    }

    public boolean isFullyUnlocked() {
        return this.lockedRanges.isEmpty();
    }

    public boolean isFullyLocked(long position, long length) {
        for (int i = 0; i < this.lockedRanges.size(); ++i) {
            if (!this.lockedRanges.get(i).contains(position, length)) continue;
            return true;
        }
        return false;
    }

    public boolean lockRange(long position, long length) {
        for (int i = 0; i < this.lockedRanges.size(); ++i) {
            if (!this.lockedRanges.get(i).intersects(position, length)) continue;
            return false;
        }
        this.lockedRanges.add(new Range(position, length));
        return true;
    }

    public void unlockRange(long position) {
        for (int i = 0; i < this.lockedRanges.size(); ++i) {
            if (this.lockedRanges.get((int)i).position != position) continue;
            this.lockedRanges.remove(i);
            return;
        }
        throw new IllegalStateException();
    }

    public void addSpan(SimpleCacheSpan span) {
        this.cachedSpans.add(span);
    }

    public TreeSet<SimpleCacheSpan> getSpans() {
        return this.cachedSpans;
    }

    public SimpleCacheSpan getSpan(long position, long length) {
        SimpleCacheSpan lookupSpan = SimpleCacheSpan.createLookup(this.key, position);
        SimpleCacheSpan floorSpan = this.cachedSpans.floor(lookupSpan);
        if (floorSpan != null && floorSpan.position + floorSpan.length > position) {
            return floorSpan;
        }
        SimpleCacheSpan ceilSpan = this.cachedSpans.ceiling(lookupSpan);
        if (ceilSpan != null) {
            long holeLength = ceilSpan.position - position;
            length = length == -1L ? holeLength : Math.min(holeLength, length);
        }
        return SimpleCacheSpan.createHole(this.key, position, length);
    }

    public long getCachedBytesLength(long position, long length) {
        long currentEndPosition;
        Assertions.checkArgument((position >= 0L ? 1 : 0) != 0);
        Assertions.checkArgument((length >= 0L ? 1 : 0) != 0);
        SimpleCacheSpan span = this.getSpan(position, length);
        if (span.isHoleSpan()) {
            return -Math.min(span.isOpenEnded() ? Long.MAX_VALUE : span.length, length);
        }
        long queryEndPosition = position + length;
        if (queryEndPosition < 0L) {
            queryEndPosition = Long.MAX_VALUE;
        }
        if ((currentEndPosition = span.position + span.length) < queryEndPosition) {
            for (SimpleCacheSpan next : this.cachedSpans.tailSet(span, false)) {
                if (next.position <= currentEndPosition && (currentEndPosition = Math.max(currentEndPosition, next.position + next.length)) < queryEndPosition) continue;
                break;
            }
        }
        return Math.min(currentEndPosition - position, length);
    }

    public SimpleCacheSpan setLastTouchTimestamp(SimpleCacheSpan cacheSpan, long lastTouchTimestamp, boolean updateFile) {
        Assertions.checkState((boolean)this.cachedSpans.remove(cacheSpan));
        File file = (File)Assertions.checkNotNull((Object)cacheSpan.file);
        if (updateFile) {
            long position;
            File directory = (File)Assertions.checkNotNull((Object)file.getParentFile());
            File newFile = SimpleCacheSpan.getCacheFile(directory, this.id, position = cacheSpan.position, lastTouchTimestamp);
            if (file.renameTo(newFile)) {
                file = newFile;
            } else {
                String string = String.valueOf(file);
                String string2 = String.valueOf(newFile);
                Log.w((String)TAG, (String)new StringBuilder(21 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Failed to rename ").append(string).append(" to ").append(string2).toString());
            }
        }
        SimpleCacheSpan newCacheSpan = cacheSpan.copyWithFileAndLastTouchTimestamp(file, lastTouchTimestamp);
        this.cachedSpans.add(newCacheSpan);
        return newCacheSpan;
    }

    public boolean isEmpty() {
        return this.cachedSpans.isEmpty();
    }

    public boolean removeSpan(CacheSpan span) {
        if (this.cachedSpans.remove(span)) {
            if (span.file != null) {
                span.file.delete();
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + this.metadata.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachedContent that = (CachedContent)o;
        return this.id == that.id && this.key.equals(that.key) && this.cachedSpans.equals(that.cachedSpans) && this.metadata.equals(that.metadata);
    }

    private static final class Range {
        public final long position;
        public final long length;

        public Range(long position, long length) {
            this.position = position;
            this.length = length;
        }

        public boolean contains(long otherPosition, long otherLength) {
            if (this.length == -1L) {
                return otherPosition >= this.position;
            }
            if (otherLength == -1L) {
                return false;
            }
            return this.position <= otherPosition && otherPosition + otherLength <= this.position + this.length;
        }

        public boolean intersects(long otherPosition, long otherLength) {
            if (this.position <= otherPosition) {
                return this.length == -1L || this.position + this.length > otherPosition;
            }
            return otherLength == -1L || otherPosition + otherLength > this.position;
        }
    }
}

