/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.ts;

import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.TimestampAdjuster;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;

final class PsDurationReader {
    private static final String TAG = "PsDurationReader";
    private static final int TIMESTAMP_SEARCH_BYTES = 20000;
    private final TimestampAdjuster scrTimestampAdjuster = new TimestampAdjuster(0L);
    private final ParsableByteArray packetBuffer = new ParsableByteArray();
    private boolean isDurationRead;
    private boolean isFirstScrValueRead;
    private boolean isLastScrValueRead;
    private long firstScrValue = -9223372036854775807L;
    private long lastScrValue = -9223372036854775807L;
    private long durationUs = -9223372036854775807L;

    PsDurationReader() {
    }

    public boolean isDurationReadFinished() {
        return this.isDurationRead;
    }

    public TimestampAdjuster getScrTimestampAdjuster() {
        return this.scrTimestampAdjuster;
    }

    public int readDuration(ExtractorInput input, PositionHolder seekPositionHolder) throws IOException {
        if (!this.isLastScrValueRead) {
            return this.readLastScrValue(input, seekPositionHolder);
        }
        if (this.lastScrValue == -9223372036854775807L) {
            return this.finishReadDuration(input);
        }
        if (!this.isFirstScrValueRead) {
            return this.readFirstScrValue(input, seekPositionHolder);
        }
        if (this.firstScrValue == -9223372036854775807L) {
            return this.finishReadDuration(input);
        }
        long minScrPositionUs = this.scrTimestampAdjuster.adjustTsTimestamp(this.firstScrValue);
        long maxScrPositionUs = this.scrTimestampAdjuster.adjustTsTimestamp(this.lastScrValue);
        this.durationUs = maxScrPositionUs - minScrPositionUs;
        if (this.durationUs < 0L) {
            long l = this.durationUs;
            Log.w((String)TAG, (String)new StringBuilder(65).append("Invalid duration: ").append(l).append(". Using TIME_UNSET instead.").toString());
            this.durationUs = -9223372036854775807L;
        }
        return this.finishReadDuration(input);
    }

    public long getDurationUs() {
        return this.durationUs;
    }

    public static long readScrValueFromPack(ParsableByteArray packetBuffer) {
        int originalPosition = packetBuffer.getPosition();
        if (packetBuffer.bytesLeft() < 9) {
            return -9223372036854775807L;
        }
        byte[] scrBytes = new byte[9];
        packetBuffer.readBytes(scrBytes, 0, scrBytes.length);
        packetBuffer.setPosition(originalPosition);
        if (!PsDurationReader.checkMarkerBits(scrBytes)) {
            return -9223372036854775807L;
        }
        return PsDurationReader.readScrValueFromPackHeader(scrBytes);
    }

    private int finishReadDuration(ExtractorInput input) {
        this.packetBuffer.reset(Util.EMPTY_BYTE_ARRAY);
        this.isDurationRead = true;
        input.resetPeekPosition();
        return 0;
    }

    private int readFirstScrValue(ExtractorInput input, PositionHolder seekPositionHolder) throws IOException {
        int bytesToSearch = (int)Math.min(20000L, input.getLength());
        int searchStartPosition = 0;
        if (input.getPosition() != (long)searchStartPosition) {
            seekPositionHolder.position = searchStartPosition;
            return 1;
        }
        this.packetBuffer.reset(bytesToSearch);
        input.resetPeekPosition();
        input.peekFully(this.packetBuffer.getData(), 0, bytesToSearch);
        this.firstScrValue = this.readFirstScrValueFromBuffer(this.packetBuffer);
        this.isFirstScrValueRead = true;
        return 0;
    }

    private long readFirstScrValueFromBuffer(ParsableByteArray packetBuffer) {
        int searchStartPosition = packetBuffer.getPosition();
        int searchEndPosition = packetBuffer.limit();
        for (int searchPosition = searchStartPosition; searchPosition < searchEndPosition - 3; ++searchPosition) {
            int nextStartCode = this.peekIntAtPosition(packetBuffer.getData(), searchPosition);
            if (nextStartCode != 442) continue;
            packetBuffer.setPosition(searchPosition + 4);
            long scrValue = PsDurationReader.readScrValueFromPack(packetBuffer);
            if (scrValue == -9223372036854775807L) continue;
            return scrValue;
        }
        return -9223372036854775807L;
    }

    private int readLastScrValue(ExtractorInput input, PositionHolder seekPositionHolder) throws IOException {
        long inputLength = input.getLength();
        int bytesToSearch = (int)Math.min(20000L, inputLength);
        long searchStartPosition = inputLength - (long)bytesToSearch;
        if (input.getPosition() != searchStartPosition) {
            seekPositionHolder.position = searchStartPosition;
            return 1;
        }
        this.packetBuffer.reset(bytesToSearch);
        input.resetPeekPosition();
        input.peekFully(this.packetBuffer.getData(), 0, bytesToSearch);
        this.lastScrValue = this.readLastScrValueFromBuffer(this.packetBuffer);
        this.isLastScrValueRead = true;
        return 0;
    }

    private long readLastScrValueFromBuffer(ParsableByteArray packetBuffer) {
        int searchStartPosition = packetBuffer.getPosition();
        int searchEndPosition = packetBuffer.limit();
        for (int searchPosition = searchEndPosition - 4; searchPosition >= searchStartPosition; --searchPosition) {
            int nextStartCode = this.peekIntAtPosition(packetBuffer.getData(), searchPosition);
            if (nextStartCode != 442) continue;
            packetBuffer.setPosition(searchPosition + 4);
            long scrValue = PsDurationReader.readScrValueFromPack(packetBuffer);
            if (scrValue == -9223372036854775807L) continue;
            return scrValue;
        }
        return -9223372036854775807L;
    }

    private int peekIntAtPosition(byte[] data, int position) {
        return (data[position] & 0xFF) << 24 | (data[position + 1] & 0xFF) << 16 | (data[position + 2] & 0xFF) << 8 | data[position + 3] & 0xFF;
    }

    private static boolean checkMarkerBits(byte[] scrBytes) {
        if ((scrBytes[0] & 0xC4) != 68) {
            return false;
        }
        if ((scrBytes[2] & 4) != 4) {
            return false;
        }
        if ((scrBytes[4] & 4) != 4) {
            return false;
        }
        if ((scrBytes[5] & 1) != 1) {
            return false;
        }
        return (scrBytes[8] & 3) == 3;
    }

    private static long readScrValueFromPackHeader(byte[] scrBytes) {
        return ((long)scrBytes[0] & 0x38L) >> 3 << 30 | ((long)scrBytes[0] & 3L) << 28 | ((long)scrBytes[1] & 0xFFL) << 20 | ((long)scrBytes[2] & 0xF8L) >> 3 << 15 | ((long)scrBytes[2] & 3L) << 13 | ((long)scrBytes[3] & 0xFFL) << 5 | ((long)scrBytes[4] & 0xF8L) >> 3;
    }
}

