/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.metadata.id3;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.metadata.id3.Id3Frame;
import com.google.android.exoplayer2.util.Util;
import java.util.Arrays;

public final class PrivFrame
extends Id3Frame {
    public static final String ID = "PRIV";
    public final String owner;
    public final byte[] privateData;
    public static final Parcelable.Creator<PrivFrame> CREATOR = new Parcelable.Creator<PrivFrame>(){

        public PrivFrame createFromParcel(Parcel in) {
            return new PrivFrame(in);
        }

        public PrivFrame[] newArray(int size) {
            return new PrivFrame[size];
        }
    };

    public PrivFrame(String owner, byte[] privateData) {
        super(ID);
        this.owner = owner;
        this.privateData = privateData;
    }

    PrivFrame(Parcel in) {
        super(ID);
        this.owner = (String)Util.castNonNull((Object)in.readString());
        this.privateData = (byte[])Util.castNonNull((Object)in.createByteArray());
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrivFrame other = (PrivFrame)obj;
        return Util.areEqual((Object)this.owner, (Object)other.owner) && Arrays.equals(this.privateData, other.privateData);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.privateData);
        return result;
    }

    @Override
    public String toString() {
        String string = this.id;
        String string2 = this.owner;
        return new StringBuilder(8 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(": owner=").append(string2).toString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.owner);
        dest.writeByteArray(this.privateData);
    }
}

