/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.text;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.decoder.DecoderOutputBuffer;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.Subtitle;
import com.google.android.exoplayer2.util.Assertions;
import java.util.List;

public abstract class SubtitleOutputBuffer
extends DecoderOutputBuffer
implements Subtitle {
    @Nullable
    private Subtitle subtitle;
    private long subsampleOffsetUs;

    public void setContent(long timeUs, Subtitle subtitle, long subsampleOffsetUs) {
        this.timeUs = timeUs;
        this.subtitle = subtitle;
        this.subsampleOffsetUs = subsampleOffsetUs == Long.MAX_VALUE ? this.timeUs : subsampleOffsetUs;
    }

    @Override
    public int getEventTimeCount() {
        return ((Subtitle)Assertions.checkNotNull((Object)this.subtitle)).getEventTimeCount();
    }

    @Override
    public long getEventTime(int index) {
        return ((Subtitle)Assertions.checkNotNull((Object)this.subtitle)).getEventTime(index) + this.subsampleOffsetUs;
    }

    @Override
    public int getNextEventTimeIndex(long timeUs) {
        return ((Subtitle)Assertions.checkNotNull((Object)this.subtitle)).getNextEventTimeIndex(timeUs - this.subsampleOffsetUs);
    }

    @Override
    public List<Cue> getCues(long timeUs) {
        return ((Subtitle)Assertions.checkNotNull((Object)this.subtitle)).getCues(timeUs - this.subsampleOffsetUs);
    }

    public void clear() {
        super.clear();
        this.subtitle = null;
    }
}

