/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor;

import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.SeekPoint;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;

public final class IndexSeekMap
implements SeekMap {
    private final long[] positions;
    private final long[] timesUs;
    private final long durationUs;
    private final boolean isSeekable;

    public IndexSeekMap(long[] positions, long[] timesUs, long durationUs) {
        Assertions.checkArgument((positions.length == timesUs.length ? 1 : 0) != 0);
        int length = timesUs.length;
        boolean bl = this.isSeekable = length > 0;
        if (this.isSeekable && timesUs[0] > 0L) {
            this.positions = new long[length + 1];
            this.timesUs = new long[length + 1];
            System.arraycopy(positions, 0, this.positions, 1, length);
            System.arraycopy(timesUs, 0, this.timesUs, 1, length);
        } else {
            this.positions = positions;
            this.timesUs = timesUs;
        }
        this.durationUs = durationUs;
    }

    @Override
    public boolean isSeekable() {
        return this.isSeekable;
    }

    @Override
    public long getDurationUs() {
        return this.durationUs;
    }

    @Override
    public SeekMap.SeekPoints getSeekPoints(long timeUs) {
        if (!this.isSeekable) {
            return new SeekMap.SeekPoints(SeekPoint.START);
        }
        int targetIndex = Util.binarySearchFloor((long[])this.timesUs, (long)timeUs, (boolean)true, (boolean)true);
        SeekPoint leftSeekPoint = new SeekPoint(this.timesUs[targetIndex], this.positions[targetIndex]);
        if (leftSeekPoint.timeUs == timeUs || targetIndex == this.timesUs.length - 1) {
            return new SeekMap.SeekPoints(leftSeekPoint);
        }
        SeekPoint rightSeekPoint = new SeekPoint(this.timesUs[targetIndex + 1], this.positions[targetIndex + 1]);
        return new SeekMap.SeekPoints(leftSeekPoint, rightSeekPoint);
    }
}

