/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.extractor.avi;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.DummyExtractorOutput;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.extractor.avi.AviChunk;
import com.google.android.exoplayer2.extractor.avi.AviMainHeaderChunk;
import com.google.android.exoplayer2.extractor.avi.AviStreamHeaderChunk;
import com.google.android.exoplayer2.extractor.avi.ChunkReader;
import com.google.android.exoplayer2.extractor.avi.ListChunk;
import com.google.android.exoplayer2.extractor.avi.StreamFormatChunk;
import com.google.android.exoplayer2.extractor.avi.StreamNameChunk;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.io.IOException;
import java.util.ArrayList;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class AviExtractor
implements Extractor {
    private static final String TAG = "AviExtractor";
    public static final int FOURCC_RIFF = 1179011410;
    public static final int FOURCC_AVI_ = 541677121;
    public static final int FOURCC_LIST = 1414744396;
    public static final int FOURCC_avih = 1751742049;
    public static final int FOURCC_hdrl = 1819436136;
    public static final int FOURCC_strl = 1819440243;
    public static final int FOURCC_movi = 1769369453;
    public static final int FOURCC_idx1 = 829973609;
    public static final int FOURCC_JUNK = 1263424842;
    public static final int FOURCC_strf = 1718776947;
    public static final int FOURCC_strn = 1852994675;
    public static final int FOURCC_strh = 1752331379;
    public static final int FOURCC_auds = 1935963489;
    public static final int FOURCC_txts = 1937012852;
    public static final int FOURCC_vids = 1935960438;
    private static final int STATE_SKIPPING_TO_HDRL = 0;
    private static final int STATE_READING_HDRL_HEADER = 1;
    private static final int STATE_READING_HDRL_BODY = 2;
    private static final int STATE_FINDING_MOVI_HEADER = 3;
    private static final int STATE_FINDING_IDX1_HEADER = 4;
    private static final int STATE_READING_IDX1_BODY = 5;
    private static final int STATE_READING_SAMPLES = 6;
    private static final int AVIIF_KEYFRAME = 16;
    private static final long RELOAD_MINIMUM_SEEK_DISTANCE = 262144L;
    private final ParsableByteArray scratch = new ParsableByteArray(12);
    private final ChunkHeaderHolder chunkHeaderHolder = new ChunkHeaderHolder();
    private int state;
    private ExtractorOutput extractorOutput = new DummyExtractorOutput();
    private @MonotonicNonNull AviMainHeaderChunk aviHeader;
    private long durationUs = -9223372036854775807L;
    private ChunkReader[] chunkReaders = new ChunkReader[0];
    private long pendingReposition;
    @Nullable
    private ChunkReader currentChunkReader;
    private int hdrlSize = -1;
    private long moviStart = -1L;
    private long moviEnd = -1L;
    private int idx1BodySize;
    private boolean seekMapHasBeenOutput;

    @Override
    public void init(ExtractorOutput output) {
        this.state = 0;
        this.extractorOutput = output;
        this.pendingReposition = -1L;
    }

    @Override
    public boolean sniff(ExtractorInput input) throws IOException {
        input.peekFully(this.scratch.getData(), 0, 12);
        this.scratch.setPosition(0);
        if (this.scratch.readLittleEndianInt() != 1179011410) {
            return false;
        }
        this.scratch.skipBytes(4);
        return this.scratch.readLittleEndianInt() == 541677121;
    }

    @Override
    public int read(ExtractorInput input, PositionHolder positionHolder) throws IOException {
        if (this.resolvePendingReposition(input, positionHolder)) {
            return 1;
        }
        switch (this.state) {
            case 0: {
                if (!this.sniff(input)) {
                    throw ParserException.createForMalformedContainer((String)"AVI Header List not found", null);
                }
                input.skipFully(12);
                this.state = 1;
                return 0;
            }
            case 1: {
                input.readFully(this.scratch.getData(), 0, 12);
                this.scratch.setPosition(0);
                this.chunkHeaderHolder.populateWithListHeaderFrom(this.scratch);
                if (this.chunkHeaderHolder.listType != 1819436136) {
                    throw ParserException.createForMalformedContainer((String)("hdrl expected, found: " + this.chunkHeaderHolder.listType), null);
                }
                this.hdrlSize = this.chunkHeaderHolder.size;
                this.state = 2;
                return 0;
            }
            case 2: {
                int bytesToRead = this.hdrlSize - 4;
                ParsableByteArray hdrlBody = new ParsableByteArray(bytesToRead);
                input.readFully(hdrlBody.getData(), 0, bytesToRead);
                this.parseHdrlBody(hdrlBody);
                this.state = 3;
                return 0;
            }
            case 3: {
                if (this.moviStart != -1L && input.getPosition() != this.moviStart) {
                    this.pendingReposition = this.moviStart;
                    return 0;
                }
                input.peekFully(this.scratch.getData(), 0, 12);
                input.resetPeekPosition();
                this.scratch.setPosition(0);
                this.chunkHeaderHolder.populateFrom(this.scratch);
                int listType = this.scratch.readLittleEndianInt();
                if (this.chunkHeaderHolder.chunkType == 1179011410) {
                    input.skipFully(12);
                    return 0;
                }
                if (this.chunkHeaderHolder.chunkType != 1414744396 || listType != 1769369453) {
                    this.pendingReposition = input.getPosition() + (long)this.chunkHeaderHolder.size + 8L;
                    return 0;
                }
                this.moviStart = input.getPosition();
                this.moviEnd = this.moviStart + (long)this.chunkHeaderHolder.size + 8L;
                if (!this.seekMapHasBeenOutput) {
                    if (((AviMainHeaderChunk)Assertions.checkNotNull((Object)this.aviHeader)).hasIndex()) {
                        this.state = 4;
                        this.pendingReposition = this.moviEnd;
                        return 0;
                    }
                    this.extractorOutput.seekMap(new SeekMap.Unseekable(this.durationUs));
                    this.seekMapHasBeenOutput = true;
                }
                this.pendingReposition = input.getPosition() + 12L;
                this.state = 6;
                return 0;
            }
            case 4: {
                input.readFully(this.scratch.getData(), 0, 8);
                this.scratch.setPosition(0);
                int idx1Fourcc = this.scratch.readLittleEndianInt();
                int boxSize = this.scratch.readLittleEndianInt();
                if (idx1Fourcc == 829973609) {
                    this.state = 5;
                    this.idx1BodySize = boxSize;
                } else {
                    this.pendingReposition = input.getPosition() + (long)boxSize;
                }
                return 0;
            }
            case 5: {
                ParsableByteArray idx1Body = new ParsableByteArray(this.idx1BodySize);
                input.readFully(idx1Body.getData(), 0, this.idx1BodySize);
                this.parseIdx1Body(idx1Body);
                this.state = 6;
                this.pendingReposition = this.moviStart;
                return 0;
            }
            case 6: {
                return this.readMoviChunks(input);
            }
        }
        throw new AssertionError();
    }

    @Override
    public void seek(long position, long timeUs) {
        this.pendingReposition = -1L;
        this.currentChunkReader = null;
        for (ChunkReader chunkReader : this.chunkReaders) {
            chunkReader.seekToPosition(position);
        }
        if (position == 0L) {
            this.state = this.chunkReaders.length == 0 ? 0 : 3;
            return;
        }
        this.state = 6;
    }

    @Override
    public void release() {
    }

    private boolean resolvePendingReposition(ExtractorInput input, PositionHolder positionHolder) throws IOException {
        boolean needSeek = false;
        if (this.pendingReposition != -1L) {
            long currentPosition = input.getPosition();
            if (this.pendingReposition < currentPosition || this.pendingReposition > currentPosition + 262144L) {
                positionHolder.position = this.pendingReposition;
                needSeek = true;
            } else {
                input.skipFully((int)(this.pendingReposition - currentPosition));
            }
        }
        this.pendingReposition = -1L;
        return needSeek;
    }

    private void parseHdrlBody(ParsableByteArray hrdlBody) throws IOException {
        ListChunk headerList = ListChunk.parseFrom(1819436136, hrdlBody);
        if (headerList.getType() != 1819436136) {
            throw ParserException.createForMalformedContainer((String)("Unexpected header list type " + headerList.getType()), null);
        }
        AviMainHeaderChunk aviHeader = headerList.getChild(AviMainHeaderChunk.class);
        if (aviHeader == null) {
            throw ParserException.createForMalformedContainer((String)"AviHeader not found", null);
        }
        this.aviHeader = aviHeader;
        this.durationUs = (long)aviHeader.totalFrames * (long)aviHeader.frameDurationUs;
        ArrayList<ChunkReader> chunkReaderList = new ArrayList<ChunkReader>();
        int streamId = 0;
        for (AviChunk aviChunk : headerList.children) {
            ListChunk streamList;
            ChunkReader chunkReader;
            if (aviChunk.getType() != 1819440243 || (chunkReader = this.processStreamList(streamList = (ListChunk)aviChunk, streamId++)) == null) continue;
            chunkReaderList.add(chunkReader);
        }
        this.chunkReaders = chunkReaderList.toArray(new ChunkReader[0]);
        this.extractorOutput.endTracks();
    }

    private void parseIdx1Body(ParsableByteArray body) {
        long seekOffset = this.peekSeekOffset(body);
        while (body.bytesLeft() >= 16) {
            int chunkId = body.readLittleEndianInt();
            int flags = body.readLittleEndianInt();
            long offset = (long)body.readLittleEndianInt() + seekOffset;
            body.readLittleEndianInt();
            ChunkReader chunkReader = this.getChunkReader(chunkId);
            if (chunkReader == null) continue;
            if ((flags & 0x10) == 16) {
                chunkReader.appendKeyFrameToIndex(offset);
            }
            chunkReader.incrementIndexChunkCount();
        }
        for (ChunkReader chunkReader : this.chunkReaders) {
            chunkReader.compactIndex();
        }
        this.seekMapHasBeenOutput = true;
        this.extractorOutput.seekMap(new AviSeekMap(this.durationUs));
    }

    private long peekSeekOffset(ParsableByteArray idx1Body) {
        if (idx1Body.bytesLeft() < 16) {
            return 0L;
        }
        int startingPosition = idx1Body.getPosition();
        idx1Body.skipBytes(8);
        int offset = idx1Body.readLittleEndianInt();
        long seekOffset = (long)offset > this.moviStart ? 0L : this.moviStart + 8L;
        idx1Body.setPosition(startingPosition);
        return seekOffset;
    }

    @Nullable
    private ChunkReader getChunkReader(int chunkId) {
        for (ChunkReader chunkReader : this.chunkReaders) {
            if (!chunkReader.handlesChunkId(chunkId)) continue;
            return chunkReader;
        }
        return null;
    }

    private int readMoviChunks(ExtractorInput input) throws IOException {
        if (input.getPosition() >= this.moviEnd) {
            return -1;
        }
        if (this.currentChunkReader != null) {
            if (this.currentChunkReader.onChunkData(input)) {
                this.currentChunkReader = null;
            }
        } else {
            AviExtractor.alignInputToEvenPosition(input);
            input.peekFully(this.scratch.getData(), 0, 12);
            this.scratch.setPosition(0);
            int chunkType = this.scratch.readLittleEndianInt();
            if (chunkType == 1414744396) {
                this.scratch.setPosition(8);
                int listType = this.scratch.readLittleEndianInt();
                input.skipFully(listType == 1769369453 ? 12 : 8);
                input.resetPeekPosition();
                return 0;
            }
            int size = this.scratch.readLittleEndianInt();
            if (chunkType == 1263424842) {
                this.pendingReposition = input.getPosition() + (long)size + 8L;
                return 0;
            }
            input.skipFully(8);
            input.resetPeekPosition();
            ChunkReader chunkReader = this.getChunkReader(chunkType);
            if (chunkReader == null) {
                this.pendingReposition = input.getPosition() + (long)size;
                return 0;
            }
            chunkReader.onChunkStart(size);
            this.currentChunkReader = chunkReader;
        }
        return 0;
    }

    @Nullable
    private ChunkReader processStreamList(ListChunk streamList, int streamId) {
        int trackType;
        StreamNameChunk streamName;
        AviStreamHeaderChunk aviStreamHeaderChunk = streamList.getChild(AviStreamHeaderChunk.class);
        StreamFormatChunk streamFormatChunk = streamList.getChild(StreamFormatChunk.class);
        if (aviStreamHeaderChunk == null) {
            Log.w((String)TAG, (String)"Missing Stream Header");
            return null;
        }
        if (streamFormatChunk == null) {
            Log.w((String)TAG, (String)"Missing Stream Format");
            return null;
        }
        long durationUs = aviStreamHeaderChunk.getDurationUs();
        Format streamFormat = streamFormatChunk.format;
        Format.Builder builder = streamFormat.buildUpon();
        builder.setId(streamId);
        int suggestedBufferSize = aviStreamHeaderChunk.suggestedBufferSize;
        if (suggestedBufferSize != 0) {
            builder.setMaxInputSize(suggestedBufferSize);
        }
        if ((streamName = streamList.getChild(StreamNameChunk.class)) != null) {
            builder.setLabel(streamName.name);
        }
        if ((trackType = MimeTypes.getTrackType((String)streamFormat.sampleMimeType)) == 1 || trackType == 2) {
            TrackOutput trackOutput = this.extractorOutput.track(streamId, trackType);
            trackOutput.format(builder.build());
            ChunkReader chunkReader = new ChunkReader(streamId, trackType, durationUs, aviStreamHeaderChunk.length, trackOutput);
            this.durationUs = durationUs;
            return chunkReader;
        }
        return null;
    }

    private static void alignInputToEvenPosition(ExtractorInput input) throws IOException {
        if ((input.getPosition() & 1L) == 1L) {
            input.skipFully(1);
        }
    }

    private static class ChunkHeaderHolder {
        public int chunkType;
        public int size;
        public int listType;

        private ChunkHeaderHolder() {
        }

        public void populateWithListHeaderFrom(ParsableByteArray headerBytes) throws ParserException {
            this.populateFrom(headerBytes);
            if (this.chunkType != 1414744396) {
                throw ParserException.createForMalformedContainer((String)("LIST expected, found: " + this.chunkType), null);
            }
            this.listType = headerBytes.readLittleEndianInt();
        }

        public void populateFrom(ParsableByteArray headerBytes) {
            this.chunkType = headerBytes.readLittleEndianInt();
            this.size = headerBytes.readLittleEndianInt();
            this.listType = 0;
        }
    }

    private class AviSeekMap
    implements SeekMap {
        private final long durationUs;

        public AviSeekMap(long durationUs) {
            this.durationUs = durationUs;
        }

        @Override
        public boolean isSeekable() {
            return true;
        }

        @Override
        public long getDurationUs() {
            return this.durationUs;
        }

        @Override
        public SeekMap.SeekPoints getSeekPoints(long timeUs) {
            SeekMap.SeekPoints result = AviExtractor.this.chunkReaders[0].getSeekPoints(timeUs);
            for (int i = 1; i < AviExtractor.this.chunkReaders.length; ++i) {
                SeekMap.SeekPoints seekPoints = AviExtractor.this.chunkReaders[i].getSeekPoints(timeUs);
                if (seekPoints.first.position >= result.first.position) continue;
                result = seekPoints;
            }
            return result;
        }
    }
}

